
<div class="box">
    <div class="box-header">
        <h3 class="box-title"><i class="fa iniicon-leaveapply"></i> <?=$this->lang->line('student_panel_title')?></h3>
        <ol class="breadcrumb">
            <li><a href="<?=base_url("dashboard/index")?>"><i class="fa fa-laptop"></i> <?=$this->lang->line('menu_dashboard')?></a></li>
            <li><a href="<?=base_url("leaveapply/index")?>"><?=$this->lang->line('menu_leaveapply')?></a></li>
            <li class="active"><?=$this->lang->line('student_panel_title')?></li>
        </ol>
    </div><!-- /.box-header -->
    <!-- form start -->
    <div class="row">
        <div class="col-sm-4">
            <form class="form-horizontal" role="form" method="post" enctype="multipart/form-data">
                <div class="box-body">
                    <div class="row">
                        <div class="col-sm-12">
                            <?php
                                if(form_error('studentID'))
                                    echo "<div class='form-group has-error' >";
                                else
                                    echo "<div class='form-group' >";
                            ?>                        
                                <div class="col-sm-12">
                                    <label for="classesID" class="control-label">
                                        <?=$this->lang->line("leaveapply_class")?> <span class="text-red">*</span>
                                    </label>
                                    <?php
                                        $classesArray = array('0' => $this->lang->line("select_classes"));
                                        if(customCompute($classes)) {
                                            foreach ($classes as $classa) {
                                                $classesArray[$classa->classesID] = $classa->classes;
                                            }
                                        }
                                        echo form_dropdown("classesID", $classesArray, set_value("classesID"), "id='classesID' class='form-control select2'");
                                    ?>
                                    <span class="control-label">
                                        <?php echo form_error('classesID'); ?>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12">
                            <div class='form-group <?=form_error('applicationto_userID') ? "has-error" : "";?>' >
                                
                                <div class="col-sm-12">
                                <label for="studentID" class="control-label">
                                    <?=$this->lang->line("leaveapply_student")?> <span class="text-red">*</span>
                                </label>
                                    <?php
                                        $studentsArray = array('0' => $this->lang->line("select_student"));
                                        if(customCompute($students)) {
                                            foreach ($students as $student) {
                                                $studentsArray[$student->studentID] = $student->name;
                                            }
                                        }
                                        echo form_dropdown("studentID", $studentsArray, set_value("studentID"), "id='studentID' class='form-control select2'");
                                    ?>
                                    <span class="control-label">
                                        <?php echo form_error('studentID'); ?>
                                    </span>
                                </div>                        
                            </div>
                        </div>
                        <div class="col-sm-12">
                            <?php
                                if(form_error('leave_schedule'))
                                    echo "<div class='form-group has-error' >";
                                else
                                    echo "<div class='form-group' >";
                            ?>                        
                                <div class="col-sm-12">
                                    <label for="leave_schedule" class="control-label">
                                        <?=$this->lang->line("leaveapply_schedule")?> <span class="text-red">*</span>
                                    </label>
                                    <input type="text" class="form-control" id="leave_schedule" name="leave_schedule" value="<?=set_value('leave_schedule')?>" >
                                    <span class="control-label">
                                        <?php echo form_error('leave_schedule'); ?>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12">
                            <?php
                                if(form_error('reason'))
                                    echo "<div class='form-group has-error' >";
                                else
                                    echo "<div class='form-group' >";
                            ?>
                                
                                <div class="col-sm-12">
                                    <label for="reason" class="control-label">
                                        <?=$this->lang->line("leaveapply_reason")?> <span class="text-red">*</span>
                                    </label>
                                    <textarea class="form-control" id="reason" name="reason" rows="5"><?=set_value('reason')?></textarea>
                                    <span class="control-label">
                                        <?php echo form_error('reason'); ?>
                                    </span>
                                </div>                        
                            </div>
                        </div>                
                        <div class="form-group">
                            <div class="col-sm-offset-2 col-sm-10">
                                <input type="submit" class="btn btn-success" value="<?=$this->lang->line("add_leaveapply")?>" >
                            </div>
                        </div>
                    </div>
                </div>
            </form>       
        </div> 
        <div class="col-sm-8">
            <div class="box-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div id="hide-table">
                            <table id="example1" class="table table-striped table-bordered table-hover dataTable no-footer">
                                <thead>
                                    <tr>
                                        <th><?=$this->lang->line('slno')?></th>
                                        <th><?=$this->lang->line('leaveapply_student')?></th>
                                        <th><?=$this->lang->line('leaveapply_class')?></th>
                                        <th><?=$this->lang->line('leaveapply_date')?></th>
                                        <th><?=$this->lang->line('leaveapply_schedule')?></th>
                                        <?php if(permissionChecker('leaveapply_view') || permissionChecker('leaveapply_edit') || permissionChecker('leaveapply_delete')) { ?>
                                            <th class="col-md-2"><?=$this->lang->line('action')?></th>
                                        <?php } ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if(customCompute($myleaveapplications)) {$i = 1; foreach($myleaveapplications as $leaveapply) { ?>
                                        <tr>
                                            <td data-title="<?=$this->lang->line('slno')?>">
                                                <?php echo $i; ?>
                                            </td>
                                            <td data-title="<?=$this->lang->line('leaveapply_class')?>">
                                                <?=isset($userName[$leaveapply->studentID]) ? $userName[$leaveapply->studentID]->name : ''?>
                                            </td>
                                            <td data-title="<?=$this->lang->line('leaveapply_class')?>">
                                                <?=isset($userName[$leaveapply->studentID]) ? $userName[$leaveapply->studentID]->srclasses : ''?>
                                            </td>
                                            <td data-title="<?=$this->lang->line('leaveapply_date')?>">
                                                <?=date('d M Y',strtotime($leaveapply->apply_date))?>
                                            </td>
                                            <td data-title="<?=$this->lang->line('leaveapply_schedule')?>">
                                                <?=date('d M Y',strtotime($leaveapply->from_date))?> - <?=date('d M Y',strtotime($leaveapply->to_date))?>
                                            </td>
                                            <?php if(permissionChecker('leaveapply_view') || permissionChecker('leaveapply_edit') || permissionChecker('leaveapply_delete')) { ?>
                                                <td data-title="<?=$this->lang->line('action')?>">
                                                    <?php echo btn_view('studentleaveout/view/'.$leaveapply->studentleaveoutID, $this->lang->line('view')) ?>
                                                    <?php if($leaveapply->status == NULL) {?>
                                                        <?php if(($siteinfos->school_year == $this->session->userdata('defaultschoolyearID')) || ($this->session->userdata('usertypeID') == 1)) { ?>
                                                            <!-- <?php echo btn_edit('studentleaveout/edit/'.$leaveapply->studentleaveoutID, $this->lang->line('edit')) ?> -->
                                                            <?php echo btn_delete('studentleaveout/delete/'.$leaveapply->studentleaveoutID, $this->lang->line('delete')) ?>
                                                        <?php } ?>
                                                    <?php } ?>
                                                </td>
                                            <?php } ?>
                                        </tr>
                                    <?php $i++; }} ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>       
    </div>  
</div>

<script type="text/javascript">
    // $('#reason').jqte();
    $('.select2').select2();

    $('#classesID').change(function(event) {
        var classesID = $(this).val();

        $.ajax({
                type: 'POST',
                url: "<?=base_url('invoice/getstudent')?>",
                data: {'classesID' : classesID},
                dataType: "html",
                success: function(data) {
                    $('#studentID').html(data);
                }
        });
    });

    $('#leave_schedule').daterangepicker({
        timePicker: true,
        timePickerIncrement: 5,
        maxDate: '<?=date('m/d/Y', strtotime($schoolyearsessionobj->endingdate))?>',
        minDate: '<?=date('m/d/Y', strtotime($schoolyearsessionobj->startingdate))?>',
        locale: {
            format: 'MM/DD/YYYY'
        },
    });

    $(function() {
        // Create the close button
        var closebtn = $('<button/>', {
            type:"button",
            text: 'x',
            id: 'close-preview',
            style: 'font-size: initial;',
        });
        closebtn.attr("class","close pull-right");
        // Set the popover default content
        $('.image-preview').popover({
            trigger:'manual',
            html:true,
            title: "<strong>Preview</strong>"+$(closebtn)[0].outerHTML,
            content: "There's no image",
            placement:'bottom'
        });
        // Clear event
        $('.image-preview-clear').click(function(){
            $('.image-preview').attr("data-content","").popover('hide');
            $('.image-preview-filename').val("");
            $('.image-preview-clear').hide();
            $('.image-preview-input input:file').val("");
            $(".image-preview-input-title").text("<?=$this->lang->line('leaveapply_file_browse')?>");
        });
        // Create the preview image
        $(".image-preview-input input:file").change(function (){
            var file = this.files[0];
            var reader = new FileReader();
            // Set preview image into the popover data-content
            reader.onload = function (e) {
                $(".image-preview-input-title").text("<?=$this->lang->line('leaveapply_file_browse')?>");
                $(".image-preview-clear").show();
                $(".image-preview-filename").val(file.name);
            }
            reader.readAsDataURL(file);
        });
    });
</script>