<div class="form-box col-3" id="login-box">
    <div class="header">Reset Password</div>
    <form role="form" method="post">
        <div class="body white-bg">
            <?php 
                if ($form_validation == "No") {
                } else {
                    if (customCompute($form_validation)) {
                        echo "<div class=\"alert alert-danger alert-dismissable\">
                                <i class=\"fa fa-ban\"></i>
                                <button aria-hidden=\"true\" data-dismiss=\"alert\" class=\"close\" type=\"button\">×</button>
                                $form_validation
                            </div>";
                    }
                }

                if ($this->session->flashdata('reset_send')) {
                    $message = $this->session->flashdata('reset_send');
                    echo "<div class=\"alert alert-success alert-dismissable\">
                            <i class=\"fa fa-ban\"></i>
                            <button aria-hidden=\"true\" data-dismiss=\"alert\" class=\"close\" type=\"button\">×</button>
                            $message
                        </div>";
                } else {
                    if ($this->session->flashdata('reset_error')) {
                        $message = $this->session->flashdata('reset_error');
                        echo "<div class=\"alert alert-danger alert-dismissable\">
                                <i class=\"fa fa-ban\"></i>
                                <button aria-hidden=\"true\" data-dismiss=\"alert\" class=\"close\" type=\"button\">×</button>
                                $message
                            </div>";
                    }
                }
            ?>
            <div class="form-group text-center">
                <label for="verificationCode">Enter Verification Code</label>
                <div class="verification-form">
                    <input type="hidden" id="verificationCode" name="verification_code" value="">
                    <input id="inputType" name="type" type="hidden" value="phone">
                    <input type="text" class="verification-input" maxlength="1" oninput="moveToNext(this, 0)">
                    <input type="text" class="verification-input" maxlength="1" oninput="moveToNext(this, 1)">
                    <input type="text" class="verification-input" maxlength="1" oninput="moveToNext(this, 2)">
                    <input type="text" class="verification-input" maxlength="1" oninput="moveToNext(this, 3)">
                    <input type="text" class="verification-input" maxlength="1" oninput="moveToNext(this, 4)">
                    <input type="text" class="verification-input" maxlength="1" oninput="moveToNext(this, 5)">
                </div>
            </div>
            <input type="submit" class="btn btn-lg btn-primary btn-block" value="Verify" />
        </div>
    </form>
</div>

<style>
    .verification-form {
        display: flex;
        gap: 10px;
        justify-content: center;
        margin-top: 15px;
    }
    .verification-input {
        width: 40px;
        height: 40px;
        text-align: center;
        font-size: 18px;
        border: 1px solid #ccc;
        border-radius: 5px;
        outline: none;
        background-color: #fff;
        box-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
        transition: border-color 0.2s ease;
    }
    .verification-input:focus {
        border-color: #007bff;
    }
    .btn-primary {
        background-color: #007bff;
        color: #fff;
        border: none;
        padding: 10px 20px;
        font-size: 16px;
        border-radius: 5px;
        cursor: pointer;
    }
    .btn-primary:hover {
        background-color: #0056b3;
    }
</style>

<script>
    function moveToNext(currentInput, index) {
        const inputs = document.querySelectorAll('.verification-input');
        const hiddenInput = document.getElementById('verificationCode');

        let verificationCode = '';
        inputs.forEach((input) => {
            verificationCode += input.value;
        });
        hiddenInput.value = verificationCode;

        if (currentInput.value.length === 1 && index < inputs.length - 1) {
            inputs[index + 1].focus();
        }
    }
</script>
