<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>IES COLLEGE ID Card Builder</title>
    <style>
                            .clear {
                                clear: both;
                            }
                    
                            p {
                                font-size: 12px;
                                margin: 2px;
                                color: #000;
                                font-weight: bold;
                            }
                            
                    
                            .id-card-holder {
                                width: 450px;
                                margin: 0 auto;
                                font-family: "Nunito", sans-serif;
                            }
                    
                            .id-card {
                                background-color: #fff;
                                padding: 0px;
                                text-align: center;
                                box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1),
                                    0 4px 6px -2px rgba(0, 0, 0, 0.05);
                                display: block;
                                border-radius: 0.5rem;
                                overflow: hidden;
                            }
                    
                            .header {
                                /* padding: 15px; */
                                background-color: #db223c;
                                border-bottom: 2px solid #6FAC45;
                            }
                    
                    
                            .id {
                                display: inline-block;
                                float: left;
                                font-size: 15px;
                                text-transform: uppercase;
                                color: #fff;
                                text-align: center;
                                margin-left: 20px;
                                margin-top: 10px;
                            }
                    
                            .head-info {
                                display: inline-block;
                                float: left;
                                padding: 10px 0px 0;
                                width: calc(100% - 130px);
                                box-sizing: border-box;
                                text-align: left;
                                color: #006341;
                            }
                    
                            .sc-logo {
                                float: left;
                                padding: 10px 0px 0;
                                width: 120px;
                            }
                    
                            .head-info p {
                                font-size: 9px;
                            }
                    
                            .b-border {
                                width: 100%;
                                height: 6px;
                                display: block;
                                background-color: #006341;
                                margin-top: 1px;
                            }
                    
                            .card-detail {
                                width: 100%;
                                display: block;
                                padding: 10px;
                                box-sizing: border-box;
                                margin-top:10px;
                                margin-bottom:20px;
                            }
                    
                            .stu-photo {
                                float: left;
                                width: 100px;
                                border: 1px solid #ddd;
                                border-radius: 5px;
                                box-sizing: border-box;
                    
                            }
                    
                            .card-photo {
                                height: 140px;
                                width: 100px;
                                object-fit: cover;
                                object-position: 100% 0;
                            }
                    
                            .stu-info {
                                float: left;
                                width: calc(100% - 100px);
                                padding: 0px 5px 0 15px;
                                box-sizing: border-box;
                                text-align: left;
                                text-transform: capitalize;
                            }
                    
                            .session {
                                font-size: 13px;
                                font-weight: 600;
                                margin: 0 0 7px;
                            }
                    
                            .stu-info h3 {
                                font-size: 15px;
                                font-weight: 700;
                                margin: 0 0 8px 0;
                                /* padding: 5px 15px; */
                                /* background-color: #4a0a2c9e; */
                                /* border-radius: 70px; */
                                /* text-align: center; */
                                color: #4a0a2cfc;
                                /* border: 1px solid #4a0a2cfc;*/
                            }
                    
                            .stu-info p {
                                font-size: 11px;
                                margin: 0 0 3px 0;
                                font-weight: 300;
                                line-height: 17px;
                            }
                    
                            .stu-info p span {
                                font-weight: 600;
                                text-transform: uppercase;
                            }
                    
                            footer {
                                padding: 5px 0;
                                border-top: 1px solid #6FAC45;
                            }
                    
                            footer p {
                                font-size: 7px;
                                margin: 0 0 2px 0;
                            }
                    
                            .head-info h3 {
                                font-size: 15px;
                                margin: 0 0 3px 0;
                                /* padding: 5px 15px; */
                                /* background-color: #4a0a2c9e; */
                                /* border-radius: 70px; */
                                /* text-align: center; */
                                color: #000;
                                text-transform: uppercase;
                                font-weight: 700;
                                /* border: 1px solid #4a0a2cfc;*/
                            }
                    
                            .center {
                                display: flex;
                                align-items: center;
                                justify-content: center;
                                text-align: center;
                            }
                    
                            .background-image {
                                background-size: 130px 130px;
                                background-position: right bottom;
                                background-repeat: no-repeat;
                            }
                            .card-detail {
                                width: 100%;
                                display: block;
                                padding: 10px;
                                box-sizing: border-box;
                                margin-top: 10px;
                                margin-bottom: 30px;
                            }
                            
                            .column-container {
                                display: flex;
                                flex-direction: row;
                            }
                            
                            .column1 {
                                width: 30%;
                                padding: 0 5px;
                            }
                            .column2 {
                                width: 30%;
                                padding: 0 5px;
                            }
                            .column3 {
                                width: 40%;
                                padding: 0 5px;
                            }
                            
                            .qr-code-column {
                                text-align: center;
                            }
                            
                            .qr-code-column img {
                                width: 180px;
                                height: auto;
                            }
                            
                            .photo-column .stu-photo {
                                width: 100%;
                                margin: 0 auto;
                            }
                            
                            .info-column {
                                font-size:15px;
                                text-align: left;
                                color: #000;
                                text-transform: capitalize;
                            }
                            
                            .bold-text {
                                font-size:14px;
                                font-weight: 700;
                                color: #000;
                                text-transform: capitalize;
                            }
                            .mbc {
                                margin-bottom:8px;
                            }
                           @media print {
                                .print-row {
                                    display: block; /* One card per page */
                                }
                                .id-card-holder {
                                    page-break-after: always; 
                                }
                                
                                @page {
                                    size: 8.6cm 5.6cm landscape;
                                    margin: 0;
                                }
                            }
                        </style>
    
</head>
<body>
    <div class="row print-row" style="margin-left:10px">
                    <?php foreach($idcards as $idcard) {?> 
                    <div class="id-card-holder col-sm-4 print-col" style="margin:5px">
                            <div class="id-card">
                                <div class="header" style="background-color: #fff;">
                                    <div class="center">
                                        <div class="sc-logo">
                                            <img src='<?=base_url('uploads/images/'.$siteinfos->photo)?>' alt="" width="50px">
                                        </div>
                                        <div class="head-info">
                                            <h3><?php echo $siteinfos->sname; ?></h3>
                                            <p><?php echo rtrim(str_replace(['https://', 'http://'], 'www.', site_url()), '/'); ?></p>
                                        </div>
                                    </div>
                                    <div class="clear"></div>
                                </div>
                                <span class="b-border"></span>
                        
                                <div class="card-detail">
                                    <div class="column-container">
                                        
                                        <div class="column1 photo-column">
                                            <div class="stu-photo">
                                                <img class="card-photo" src='<?=imagelink($idcard->srregisterNO.'.png', 'uploads/images')?>' alt="">
                                            </div>
                                        </div>
                                        <div class="column2 info-column">
                                            <?php 
                                                $nameParts = explode(' ', trim($idcard->srname));
                                                $firstName = isset($nameParts[0]) ? $nameParts[0] : '';
                                                $secondName = isset($nameParts[1]) ? $nameParts[1] : '';
                                            ?>
                                            <p class="mbc">
                                                <span><?= strtoupper($firstName) ?></span><br>
                                                <span class="bold-text"><?= strtoupper($secondName) ?></span>
                                            </p>
                                            <p class="bold-text">ADM</p>
                                            <p class="bold-text mbc"><?=$idcard->srregisterNO?></p>
                                            <p class="bold-text">ISSUED</p>
                                            <p class="bold-text"><?=date('Y')?></p>
                                        </div>
                                        <div class="column3 qr-code-column">
                                            <img src="<?php echo base_url('uploads/students/'.$idcard->srstudentID.'/'.$idcard->srregisterNO.'.png'); ?>" alt="QR Code">
                                        </div>
                                    </div>
                                    <div class="clear"></div>
                                </div>
                            </div>
                        </div>
                    <?php }?>
                    </div>
                    <style>
        @media print {
            @page {
                size: A7;
                margin: default;
                transform: scale(0.8);
            }

            .no-print {
                display: none !important;
            }
        }
    </style>

    <script>
        // Auto-print when page loads
        window.onload = function () {
            window.print();
        };
    </script>
</body>
</html>