<?php
$sales_months = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12];
$month_abbreviations = array_map(function($month) {
    return date('M', mktime(0, 0, 0, $month, 10));
}, $sales_months);
?>
<script type="application/javascript">
$(function() {
    LoadExpenseMonthly();
    function LoadExpenseMonthly()
    {
        Highcharts.chart('expenseGraph', {
            chart: {
                type: 'column'
            },
            title: {
                text: 'Expense Summary <?=getSchoolYear()?>',
                align: 'center'
            },
            xAxis: {
                categories: <?php echo json_encode($month_abbreviations); ?>,
            },
            yAxis: {
                min: 0,
                title: {
                    text: 'Amount',
                    enabled: false
                },
                stackLabels: {
                enabled: false,
                style: {
                    fontWeight: 'bold',
                    color: 'gray',
                    textOutline: 'none'
                }
                }
            },
            tooltip: {
                headerFormat: '<b>{point.x}</b><br/>',
                pointFormat: '{series.name}: {point.y}<br/>Total: {point.stackTotal}'
            },
            plotOptions: {
                column: {
                stacking: 'normal',
                dataLabels: {
                    enabled: false
                }
                }
            },
            series: [{
                name: 'Purchases',
                data: <?php echo json_encode($total_purchases); ?>,
                color: 'red'
            },{
                name: 'Salary',
                data: <?php echo json_encode($total_salary); ?>,
                color: '#5C5C61'
            },{
                name: 'Other expenses',
                data: <?php echo json_encode($total_expense); ?>,
                color: 'orange'
            }]

        });

    }

});
</script>
