<div class="box">
    <div class="box-header">
        <h3 class="box-title"><i class="fa fa-calendar"></i> Automation Setting</h3>
    </div>
    <div class="box-body">
        <div class="table-responsive">
            <table class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th>Initiated At</th>
                        <th>Name</th>
                        <th>Ideal Time</th>
                        <th>Specific Time</th>
                        <th>Last Run</th>
                        <th>Next Run</th>
                        <th>Status</th>
                        <th>Enabled</th>
                        <th>Notification Usertypes</th>
                        <th>Details</th>
                    </tr>
                </thead>
                <tbody>
                <?php if (!empty($crons)) { foreach ($crons as $cron) { ?>
                    <tr>
                        <td><?= date('Y-m-d h:i A', strtotime($cron->created_at)) ?></td>
                        <td><?= $cron->name ?></td>
                        <td><?= ucfirst(strtolower(str_replace('_', ' ', $cron->ideal_time))) ?></td>
                        <td><?= $cron->specific_time ? date('h:i A', strtotime($cron->specific_time)) : '-' ?></td>
                        <td><?= $cron->last_run ? date('Y-m-d h:i A', strtotime($cron->last_run)) : 'Never' ?></td>
                        <td><?= $cron->next_run ? date('Y-m-d h:i A', strtotime($cron->next_run)) : '' ?></td>
                        <td>
                            <?php if($cron->last_status == "success"): ?>
                                <span class="badge badge-success">Success</span>
                            <?php elseif($cron->last_status == "failure"): ?>
                                <span class="badge badge-danger" data-toggle="tooltip" title="<?= htmlspecialchars($cron->failure_reason?? '', ENT_QUOTES) ?>">Failed</span>
                            <?php else: ?>
                                <span class="badge badge-secondary">Unknown</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <label class="switch skooly-switch">
                                <input type="checkbox"
                                    class="cron-enable-switch"
                                    data-cron-id="<?= $cron->id ?>"
                                    <?= $cron->enabled ? 'checked' : '' ?>>
                                <span class="slider round"></span>
                            </label>
                        </td>
                        <td>
                            <form class="form-inline" id="add-usertype-form-<?= $cron->id ?>" onsubmit="return false;">
                                <div class="input-group">
                                    <select class="form-control" id="usertype-<?= $cron->id ?>">
                                        <option value="admin">Admin</option>
                                        <option value="teacher">Teacher</option>
                                        <option value="student">Student</option>
                                        <option value="accountant">Accountant</option>
                                        <!-- Add more as needed -->
                                    </select>
                                    <span class="input-group-btn">
                                        <button type="button" class="btn btn-primary add-usertype-btn" data-cron="<?= $cron->id ?>">Add</button>
                                    </span>
                                </div>
                            </form>
                            <ul id="cron-notify-list-<?= $cron->id ?>">
                                <?php foreach($cron->notifications as $note): ?>
                                    <li>
                                        <?= ucfirst($note->contact_value) ?>
                                        <button class="btn btn-xs btn-danger remove-contact" data-id="<?= $note->id ?>">Remove</button>
                                    </li>
                                <?php endforeach; ?>
                                <?php if (empty($cron->notifications)) { ?>
                                    <li class="text-muted">No usertypes yet.</li>
                                <?php } ?>
                            </ul>
                        </td>
                        <td>
                            <button class="btn btn-info btn-sm cron-detail-btn" data-toggle="tooltip" data-placement="top" title="<?= htmlspecialchars($cron->message?? '', ENT_QUOTES) ?>">
                                <i class="fa fa-info-circle"></i>
                            </button>
                        </td>
                    </tr>
                <?php } } else { ?>
                    <tr><td colspan="10" class="text-center">No cron jobs available.</td></tr>
                <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();

    $('.cron-detail-btn').click(function () {
        let tooltip = $(this);
        tooltip.tooltip('show');
        setTimeout(() => { tooltip.tooltip('hide'); }, 3000);
    });

    $(".cron-enable-switch").change(function () {
        let status = this.checked ? 1 : 0;
        let cronId = $(this).data("cron-id");
        $.ajax({
            type: "POST",
            url: "<?= base_url('automation/update_cron_enabled') ?>",
            data: { id: cronId, enabled: status },
            dataType: "json"
        });
    });

    $(".add-usertype-btn").click(function(){
        var cron_id = $(this).data('cron');
        var usertype = $('#usertype-' + cron_id).val();
        $.post('<?= base_url('automation/add_cron_contact') ?>', {
            cron_id: cron_id,
            contact_type: 'usertype',
            contact_value: usertype
        }, function(resp){
            if(resp.success) location.reload();
        }, 'json');
    });

    $(".remove-contact").click(function(){
        var id = $(this).data('id');
        $.post('<?= base_url('automation/remove_cron_contact') ?>', {id: id}, function(resp){
            if(resp.success) location.reload();
        }, 'json');
    });
});
</script>