<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Tattendance_m extends MY_Model {

	protected $_table_name = 'tattendance';
	protected $_primary_key = 'tattendanceID';
	protected $_primary_filter = 'intval';
	protected $_order_by = "monthyear asc";

	function __construct() {
		parent::__construct();
	}

	public function get_tattendance($array=NULL, $signal=FALSE) {
		$query = parent::get($array, $signal);
		return $query;
	}

	public function get_order_by_tattendance($array=NULL) {
		$query = parent::get_order_by($array);
		return $query;
	}

	public function insert_tattendance($array) {
		$error = parent::insert($array);
		return $error;
	}

	public function insert_batch_tattendance($array) {
		$id = parent::insert_batch($array);
		return $id;
	}

	public function update_tattendance($data, $id = NULL) {
		parent::update($data, $id);
		return $id;
	}

	public function update_batch_tattendance($data, $id = NULL) {
        parent::update_batch($data, $id);
        return TRUE;
    }

	public function delete_tattendance($id){
		parent::delete($id);
	}


	public function verify_attendence($where)
	{
		// return $where;
		$attendence = $this->db->select('*')
				->from('clock_in_out')
				->join('tattendance', 'tattendance.tattendanceID = clock_in_out.attendanceID')
				->join('teacher','teacher.teacherID = clock_in_out.userID')
				// ->from('teacher')
				// ->join('tattendance', 'tattendance.teacherID = teacher.teacherID', 'LEFT')
				// ->join('clock_in_out','clock_in_out.attendanceID = tattendance.tattendanceID','LEFT')
				->where($where)
				->get()->row();
		return $attendence;

	}


	public function get_today_attendence($teacherID)
	{
		return $this->db->select('*')
			->from('tattendance')
			->where('teacherID',$teacherID)
			->where('monthyear',date('m-Y'))
			->get()->row();
	}

	public function get_attendance_report($where){
	
		return $this->db->select('tattendance.teacherID,name,clock_in_out.*,tattendance.*')
			->from('clock_in_out')
			->join('tattendance', 'tattendance.tattendanceID = clock_in_out.attendanceID')
			->join('teacher','teacher.teacherID = clock_in_out.userID')
			// ->from('teacher')
			// ->join('tattendance', 'tattendance.teacherID = teacher.teacherID', 'LEFT')
			// ->join('clock_in_out','clock_in_out.attendanceID = tattendance.tattendanceID','LEFT')
			->where('clock_in_out.usertypeID',2)
			->where($where)
			->order_by('last_modified','desc')
			->get()->result();
	}

}