<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Product_m extends MY_Model {

    protected $_table_name = 'product';
    protected $_primary_key = 'productID';
    protected $_primary_filter = 'intval';
    protected $_order_by = "productID asc";

    function __construct() {
        parent::__construct();
    }

    public function get_products($keyword = '') {
        $this->db->select('*');
        $this->db->from('product');
        // if ($keyword != '') {
        //    $this->db->like('productname', $keyword);
        // }
        $query = $this->db->get();
        return $query->result();
     }

     public function get_products_category($array) {
        // $this->db->select('product.*, productcategory.productcategoryname');
        // $this->db->from('product');
        // $this->db->join('productcategory', 'product.productcategoryID = productcategory.productcategoryID');
        // $this->db->group_by('product.productcategoryID');
        // return $this->db->get()->result();

        $this->db->select('product.productcategoryID, SUM(productpurchaseitem.productpurchaseunitprice * productpurchaseitem.productpurchasequantity) as total_price, SUM(productpurchaseitem.productpurchasequantity) as total_quantity');
        $this->db->from('productpurchaseitem');
        $this->db->join('product', 'product.productID = productpurchaseitem.productID');
        $this->db->join('productpurchase', 'productpurchase.productpurchaseID = productpurchaseitem.productpurchaseID');
        $this->db->group_by('product.productcategoryID');
        if ( customCompute($array) ) {
            $this->db->where($array);
        }
        $query = $this->db->get();
        return $query->result();

    }

    public function get_products_category_sale($array) {
    
        $this->db->select('product.productcategoryID, SUM(productsaleitem.productsaleunitprice * productsaleitem.productsalequantity) as total_price, SUM(productsaleitem.productsalequantity) as total_quantity');
        $this->db->from('productsaleitem');
        $this->db->join('product', 'product.productID = productsaleitem.productID');
        $this->db->join('productsale', 'productsale.productsaleID = productsaleitem.productsaleID');
        $this->db->group_by('product.productcategoryID');
        if ( customCompute($array) ) {
            $this->db->where($array);
        }
        $query = $this->db->get();
        return $query->result();
    
    }    
     

    function get_product($array=NULL, $signal=FALSE) {
        $query = parent::get($array, $signal);
        return $query;
    }

    function get_single_product($array) {
        $query = parent::get_single($array);
        return $query;
    }

    function get_order_by_product($array=NULL) {
        $query = parent::get_order_by($array);
        return $query;
    }

    function insert_product($array) {
        $id = parent::insert($array);
        return $id;
    }

    function update_product($data, $id = NULL) {
        parent::update($data, $id);
        return $id;
    }

    public function delete_product($id){
        parent::delete($id);
    }
}
