<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Lunch_m extends MY_Model {

    protected $_table_name = 'lunchlogs';
    protected $_primary_key = 'id';
    protected $_primary_filter = 'intval';
    protected $_order_by = "date desc";

    function __construct() {
        parent::__construct();
    }

    // public function getData($array = null){
    //     $this->db->select('lunchlogs.*, student.name');
    //     $this->db->from('lunchlogs');
    //     $this->db->join('student', 'student.studentID = lunchlogs.studentID', 'left');
    //     if ( customCompute($array) ) {
    //         $this->db->where($array);
    //     }
    //     $this->db->order_by('date desc');
    //     $query = $this->db->get();
    //     $lunchlogs = $query->result();

    //     return $lunchlogs;
    // }
    
    public function getData($array = null){
        $this->db->select('lunchlogs.*, student.name');
        $this->db->from('lunchlogs');
        $this->db->join('student', 'student.studentID = lunchlogs.studentID', 'left');
        if ( customCompute($array) ) {
            $this->db->where($array);
        }
        $this->db->order_by('date desc');
        $query = $this->db->get();
        $lunchlogs = $query->result();

        $this->db->select('SUM(amount) as total_amount');
        $this->db->from('lunchlogs');
        if ( customCompute($array) ) {
            $this->db->where($array);
        }
        $query = $this->db->get();
        $total_amount = $query->row()->total_amount;

        return array('lunchlogs' => $lunchlogs, 'total_amount' => $total_amount);
    }
    
    public function getDatastudent($studentID){
        $this->db->select('lunchlogs.*');
        $this->db->from('lunchlogs');
        $this->db->where('studentID', $studentID);
        // $this->db->limit(10);
        $query = $this->db->get();
    
        return $query->result();
    }

    
    public function insert_lunch($array) {
		$error = parent::insert($array);
		return TRUE;
	}
}