<?php
defined('BASEPATH') OR exit('No direct script access allowed');

if (!function_exists('show_sweetalert')) {
    function show_sweetalert() {
        $CI =& get_instance();
        
        $alerts = [];
        
        // Check for all flashdata types
        $types = ['success', 'error', 'warning', 'info'];
        foreach ($types as $type) {
            if ($CI->session->flashdata($type)) {
                $message = addslashes($CI->session->flashdata($type));
                $alerts[] = [
                    'type' => $type,
                    'message' => $message
                ];
                // CLEAR THE FLASHDATA AFTER USING IT
                $CI->session->unset_userdata($type);
            }
        }
        
        if (!empty($alerts)) {
            echo "<script>
            document.addEventListener('DOMContentLoaded', function() {";
            
            foreach ($alerts as $alert) {
                $title = ucfirst($alert['type']);
                $icon = $alert['type'];
                
                // Custom titles for different alert types
                if ($alert['type'] == 'error') $title = 'Error!';
                if ($alert['type'] == 'success') $title = 'Success!';
                
                echo "
                Swal.fire({
                    title: '{$title}',
                    text: '{$alert['message']}',
                    icon: '{$icon}',
                    confirmButtonText: 'OK',
                    confirmButtonColor: '#3085d6',
                    allowOutsideClick: false
                });";
            }
            
            echo "});
            </script>";
        }
    }
}

if (!function_exists('set_swal_flash')) {
    function set_swal_flash($type, $message) {
        $ci =& get_instance();
        $ci->session->set_flashdata($type, $message);
    }
}

if (!function_exists('get_swal_flash')) {
    function get_swal_flash() {
        $ci =& get_instance();
        $types = ['success', 'error', 'warning', 'info'];
        
        foreach ($types as $type) {
            if ($message = $ci->session->flashdata($type)) {
                return [
                    'type' => $type,
                    'message' => addslashes($message)
                ];
            }
        }
        return null;
    }
}

if (!function_exists('render_swal_flash')) {
    function render_swal_flash() {
        $flash = get_swal_flash();
        if ($flash) {
            $title = ucfirst($flash['type']);
            if ($flash['type'] == 'error') $title = 'Error!';
            if ($flash['type'] == 'success') $title = 'Success!';
            
            echo "<script>
            document.addEventListener('DOMContentLoaded', function() {
                Swal.fire({
                    title: '{$title}',
                    text: '{$flash['message']}',
                    icon: '{$flash['type']}',
                    confirmButtonText: 'OK',
                    confirmButtonColor: '#3085d6',
                    allowOutsideClick: false
                });
            });
            </script>";
        }
    }
}

if (!function_exists('swal_data_attributes')) {
    function swal_data_attributes($type = 'delete', $custom_text = null) {
        $attributes = [
            'class' => 'confirm-action sms-check-button'
        ];
        
        switch($type) {
            case 'delete':
                $attributes['data-title'] = 'Are you sure?';
                $attributes['data-text'] = $custom_text ?: 'You are about to delete a record. This cannot be undone.';
                $attributes['data-icon'] = 'warning';
                $attributes['data-confirm-button-text'] = 'Yes, delete it!';
                break;
                
            case 'update':
                $attributes['data-title'] = 'Confirm Update';
                $attributes['data-text'] = $custom_text ?: 'Are you sure you want to update this record?';
                $attributes['data-icon'] = 'question';
                $attributes['data-confirm-button-text'] = 'Yes, update it!';
                break;
                
            case 'submit':
                $attributes['data-title'] = 'Confirm Submission';
                $attributes['data-text'] = $custom_text ?: 'Are you sure you want to submit this form?';
                $attributes['data-icon'] = 'question';
                $attributes['data-confirm-button-text'] = 'Yes, submit it!';
                break;
                
            case 'cancel':
                $attributes['data-title'] = 'Confirm Cancellation';
                $attributes['data-text'] = $custom_text ?: 'Are you sure you want to cancel this operation?';
                $attributes['data-icon'] = 'warning';
                $attributes['data-confirm-button-text'] = 'Yes, cancel it!';
                break;
                
            case 'reset':
                $attributes['data-title'] = 'Confirm Reset';
                $attributes['data-text'] = $custom_text ?: 'Are you sure you want to reset this data?';
                $attributes['data-icon'] = 'warning';
                $attributes['data-confirm-button-text'] = 'Yes, reset it!';
                break;
                
            default:
                $attributes['data-title'] = 'Are you sure?';
                $attributes['data-text'] = $custom_text ?: 'This action cannot be undone.';
                $attributes['data-icon'] = 'warning';
                $attributes['data-confirm-button-text'] = 'Yes, proceed!';
        }
        
        return $attributes;
    }
}

if (!function_exists('swal_confirm_button')) {
    function swal_confirm_button($url, $text, $button_class = 'btn-primary', $swal_type = 'custom', $custom_text = null, $icon = null, $attributes = []) {
        $swal_attrs = swal_data_attributes($swal_type, $custom_text);
        
        $defaultAttributes = [
            'class' => 'btn ' . $button_class
        ];
        
        // Add icon if provided
        $button_content = $text;
        if ($icon) {
            $button_content = "<i class='{$icon}'></i> " . $text;
        }
        
        $attributes = array_merge($defaultAttributes, $swal_attrs, $attributes);
        
        $attrString = '';
        foreach ($attributes as $key => $value) {
            if ($key !== 'href') {
                $attrString .= ' ' . $key . '="' . htmlspecialchars($value) . '"';
            }
        }
        
        return '<a href="' . $url . '"' . $attrString . '>' . $button_content . '</a>';
    }
}

if (!function_exists('swal_submit_button')) {
    function swal_submit_button($text = 'Submit', $swal_type = 'submit', $custom_text = null, $button_class = 'btn-success', $attributes = []) {
        $swal_attrs = swal_data_attributes($swal_type, $custom_text);
        
        $defaultAttributes = [
            'type' => 'submit',
            'class' => 'btn ' . $button_class
        ];
        
        $attributes = array_merge($defaultAttributes, $swal_attrs, $attributes);
        
        $attrString = '';
        foreach ($attributes as $key => $value) {
            $attrString .= ' ' . $key . '="' . htmlspecialchars($value) . '"';
        }
        
        return '<button' . $attrString . '>' . $text . '</button>';
    }
}

// Backward compatibility alias
if (!function_exists('render_sweetalert_flash')) {
    function render_sweetalert_flash() {
        return show_sweetalert();
    }
}