<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class User_attendance_report extends Admin_Controller {

	function __construct() {
		parent::__construct();
		$this->load->model("user_m");
		$this->load->model("uattendance_m");
		$this->load->model("leaveapplication_m");
		$this->load->model("setting_m");
		$language = $this->session->userdata('lang');
		$this->lang->load('uattendance', $language);
		$this->lang->load('attendancereport', $language);
	}


    public function index()
    {
        $this->data['classes'] = $this->classes_m->general_get_classes();
		$this->data['get_all_holidays'] = $this->getHolidaysSession();
		$settings = $this->setting_m->get_setting();
        $this->data['headerassets'] = array(
			'css' => array(
				'assets/datepicker/datepicker.css',
				'assets/select2/css/select2.css',
				'assets/select2/css/select2-bootstrap.css'
			),
			'js' => array(
				'assets/datepicker/datepicker.js',
				'assets/select2/select2.js',
				'assets/jquery-validate/jquery.validate.min.js'
			)
		);

		// $this->data['footerassets'] = array(
        //     'js' => array(
        //         'assets/jquery-validate/jquery.validate.min.js'
        //     )
        // );

        $filter = array();

        if($_GET){
            $filter = array(
                'check_date>='         =>  $this->input->get('start_date'),
                'check_date<='         =>  $this->input->get('end_date')
            );
        }

        $this->data['attendence_report'] = $this->uattendance_m->get_attendance_report($filter);
		$this->data['working_times'] = $settings->user_working_time;


        $this->data["subview"] = "report/attendance/UserAttendanceReport";
        $this->load->view('_layout_main', $this->data);
    }


}