<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Smspanel extends Admin_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('usertype_m');
        $this->load->model('systemadmin_m');
        $this->load->model('smssettings_m');
        $this->load->model('user_m');
        $this->load->model('payment_m');
        $this->load->library("inilabs", $this->data);
        $this->load->library('sms/skooly_init');
        $this->load->library('sms/sms_panel');
        $this->load->model('setting_m');

        $language = $this->session->userdata('lang');
        $this->lang->load('mailandsms', $language);
        
    }

    public function index()
    {
        $this->data['headerassets'] = array(
            'css' => array(
                'assets/select2/css/select2.css',
                'assets/select2/css/select2-bootstrap.css',
                'assets/editor/jquery-te-1.4.0.css'
            ),
            'js' => array(
                'assets/select2/select2.js',
                'assets/editor/jquery-te-1.4.0.min.js'
            )
        );

        $this->data['usertypes'] = $this->usertype_m->get_usertype();
        $this->data['settings'] = $this->setting_m->get_setting_array();
        $this->data['stats'] = $this->fetchDashboardStats();

        $this->data["subview"] = "mailandsms/panel";
        $this->load->view('_layout_main', $this->data);
    }

    private function fetchDashboardStats()
    {
        $stats = [
            'available_credits' => 0,
            'total_clients' => 0,
            'last_transaction' => 'N/A',
            'total_groups' => 0,
            'transactions' => []
        ];   
        

        $responses = $this->sms_panel->makeConcurrentApiRequests();

        $creditsResponse = $responses[0];
        if (isset($creditsResponse['response']['account']['smsBalance'])) {
            $stats['available_credits'] = $creditsResponse['response']['account']['smsBalance'];
        }

        $clientsResponse = $responses[1];
        if (isset($clientsResponse['response']['userList'])) {
            $stats['clients'] = $this->parseClientData($clientsResponse['response']['userList']);
            $stats['total_clients'] = count($clientsResponse['response']['userList']);
        }

        $transactionResponse = $responses[2];
        if (isset($transactionResponse['response']['historyList'])) {
            
            usort($transactionResponse['response']['historyList'], function ($a, $b) {
                return $b['history']['addedTime'] <=> $a['history']['addedTime'];
            });

            $stats['transactions'] = $transactionResponse['response']['historyList'];
            foreach (array_reverse($transactionResponse['response']['historyList']) as $transaction) {
                if (isset($transaction['history']['type']) && $transaction['history']['type'] === 'CREDIT') {
                    $stats['last_transaction'] = number_format($transaction['history']['credits'], 2);
                    break;
                }
            }
        }

        $groupsResponse = $responses[3];
        if (isset($groupsResponse['response']['groups'])) {
            $stats['total_groups'] = count($groupsResponse['response']['groups']);
        }


        return $stats;
    }

    private function parseClientData($clientData)
    {
        return array_map(function ($clientWrapper) {
            $client = $clientWrapper['user'] ?? [];
            return [
                'id' => $client['userId'] ?? '',
                'username' => $client['userName'] ?? '',
                'usertype' => $client['userType'] ?? '',
                'email' => $client['emailId'] ?? '',
                'mobile' => $client['mobileNo'] ?? '',
                'balance' => $client['smsBalance'] ?? '0.00',
                'is_smpp_active' => isset($client['smppEnabled']) && $client['smppEnabled'] === '1'
            ];
        }, $clientData);
    }

    public function updateCredits()
    {   
        $response = null;

        if ($this->input->server('REQUEST_METHOD') == 'POST') {
            $clientId = $this->input->post('client_username');
            $action = $this->input->post('action');
            $amount = $this->input->post('amount');
            $comment = ucfirst($action) . ' credits via admin panel';

            $response = $this->sms_panel->updateCredits($clientId, $amount, $action, $comment);
        }

        echo $response;
        exit;
        
    }

    public function updateSettings()
    {   
        try{
            $settings = [
                'sms_credit_value' => $this->input->post('sms_credit_value'),
                'allowed_url' => $this->input->post('allowed_url'),
                'auto_recharge' => $this->input->post('auto_recharge') ? 1 : 0,
                'notify_admin' => $this->input->post('notify_admin') ? 1 : 0,
                'notify_client' => $this->input->post('notify_client') ? 1 : 0,
                'sms_threshold' => $this->input->post('sms_threshold'),
            ];
    
            $this->setting_m->insertorupdate($settings);
    
            $response['message'] ='Settings updated successfully.';
        }catch(\Exception $e){
            $response['message'] = $e->getMessage();
        }        

        echo json_encode($response);
    }

}
