<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Sendsms extends Admin_Controller
{
	/*
| -----------------------------------------------------
| PRODUCT NAME: 	INILABS SCHOOL MANAGEMENT SYSTEM
| -----------------------------------------------------
| AUTHOR:			INILABS TEAM
| -----------------------------------------------------
| EMAIL:			info@inilabs.net
| -----------------------------------------------------
| COPYRIGHT:		RESERVED BY INILABS IT
| -----------------------------------------------------
| WEBSITE:			http://inilabs.net
| -----------------------------------------------------
*/
	function __construct()
	{
		parent::__construct();
		$this->load->model('usertype_m');
		$this->load->model('systemadmin_m');
		$this->load->model('teacher_m');
		$this->load->model('student_m');
		$this->load->model('parents_m');
		$this->load->model('user_m');
		$this->load->model('classes_m');
		$this->load->model('section_m');
		$this->load->model("mark_m");
		$this->load->model("grade_m");
		$this->load->model("exam_m");
		$this->load->model('mailandsms_m');
		$this->load->model('mailandsmstemplate_m');
		$this->load->model('mailandsmstemplatetag_m');
		$this->load->model('studentgroup_m');
		$this->load->model('studentrelation_m');
		$this->load->model('emailsetting_m');
		$this->load->model('subject_m');
		$this->load->library("email");
		$this->load->model('payment_m');
		$this->load->library("inilabs", $this->data);
		$this->load->library('sms/skooly_init');

		$language = $this->session->userdata('lang');
		$this->lang->load('mailandsms', $language);
	}
	public function check_sms_usertypeID()
	{
		if ($this->input->post('sms_usertypeID') == 'select') {
			$this->form_validation->set_message("check_sms_usertypeID", "The %s field is required");
			return FALSE;
		} else {
			return TRUE;
		}
	}
    protected function rules_sms()
	{
		$rules = array(
			array(
				'field' => 'sms_usertypeID',
				'label' => $this->lang->line("mailandsms_usertype"),
				'rules' => 'trim|required|xss_clean|max_length[15]|callback_check_sms_usertypeID'
			),
			array(
				'field' => 'sms_schoolyear',
				'label' => $this->lang->line("mailandsms_schoolyear"),
				'rules' => 'trim|xss_clean'
			),
			array(
				'field' => 'sms_class',
				'label' => $this->lang->line("mailandsms_select_class"),
				'rules' => 'trim|xss_clean'
			),
			array(
				'field' => 'sms_users',
				'label' => $this->lang->line("mailandsms_users"),
				'rules' => 'trim|xss_clean'
			),
			array(
				'field' => 'sms_template',
				'label' => $this->lang->line("mailandsms_template"),
				'rules' => 'trim|xss_clean'
			),
			// array(
			// 	'field' => 'sms_getway',
			// 	'label' => $this->lang->line("mailandsms_getway"),
			// 	'rules' => 'trim|required|xss_clean|max_length[15]|callback_check_getway'
			// ),
			array(
				'field' => 'sms_message',
				'label' => $this->lang->line("mailandsms_message"),
				'rules' => 'trim|required|xss_clean|max_length[20000]'
			),
		);
		return $rules;
	}

	public function index()
	{
		$this->data['headerassets'] = array(
			'css' => array(
				'assets/select2/css/select2.css',
				'assets/select2/css/select2-bootstrap.css',
				'assets/editor/jquery-te-1.4.0.css'
			),
			'js' => array(
				'assets/select2/select2.js',
				'assets/editor/jquery-te-1.4.0.min.js'
			)
		);
		$this->data['usertypes'] = $this->usertype_m->get_usertype();
		$this->data['schoolyears'] = $this->schoolyear_m->get_schoolyear();
		$this->data['allClasses'] = $this->classes_m->general_get_classes();
		$this->data['sections'] = [];
		$classesID = $this->input->post("classesID");

		if ($classesID > 0) {
			$this->data['sections'] = $this->section_m->get_order_by_section(array("classesID" => $classesID));
		} else {
			$this->data['sections'] = [];
		}


		/* Start For Email */
		$email_usertypeID = $this->input->post("email_usertypeID");
		if ($email_usertypeID && $email_usertypeID != 'select') {
			$this->data['email_usertypeID'] = $email_usertypeID;
		} else {
			$this->data['email_usertypeID'] = 'select';
		}
		/* End For Email */

		/* Start For SMS */
		$sms_usertypeID = $this->input->post("sms_usertypeID");
		if ($sms_usertypeID && $sms_usertypeID != 'select') {
			$this->data['sms_usertypeID'] = $sms_usertypeID;
		} else {
			$this->data['sms_usertypeID'] = 'select';
		}
		/* End For SMS */
		
		if ($_POST) {
			$this->data['submittype'] = $this->input->post('type');
			if ($this->input->post('type') == "sms") {
				$rules = $this->rules_sms(); ;
				$this->form_validation->set_rules($rules);
				if ($this->form_validation->run() == FALSE) {
					$this->data['smsUserID'] = $this->input->post('sms_users');
					$this->data['smsTemplateID'] = $this->input->post('sms_template');

					$this->data['allStudents'] = $this->studentrelation_m->get_order_by_student(array('srschoolyearID' => $this->input->post('sms_schoolyear'), 'srclassesID' => $this->input->post('sms_class')));

					$this->data['emailUserID'] = 0;
					$this->data['emailTemplateID'] = 0;

					$this->data["email"] = 0;
					$this->data["sms"] = 1;
					$this->data["otheremail"] = 0;
					$this->data["othersms"] = 0;

					$this->data["subview"] = "mailandsms/add";
					$this->load->view('_layout_main', $this->data);
				} else {
					$getway = 'celcom'; //$this->input->post('sms_getway'); 
					
					$usertypeID = $this->input->post('sms_usertypeID');
					$schoolyearID = $this->input->post('sms_schoolyear');

					if ($usertypeID == 1) { /* FOR ADMIN */
						$systemadminID = $this->input->post('sms_users');
						if ($systemadminID == 'select') {
							$countusers = '';
							$retval = 1;
							$retmess = '';

							$message = $this->input->post('sms_message');
							$multisystemadmins = $this->systemadmin_m->get_systemadmin();
							if (customCompute($multisystemadmins)) {

								foreach ($multisystemadmins as $key => $multisystemadmin) {
									$message = SmsUtils::userConfigSMS($this->data, $message, $multisystemadmin, $usertypeID);

									if(!empty($message)){
										$adminArray[] = [
											'name'=> $multisystemadmin->name,
											'phone' => $multisystemadmin->phone,
											'message' => $message
										];
									}
								}									
									
								Skooly::sendBulk($adminArray);

								redirect(base_url('mailandsms/index'));
							} else {
								$this->session->set_flashdata('error', $this->lang->line('mailandsms_notfound_error'));
								redirect(base_url('mailandsms/add'));
							}
						} else {
							$retval = 1;
							$retmess = '';
							$message = $this->input->post('sms_message');
							$singlesystemadmin = $this->systemadmin_m->get_systemadmin($systemadminID);
							if (customCompute($singlesystemadmin)) {
								$message = SmsUtils::userConfigSMS($this->data, $message, $singlesystemadmin, $usertypeID);
								
								if(!empty($message)){
									Skooly::send($singlesystemadmin->phone, $message, $singlesystemadmin->name);
								}
								redirect(base_url('mailandsms/index'));
							} else {
								$this->session->set_flashdata('error', $this->lang->line('mailandsms_notfound_error'));
								redirect(base_url('mailandsms/add'));
							}
						}
					} elseif ($usertypeID == 2) { /* FOR TEACHER */
						$teacherID = $this->input->post('sms_users');
						if ($teacherID == 'select') {
							$message = $this->input->post('sms_message');
							$multiteachers = $this->teacher_m->general_get_teacher();
							if (customCompute($multiteachers)) {
								$countusers = '';
								$retval = 1;
								$retmess = '';
								foreach ($multiteachers as $key => $multiteacher) {
									$message = SmsUtils::userConfigSMS($this->data, $message, $multiteacher, $usertypeID);
									$teacherArray[] = [
										'name'=> $multiteacher->name,
										'phone' => $multiteacher->phone,
										'message' => $message
									];
								}

								Skooly::sendBulk($teacherArray);

								redirect(base_url('mailandsms/index'));
							} else {
								$this->session->set_flashdata('error', $this->lang->line('mailandsms_notfound_error'));
								redirect(base_url('mailandsms/add'));
							}
						} else {
							$retval = 1;
							$retmess = '';
							$message = $this->input->post('sms_message');
							$singleteacher = $this->teacher_m->general_get_teacher($teacherID);
							if (customCompute($singleteacher)) {
								$message = SmsUtils::userConfigSMS($this->data, $message, $singleteacher, $usertypeID);
								
								if(!empty($message)){
									Skooly::send($singleteacher->phone, $message, $singleteacher->name);
								}

								redirect(base_url('mailandsms/index'));
							} else {
								$this->session->set_flashdata('error', $this->lang->line('mailandsms_notfound_error'));
								redirect(base_url('mailandsms/add'));
							}
						}
					} elseif ($usertypeID == 3) { /* FOR STUDENT */
						$exclude = $this->input->post('sms_exclude');
						$queryArray = [];
						if($exclude > 0) {
							$queryArray['active'] = ($exclude == 2)? 0 : 1;
						}
						$studentID = $this->input->post('sms_users');
						if ($studentID == 'select') {
							$class = $this->input->post('sms_class');
							if ($class == 'select') {
								/* Multi School Year */
								$countusers = '';
								$retval = 1;
								$retmess = '';

								$schoolyear = $this->input->post('sms_schoolyear');
								if ($schoolyear == 'select') {
									$message = $this->input->post('sms_message');
									$multiSchoolYearStudents = $this->studentrelation_m->general_get_student(TRUE, $queryArray);
									if (customCompute($multiSchoolYearStudents)) {
										foreach ($multiSchoolYearStudents as $key => $multiSchoolYearStudent) {
											$message = SmsUtils::userConfigSMS($this->data, $message, $multiSchoolYearStudent, $usertypeID, $multiSchoolYearStudent->srschoolyearID);
											
											$multiSchoolYearStudentArray[] = [
												'name'=> $multiSchoolYearStudent->name,
												'phone' => $multiSchoolYearStudent->phone,
												'message' => $message
											];
										}
										Skooly::sendBulk($multiSchoolYearStudentArray);
										redirect(base_url('mailandsms/index'));
									} else {
										$this->session->set_flashdata('error', $this->lang->line('mailandsms_notfound_error'));
										redirect(base_url('mailandsms/add'));
									}
								} else {
									/* Single school Year Student */
									$countusers = '';
									$retval = 1;
									$retmess = '';
									$message = $this->input->post('sms_message');
									$singleSchoolYear = $this->input->post('sms_schoolyear');
									if($exclude > 0) {
										$queryArray = array('srschoolyearID' => $singleSchoolYear, 'active'=> ($exclude == 2)? 0 : 1);
									}else{
										$queryArray = array('srschoolyearID' => $singleSchoolYear);
									}
									$singleSchoolYearStudents = $this->studentrelation_m->general_get_order_by_student($queryArray, TRUE);
									
									$singleSchoolYearStudentArray = [];
									if (customCompute($singleSchoolYearStudents)) {
										foreach ($singleSchoolYearStudents as $key => $singleSchoolYearStudent) {
											
											$singleSchoolYearStudentArray[] = [
												'name'=> $singleSchoolYearStudent->name,
												'phone' => $singleSchoolYearStudent->phone,
												'message' => SmsUtils::userConfigSMS($this->data, $message, $singleSchoolYearStudent, $usertypeID, $schoolyearID)
											];
										}
										
										Skooly::sendBulk($singleSchoolYearStudentArray);

										redirect(base_url('mailandsms/index'));
									} else {
										$this->session->set_flashdata('error', $this->lang->line('mailandsms_notfound_error'));
										redirect(base_url('mailandsms/add'));
									}
								}
							} else {
								/* Single Class Student */
								$countusers = '';
								$retval = 1;
								$retmess = '';

								$message = $this->input->post('sms_message');
								$singleClass = $this->input->post('sms_class');
								$singleSection = $this->input->post('sms_section');
								if($exclude > 0) {
									$queryArray = array('srclassesID' => $singleClass, 'srsectionID' => $singleSection, 'srschoolyearID' => $schoolyearID, 'active'=> ($exclude == 2)? 0 : 1);
								}else{
									$queryArray = array('srclassesID' => $singleClass, 'srsectionID' => $singleSection, 'srschoolyearID' => $schoolyearID);
								}
								if ((int)$singleSection) {
									$singleClassStudents = $this->studentrelation_m->general_get_order_by_student($queryArray, TRUE);
								} else {
									if($exclude > 0) {
										$queryArray = array('srclassesID' => $singleClass, 'srschoolyearID' => $schoolyearID, 'active'=> ($exclude == 2)? 0 : 1);
									}else{
										$queryArray = array('srclassesID' => $singleClass, 'srschoolyearID' => $schoolyearID);
									}
									$singleClassStudents = $this->studentrelation_m->general_get_order_by_student($queryArray, TRUE);
								}
								if (customCompute($singleClassStudents)) {
									$countusers = '';
									foreach ($singleClassStudents as $key => $singleClassStudent) {
										
										$singleClassStudentArray[] = [
											'name'=> $singleClassStudent->name,
											'phone' => $singleClassStudent->phone,
											'message' => SmsUtils::userConfigSMS($this->data, $message, $singleClassStudent, $usertypeID, $schoolyearID)
										];
									}
									Skooly::sendBulk($singleClassStudentArray);

									redirect(base_url('mailandsms/index'));
								} else {
									$this->session->set_flashdata('error', $this->lang->line('mailandsms_notfound_error'));
									redirect(base_url('mailandsms/add'));
								}
							}
						} else {
							/* Single Student */
							$retval = 1;
							$retmess = '';

							$message = $this->input->post('sms_message');
							if($exclude > 0) {
								$queryArray = array('srstudentID' => $studentID, 'srschoolyearID' => $schoolyearID, 'active'=> ($exclude == 2)? 0 : 1);
							}else{
								$queryArray = array('srstudentID' => $studentID, 'srschoolyearID' => $schoolyearID);
							}
							$singlestudent = $this->studentrelation_m->general_get_single_student($queryArray, TRUE);
							if (customCompute($singlestudent)) {
								$message = SmsUtils::userConfigSMS($this->data, $message, $singlestudent, $usertypeID, $schoolyearID);
								if(!empty($message)){
									Skooly::send($singlestudent->phone, $message, $singlestudent->name);
								}
								redirect(base_url('mailandsms/index'));
							} else {
								$this->session->set_flashdata('error', $this->lang->line('mailandsms_notfound_error'));
								redirect(base_url('mailandsms/add'));
							}
						}
					} elseif ($usertypeID == 4) { /* FOR PARENTS */
						$parentsID = $this->input->post('sms_users');
						if ($parentsID == 'select') {
							$countusers = '';
							$retval = 1;
							$retmess = '';

							$message = $this->input->post('sms_message');
							$multiparents = $this->parents_m->get_parents();
							if (customCompute($multiparents)) {

								foreach ($multiparents as $key => $multiparent) {
								
									$multiparentArray[] = [
										'name'=> $multiparent->name,
										'phone' => $multiparent->phone,
										'message' => SmsUtils::userConfigSMS($this->data, $message, $multiparent, $usertypeID)
									];
								}
								Skooly::sendBulk($multiparentArray);
								redirect(base_url('mailandsms/index'));
							} else {
								$this->session->set_flashdata('error', $this->lang->line('mailandsms_notfound_error'));
								redirect(base_url('mailandsms/add'));
							}
						} else {
							$retval = 1;
							$retmess = '';

							$message = $this->input->post('sms_message');
							$singleparent = $this->parents_m->get_parents($parentsID);
							if (customCompute($singleparent)) {
								$message = SmsUtils::userConfigSMS($this->data, $message, $singleparent, $usertypeID);
								if(!empty($message)){
									Skooly::send($singleparent->phone, $message, $singleparent->name);
								}
								redirect(base_url('mailandsms/index'));
							} else {
								$this->session->set_flashdata('error', $this->lang->line('mailandsms_notfound_error'));
								redirect(base_url('mailandsms/add'));
							}
						}
					} else { /* FOR ALL USERS */
						$userID = $this->input->post('sms_users');
						if ($userID == 'select') {
							$countusers = '';
							$retval = 1;
							$retmess = '';
							$message = $this->input->post('sms_message');
							$multiusers = $this->user_m->get_order_by_user(array('usertypeID' => $usertypeID));
							if (customCompute($multiusers)) {
								foreach ($multiusers as $key => $multiuser) {
									
									$multiuserArray[] = [
										'name'=> $multiuser->name,
										'phone' => $multiuser->phone,
										'message' => SmsUtils::userConfigSMS($this->data, $message, $multiuser, $usertypeID)
									];
								}
								Skooly::sendBulk($multiuserArray);
								redirect(base_url('mailandsms/index'));
							} else {
								$this->session->set_flashdata('error', $this->lang->line('mailandsms_notfound_error'));
								redirect(base_url('mailandsms/add'));
							}
						} else {
							$retval = 1;
							$retmess = '';
							$message = $this->input->post('sms_message');
							$singleuser = $this->user_m->get_user($userID);
							if (customCompute($singleuser)) {
								$message = SmsUtils::userConfigSMS($this->data, $message, $singleuser, $usertypeID);
								if(!empty($message)){
									Skooly::send($singleuser->phone, $message, $singleuser->name);
								}
								redirect(base_url('mailandsms/index'));
							} else {
								$this->session->set_flashdata('error', $this->lang->line('mailandsms_notfound_error'));
								redirect(base_url('mailandsms/add'));
							}
						}
					}
				}
			} elseif ($this->input->post('type') == "othersms") {
				$rules = $this->rules_othersms();
				$this->form_validation->set_rules($rules);
				if ($this->form_validation->run() == FALSE) {

					$this->data['emailUserID'] = 0;
					$this->data['emailTemplateID'] = 0;
					$this->data['allStudents'] = [];
					$this->data['smsUserID'] = 0;
					$this->data['smsTemplateID'] = 0;

					$this->data["email"] = 0;
					$this->data["sms"] = 0;
					$this->data["otheremail"] = 0;
					$this->data["othersms"] = 1;

					$this->data["subview"] = "mailandsms/add";
					$this->load->view('_layout_main', $this->data);
				} else {
					$to = $this->input->post('othersms_phone');
					$getway = 'celcom'; //$this->input->post('sms_getway');
					$message = $this->input->post('othersms_message');

					$result = $this->allgetway_send_message($getway, $to, $message);
					if ($result['check']) {
						$array = array(
							'usertypeID' => '0',
							'users' => $this->input->post('othersms_name'),
							'type' => ucfirst($this->lang->line('mailandsms_othersms')),
							'message' => $this->input->post('othersms_message'),
							'year' => date('Y'),
							'senderusertypeID' => $this->session->userdata('usertypeID'),
							'senderID' => $this->session->userdata('loginuserID')
						);
						if($getway != 'celcom'){
						    $this->mailandsms_m->insert_mailandsms($array);
						}
						redirect(base_url('mailandsms/index'));
					} else {
						$retmess = isset($result['message']) ? $result['message'] : $this->lang->line('mailandsms_error');
						$this->session->set_flashdata('error', $retmess);
						redirect(base_url("mailandsms/add"));
					}
				}
			} else {
				redirect('mailandsms/add');
			}
		} else {
			$this->data['emailUserID'] = 0;
			$this->data['emailTemplateID'] = 0;

			$this->data['smsUserID'] = 0;
			$this->data['smsTemplateID'] = 0;

			$this->data["email"] = 1;
			$this->data["sms"] = 0;
			$this->data["otheremail"] = 0;
			$this->data["othersms"] = 0;
			$this->data['submittype'] = 'none';

			$this->data['allStudents'] = array();
			$this->data["subview"] = "mailandsms/add";
			$this->load->view('_layout_main', $this->data);
		}
	}
	
	private function allgetway_send_message($getway, $to, $message)
	{
		$result = [];
		if ($getway == "clickatell") {
			if ($to) {
				$this->clickatell->send_message($to, $message);
				$result['check'] = TRUE;
				return $result;
			}
		} elseif ($getway == 'twilio') {
			$get = $this->twilio->get_twilio();
			$from = $get['number'];
			if ($to) {
				$response = $this->twilio->sms($from, $to, $message);
				if ($response->IsError) {
					$result['check'] = FALSE;
					$result['message'] = $response->ErrorMessage;
					return $result;
				} else {
					$result['check'] = TRUE;
					return $result;
				}
			}
		} elseif ($getway == 'bulk') {
			if ($to) {
				if ($this->bulk->send($to, $message) == TRUE) {
					$result['check'] = TRUE;
					return $result;
				} else {
					$result['check'] = FALSE;
					$result['message'] = "Check your bulk account";
					return $result;
				}
			}
		} elseif ($getway == 'msg91') {
			if ($to) {
				if ($this->msg91->send($to, $message) == TRUE) {
					$result['check'] = TRUE;
					return $result;
				} else {
					$result['check'] = FALSE;
					$result['message'] = "Check your msg91 account";
					return $result;
				}
			}
		} elseif ($getway == 'celcom') {
			if ($to) {
				if (Skooly::send($to, $message, '') == TRUE) {
					$result['check'] = TRUE;
					return $result;
				} else {
					$result['check'] = FALSE;
					$result['message'] = "Check your celcom account";
					return $result;
				}
			}
		}
	}

	private function tagConvertor($userTags, $user, $message, $sendType, $schoolyearID)
	{
		if (customCompute($userTags)) {
			foreach ($userTags as $key => $userTag) {
				if ($userTag->tagname == '[name]') {
					if ($user->name) {
						$message = str_replace('[name]', $user->name, $message);
					} else {
						$message = str_replace('[name]', ' ', $message);
					}
				} elseif ($userTag->tagname == '[designation]') {
					if ($user->designation) {
						$message = str_replace('[designation]', $user->designation, $message);
					} else {
						$message = str_replace('[designation]', ' ', $message);
					}
				} elseif ($userTag->tagname == '[dob]') {
					if ($user->dob) {
						$dob =  date("d M Y", strtotime($user->dob));
						$message = str_replace('[dob]', $dob, $message);
					} else {
						$message = str_replace('[dob]', ' ', $message);
					}
				} elseif ($userTag->tagname == '[gender]') {
					if ($user->sex) {
						$message = str_replace('[gender]', $user->sex, $message);
					} else {
						$message = str_replace('[gender]', ' ', $message);
					}
				} elseif ($userTag->tagname == '[religion]') {
					if ($user->religion) {
						$message = str_replace('[religion]', $user->religion, $message);
					} else {
						$message = str_replace('[religion]', ' ', $message);
					}
				} elseif ($userTag->tagname == '[email]') {
					if ($user->email) {
						$message = str_replace('[email]', $user->email, $message);
					} else {
						$message = str_replace('[email]', ' ', $message);
					}
				} elseif ($userTag->tagname == '[phone]') {
					if ($user->phone) {
						$message = str_replace('[phone]', $user->phone, $message);
					} else {
						$message = str_replace('[phone]', ' ', $message);
					}
				} elseif ($userTag->tagname == '[address]') {
					if ($user->address) {
						$message = str_replace('[address]', $user->address, $message);
					} else {
						$message = str_replace('[address]', ' ', $message);
					}
				} elseif ($userTag->tagname == '[jod]') {
					if ($user->jod) {
						$jod =  date("d M Y", strtotime($user->jod));
						$message = str_replace('[jod]', $jod, $message);
					} else {
						$message = str_replace('[jod]', ' ', $message);
					}
				} elseif ($userTag->tagname == '[username]') {
					if ($user->username) {
						$message = str_replace('[username]', $user->username, $message);
					} else {
						$message = str_replace('[username]', ' ', $message);
					}
				} elseif ($userTag->tagname == "[father's_name]") {
					if ($user->father_name) {
						$message = str_replace("[father's_name]", $user->father_name, $message);
					} else {
						$message = str_replace("[father's_name]", ' ', $message);
					}
				} elseif ($userTag->tagname == "[mother's_name]") {
					if ($user->mother_name) {
						$message = str_replace("[mother's_name]", $user->mother_name, $message);
					} else {
						$message = str_replace("[mother's_name]", ' ', $message);
					}
				} elseif ($userTag->tagname == "[father's_profession]") {
					if ($user->father_profession) {
						$message = str_replace("[father's_profession]", $user->father_profession, $message);
					} else {
						$message = str_replace("[father's_profession]", ' ', $message);
					}
				} elseif ($userTag->tagname == "[mother's_profession]") {
					if ($user->mother_profession) {
						$message = str_replace("[mother's_profession]", $user->mother_profession, $message);
					} else {
						$message = str_replace("[mother's_profession]", ' ', $message);
					}
				} elseif ($userTag->tagname == '[class]') {
					$classes = $this->classes_m->general_get_classes($user->srclassesID);
					if (customCompute($classes)) {
						$message = str_replace('[class]', $classes->classes, $message);
					} else {
						$message = str_replace('[class]', ' ', $message);
					}
				} elseif ($userTag->tagname == '[roll]') {
					if ($user->srroll) {
						$message = str_replace("[roll]", $user->srroll, $message);
					} else {
						$message = str_replace("[roll]", ' ', $message);
					}
				} elseif ($userTag->tagname == '[country]') {
					if ($user->country) {
						if (isset($this->data['allcountry'][$user->country])) {
							$message = str_replace("[country]", $this->data['allcountry'][$user->country], $message);
						} else {
							$message = str_replace("[country]", ' ', $message);
						}
					} else {
						$message = str_replace("[country]", ' ', $message);
					}
				} elseif ($userTag->tagname == '[state]') {
					if ($user->state) {
						$message = str_replace("[state]", $user->state, $message);
					} else {
						$message = str_replace("[state]", ' ', $message);
					}
				} elseif ($userTag->tagname == '[register_no]') {
					if ($user->srregisterNO) {
						$message = str_replace("[register_no]", $user->srregisterNO, $message);
					} else {
						$message = str_replace("[register_no]", ' ', $message);
					}
				}elseif ($userTag->tagname == '[balance]') {
					if ($user->srregisterNO) {
						$fee_balance = $this->payment_m->balance($user->srstudentID);
						$message = str_replace("[balance]", $fee_balance, $message);
					} else {
						$message = str_replace("[balance]", ' ', $message);
					}
				} elseif ($userTag->tagname == '[section]') {
					if ($user->srsectionID) {
						$section = $this->section_m->general_get_section($user->srsectionID);
						if (customCompute($section)) {
							$message = str_replace('[section]', $section->section, $message);
						} else {
							$message = str_replace('[section]', ' ', $message);
						}
					} else {
						$message = str_replace("[section]", ' ', $message);
					}
				} elseif ($userTag->tagname == '[blood_group]') {
					if ($user->bloodgroup && $user->bloodgroup != '0') {
						$message = str_replace("[blood_group]", $user->bloodgroup, $message);
					} else {
						$message = str_replace("[blood_group]", ' ', $message);
					}
				} elseif ($userTag->tagname == '[group]') {
					if ($user->srstudentgroupID && $user->srstudentgroupID != 0) {
						$group = $this->studentgroup_m->get_studentgroup($user->srstudentgroupID);
						if (customCompute($group)) {
							$message = str_replace('[group]', $group->group, $message);
						} else {
							$message = str_replace('[group]', ' ', $message);
						}
					} else {
						$message = str_replace('[group]', ' ', $message);
					}
				} elseif ($userTag->tagname == '[optional_subject]') {
					if ($user->sroptionalsubjectID && $user->sroptionalsubjectID != 0) {
						$subject = $this->subject_m->general_get_single_subject(array('subjectID' => $user->sroptionalsubjectID));
						if (customCompute($subject)) {
							$message = str_replace('[optional_subject]', $subject->subject, $message);
						} else {
							$message = str_replace('[optional_subject]', ' ', $message);
						}
					} else {
						$message = str_replace('[optional_subject]', ' ', $message);
					}
				} elseif ($userTag->tagname == '[extra_curricular_activities]') {
					if ($user->extracurricularactivities) {
						$message = str_replace("[extra_curricular_activities]", $user->extracurricularactivities, $message);
					} else {
						$message = str_replace("[extra_curricular_activities]", ' ', $message);
					}
				} elseif ($userTag->tagname == '[remarks]') {
					if ($user->remarks) {
						$message = str_replace("[remarks]", $user->remarks, $message);
					} else {
						$message = str_replace("[remarks]", ' ', $message);
					}
				} elseif ($userTag->tagname == '[date]') {
					$message = str_replace("[date]", (date("d M Y")), $message);
				} elseif ($userTag->tagname == '[result_table]') {
					if ($sendType == 'email') {
						if ($user->usertypeID == 3) {
							$this->load->library('mark', ['studentID' => $user->srstudentID, 'classesID' => $user->srclassesID, 'schoolyearID' => $schoolyearID, 'data' => $this->data['siteinfos']]);
							$result = $this->mark->mail();
						} else {
							$result = '';
						}
						$message = str_replace("[result_table]", $result, $message);
					} elseif ($sendType == 'SMS') {
						if ($user->usertypeID == 3) {
							$this->load->library('mark', ['studentID' => $user->srstudentID, 'classesID' => $user->srclassesID, 'schoolyearID' => $schoolyearID, 'data' => $this->data['siteinfos']]);
							$result = $this->mark->sms();
						} else {
							$result = '';
						}
						$message = str_replace("[result_table]", $result, $message);
					}
				}
			}
		}
		return $message;
	}
}