<?php

class Qrcode_attendance extends Admin_Controller
{
    function __construct()
    {
        parent::__construct();

        $this->load->model("student_m");
        $this->load->model("parents_m");
        $this->load->model("sattendance_m");
        $this->load->model("tattendance_m");
        $this->load->model('uattendance_m');
        $this->load->model("teacher_m");
        $this->load->model("classes_m");
        $this->load->model("user_m");
        $this->load->model("usertype_m");
        $this->load->model("section_m");
        $this->load->model("setting_m");
        $this->load->model('studentgroup_m');
        $this->load->model('subject_m');
        $this->load->model('schoolyear_m');
        $this->load->model('mailandsmstemplate_m');
        $this->load->model('mailandsmstemplatetag_m');
        $this->load->model('markpercentage_m');
        $this->load->model('mark_m');
        $this->load->model('grade_m');
        $this->load->model('exam_m');
        $this->load->model('studentrelation_m');
        $this->load->model('leaveapplication_m');        
        $this->load->model('payment_m');
        $this->load->library('sms/skooly_init');

        $this->load->model('clock_in_out_m');
        


        $this->load->library("email");
        // $this->load->library('clickatell');
        // $this->load->library('twilio');
        // $this->load->library('bulk');
        // $this->load->library('msg91');

        // $this->data['setting'] = $this->setting_m->get_setting();

        // if($this->data['setting']->attendance == "subject") {
        // 	$this->load->model("subjectattendance_m");
        // }

        $language = $this->session->userdata('lang');
        // $this->lang->load('sattendance', $language);
        // $this->lang->load('tattendance', $language);
        $this->lang->load('uattendance', $language);
        $this->lang->load('qrcode_attendance', $language);
    }


    public function index()
    {
        // $newFileName = FCPATH."assets";
        // print_r($newFileName);
        // $myfile = fopen($newFileName."/newfile.txt", "a");
        // $txt = "Message Sent\n";
        // print_r(fwrite($myfile, $txt));
        // fclose($myfile);
        // die();
        $this->data['headerassets'] = array(
            'css' => array(
                'assets/select2/css/select2.css',
                'assets/select2/css/select2-bootstrap.css',
                'assets/datepicker/datepicker.css'
            ),
            'js' => array(
                'assets/select2/select2.js',
                'assets/datepicker/datepicker.js',
            )
        );
        // print_r($this->session->userdata('usertypeID'));
        // die();
        $this->data['footerassets'] = array(
            'js' => array(
                'assets/html5-qrcode/html5-qrcode.min.js'
            )
        );

        $this->data['date'] = date("d-m-Y");
        $this->data['holidays'] =  $this->getHolidaysSession();
        $this->data['getWeekendDays'] =  $this->getWeekendDaysSession();



        $this->data["subview"] = "attendance/Qrcode_attendance";
        $this->load->view('_layout_main', $this->data);
    }


    public function verify_attendance($qr_token)
    {

        $data = array();
        $user = array();
        $where = array();
        $qr_data = explode("-",$qr_token);

        if(count($qr_data) < 2){
            echo 0;
            exit;
        }

        if ($qr_data[0] == 'S') {
            $user = $this->student_m->get_select_student('*',array(
                'qr_token' => $qr_token
            ))[0];

            if(!empty($user)){
                $where = array(
                    'student.studentID' => $user->studentID,
                    'clock_in_out.usertypeID' => 3,
                    'check_date'=>date('Y-m-d')
                );
                $user->ID = $user->studentID;
            }

            $data = $this->sattendance_m->verify_attendence($where);

        } elseif ($qr_data[0] == "T") {
            $user = $this->teacher_m->get_select_teacher('*',array(
                'qr_token' => $qr_token
            ))[0];

            if(!empty($user)){
                $where = array(
                    'teacher.teacherID' => $user->teacherID,
                    'clock_in_out.usertypeID' => $user->usertypeID,
                    'check_date'=>date('Y-m-d')
                );

                $user->ID = $user->teacherID;
            }

            $data = $this->tattendance_m->verify_attendence($where);

        } else {
            $user = $this->user_m->get_select_user('*',array(
                'qr_token' => $qr_token
            ))[0];

            if(!empty($user)){
                $where = array(
                    'user.userID' => $user->userID,
                    'clock_in_out.usertypeID' => $user->usertypeID,
                    'check_date'=>date('Y-m-d')
                );
                $user->ID = $user->userID;
            }
            $data = $this->uattendance_m->verify_attendence($where);
        }


        $data = (array)$data;

        if(!empty($user)){
            $user_type = $this->usertype_m->get_usertype($user->usertypeID);
            if (!empty($data)) {
                return json_encode(array(
                    "ID" => $user->ID,
                    "usertypeID" => $user->usertypeID,
                    "photo" => profileviewimage($user->photo),
                    "name" => $user->name,
                    "user_type" =>$user_type->usertype,
                    "clock_in" => $data['clock_in'],
                    "clock_out" => $data['clock_out'],
                ));
            } else {
                return json_encode(array(
                    "ID" => $user->ID,
                    "usertypeID" => $user->usertypeID,
                    "photo" => profileviewimage($user->photo),
                    "name" => $user->name,
                    "user_type" =>$user_type->usertype,
                ));
            }
        } else {
            echo 0;
        }
        exit;
    }

    public function submit_qr(){       
        if($this->input->post('in_out_time') == 'in_time'){
            $this->clock_in($this->input->post('qr_token'));
        }elseif($this->input->post('in_out_time') == 'out_time'){
            $this->clock_out($this->input->post('qr_token'));
        }
    }

    public function clock_in($qr_token)
    {
        $response = json_decode($this->verify_attendance($qr_token), true);
        $usertype = $response['usertypeID'];
        $user_ID = $response['ID'];
        $day = abs(date('d'));

        if ($usertype == 3) {
            $student = $this->studentrelation_m->get_single_student(array('srstudentID' => $user_ID), TRUE);         
            
            if (!empty($student)) {
                $parent = $this->parents_m->get_parents($student->parentID);
                $user_type = $this->usertype_m->get_usertype($student->usertypeID);
                $attendence = $this->sattendance_m->get_today_attendence($student->studentID);
                
                if (!empty($attendence)) {

                   $clock_in =  $this->clock_in_out_m->get_clock_in(array(
                       'attendanceID' => $attendence->attendanceID,
                       'userID' => $student->studentID,
                       'check_date' => date('Y-m-d'),
                       'usertypeID' => $usertype
                   ));

                    if(!empty($clock_in)){

                        $this->clock_in_out_m->update_clock_attend(array(
                            'clock_in' =>  date('H:i:s')
                        ), $clock_in->id);

                        $updateArray = array(
                            'a' . abs($day)     => 'P'
                        );
                        $this->sattendance_m->update_attendance($updateArray, $attendence->attendanceID);

                        // if(!empty($parent)){
                        //     $message = "Dear Guardian, your child ".$student->name." adm ".$student->roll." has checked in at school at ".date('H:i:s')." on ".date('d/m/Y')." . Thanks";
                        //     $this->send_sms($parent->phone,$message);
                        // }

                        SmsService::scanQrClockIn($student, 3, $this->data); 

                        $balance = $this->payment_m->balance($user_ID);
                        $check_time = $this->clock_in_out_m->get_attendance_time($clock_in->id);
                        
                        echo json_encode(array(
                            "photo" => profileviewimage($student->photo),
                            'name' => $student->name, 
                            "user_type" =>$user_type->usertype,                           
                            'clock_in' => $check_time->clock_in,
                            'clock_out' => $check_time->clock_out,
                            'fee_balance' => $balance,
                            'parent_phone_no'=> null,
                            'sms_message'=> null,
                            
                        ));
                        exit;
                    } else {

                        $data = array(
                            'attendanceID' => $attendence->attendanceID,
                            'userID' => $student->studentID,
                            'usertypeID' => $student->usertypeID,
                            'check_date' => date('y-m-d'),
                            'clock_in' => date('H:i:s')
                        );
                        $clock_out = $this->clock_in_out_m->insert_clock_attend($data);

                        $updateArray = array(
                            'a' . abs($day)     => 'P'
                        );
                        $this->sattendance_m->update_attendance($updateArray, $attendence->attendanceID);
                        
                        SmsService::scanQrClockIn($student, 3, $this->data); 

                        $balance = $this->payment_m->balance($user_ID);
                        $schoolyearID = $this->session->userdata('defaultschoolyearID');
                        
                        echo json_encode(array(
                            "photo" => profileviewimage($student->photo),
                            'name' => $student->name, 
                            "user_type" =>$user_type->usertype,
                            'clock_in'=>$data['clock_in'],
                            'clock_out'=>null,
                            'fee_balance' => $balance,
                            'parent_phone_no'=> null,
                            'sms_message'=> null,
                            
                        ));
                        exit;
                    }

                } else {            

                    $schoolyearID = $this->session->userdata('defaultschoolyearID');
                    $userID = $this->session->userdata('loginuserID');
                    $usertype = $this->session->userdata('usertype');

                    $studentArray = array(
                        "studentID" => $student->studentID,
                        'schoolyearID' => $schoolyearID,
                        "classesID" => $student->classesID,
                        'sectionID' => $student->sectionID,
                        "userID" => $userID,
                        "usertype" => $usertype,
                        "monthyear" => date('m-Y'),
                        'a'.abs($day) => 'P',

                    );

                    $attendence_id = $this->sattendance_m->insert_attendance($studentArray);

                    $data = array(
                        'attendanceID' => $attendence_id,
                        'userID' => $student->studentID,
                        'usertypeID' => $student->usertypeID,
                        'check_date' => date('y-m-d'),
                        'clock_in' => date('H:i:s')
                    );
                    $clock_out = $this->clock_in_out_m->insert_clock_attend($data);

                    SmsService::scanQrClockIn($student, 3, $this->data); 

                    $balance = $this->payment_m->balance($user_ID);
                    
                    echo json_encode(array(
                        "photo" => profileviewimage($student->photo),
                        'name' => $student->name, 
                        "user_type" =>$user_type->usertype,
                        'clock_in'=>date('H:i:s'),
                        'clock_out' => null,
                        'fee_balance' => $balance,
                        'parent_phone_no'=> null,
                        'sms_message'=> null,
                        
                    ));
                    exit;
                }
            } else {

                echo json_encode(array(
                    'status' => 'error', 
                    'message' => 'Student does not exist in the current teacher class, please enter correct adm no ',
                ));
                exit;
            }
        } elseif ($usertype == 2) {
            $teacher  = $this->teacher_m->get_teacher($user_ID, true);
            

            $insertArray = array();
            if (!empty($teacher)) {
                $user_type = $this->usertype_m->get_usertype($teacher->usertypeID);
                $attendence = $this->tattendance_m->get_today_attendence($teacher->teacherID);

                if (!empty($attendence)) {


                    $clock_in =  $this->clock_in_out_m->get_clock_in(array(
                        'attendanceID' => $attendence->tattendanceID,
                        'userID' => $teacher->teacherID,
                        'check_date' => date('Y-m-d'),
                        'usertypeID' => $usertype
                    ));

                    if(!empty($clock_in)){

                        $this->clock_in_out_m->update_clock_attend(array(
                            'clock_in' =>  date('H:i:s')
                        ), $clock_in->id);

                        $updateArray = array(
                            'a' . abs($day)     => 'P'
                        );
                        $this->tattendance_m->update_tattendance($updateArray, $attendence->tattendanceID);

                        $check_time = $this->clock_in_out_m->get_attendance_time($clock_in->id);

                        SmsService::AdminSMSonTeacherClockIn($teacher, 2, $this->data, get_setting('user_notification_number')); 

                        echo json_encode(array(
                            "photo" => profileviewimage($teacher->photo),
                            'name' => $teacher->name,
                            "user_type" =>$user_type->usertype,
                            'clock_in' => $check_time->clock_in,
                            'clock_out' => $check_time->clock_out,
                            
                        ));
                        exit;
                    } else {

                        $data = array(
                            'attendanceID' => $attendence->tattendanceID,
                            'userID' => $teacher->teacherID,
                            'usertypeID' => $teacher->usertypeID,
                            'check_date' => date('y-m-d'),
                            'clock_in' => date('H:i:s')
                        );
                        $clock_out = $this->clock_in_out_m->insert_clock_attend($data);

                        $updateArray = array(
                            'a' . abs($day)     => 'P'
                        );
                        $this->tattendance_m->update_tattendance($updateArray, $attendence->tattendanceID);
                        SmsService::AdminSMSonTeacherClockIn($teacher, 2, $this->data, get_setting('user_notification_number')); 
                        echo json_encode(array(
                            "photo" => profileviewimage($teacher->photo),
                            'name' => $teacher->name,
                            "user_type" =>$user_type->usertype,
                            'clock_in'=>$data['clock_in'],
                            'clock_out'=>null,
                            
                        ));
                        exit;
                    }

                } else {


                    $schoolyearID = $this->session->userdata('defaultschoolyearID');
                    $insertArray = array(
                        'schoolyearID' => $schoolyearID,
                        "teacherID" => $teacher->teacherID,
                        "usertypeID" => $teacher->usertypeID,
                        "monthyear" => date('m-Y'),
                        'a' . abs($day)     => 'P'
                    );
                    $attendence_id = $this->tattendance_m->insert_tattendance($insertArray);

                    $data = array(
                        'attendanceID' => $attendence_id,
                        'userID' => $teacher->teacherID,
                        'usertypeID' => $teacher->usertypeID,
                        'check_date' => date('y-m-d'),
                        'clock_in' => date('H:i:s')
                    );
                    SmsService::AdminSMSonTeacherClockIn($teacher, 2, $this->data, get_setting('user_notification_number')); 
                    $clock_out = $this->clock_in_out_m->insert_clock_attend($data);
                    
                    echo json_encode(array(
                        "photo" => profileviewimage($teacher->photo),
                        'name' => $teacher->name,
                        "user_type" =>$user_type->usertype,
                        'clock_in'=>date('H:i:s'),
                        'clock_out' => null,
                        
                    ));
                    exit;
                }
            } else {
                echo json_encode(array(
                    'status' => 'error', 
                    'message' => 'Teacher does not exist, please enter correct ID'
                ));
                exit;
            }
        } else {

            $user = $this->user_m->get_user($user_ID, true);
            

            if (!empty($user)) {
                $user_type = $this->usertype_m->get_usertype($user->usertypeID);
                $attendence = $this->uattendance_m->get_today_attendence($user->userID);

                if (!empty($attendence)) {

                    $clock_in =  $this->clock_in_out_m->get_clock_in(array(
                        'attendanceID' => $attendence->uattendanceID,
                        'userID' => $user->userID,
                        'check_date' => date('Y-m-d'),
                        'usertypeID' => $user->usertypeID
                    ));

                    if(!empty($clock_in)){

                        $this->clock_in_out_m->update_clock_attend(array(
                            'clock_in' =>  date('H:i:s')
                        ), $clock_in->id);

                        $updateArray = array(
                            'a' . abs($day)     => 'P'
                        );
                        $this->uattendance_m->update_uattendance($updateArray, $attendence->uattendanceID);

                        SmsService::AdminSMSonTeacherClockIn($user, 1, $this->data, get_setting('user_notification_number')); 

                        $check_time = $this->clock_in_out_m->get_attendance_time($clock_in->id);
                        
                        echo json_encode(array(
                            "photo" => profileviewimage($user->photo),
                            "name" => $user->name,
                            "user_type" =>$user_type->usertype,
                            'clock_in' => $check_time->clock_in,
                            'clock_out' => $check_time->clock_out,
                            
                        ));
                        exit;
                    } else {

                        $data = array(
                            'attendanceID' => $attendence->uattendanceID,
                            'userID' => $user->userID,
                            'usertypeID' => $user->usertypeID,
                            'check_date' => date('y-m-d'),
                            'clock_in' => date('H:i:s')
                        );
                        $clock_out = $this->clock_in_out_m->insert_clock_attend($data);

                        $updateArray = array(
                            'a' . abs($day)     => 'P'
                        );
                        $this->uattendance_m->update_uattendance($updateArray, $attendence->uattendanceID);

                        SmsService::AdminSMSonTeacherClockIn($user, 1, $this->data, get_setting('user_notification_number')); 

                        echo json_encode(array(
                            "photo" => profileviewimage($user->photo),
                            "name" => $user->name,
                            "user_type" =>$user_type->usertype,
                            'clock_in'=>$data['clock_in'],
                            'clock_out'=>null,
                            
                        ));
                        exit;
                    }

                } else {

                    $schoolyearID = $this->session->userdata('defaultschoolyearID');

                    $userArray = array(
                        'schoolyearID'  => $schoolyearID,
                        "userID"        => $user->userID,
                        "usertypeID"    => $user->usertypeID,
                        "monthyear"     => date('m-Y'),
                        'a' . abs($day) => 'P'
                    );

                    $attendence_id = $this->uattendance_m->insert_uattendance($userArray);

                    $data = array(
                        'attendanceID' => $attendence_id,
                        'userID' => $user->userID,
                        'usertypeID' => $user->usertypeID,
                        'check_date' => date('y-m-d'),
                        'clock_in' => date('H:i:s')
                    );
                    $clock_out = $this->clock_in_out_m->insert_clock_attend($data);
                    
                    SmsService::AdminSMSonTeacherClockIn($user, 1, $this->data, get_setting('user_notification_number')); 

                    echo json_encode(array(
                        "photo" => profileviewimage($user->photo),
                        "name" => $user->name,
                        "user_type" =>$user_type->usertype,
                        'clock_in'=>date('H:i:s'),
                        'clock_out' => null,
                        
                    ));
                    exit;
                }
            } else {
                echo json_encode(array(
                    'status' => 'error', 
                    'message' => 'User does not exist, please enter correct ID'
                ));
                exit;
            }
        }
    }


    public function clock_out($qr_token)
    {
        $response = json_decode($this->verify_attendance($qr_token), true);
        $usertype = $response['usertypeID'];
        $user_ID = $response['ID'];
        $day = abs(date('d'));


        if ($usertype == 3) {

            $student = $this->studentrelation_m->get_single_student(array('srstudentID' => $user_ID), TRUE);  
            

            if (!empty($student)) {
                $parent = $this->parents_m->get_parents($student->parentID);
                $user_type = $this->usertype_m->get_usertype($student->usertypeID);
                $attendence = $this->sattendance_m->get_today_attendence($student->studentID);

                if (!empty($attendence)) {

                    $clock_out =  $this->clock_in_out_m->get_clock_in(array(
                        'attendanceID' => $attendence->attendanceID,
                        'userID' => $student->studentID,
                        'check_date' => date('Y-m-d'),
                        'usertypeID' => $usertype
                    ));

                    if(!empty($clock_out)){

                        $this->clock_in_out_m->update_clock_attend(array(
                            'clock_out' =>  date('H:i:s')
                        ), $clock_out->id);
                        $smsmessage ="";
                        $parent_phone_no="";
                        SmsService::scanQrClockOut($student, 3, $this->data); 

                        $balance = $this->payment_m->balance($user_ID);
                        $check_time = $this->clock_in_out_m->get_attendance_time($clock_out->id);
                        

                        echo json_encode(array(
                            "photo" => profileviewimage($student->photo),
                            'name' => $student->name, 
                            "user_type" =>$user_type->usertype,
                            'clock_in' => $check_time->clock_in,
                            'clock_out' => $check_time->clock_out,
                            'fee_balance' => $balance,
                            "sms_message" =>  $smsmessage,
                            "parent_phone_no" => $parent_phone_no,
                            
                        ));
                        exit;

                    } else {

                        //Create clock out record
                        $data = array(
                            'attendanceID' => $attendence->attendanceID,
                            'userID' => $student->studentID,
                            'usertypeID' => $student->usertypeID,
                            'check_date' => date('y-m-d'),
                            'clock_out' => date('H:i:s')
                        );

                        $clock_out = $this->clock_in_out_m->insert_clock_attend($data);

                        SmsService::scanQrClockOut($student, 3, $this->data); 

                        $balance = $this->payment_m->balance($user_ID);

                        
                        echo json_encode(array(
                            "photo" => profileviewimage($student->photo),
                            'name' => $student->name,
                            "user_type" =>$user_type->usertype,
                            'clock_in'=>null,
                            'clock_out' => date('H:i:s'),
                            'fee_balance' => $balance,
                            
                        ));
                        exit;
                    }

                } else {
                    
                    $schoolyearID = $this->session->userdata('defaultschoolyearID');
                    $userID = $this->session->userdata('loginuserID');
                    $usertype = $this->session->userdata('usertype');

                    $studentArray = array(
                        "studentID" => $student->studentID,
                        'schoolyearID' => $schoolyearID,
                        "classesID" => $student->classesID,
                        'sectionID' => $student->sectionID,
                        "userID" => $userID,
                        "usertype" => $usertype,
                        "monthyear" => date('m-Y'),
                        'a'.abs($day) => 'P'

                    );

                    $attendence_id = $this->sattendance_m->insert_attendance($studentArray);

                    $data = array(
                        'attendanceID' => $attendence_id,
                        'userID' => $student->studentID,
                        'usertypeID' => $student->usertypeID,
                        'check_date' => date('y-m-d'),
                        'clock_out' => date('H:i:s')
                    );

                    $clock_out = $this->clock_in_out_m->insert_clock_attend($data);

                    SmsService::scanQrClockOut($student, 3, $this->data); 

                    $balance = $this->payment_m->balance($user_ID);

                    
                    echo json_encode(array(
                        "photo" => profileviewimage($student->photo),
                        'name' => $student->name,
                        "user_type" =>$user_type->usertype,
                        'clock_in'=>null,
                        'clock_out' => date('H:i:s'),
                        'fee_balance' => $balance,
                        
                    ));
                    exit;
                }
            } else {
                   $usertypeID = $this->session->userdata('usertypeID');
                if($usertypeID==2){
                     echo json_encode(array(
                    'status' => 'error',
                    'message' => 'Student does not exist In class, please enter correct ADM No'
                ));
                exit;
                }
                echo json_encode(array(
                    'status' => 'error',
                    'message' => 'Student does not exist, please enter correct ADM No.'));
                exit;
            }
        } elseif ($usertype == 2) {
            $teacher  = $this->teacher_m->get_teacher($user_ID, true);
            
            if (!empty($teacher)) {
                $user_type = $this->usertype_m->get_usertype($teacher->usertypeID);
                $attendence = $this->tattendance_m->get_today_attendence($teacher->teacherID);

                if (!empty($attendence)) {


                    $clock_out =  $this->clock_in_out_m->get_clock_in(array(
                        'attendanceID' => $attendence->tattendanceID,
                        'userID' => $teacher->teacherID,
                        'check_date' => date('Y-m-d'),
                        'usertypeID' => $usertype
                    ));

                    if(!empty($clock_out)){

                        $this->clock_in_out_m->update_clock_attend(array(
                            'clock_out' =>  date('H:i:s')
                        ), $clock_out->id);

                        $check_time = $this->clock_in_out_m->get_attendance_time($clock_out->id);

                        SmsService::AdminSMSonTeacherClockOut($teacher, 3, $this->data, get_setting('user_notification_number')); 
                        
                        echo json_encode(array(
                            "photo" => profileviewimage($teacher->photo),
                            'name' => $teacher->name,
                            "user_type" =>$user_type->usertype,
                            'clock_in' => $check_time->clock_in,
                            'clock_out' => $check_time->clock_out,
                            
                        ));
                        exit;

                    } else {

                        
                        echo json_encode(array(
                            'status' => 'error',
                            'message' => 'Have not Checked-in yet',
                            "photo" => profileviewimage($teacher->photo),
                            "name" => $teacher->name,
                            "user_type" =>$user_type->usertype,
                            
                        ));
                        exit;
                    }

                } else {

                    
                    echo json_encode(array(
                        'status' => 'error',
                        'message' => 'Have not Checked-in yet',
                        "photo" => profileviewimage($teacher->photo),
                        "name" => $teacher->name,
                        "user_type" =>$user_type->usertype,
                        
                    ));
                    exit;
                }
            } else {
                echo json_encode(array(
                    'status' => 'error',
                    'message' => 'Teacher does not exist, please enter correct ID'
                ));
                exit;
            }
        } else {

            $user = $this->user_m->get_user($user_ID, true);
            

            if (!empty($user)) {
                $user_type = $this->usertype_m->get_usertype($user->usertypeID);
                $attendence = $this->uattendance_m->get_today_attendence($user->userID);

                if (!empty($attendence)) {

                    $clock_out =  $this->clock_in_out_m->get_clock_in(array(
                        'attendanceID' => $attendence->uattendanceID,
                        'userID' => $user->userID,
                        'check_date' => date('Y-m-d'),
                        'usertypeID' => $user->usertypeID
                    ));


                    if(!empty($clock_out)){

                        $this->clock_in_out_m->update_clock_attend(array(
                            'clock_out' =>  date('H:i:s')
                        ), $clock_out->id);

                        $check_time = $this->clock_in_out_m->get_attendance_time($clock_out->id);
                        SmsService::AdminSMSonTeacherClockOut($user, 1, $this->data, get_setting('user_notification_number')); 
                        
                        echo json_encode(array(
                            "photo" => profileviewimage($user->photo),
                            "name" => $user->name,
                            "user_type" =>$user_type->usertype,
                            'clock_in' => $check_time->clock_in,
                            'clock_out' => $check_time->clock_out,
                            
                        ));
                        exit;

                    } else {
                        
                        echo json_encode(array(
                            'status' => 'error',
                            'message' => 'Have not Checked-in yet',
                            "photo" => profileviewimage($user->photo),
                            "name" => $user->name,
                            "user_type" =>$user_type->usertype,
                            
                        ));
                        exit;
                    }
                } else {
                    
                    echo json_encode(array(
                        'status' => 'error',
                        'message' => 'Have not Checked-in yet',
                        "photo" => profileviewimage($user->photo),
                        "name" => $user->name,
                        "user_type" =>$user_type->usertype,
                        
                        ));
                    exit;
                }
            } else {
             

                echo json_encode(array(
                    'status' => 'error',
                    'message' => 'User does not exist, please enter correct ID'
                ));
                exit;
            }
        }
    }


}