<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Notification_setting extends Admin_Controller {
    /*
    | -----------------------------------------------------
    | PRODUCT NAME: 	INILABS SCHOOL MANAGEMENT SYSTEM
    | -----------------------------------------------------
    | AUTHOR:			INILABS TEAM
    | -----------------------------------------------------
    | EMAIL:			info@inilabs.net
    | -----------------------------------------------------
    | COPYRIGHT:		RESERVED BY INILABS IT
    | -----------------------------------------------------
    | WEBSITE:			http://inilabs.net
    | -----------------------------------------------------
    */
    function __construct() {
        parent::__construct();
        $this->load->model("notification_setting_m");
        $this->load->helper('frontenddata');
        $language = $this->session->userdata('lang');
        $this->lang->load('notification', $language);
    }

    public function index() {
        $this->data['headerassets'] = array(
            'css' => array(
                'assets/select2/css/select2.css',
                'assets/select2/css/select2-bootstrap.css'
            ),
            'js' => array(
                'assets/select2/select2.js'
            )
        );
        $this->data['notificationSettings'] = [
            'welcome_sms',
            'create_invoice_sms',
            'edit_invoice_sms',
            'receive_payment_sms',
            'credit_wallet_sms',
            'debit_wallet_sms',
            'clock_in_out_sms_students',
            'clock_in_out_sms_teachers',
            'scan_qr_attendance_students',
            'scan_qr_attendance_teachers',
            'scan_for_meals_attendance',
            'send_sms_balance',
            'fee_balance'
        ];

        $this->data['notification_setting'] = $this->notification_setting_m->get_notification_setting();

        if($this->data['notification_setting']) {
            if($_POST) {
                    $array = array(
                        'welcome_sms' => $this->input->post('welcome_sms'),
                        'create_invoice_sms' => $this->input->post('create_invoice_sms'),
                        'edit_invoice_sms' => $this->input->post('edit_invoice_sms'),
                        'receive_payment_sms' => $this->input->post('receive_payment_sms'),
                        'credit_wallet_sms' => $this->input->post('credit_wallet_sms'),
                        'debit_wallet_sms' => $this->input->post('debit_wallet_sms'),
                        'clock_in_out_sms_students' => $this->input->post('clock_in_out_sms_students'),
                        'clock_in_out_sms_teachers' => $this->input->post('clock_in_out_sms_teachers'),
                        'scan_qr_attendance_students' => $this->input->post('scan_qr_attendance_students'),
                        'scan_qr_attendance_teachers' => $this->input->post('scan_qr_attendance_teachers'),
                        'scan_for_meals_attendance' => $this->input->post('scan_for_meals_attendance'),
                        'send_sms_balance' => $this->input->post('send_sms_balance'),
                        'fee_balance' => $this->input->post('fee_balance')
                    );           


                    $this->notification_setting_m->insertorupdate($array);
                    $this->session->set_flashdata('success', $this->lang->line('menu_success'));

                    // frontendData::get_frontend_delete();
                    // frontendData::get_frontend();
                    redirect(base_url("notification_setting/index"));
            } else {
                $this->data["subview"] = "notification/index";
                $this->load->view('_layout_main', $this->data);
            }
        } else {
            $this->data["subview"] = "error";
            $this->load->view('_layout_main', $this->data);
        }
    }
}
