<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
use Illuminate\Http\Request;

class Mpesa extends Admin_Controller {
    /*
    | -----------------------------------------------------
    | PRODUCT NAME: 	INILABS SCHOOL MANAGEMENT SYSTEM
    | -----------------------------------------------------
    | AUTHOR:			INILABS TEAM
    | -----------------------------------------------------
    | EMAIL:			info@inilabs.net
    | -----------------------------------------------------
    | COPYRIGHT:		RESERVED BY INILABS IT
    | -----------------------------------------------------
    | WEBSITE:			http://inilabs.net
    | -----------------------------------------------------
    */
    function __construct () {
        parent::__construct();
        $this->load->model("mpesa_m");
        $language = $this->session->userdata('lang');
        $this->lang->load('mpesa', $language);             
    }
    
    public function index() {
        $this->data['headerassets'] = array(
            'css' => array(
                'assets/datepicker/datepicker.css',
            ),
            'js' => array(
                'assets/datepicker/datepicker.js',
            )
        );

        $filter = array();
        
        // if ($_GET) {
        //     if($this->input->get('start_date') || $this->input->get('end_date')){
        //         $filter['TransTime>='] = $this->input->get('start_date') . ' ' . '00:00:00';
        //         $filter['TransTime<='] = $this->input->get('end_date') . ' ' . '23:59:59';
        //     }
        // }      

        $this->data['logs'] = $this->mpesa_m->getData($filter);
        $this->data['get_all_holidays'] = $this->getHolidaysSession();
        $this->data['chartData'] = $this->pieChart();
        $this->data['columnData'] = $this->columnChart();
        $this->data["subview"] = "mpesa/index";
        $this->load->view('_layout_main', $this->data);
    }

    public function columnChart(){
        $columnData = [];
        $today = strtotime("today");
        
        for ($i = 0; $i < 7; $i++) {
            $date = strtotime("-$i days", $today);
            $day = date('Y-m-d', $date);
            $columnData[$day] = 0;
        }
        
        foreach ($this->data['logs'] as $log) {
            $dateTimestamp = strtotime($log->TransTime);
            
            if ($dateTimestamp >= $today - 6 * 24 * 60 * 60 && $dateTimestamp <= $today + 24 * 60 * 60) {
                $day = date('Y-m-d', $dateTimestamp);
        
                $columnData[$day] += (int) $log->TransAmount;
            }
        }

        ksort($columnData);
        return $columnData;
    }    

    public function pieChart(){
        $genderTypes = [];
        foreach ($this->data["logs"] as $log) {
            $gender = $log->sex;
            if (!isset($genderTypes[$gender])) {
                $genderTypes[$gender] = 0;
            }
            $genderTypes[$gender]++;
        }

        $pieChartData = [];
        foreach ($genderTypes as $gender => $count) {
            $pieChartData[] = [
                'gender' => $gender,
                'count' => $count
            ];
        }

        return $pieChartData;

    }
}