<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Lunchsetting extends Admin_Controller {
    /*
    | -----------------------------------------------------
    | PRODUCT NAME: 	INILABS SCHOOL MANAGEMENT SYSTEM
    | -----------------------------------------------------
    | AUTHOR:			INILABS TEAM
    | -----------------------------------------------------
    | EMAIL:			info@inilabs.net
    | -----------------------------------------------------
    | COPYRIGHT:		RESERVED BY INILABS IT
    | -----------------------------------------------------
    | WEBSITE:			http://inilabs.net
    | -----------------------------------------------------
    */
    function __construct() {
        parent::__construct();
        $this->load->model("frontend_setting_m");
        $this->load->helper('frontenddata');
        $language = $this->session->userdata('lang');
        $this->lang->load('lunch', $language);
    }

    public function index() {
        $this->data['lunch_setting'] = $this->frontend_setting_m->get_frontend_setting();
        if($_POST) {
            $array = array(
                'lunch' => $this->input->post('lunch'),
                'break' => $this->input->post('break')
            );


            $this->frontend_setting_m->insertorupdate($array);
            $this->session->set_flashdata('success', $this->lang->line('menu_success'));

            frontendData::get_frontend_delete();
            frontendData::get_frontend();
            redirect(base_url("lunchsetting"));
        } else {            
            $this->data["subview"] = "lunch/setting";
            $this->load->view('_layout_main', $this->data);
        }
    }
}
