<div class="box">
    <div class="box-header">
        <h3 class="box-title"><i class="fa icon-attendance"></i> Credit Wallet</h3>

        <ol class="breadcrumb">
            <li><a href="<?= base_url("dashboard/index") ?>"><i class="fa fa-laptop"></i> <?= $this->lang->line('menu_dashboard') ?></a></li>
            <li class="active">Credit Wallet</li>
        </ol>
    </div>
    <div class="box-body">
        <div class="row qrcode-scan">
            <div class="col-sm-4">
                <div class="box mt-md">
                    <div class="form-group">
                        <span class="title"><?=$this->lang->line('scan_qr_code')?></span>
                        <div class="justify-content-md-center" id="reader" width="300px" height="300px"></div>
                        <span class="text-center" id='qr_status'>Scanning</span>
                        <?php
                            $paymentArray = array('CASH' => 'CASH', 'MPESA' => 'MPESA', 'BANK' => 'BANK');

                            foreach($paymentArray as $payment) {
                                echo '<div class="radio-custom radio-success radio-inline mt-md">
                                    <input type="radio" value="' . $payment . '" name="paymentMethod" id="paymentMethod_' . $payment . '">
                                    <label for="paymentMethod_' . $payment . '">' . $payment . '</label>
                                </div>';
                            }
                        ?>                        
                        <input type="text" class="form-control mt-md" id="amount" name="amount" autocomplete="off" placeholder="Enter Amount">
						<textarea id="remarks" name="remarks" class="form-control mt-md" rows="4" placeholder="Enter Remarks"></textarea>
                        <div class="mt-md">
							<button id="flipCameraFront" class="btn btn-primary">Front Cam</button>
							<button id="flipCameraBack" class="btn btn-primary">Back Cam</button>
                            <button id="resetField" class="btn btn-danger" onclick="resetField()">Reset</button>
						</div>
                    </div>                    
                </div>       
            </div>		
            <div class="col-sm-8">
				<div class="box mt-md" style="text-align: left;">
				    <span class="title">Process Payment</span>
					<div class="box-body">
						<form method="post" id="creditForm">
                            <input type="hidden" id="studentID" name="studentID">
							<div class="row">
                                <div class="form-group col-sm-6">
                                    <label for="name">Student Name</label>
                                    <input type="text" class="form-control" id="name" name="name" readonly>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label for="registerNO">Student ADM</label>
                                    <input type="text" class="form-control" id="registerNO" name="registerNO" readonly>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label for="class">Student Class</label>
                                    <input type="text" class="form-control" id="class" name="class" readonly>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label for="section">Student Section</label>
                                    <input type="text" class="form-control" id="section" name="section" readonly>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label for="section">Wallet Balance</label>
                                    <input type="text" class="form-control" id="walletBalance" name="walletBalance" readonly>
                                </div>
                            </div>
						</form>
                    </div> 
                </div>                
            </div>	
        </div>
    </div>
</div>

<audio id="successAudio">
  <source src="<?php echo base_url('assets/inilabs/themes/skooly/vendor/qrcode/success.mp3') ?>" type="audio/ogg">
</audio>
<script src="<?php echo base_url('assets/inilabs/themes/skooly/vendor/qrcode/qrcode.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/inilabs/themes/skooly/js/qrcode_attendance.js'); ?>"></script>
<script type="text/javascript">
	var statusMatched = "<?=$this->lang->line('matched')?>";
	var statusScanning = "<?=$this->lang->line('scanning')?>";
	$("#qr_status").css("background", "green");

	var x = document.getElementById("successAudio");
	var lastResult, modalOpen = 0;
	const html5QrCode = new Html5Qrcode("reader");
    function resetField(){
        lastResult = '';
        $('#name').val('');   
        $('#registerNO').val(''); 
        $('#class').val(''); 
        $('#section').val('');
        $('#studentID').val('');
        $('#amount').val('');
        $('#remarks').val('');
    }
	const qrCodeSuccessCallback = (decodedText, decodedResult) => {
        if (decodedText !== lastResult && modalOpen === 0) {
            x.play();
            lastResult = decodedText;
            var amount = $('#amount').val();
            var remarks = $('#remarks').val();
            var paymentMethod = $('input[name="paymentMethod"]:checked').val();

            if(amount ==''){
                showToastr('Amount is required', 'error');
                return;
            }

            if(paymentMethod ==''){
                showToastr('Payment method is required', 'error');
                return;
            }

            $.ajax({
                url: "<?= base_url('creditscan/process'); ?>",
                type: 'POST',
                data: { qr_token: decodedText, amount: amount, paymentMethod: paymentMethod, remarks: remarks },
                success: function(response) {
                    try {
                        let parsedResponse = JSON.parse(response);
                        $('#name').val(parsedResponse.name || '');   
                        $('#registerNO').val(parsedResponse.registerNO || ''); 
                        $('#class').val(parsedResponse.class || ''); 
                        $('#section').val(parsedResponse.section || '');
                        $('#studentID').val(parsedResponse.studentID || '');
                        $('#walletBalance').val(parsedResponse.walletBalance || '');
                        $('#amount').val('');
                        $('#remarks').val('');

                        $('#qr_status').text(statusMatched).css("background", "green");
                        showToastr(parsedResponse.message || 'Wallet credited successfully!', 'success');
                    } catch(e) {
                        console.error("Error parsing JSON:", e);
                        $('#qr_status').text('Error parsing data').css("background", "red");
                        showToastr('Error: ' + e, 'error');
                    }
                        
                    
                },
                error: function() {
                    $('#qr_status').text('Error fetching data').css("background", "red");
                }
            });
            
            html5QrCode.clear();
        }
    };

	const formatsToSupport = [
		Html5QrcodeSupportedFormats.QR_CODE,
	];

	var config = { fps: 50, qrbox: 200};
	if($(window).width()  <= '400'){
		config = { fps: 50, qrbox: 150};
	}
	if($(window).width()  <= '370'){
		config = { fps: 50, qrbox: 120};
	}

	function startCamera(cameraFacingMode) {
        html5QrCode.start({ facingMode: cameraFacingMode }, config, qrCodeSuccessCallback).catch((err) => {
            $("#qr_status").css("background", "red");
            $("#reader").addClass("camera-preview").html(cameraFacingMode + " camera not found.");
            $("#qr_status").html(err);
            alert(cameraFacingMode + ' camera not found.');
            console.log(err);
        });
    }

    startCamera("environment");

    document.getElementById("flipCameraFront").addEventListener("click", function() {
        html5QrCode.stop().then(ignore => {
            startCamera("user");
        }).catch(err => {
            console.log("Failed to stop QR code scanner.");
        });
    });

	document.getElementById("flipCameraBack").addEventListener("click", function() {
        html5QrCode.stop().then(ignore => {
            startCamera("environment");
        }).catch(err => {
            console.log("Failed to stop QR code scanner.");
        });
    });

	$('.modal-dismiss').on('click', function() {
		end_loader()
	});
</script>


