<div class="box">
    <div class="box-header">
        <h3 class="box-title"><i class="fa iniicon-productpurchase"></i> <?=$this->lang->line('wallet_panel_title')?></h3>


        <ol class="breadcrumb">
            <li><a href="<?=base_url("dashboard/index")?>"><i class="fa fa-laptop"></i> <?=$this->lang->line('menu_dashboard')?></a></li>
            <li class="active"><?=$this->lang->line('wallet_panel_title')?></li>
        </ol>
    </div><!-- /.box-header -->
    <div class="box-body">
        <div class="row">
            <div class="col-sm-12">
                <form method="GET" id="filter_attendance">                   
                
                    <div class="form-group col-sm-3" id="dateDiv">
                        <label><?= $this->lang->line("wallet_start_date") ?><span class="text-red"> * </span></label>
                        <input class="form-control" name="start_date" id="start_date" value="<?= ($this->input->get('start_date')? $this->input->get('start_date') : '') ?>" type="text">
                    </div>

                    <div class="form-group col-sm-3" id="dateDiv">
                        <label><?= $this->lang->line("wallet_end_date") ?><span class="text-red"> * </span></label>
                        <input class="form-control" name="end_date" id="end_date" value="<?= ($this->input->get('end_date')? $this->input->get('end_date') : '') ?>" type="text">
                    </div>
                    <div class="form-group col-sm-2">
                        <label for="amount">Transaction Type:</label>
                        <?php
                            $statusArray = array(''=> 'Select','debit' => 'DEBIT', 'credit' => 'CREDIT');                            

                            echo form_dropdown("transactionType", $statusArray, set_value("transactionType"), "id='transactionType' class='form-control select2'");
                        ?>
                    </div>
                    <div class="form-group col-sm-2">
                        <label for="amount">Payment Method:</label>
                        <?php
                            $statusArray = array(''=> 'Select', 'CASH' => 'CASH', 'MPESA' => 'MPESA', 'BANK'=> 'BANK');                            

                            echo form_dropdown("paymentMethod", $statusArray, set_value("paymentMethod"), "id='paymentMethod' class='form-control select2'");
                        ?>
                    </div>

                    <div class="form-group col-sm-2">
                        <button id="get_attendancereport" class="btn btn-success pull-left" style="margin-top:23px;"> <?= $this->lang->line("wallet_submit") ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<div class="row"> 
    <div class="col-sm-8">
        <div class="box"> 
            <div id="column-chart"></div>
        </div>
    </div>
    <div class="col-sm-4">
        <div class="box"> 
            <div id="pie-chart"></div>
        </div>
    </div>
</div>
<div class="box"> 
    <!-- form start -->
    <div class="box-body">
        <div class="row">
            <div class="col-sm-12">
                <div id="hide-table">
                    <table id="example1" class="table table-striped table-bordered table-hover dataTable no-footer">
                        <thead>
                            <tr>
                                <th><?= $this->lang->line('slno') ?></th>
                                <th><?= $this->lang->line('wallet_reference') ?></th>
                                <th><?= $this->lang->line('wallet_user') ?></th>
                                <th><?= $this->lang->line('wallet_amount') ?></th>
                                <th><?= $this->lang->line('wallet_post_balance') ?></th>
                                <!-- <th><?= $this->lang->line('wallet_payment_type') ?></th> -->
                                <th><?= $this->lang->line('wallet_trx') ?></th>
                                <th><?= $this->lang->line('wallet_details') ?></th>
                                <th><?= $this->lang->line('wallet_date') ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (customCompute($logs)) {
                                $i = 1;
                                foreach ($logs as $log) { ?>
                                    <tr>
                                        <td data-title="<?= $this->lang->line('slno') ?>">
                                            <?php echo $i; ?>
                                        </td>
                                        <td data-title="<?= $this->lang->line('wallet_reference') ?>">
                                            <?= $log->referenceNO; ?>
                                        </td>
                                        <td data-title="<?= $this->lang->line('wallet_user') ?>">
                                            <a href="<?= base_url('wallet/view/' . $log->studentID) ?>" style="color:blue">
                                                <?php echo $log->name; ?>
                                            </a>
                                        </td>
                                        <td data-title="<?= $this->lang->line('wallet_amount') ?>">
                                            <?= $log->amount; ?>
                                        </td>

                                        <td data-title="<?= $this->lang->line('wallet_post_balance') ?>">
                                            <?= $log->post_balance; ?>
                                        </td>
                                        <!-- <td data-title="<?= $this->lang->line('wallet_payment_type') ?>">
															<?= $log->payment_type; ?>
														</td> -->

                                        <td data-title="<?= $this->lang->line('wallet_trx') ?>">
                                            <?php if ($log->trx_type == 'debit') {
                                                echo '<span style="color:red;">Debit</span>';
                                            } else if ($log->trx_type == 'credit') {
                                                echo '<span style="color:green;">Credit</span>';
                                            } ?>
                                        </td>
                                        <td data-title="<?= $this->lang->line('wallet_details') ?>">
                                            <?= $log->details; ?>
                                        </td>
                                        <td data-title="<?= $this->lang->line('wallet_date') ?>">
                                            <?= date('Y-m-d h:i A', strtotime($log->create_date)); ?>
                                        </td>

                                    </tr>
                            <?php $i++;
                                }
                            } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
$(function() {
    LoadGraph();
    function LoadGraph() {  
    
        var columnData = <?php echo json_encode($columnData); ?>;

        var categories = Object.keys(columnData).map(function(day) {
            return new Date(day).toLocaleDateString('en-US', { weekday: 'short', month: 'short', day: 'numeric' });
        });

        var columnDataSeries = Object.values(columnData);

        Highcharts.chart('column-chart', {
            chart: {
                type: 'column'
            },
            title: {
                text: 'Total Transactions for the Last 7 Days'
            },
            xAxis: {
                categories: categories,
                title: {
                    text: 'Date',
                    enabled: false
                }
            },
            yAxis: {
                title: {
                    text: 'Amount',
                    enabled: false
                }
            },
            series: [{
                name: 'Transaction',
                data: columnDataSeries,
                color: '#09A3A3'
            }],
        });
    }
});
</script>
<script>
$(function() {
    LoadPieChart();
    
    function LoadPieChart() {
        var chartData = <?php echo json_encode($chartData); ?>;

        var pieChartData = [];
        chartData.forEach(function(item) {
            var paymentType = item.paymentType || 'Unknown';
            pieChartData.push({
                name: paymentType, 
                y: item.count
            });
        });

        Highcharts.chart('pie-chart', {
            chart: {
                type: 'pie'
            },
            title: {
                text: 'Payment Method Distribution'
            },
            series: [{
                name: 'Payment Method',
                data: pieChartData,
                states: {
                    hover: {
                        enabled: false
                    }
                }
            }],
            tooltip: {
                pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
            },
            plotOptions: {
                pie: {
                    allowPointSelect: true,
                    cursor: 'pointer',
                    dataLabels: {
                        enabled: true,
                        format: '{point.name}: {point.percentage:.1f} %'
                    },
                    showInLegend: true
                }
            },
            legend: {
                align: 'center',
                verticalAlign: 'bottom',
                layout: 'horizontal',
                itemDistance: 10
            }
        });
    }
});
</script>


<script type="text/javascript">
    function clearDateField() {
        document.getElementById("start_date").value = "";
        document.getElementById("end_date").value = "";
    }
    // $(document).bind('click', function() {
    $('#start_date').datepicker({
        autoclose: true,
        format: 'yyyy-mm-dd',
        endDate: '<?= date('Y-m-d') ?>',
        daysOfWeekDisabled: "<?= $siteinfos->weekends ?>",
        datesDisabled: ["<?= $get_all_holidays; ?>"],
    });

    // });

    $('#end_date').datepicker({
        autoclose: true,
        format: 'yyyy-mm-dd',
        endDate: '<?= date('Y-m-d') ?>',
        daysOfWeekDisabled: "<?= $siteinfos->weekends ?>",
        datesDisabled: ["<?= $get_all_holidays; ?>"],
    });
    $(function() {
        var closebtn = $('<button/>', {
            type: "button",
            text: 'x',
            id: 'close-preview',
            style: 'font-size: initial;',
        });
        closebtn.attr("class", "close pull-right");

        $('.image-preview').popover({
            trigger: 'manual',
            html: true,
            title: "<strong>Preview</strong>" + $(closebtn)[0].outerHTML,
            content: "There's no image",
            placement: 'bottom'
        });

        $('.image-preview-clear').click(function() {
            $('.image-preview').attr("data-content", "").popover('hide');
            $('.image-preview-filename').val("");
            $('.image-preview-clear').hide();
            $('.image-preview-input input:file').val("");
            $(".image-preview-input-title").text("<?= $this->lang->line('productpurchase_browse') ?>");
        });

        $(".image-preview-input input:file").change(function() {
            var file = this.files[0];
            var reader = new FileReader();

            reader.onload = function(e) {
                $(".image-preview-input-title").text("<?= $this->lang->line('productpurchase_browse') ?>");
                $(".image-preview-clear").show();
                $(".image-preview-filename").val(file.name);
            }
            reader.readAsDataURL(file);
        });
    });

    $('#productpurchasepaiddate').datepicker({
        autoclose: true,
        format: 'dd-mm-yyyy',
        startDate: '<?= $schoolyearobj->startingdate ?>',
        endDate: '<?= $schoolyearobj->endingdate ?>',
    });

    function isNumeric(n) {
        return !isNaN(parseFloat(n)) && isFinite(n);
    }

    function floatChecker(value) {
        var val = value;
        if (isNumeric(val)) {
            return true;
        } else {
            return false;
        }
    }

    function parseSentenceForNumber(sentence) {
        var matches = sentence.replace(/,/g, '').match(/(\+|-)?((\d+(\.\d+)?)|(\.\d+))/);
        return matches && matches[0] || null;
    }

    function sentanceLengthRemove(sentence) {
        sentence = sentence.toString();
        sentence = sentence.slice(0, -1);
        sentence = parseFloat(sentence);
        return sentence;
    }

    function dotAndNumber(data) {
        var retArray = [];
        var fltFlag = true;
        if (data.length > 0) {
            for (var i = 0; i <= (data.length - 1); i++) {
                if (i == 0 && data.charAt(i) == '.') {
                    fltFlag = false;
                    retArray.push(true);
                } else {
                    if (data.charAt(i) == '.' && fltFlag == true) {
                        retArray.push(true);
                        fltFlag = false;
                    } else {
                        if (isNumeric(data.charAt(i))) {
                            retArray.push(true);
                        } else {
                            retArray.push(false);
                        }
                    }

                }
            }
        }

        if (jQuery.inArray(false, retArray) == -1) {
            return true;
        }
        return false;
    }

    function toFixedVal(x) {
        if (Math.abs(x) < 1.0) {
            var e = parseFloat(x.toString().split('e-')[1]);
            if (e) {
                x *= Math.pow(10, e - 1);
                x = '0.' + (new Array(e)).join('0') + x.toString().substring(2);
            }
        } else {
            var e = parseFloat(x.toString().split('+')[1]);
            if (e > 20) {
                e -= 20;
                x /= Math.pow(10, e);
                x += (new Array(e + 1)).join('0');
            }
        }
        return x;
    }

    function lenChecker(data, len) {
        var retdata = 0;
        var lencount = 0;
        data = toFixedVal(data);
        if (data.length > len) {
            lencount = (data.length - len);
            data = data.toString();
            data = data.slice(0, -lencount);
            retdata = parseFloat(data);
        } else {
            retdata = parseFloat(data);
        }

        return toFixedVal(retdata);
    }

    function lenCheckerWithoutParseFloat(data, len) {
        var retdata = 0;
        var lencount = 0;
        if (data.length > len) {
            lencount = (data.length - len);
            data = data.toString();
            data = data.slice(0, -lencount);
            retdata = data;
        } else {
            retdata = data;
        }

        return retdata;
    }

    $(document).on('keyup', '#productpurchasepaidreferenceno', function() {
        var productpurchasepaidreferenceno = $(this).val();
        if (productpurchasepaidreferenceno.length > 99) {
            productpurchasepaidreferenceno = lenCheckerWithoutParseFloat(productpurchasepaidreferenceno, 99);
            $(this).val(productpurchasepaidreferenceno);
        }
    });

    var globalproductpurchasepaidamount = 0;
    var globalproductpurchaseID = 0;
    $(document).on('keyup', '#productpurchasepaidamount', function() {
        var productpurchasepaidamount = $(this).val();
        if (dotAndNumber(productpurchasepaidamount)) {
            if (productpurchasepaidamount != '' && productpurchasepaidamount != null) {
                if (floatChecker(productpurchasepaidamount)) {
                    if (productpurchasepaidamount.length > 15) {
                        productpurchasepaidamount = lenChecker(productpurchasepaidamount);
                        $(this).val(productpurchasepaidamount);

                        if (productpurchasepaidamount > globalproductpurchasepaidamount) {
                            $(this).val(globalproductpurchasepaidamount);
                        }
                    } else {
                        if (productpurchasepaidamount > globalproductpurchasepaidamount) {
                            $(this).val(globalproductpurchasepaidamount);
                        }
                    }
                }
            }
        } else {
            var productpurchasepaidamount = parseSentenceForNumber($(this).val());
            $(this).val(productpurchasepaidamount);
        }
    });

    $('.getpurchaseinfobtn').click(function() {
        var productpurchaseID = $(this).attr('id');
        globalproductpurchaseID = productpurchaseID;
        if (productpurchaseID > 0) {
            $.ajax({
                type: 'POST',
                url: "<?= base_url('productpurchase/getpurchaseinfo') ?>",
                data: {
                    'productpurchaseID': productpurchaseID
                },
                dataType: "html",
                success: function(data) {
                    $('#productpurchasepaidamount').val('');
                    var response = JSON.parse(data);
                    if (response.status == true) {
                        $('#productpurchasepaidamount').val(response.dueamount);
                        globalproductpurchasepaidamount = parseFloat(response.dueamount);
                    }
                }
            });
        }
    });

    $('.getpaymentinfobtn').click(function() {
        var productpurchaseID = $(this).attr('id');
        if (productpurchaseID > 0) {
            $.ajax({
                type: 'POST',
                url: "<?= base_url('productpurchase/paymentlist') ?>",
                data: {
                    'productpurchaseID': productpurchaseID
                },
                dataType: "html",
                success: function(data) {
                    $('#payment-list-body').children().remove();
                    $('#payment-list-body').append(data);
                }
            });
        }
    });


    $(document).on('click', '#add_payment_button', function() {
        var error = 0;;
        var field = {
            'productpurchasepaiddate': $('#productpurchasepaiddate').val(),
            'productpurchasepaidreferenceno': $('#productpurchasepaidreferenceno').val(),
            'productpurchasepaidamount': $('#productpurchasepaidamount').val(),
            'productpurchasepaidpaymentmethod': $('#productpurchasepaidpaymentmethod').val(),
        };

        if (field['productpurchasepaiddate'] == '') {
            $('#productpurchasepaiddateerrorDiv').addClass('has-error');
            error++;
        } else {
            $('#productpurchasepaiddateerrorDiv').removeClass('has-error');
        }

        if (field['productpurchasepaidreferenceno'] == '') {
            $('#productpurchasepaidreferencenoerrorDiv').addClass('has-error');
            error++;
        } else {
            $('#productpurchasepaidreferencenoerrorDiv').removeClass('has-error');
        }

        if (field['productpurchasepaidamount'] == '') {
            $('#productpurchasepaidamounterrorDiv').addClass('has-error');
            error++;
        } else {
            $('#productpurchasepaidamounterrorDiv').removeClass('has-error');
        }

        if (field['productpurchasepaidpaymentmethod'] === '0') {
            $('#productpurchasepaidpaymentmethoderrorDiv').addClass('has-error');
            error++;
        } else {
            $('#productpurchasepaidpaymentmethoderrorDiv').removeClass('has-error');
        }

        if (error === 0) {
            $(this).attr('disabled', 'disabled');
            var formData = new FormData($('#productPurchasePaymentAddDataForm')[0]);
            formData.append("productpurchaseID", globalproductpurchaseID);
            makingPostDataPreviousofAjaxCall(formData);
        }

    });

    function makingPostDataPreviousofAjaxCall(field) {
        passData = field;
        ajaxCall(passData);
    }

    function ajaxCall(passData) {
        $.ajax({
            type: 'POST',
            url: "<?= base_url('productpurchase/saveproductpurchasepayment') ?>",
            data: passData,
            async: true,
            dataType: "html",
            success: function(data) {
                var response = JSON.parse(data);
                errrorLoader(response);
            },
            cache: false,
            contentType: false,
            processData: false
        });
    }

    function errrorLoader(response) {
        if (response.status) {
            window.location = "<?= base_url("productpurchase/index") ?>";
        } else {
            $('#add_payment_button').removeAttr('disabled');
            $.each(response.error, function(index, val) {
                toastr["error"](val)
                toastr.options = {
                    "closeButton": true,
                    "debug": false,
                    "newestOnTop": false,
                    "progressBar": false,
                    "positionClass": "toast-top-right",
                    "preventDuplicates": false,
                    "onclick": null,
                    "showDuration": "500",
                    "hideDuration": "500",
                    "timeOut": "5000",
                    "extendedTimeOut": "1000",
                    "showEasing": "swing",
                    "hideEasing": "linear",
                    "showMethod": "fadeIn",
                    "hideMethod": "fadeOut"
                }
            });
        }
    }
</script>