<style>
.card {
  background-color: #ffffff;
  box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
  border-radius: 5px;
  padding: 20px;
  width: 350px;
  margin: 0 auto;
  text-align: center;
}

.card-header {
  display: flex;
  flex-direction: column;
  align-items: center;
  margin-bottom: 20px;
}

.card-header img {
  border-radius: 50%;
  width: 100px;
  height: 100px;
  object-fit: cover;
  margin-bottom: 10px;
}

.card-title {
  font-size: 24px;
  margin: 0;
  font-weight: 500;
  color: #2d2d2d;
}

.card-body {
  text-align: left;
  font-size: 16px;
}

.card-body p {
  margin: 10px 0;
  color: #616161;
  line-height: 1.5;
}

.card-body p strong {
  font-weight: 500;
  color: #2d2d2d;
}

/* Transaction status labels */
.label-waiver { background-color: #007bff; color: white; }
.label-payment { background-color: #28a745; color: white; }
.label-debit { background-color: #dc3545; color: white; }
.label-credit { background-color: #17a2b8; color: white; }
.label-deposit { background-color: #6f42c1; color: white; }
.label-withdraw { background-color: #fd7e14; color: white; }
.label-transfer { background-color: #20c997; color: white; }
.label-adjustment { background-color: #6c757d; color: white; }
.label-reverse { background-color: #ffc107; color: #000; }

.label {
    padding: 3px 8px;
    border-radius: 3px;
    font-size: 12px;
    display: inline-block;
    margin: 2px;
}
</style>
<div class="box">
	<div class="box-header">
		<h3 class="box-title"><i class="fa fa-credit-card"></i> <?= $this->lang->line('wallet_panel_title') ?></h3>

		<ol class="breadcrumb">
			<li><a href="<?= base_url("dashboard/index") ?>"><i class="fa fa-laptop"></i> <?= $this->lang->line('menu_dashboard') ?></a></li>
			<li class="active"><?= $this->lang->line('menu_student') ?></li>
		</ol>
	</div><!-- /.box-header -->
	<!-- form start -->
	<div class="box-body">
		<div class="row">
			<div class="col-sm-3" style="margin-bottom: 20px;">
				<div class="row">
					<div class="col-lg-12">
						<div class="box box-primary backgroud-image">
							<div class="box-body box-profile">
								<?= profileviewimage($student->photo) ?>
								<h3 class="profile-username text-center"><?= $student->srname ?></h3>
								<ul class="list-group list-group-unbordered">
									<li class="list-group-item" style="background-color: #FFF">
										<b><?= $this->lang->line('student_registerNO') ?></b> <a class="pull-right"><?= $student->srregisterNO ?></a>
									</li>
									<li class="list-group-item" style="background-color: #FFF">
										<b><?= $this->lang->line('student_phone') ?></b> <a class="pull-right"><?= $student->phone ?></a>
									</li>
									<li class="list-group-item" style="background-color: #FFF">
										<b><?= $this->lang->line('student_classes') ?></b> <a class="pull-right"><?= $student->srclasses ?></a>
									</li>
									<li class="list-group-item" style="background-color: #FFF">
										<b><?= $this->lang->line('student_section') ?></b> <a class="pull-right"><?=$student->srsection ?></a>
									</li>
								</ul>
							</div>
						</div>
					</div>
					<?php  $getActiveUserID = $this->session->userdata('usertypeID'); if($getActiveUserID == 1 || $getActiveUserID == 5 || permissionChecker('wallet')) { ?>
					<div class="col-lg-12">
						<div class="col-lg-6">
							<div class="text-center">
								<button type="button" class="btn btn-success btn-block" data-toggle="modal" data-target="#depositModal">
									Credit
								</button>
							</div>
						</div>
						<div class="col-lg-6">
							<div class="text-center">
								<button type="button" class="btn btn-danger btn-block" data-toggle="modal" data-target="#withdrawModal">
									Debit
								</button>
							</div>
						</div>
					</div>
					<?php } ?>
					<style>
						/* Add margin between buttons on smaller screens */
						@media (max-width: 767px) {
							.col-lg-6 {
								margin-top: 10px;
							}
						}
					</style>

				</div>
			</div>
			<div class="col-sm-9">
				<div class="row">
					<div class="col-xs-12">
						<div class="col-sm-4 col-xs-12">
							<div class="small-box ">
								<a class="small-box-footer bg-pink-light" href="javascript:void(0);">
									<div class="icon bg-pink-light" style="padding: 9.5px 18px 6px 18px;">
										<i class="fa fa-credit-card"></i>
									</div>
									<div class="inner ">
										<h3 class="text-white">
											<?= $wallet ?? 0.00 ?>
										</h3 class="text-white">
										<p class="text-white">
											<?= $this->lang->line('current_balance') ?>
										</p>
									</div>
								</a>
							</div>
						</div>
						<div class="col-sm-4 col-xs-12">
							<div class="small-box ">
								<a class="small-box-footer bg-purple-light" href="<?= base_url('invoice') ?>">
									<div class="icon bg-purple-light" style="padding: 9.5px 18px 6px 18px;">
										<i class="fa fa-file-text-o"></i>
									</div>
									<div class="inner ">
										<h3 class="text-white">
											<?= $total_invoices ?>
										</h3 class="text-white">
										<p class="text-white">
											<?= $this->lang->line('total-invoices') ?>
										</p>
									</div>
								</a>
							</div>
						</div>
						<div class="col-sm-4 col-xs-12">
							<div class="small-box ">
								<a class="small-box-footer bg-teal-light" href="<?=base_url('productsale')?>">
									<div class="icon bg-teal-light" style="padding: 9.5px 18px 6px 18px;">
										<i class="fa fa-history"></i>
									</div>
									<div class="inner ">
										<h3 class="text-white">
											<?= $sales_balance ?>
										</h3 class="text-white">
										<p class="text-white">Sales Balance</p>
									</div>
								</a>
							</div>
						</div>
					</div>
					<div class="col-xs-12" style="margin-top: 20px;">
						<div class="box">
							<div class="box-header">
								<h3 class="box-title"><i class="fa icon-feetypes"></i> <?= $this->lang->line('wallet_transactions') ?></h3>
							</div>
							<div class="box-body">
								<div id="hide-table">
									<table id="example1" class="table table-striped table-bordered table-hover dataTable no-footer">
										<thead>
											<tr>
												<th><?= $this->lang->line('slno') ?></th>
												<th><?= $this->lang->line('wallet_reference') ?></th>
												<th><?= $this->lang->line('wallet_amount') ?></th>
												<th><?= $this->lang->line('wallet_post_balance') ?></th>
												<th><?= $this->lang->line('wallet_payment_type') ?></th>
												<th><?= $this->lang->line('wallet_trx') ?></th>
												<th><?= $this->lang->line('wallet_action') ?></th>
												<th><?= $this->lang->line('wallet_details') ?></th>
												<th><?= $this->lang->line('wallet_date') ?></th>
											</tr>
										</thead>
										<tbody>
											<?php if (customCompute($logs)) {
												$i = 1;
												foreach ($logs as $log) { 
													// Determine label class based on transaction type
													$trxClass = 'label-default';
													$actionClass = 'label-default';
													
													if ($log->trx_type == 'waiver') {
														$trxClass = 'label-waiver';
													} elseif ($log->trx_type == 'debit') {
														$trxClass = 'label-debit';
													} elseif ($log->trx_type == 'credit') {
														$trxClass = 'label-credit';
													}
													
													if ($log->trx_action == 'Waiver') {
														$actionClass = 'label-waiver';
													} elseif ($log->trx_action == 'Payment') {
														$actionClass = 'label-payment';
													} elseif ($log->trx_action == 'Deposit') {
														$actionClass = 'label-deposit';
													} elseif ($log->trx_action == 'Withdraw') {
														$actionClass = 'label-withdraw';
													} elseif ($log->trx_action == 'Transfer') {
														$actionClass = 'label-transfer';
													} elseif ($log->trx_action == 'Adjustment') {
														$actionClass = 'label-adjustment';
													} elseif ($log->trx_action == 'Reverse') {
														$actionClass = 'label-reverse';
													}
													?>
													<tr>
														<td data-title="<?= $this->lang->line('slno') ?>">
															<?php echo $i; ?>
														</td>
														<td data-title="<?= $this->lang->line('wallet_reference') ?>">
															<?= $log->referenceNO; ?>
														</td>
														<td data-title="<?= $this->lang->line('wallet_amount') ?>">
															<?= $log->amount; ?>
														</td>
														
														<td data-title="<?= $this->lang->line('wallet_post_balance') ?>">
															<?= $log->post_balance; ?>
														</td>
														<td data-title="<?= $this->lang->line('wallet_payment_type') ?>">
															<span class="label <?= $trxClass ?>"><?= $log->payment_type; ?></span>
														</td>

														<td data-title="<?= $this->lang->line('wallet_trx') ?>">
															<span class="label <?= $trxClass ?>"><?= ucfirst($log->trx_type); ?></span>
														</td>
														<td data-title="<?= $this->lang->line('wallet_action') ?>">
															<span class="label <?= $actionClass ?>"><?= $log->trx_action; ?></span>
														</td>
														<td data-title="<?= $this->lang->line('wallet_details') ?>">
														<?= $log->details; ?>
														</td>
														<td data-title="<?= $this->lang->line('wallet_date') ?>">
															<?= date('Y-m-d h:i A', strtotime($log->create_date)); ?>
														</td>

													</tr>
											<?php $i++;
												}
											} ?>
										</tbody>
									</table>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div><!-- Body -->
</div><!-- /.box -->
<!-- Deposit Modal -->

<form method="POST" action="<?= base_url('wallet/deposit') ?>">
<div class="modal fade" id="depositModal" tabindex="-1" role="dialog" aria-labelledby="depositModalLabel" aria-hidden="true">
	<div class="modal-dialog modal-sm" role="document">
		<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="depositModalLabel">Credit</h5>
					<!-- <button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button> -->
				</div>
				<div class="modal-body">
					<input type="hidden" name="studentID" value="<?= $student->srstudentID ?>">
					<div class="form-group">
						<label for="amount">Amount:</label>
						<input type="number" class="form-control" id="amount" name="amount" placeholder="Enter amount to Credit">
					</div>
					<div class="form-group">
                        <label for="amount">Payment Method:</label>
                        <?php
                            $statusArray = array('CASH' => 'CASH', 'MPESA' => 'MPESA', 'BANK'=> 'BANK');                            

                            echo form_dropdown("paymentMethod", $statusArray, set_value("paymentMethod"), "id='paymentMethod' class='form-control select2'");
                        ?>
                    </div>
					<div class="form-group">
                    	<label for="remarks">Remarks</label>
                        <textarea id="remarks" name="remarks" class="form-control" rows="4"></textarea>
                    </div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
					<button type="submit" class="btn btn-success">Credit</button>
				</div>
		</div>
	</div>
</div>
</form>

<!-- Withdraw Modal -->
<form method="POST" action="<?= base_url('wallet/withdraw') ?>">
<div class="modal fade" id="withdrawModal" tabindex="-1" role="dialog" aria-labelledby="withdrawModalLabel" aria-hidden="true">
	<div class="modal-dialog modal-sm" role="document">
		<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="withdrawModalLabel">Debit</h5>
				</div>
				<div class="modal-body">
					<div class="form-group">
						<label for="amount">Amount:</label>
						<input type="number" class="form-control" id="amount" name="amount" placeholder="Enter amount to Credit">
					</div>
					<input type="hidden" name="studentID" value="<?= $student->srstudentID ?>">
					<div class="form-group">
						<label for="remarks">Remarks</label>
						<textarea id="remarks" name="remarks" class="form-control" rows="4"></textarea>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
					<button type="submit" class="btn btn-danger">Debit</button>
				</div>
		</div>
	</div>
</div>
</form>
<script type="text/javascript">

</script>