<?php
$current_time = time();
$remaining_seconds = max(0, $otp_expiration - $current_time);
?>
<style>
    #timer {
        font-size: 16px;
        color: #333;
    }
    #resendButton {
        cursor: not-allowed;
        opacity: 0.5;
    }
    #resendButton.enabled {
        cursor: pointer;
        opacity: 1;
    }
</style>

<div class="form-box col-3 text-center" id="login-box">
<!--    <div class="skooly-header">Verify OTP</div>  -->
    <h5 class="text-white">Enter OTP code sent to your phone</h5>
    <form role="form" method="post">
        <div class="body white-bg">
            <?php 
                if ($form_validation == "No") {
                } else {
                    if (customCompute($form_validation)) {
                        echo "<div class=\"alert alert-danger alert-dismissable\">
                                <i class=\"fa fa-ban\"></i>
                                <button aria-hidden=\"true\" data-dismiss=\"alert\" class=\"close\" type=\"button\">×</button>
                                $form_validation
                            </div>";
                    }
                }

                if ($this->session->flashdata('reset_send')) {
                    $message = $this->session->flashdata('reset_send');
                    echo "<div class=\"alert alert-success alert-dismissable\">
                            <i class=\"fa fa-ban\"></i>
                            <button aria-hidden=\"true\" data-dismiss=\"alert\" class=\"close\" type=\"button\">×</button>
                            $message
                        </div>";
                } else {
                    if ($this->session->flashdata('reset_error')) {
                        $message = $this->session->flashdata('reset_error');
                        echo "<div class=\"alert alert-danger alert-dismissable\">
                                <i class=\"fa fa-ban\"></i>
                                <button aria-hidden=\"true\" data-dismiss=\"alert\" class=\"close\" type=\"button\">×</button>
                                $message
                            </div>";
                    }
                }
            ?>
            <div class="form-group text-center">
                <label for="verificationCode">Enter Verification Code</label>
                <div class="verification-form">
                    <input type="hidden" id="verificationCode" name="verification_code" value="">
                    <input id="inputType" name="type" type="hidden" value="phone">
                    <input type="text" class="verification-input" maxlength="1" oninput="moveToNext(this, 0)">
                    <input type="text" class="verification-input" maxlength="1" oninput="moveToNext(this, 1)">
                    <input type="text" class="verification-input" maxlength="1" oninput="moveToNext(this, 2)">
                    <input type="text" class="verification-input" maxlength="1" oninput="moveToNext(this, 3)">
                    <!-- <input type="text" class="verification-input" maxlength="1" oninput="moveToNext(this, 4)">
                    <input type="text" class="verification-input" maxlength="1" oninput="moveToNext(this, 5)"> -->
                </div>
                <p id="timer" class="text-center mt-3" style="color:white; margin-top:10px;">Resend OTP in <span id="countdown">60</span> seconds</p>
                <button type="button" id="resendButton" class="btn btn-secondary btn-sm mt-2" disabled>Resend OTP</button>
            </div>

            <input type="submit" class="btn btn-lg btn-primary btn-block" value="Verify" />
        </div>
    </form>
    <a href="javascript:void(0);" id="goBack" class="text-white" style="font-weight:bold; font-size:14px;"><i class="fa fa-arrow-left"></i> Go Back</a>
</div>

<style>
    .verification-form {
        display: flex;
        gap: 10px;
        justify-content: center;
        margin-top: 15px;
    }
    .verification-input {
        width: 40px;
        height: 40px;
        text-align: center;
        font-size: 18px;
        border: 1px solid #ccc;
        border-radius: 5px;
        outline: none;
        background-color: #fff;
        box-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
        transition: border-color 0.2s ease;
    }
    .verification-input:focus {
        border-color: #007bff;
    }
    .btn-primary {
        background-color: #007bff;
        color: #fff;
        border: none;
        padding: 10px 20px;
        font-size: 16px;
        border-radius: 5px;
        cursor: pointer;
    }
    .btn-primary:hover {
        background-color: #0056b3;
    }
</style>

<script>
    function moveToNext(currentInput, index) {
        const inputs = document.querySelectorAll('.verification-input');
        const hiddenInput = document.getElementById('verificationCode');

        let verificationCode = '';
        inputs.forEach((input) => {
            verificationCode += input.value;
        });
        hiddenInput.value = verificationCode;

        if (currentInput.value.length === 1 && index < inputs.length - 1) {
            inputs[index + 1].focus();
        }
    }
</script>
<script>
    let countdown = <?php echo $remaining_seconds; ?>;
    const countdownElement = document.getElementById('countdown');
    const resendButton = document.getElementById('resendButton');
    const goBack = document.getElementById('goBack');

    function startCountdown() {
        const timer = setInterval(() => {
            countdown -= 1;
            countdownElement.textContent = countdown;

            if (countdown <= 0) {
                clearInterval(timer);
                resendButton.disabled = false;
                resendButton.classList.add('enabled');
                resendButton.style.cursor = 'pointer';
            }
        }, 1000);
    }
    
    goBack.addEventListener('click', (event) => {
        event.preventDefault();
    
        fetch('/login/go_back', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
        })
        .then(response => {
            if (!response.ok) {
                throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then(data => {
            if (data.success) {
                window.location.href = '<?= site_url('signin/index') ?>';
            } else {
                console.error('Failed to go back: ', data.message || 'Unknown error');
                alert('An error occurred while trying to go back. Please try again.');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred while trying to go back. Please try again.');
        });
    });

    resendButton.addEventListener('click', () => {
        if (!resendButton.disabled) {
            resendButton.disabled = true;
            resendButton.classList.remove('enabled');
            resendButton.style.cursor = 'not-allowed';

            resendButton.textContent = 'Resending...';

            fetch('/login/resend_otp', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    action: 'resend_otp',
                }),
            })
            .then((response) => {
                if (!response.ok) {
                    throw new Error('Failed to resend OTP');
                }
                return response.json();
            })
            .then((data) => {
                if (data.success) {
                    countdown = data.otp_expiration;
                    showToastr("OTP has been resent successfully!", 'success');
                } else {
                    showToastr("Failed to resend OTP. Please try again later.", 'error');
                }
            })
            .catch((error) => {
                console.error('Error:', error);
                showToastr('An error occurred while resending OTP. Please try again.', 'error');
            })
            .finally(() => {
                resendButton.textContent = 'Resend OTP';
                startCountdown();
            });
        }
    });

    startCountdown();
</script>

