<script>
// Inject SMS data for JavaScript (in your main layout)
const smsBalance = <?= $smsBalance ?? 0 ?>;
const smsThreshold = <?= $smsThreshold ?? 0 ?>;
const smsSettingsUrl = '<?= $smsSettingsUrl ?? base_url("settings/sms") ?>';
</script>
<div class="box">
    <div class="box-header">
        <h3 class="box-title"><i class="fa fa-gears"></i> <?=$this->lang->line('panel_title')?></h3>
        <ol class="breadcrumb">
            <li><a href="<?=base_url("dashboard/index")?>"><i class="fa fa-laptop"></i> <?=$this->lang->line('menu_dashboard')?></a></li>
            <li class="active"><?=$this->lang->line('menu_setting')?></li>
        </ol>
    </div><!-- /.box-header -->
    
    <form class="form-horizontal" role="form" method="post" enctype="multipart/form-data">
        <div class="box-body">
            <fieldset class="setting-fieldset">
                <legend class="setting-legend"><?=$this->lang->line('setting_site_configaration')?></legend>
                <div class="row">
                    <div class="col-sm-4">
                        <div class="form-group <?=form_error('sname') ? 'has-error' : ''?>" >
                            <div class="col-sm-12">
                                <label for="sname"><?=$this->lang->line("setting_school_name")?>
                                    &nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="right" title="set your site title here"></i>
                                </label>
                                <input type="text" class="form-control" id="sname" name="sname" value="<?=set_value('sname', $setting->sname)?>" />
                                <span class="control-label"><?=form_error('sname'); ?></span>
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group <?=form_error('phone') ? 'has-error' : ''?>">
                            <div class="col-sm-12">
                                <label for="phone"><?=$this->lang->line("setting_school_phone")?>
                                    &nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="right" title="Set organization phone number here"></i>
                                </label>
                                <input type="text" class="form-control" id="phone" name="phone" value="<?=set_value('phone', $setting->phone)?>" >
                                <span class="control-label"><?=form_error('phone'); ?></span>
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group <?=form_error('email') ? 'has-error' : ''?>">
                            <div class="col-sm-12">
                                <label for="email"><?=$this->lang->line("setting_school_email")?>
                                    &nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="right" title="Set organization email address here"></i>
                                </label>
                                <input type="text" class="form-control" id="email" name="email" value="<?=set_value('email', $setting->email)?>" >
                                <span class="control-label"><?=form_error('email'); ?></span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-4">
                        <div class="form-group <?=form_error('address') ? 'has-error' : ''?>">
                            <div class="col-sm-12">
                                <label for="address"><?=$this->lang->line("setting_school_address")?>&nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="right" title="Set organization address here"></i>
                                </label>
                                <textarea class="form-control" style="resize:none;" id="address" name="address"><?=set_value('address', $setting->address)?></textarea>
                                <span class="control-label">
                                    <?=form_error('address'); ?>
                                </span>
                            </div>
                        </div>
                    </div>
                      
                    <div class="col-sm-4">
                        <div class="form-group <?=form_error('footer') ? 'has-error' : ''?>">
                            <div class="col-sm-12">
                                <label for="footer"><?=$this->lang->line("setting_school_footer")?>&nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="right" title="Set site footer text here"></i>
                                </label>
                                <input type="text" class="form-control" id="footer" name="footer" value="<?=set_value('footer', $setting->footer)?>" >
                                <span class="control-label">
                                    <?=form_error('footer'); ?>
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group <?=form_error('currency_code') ? 'has-error' : ''?>">
                            <div class="col-sm-12">
                                <label for="currency_code">
                                    <?=$this->lang->line("setting_school_currency_code")?>&nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="top" title="Set organization currency code like USD or GBP"></i>
                                </label>
                                <input type="text" class="form-control" id="currency_code" name="currency_code" value="<?=set_value('currency_code', $setting->currency_code)?>" >
                                <span class="control-label">
                                    <?=form_error('currency_code'); ?>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-4">
                        <div class="form-group <?=form_error('currency_symbol') ? 'has-error' : ''?>">
                            <div class="col-sm-12">
                                <label for="currency_symbol"><?=$this->lang->line("setting_school_currency_symbol")?> &nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="top" title="Set organization currency system here like $ or £"></i>
                                </label>
                                <input type="text" class="form-control" id="currency_symbol" name="currency_symbol" value="<?=set_value('currency_symbol', $setting->currency_symbol)?>" >
                                <span class="control-label">
                                    <?=form_error('currency_symbol'); ?>
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group <?php if(form_error('language_status')) { echo 'has-error'; } ?>">
                            <div class="col-sm-12">
                                <label><?=$this->lang->line("setting_language")?>&nbsp; <i class="fa fa-question-circle" data-toggle="tooltip" data-placement="bottom" title="Enable/Disable language for top section"></i>
                                </label>
                                <?php
                                    $languageArray[0] = $this->lang->line('setting_enable');
                                    $languageArray[1] = $this->lang->line('setting_disable');
                                    echo form_dropdown("language_status", $languageArray, set_value("language_status",$setting->language_status), "id='language_status' class='dropdown-dark form-control select2'");
                                ?>
                                <span class="control-label">
                                    <?php echo form_error('language_status'); ?>
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group <?=form_error('lang') ? 'has-error' : ''?>">
                            <div class="col-sm-12">
                                <label for="lang"><?=$this->lang->line("setting_dafault_language")?>
                                    &nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="top" title="Select organization default language here"></i>
                                </label>
                                <?php
                                    echo form_dropdown("language", array("english" => $this->lang->line("setting_english"),
                                    "bengali" => $this->lang->line("setting_bengali"),
                                    "arabic" => $this->lang->line("setting_arabic"),
                                    "chinese" => $this->lang->line("setting_chinese"),
                                    "french" => $this->lang->line("setting_french"),
                                    "german" => $this->lang->line("setting_german"),
                                    "hindi" => $this->lang->line("setting_hindi"),
                                    "indonesian" => $this->lang->line("setting_indonesian"),
                                    "italian" => $this->lang->line("setting_italian"),
                                    "portuguese" => $this->lang->line("setting_portuguese"),
                                    "romanian" => $this->lang->line("setting_romanian"),
                                    "russian" => $this->lang->line("setting_russian"),
                                    "spanish" => $this->lang->line("setting_spanish"),
                                    "thai" => $this->lang->line("setting_thai"),
                                    "turkish" => $this->lang->line("setting_turkish"),
                                    ),
                                    set_value("lang", $setting->language), "id='lang' class='form-control select2'");
                                ?>
                                <span class="control-label">
                                    <?=form_error('lang'); ?>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-4">
                        <div class="form-group <?=form_error('school_year') ? 'has-error' : ''?>">
                            <div class="col-sm-12">
                                <label for="school_year"><?=$this->lang->line("setting_school_default_school_year")?>&nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="top" title="Select school running academic year"></i>
                                </label>
                                <?php
                                    $array = array(
                                        "0" => $this->lang->line("setting_school_select_school_year")  
                                    );
                                    if(customCompute($schoolyears)) {
                                        foreach ($schoolyears as $key => $schoolyear) {
                                            if($schoolyear->schooltype == 'semesterbase') {
                                                $array[$schoolyear->schoolyearID] = $schoolyear->schoolyeartitle.' ('.$schoolyear->schoolyear.')'; 
                                            } else {
                                                $array[$schoolyear->schoolyearID] = $schoolyear->schoolyear;    
                                            }
                                        }
                                         
                                    }
                                    echo form_dropdown("school_year", $array, set_value("school_year",$setting->school_year), "id='school_year' class='form-control select2'");
                                ?>
                                <span class="control-label">
                                    <?=form_error('school_year'); ?>
                                </span>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-sm-4">
                        <div class="form-group <?=form_error('attendance') ? 'has-error' : ''?>">
                            <div class="col-sm-12">
                                <label for="attendance"><?=$this->lang->line("setting_school_default_attendance")?>&nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="top" title="Select school default attendance system"></i></label>
                                <?php
                                    $array = array(
                                        "0" => $this->lang->line("setting_school_select_attendance"),
                                        "day" => $this->lang->line("setting_school_select_day_attendance"),
                                        "subject" => $this->lang->line("setting_school_select_subject_attendance")
                                    );
                                    echo form_dropdown("attendance", $array, set_value("attendance",$setting->attendance), "id='attendance' class='form-control select2'");
                                ?>
                                <span class="control-label">
                                    <?=form_error('attendance'); ?>
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group <?=(form_error('auto_invoice_generate') || form_error('automation')) ? 'has-error' : ''?>">
                            <div class="col-sm-12">
                                <label for="auto_invoice_generate"><?=$this->lang->line("setting_school_auto_invoice_generate")?>
                                    <i class="fa fa-question-circle" data-toggle="tooltip" data-placement="top" title="Enable/Disable library fee, hostel fee, transport fee invoice in student account automatically. it's will be added monthly wise."></i>
                                </label>
                                <div class="row">
                                    <div id="autoinvoicediv" class="">
                                        <?php
                                            $array = array(
                                                "0" => $this->lang->line("setting_school_no"),
                                                "1" => $this->lang->line("setting_school_yes")
                                            );
                                            echo form_dropdown("auto_invoice_generate", $array, set_value("auto_invoice_generate",$setting->auto_invoice_generate), "id='auto_invoice_generate' class='form-control select2'");
                                        ?>
                                    </div>
                                    <div class="col-sm-6">
                                        <?php
                                            $dayArray = array();
                                            for($i =1; $i<=28; $i++) {
                                                $dayArray[$i] = $i;
                                            }
                                            echo form_dropdown("automation", $dayArray, set_value("automation",$setting->automation), "id='automation' class='form-control select2'");
                                        ?>
                                    </div>
                                </div>
                                <span class="control-label">
                                    <?php 
                                        if(form_error('auto_invoice_generate')) {
                                            echo form_error('auto_invoice_generate');
                                        } else  {
                                            echo form_error('automation'); 
                                        }
                                    ?>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-4">
                        <div class="form-group <?=form_error('note') ? 'has-error' : ''?>">
                            <div class="col-sm-12">
                                <label for="note"><?=$this->lang->line("setting_school_note")?>&nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="right" title="Enable/Disable module helper note"></i>
                                </label>
                                <?php
                                    $noteArray[1] = $this->lang->line('setting_enable');
                                    $noteArray[0] = $this->lang->line('setting_disable');
                                    echo form_dropdown("note", $noteArray, set_value("note",$setting->note), "id='note' class='form-control select2'");
                                ?>
                                <span class="control-label">
                                    <?=form_error('note'); ?>
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group <?php if(form_error('weekends')) { echo 'has-error'; } ?>">
                            <div class="col-sm-12">
                            <label><?=$this->lang->line('setting_weekends')?>&nbsp; <i class="fa fa-question-circle" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="Select Weekends"></i></label>
                                <?php
                                    $array = array(
                                        "0" => $this->lang->line("setting_sunday"),
                                        "1" => $this->lang->line("setting_monday"),
                                        "2" => $this->lang->line("setting_tuesday"),
                                        "3" => $this->lang->line("setting_wednesday"),
                                        "4" => $this->lang->line("setting_thursday"),
                                        "5" => $this->lang->line("setting_friday"),
                                        "6" => $this->lang->line("setting_saturday")
                                    );

                                    if(isset($setting->weekends)) {
                                        $expHoliday = explode(',', $setting->weekends);
                                    } else {
                                        $expHoliday = [];
                                    }

                                    echo form_multiselect("weekends[]", $array, set_value('weekends', $expHoliday), "id='weekends' class='form-control'");
                                ?>
                                <span class="control-label">
                                    <?php echo form_error('weekends[]'); ?>
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group <?=form_error('frontendorbackend') ? 'has-error' : ''?>">
                            <div class="col-sm-12">
                                <label for="frontendorbackend"><?=$this->lang->line("setting_school_frontend")?>&nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="top" title="Enable/Disable frontend site"></i>
                                </label>
                                    <?php
                                        echo form_dropdown("frontendorbackend", array("YES" => $this->lang->line("setting_school_yes"),
                                        "NO" => $this->lang->line("setting_school_no"),
                                        ),
                                        set_value("frontendorbackend", $setting->frontendorbackend), "id='frontendorbackend' class='form-control select2'");
                                    ?>
                                <span class="control-label">
                                    <?=form_error('frontendorbackend'); ?>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-4">
                        <div class="form-group <?=form_error('google_analytics') ? 'has-error' : ''?>">
                            <div class="col-sm-12">
                                <label for="google_analytics"><?=$this->lang->line("setting_school_google_analytics")?>&nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="right" title="Set site google_analytics code"></i>
                                </label>
                                <input type="text" class="form-control" id="google_analytics" name="google_analytics" value="<?=set_value('google_analytics', $setting->google_analytics)?>" >
                                <span class="control-label">
                                    <?php echo form_error('google_analytics'); ?>
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group <?php if(form_error('profile_edit')) { echo 'has-error'; } ?>">
                            <div class="col-sm-12">
                                <label><?=$this->lang->line("setting_school_profile_edit")?>&nbsp; <i class="fa fa-question-circle" data-toggle="tooltip" data-placement="bottom" title="Enable/Disable for profile edit"></i>
                                </label>
                                <?php
                                    $profileEditArray[1] = $this->lang->line('setting_enable');
                                    $profileEditArray[0] = $this->lang->line('setting_disable');
                                    echo form_dropdown("profile_edit", $profileEditArray, set_value("profile_edit",$setting->profile_edit), "id='profile_edit' class='form-control select2'");
                                ?>
                                <span class="control-label">
                                    <?php echo form_error('profile_edit'); ?>
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group <?=form_error('time_zone') ? 'has-error' : ''?>">
                            <div class="col-sm-12">
                                <label for="time_zone"><?=$this->lang->line("setting_school_time_zone")?>&nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="top" title="Select your region time zone. We define a time zone as a region where the same standard time is used"></i>
                                </label>
                                    <?php
                                        $path = APPPATH."config/timezones_class.php";
                                        if(@include($path)) {
                                            $timezones_cls = new Timezones();
                                            $timezones = $timezones_cls->get_timezones();
                                            unset($timezones['']);
                                            $selectTimeZone['none'] = $this->lang->line('setting_school_select_time_zone');
                                            $timeZones = array_merge($selectTimeZone, $timezones);

                                            echo form_dropdown("time_zone", $timeZones, set_value("time_zone", $setting->time_zone), "id='time_zone' class='form-control select2'");
                                        }
                                    ?>
                                <span class="control-label">
                                    <?=form_error('time_zone'); ?>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-4">
                        <div class="form-group <?=form_error('ex_class') ? 'has-error' : ''?>">
                            <div class="col-sm-12">
                                <label for="ex_class"><?=$this->lang->line("setting_graduate_class")?>&nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="top" title="a graduate or former student class of a specific school"></i>
                                </label>
                                    <?php
                                        $ex_classArray['0'] = $this->lang->line('setting_select_graduate_class');
                                        if(customCompute($classes)) {
                                            foreach($classes as $class) {
                                                $ex_classArray[$class->classesID] = $class->classes;
                                            }
                                        }
                                        echo form_dropdown("ex_class", $ex_classArray, set_value("ex_class", $setting->ex_class), "id='ex_class' class='form-control select2'");
                                    ?>
                                <span class="control-label">
                                    <?=form_error('ex_class'); ?>
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group <?=form_error('photo') ? 'has-error' : ''?>">
                            <div class="col-sm-12">
                                <label for="photo"><?=$this->lang->line("setting_logo")?>&nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="right" title="Set organization logo here"></i>
                                </label>
                                <div class="input-group image-preview">
                                    <input type="text" class="form-control image-preview-filename" disabled="disabled">
                                    <span class="input-group-btn">
                                        <button type="button" class="btn btn-default image-preview-clear" style="display:none;">
                                            <span class="fa fa-remove"></span>
                                            <?=$this->lang->line('setting_clear')?>
                                        </button>
                                        <div class="btn btn-success image-preview-input">
                                            <span class="fa fa-repeat"></span>
                                            <span class="image-preview-input-title">
                                            <?=$this->lang->line('setting_file_browse')?></span>
                                            <input type="file" accept="image/png, image/jpeg, image/gif" name="photo"/>
                                        </div>
                                    </span>
                                </div>
                                <span class="control-label">
                                    <?=form_error('photo'); ?>
                                </span>
                            </div>
                        </div>
                    </div>
                   <div class="col-sm-4">
                        <div class="form-group <?=form_error('sms_bal_number') ? 'has-error' : ''?>">
                            <div class="col-sm-12">
                                <label for="sms_bal_number">
                                    <?=$this->lang->line("sms_bal_number")?>
                                    &nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="right" title="<?=$this->lang->line("sms_bal_number")?>"></i>
                                </label>
                                <input type="text" class="form-control" id="sms_bal_number" name="sms_bal_number" value="<?=set_value('sms_bal_number', $setting->sms_bal_number)?>" >
                                <span class="control-label"><?php echo form_error('sms_bal_number'); ?></span>
                            </div>
                        </div>
                    </div>
                    </div>
                    <div class="row">
                        <!-- Slogan -->
                        <div class="col-sm-4">
                            <div class="form-group <?=form_error('slogan') ? 'has-error' : ''?>">
                                <div class="col-sm-12">
                                    <label for="slogan">
                                        <?=$this->lang->line('setting_school_slogan')?>
                                        &nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="right" title="<?=$this->lang->line('setting_school_slogan')?>"></i>
                                    </label>
                                    <input type="text" class="form-control" id="slogan" name="slogan" value="<?=set_value('slogan', $settingarray['slogan'] ?? '')?>" />
                                    <span class="control-label"><?=form_error('slogan'); ?></span>
                                </div>
                            </div>
                        </div>
                        <!-- Motto -->
                        <div class="col-sm-4">
                            <div class="form-group <?=form_error('motto') ? 'has-error' : ''?>">
                                <div class="col-sm-12">
                                    <label for="motto">
                                        <?=$this->lang->line('setting_school_motto')?>
                                        &nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="right" title="<?=$this->lang->line('setting_school_motto')?>"></i>
                                    </label>
                                    <input type="text" class="form-control" id="motto" name="motto" value="<?=set_value('motto', $settingarray['motto'] ?? '')?>" />
                                    <span class="control-label"><?=form_error('motto'); ?></span>
                                </div>
                            </div>
                        </div>
                        <!-- If Found -->
                        <div class="col-sm-4">
                            <div class="form-group <?=form_error('iffound') ? 'has-error' : ''?>">
                                <div class="col-sm-12">
                                    <label for="iffound">
                                        <?=$this->lang->line('setting_school_iffound')?>
                                        &nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="right" title="<?=$this->lang->line('setting_school_iffound')?>"></i>
                                    </label>
                                    <input type="text" class="form-control" id="iffound" name="iffound" value="<?=set_value('iffound', $settingarray['iffound'] ?? '')?>" />
                                    <span class="control-label"><?=form_error('iffound'); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <!-- School Code -->
                        <div class="col-sm-4">
                            <div class="form-group <?=form_error('school_code') ? 'has-error' : ''?>">
                                <div class="col-sm-12">
                                    <label for="school_code">
                                        <?=$this->lang->line('setting_school_code')?>
                                        &nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="right" title="<?=$this->lang->line('setting_school_code')?>"></i>
                                    </label>
                                    <input type="text" class="form-control" id="school_code" name="school_code" value="<?=set_value('school_code', $settingarray['school_code'] ?? '')?>" />
                                    <span class="control-label"><?=form_error('school_code'); ?></span>
                                </div>
                            </div>
                        </div>
                        <!-- App Background Image -->
                        <div class="col-sm-4">
                            <div class="form-group <?=form_error('app_bg') ? 'has-error' : ''?>">
                                <div class="col-sm-12">
                                    <label for="app_bg">
                                        <?=$this->lang->line('setting_school_app_bg')?>
                                        &nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="right" title="<?=$this->lang->line('setting_school_app_bg')?>"></i>
                                    </label>
                                    <input type="file" class="form-control" id="app_bg" name="app_bg" />
                                    <?php if(!empty($settingarray['app_bg'])): ?>
                                        <br/><img src="<?=base_url('uploads/skooly/defaults/'.$settingarray['app_bg'])?>" style="max-width:80px;" alt="App Background">
                                    <?php endif; ?>
                                    <span class="control-label"><?=form_error('app_bg'); ?></span>
                                </div>
                            </div>
                        </div>
                        <!-- App Logo -->
                        <div class="col-sm-4">
                            <div class="form-group <?=form_error('app_logo') ? 'has-error' : ''?>">
                                <div class="col-sm-12">
                                    <label for="app_logo">
                                        <?=$this->lang->line('setting_school_app_logo')?>
                                        &nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="right" title="<?=$this->lang->line('setting_school_app_logo')?>"></i>
                                    </label>
                                    <input type="file" class="form-control" id="app_logo" name="app_logo" />
                                    <?php if(!empty($settingarray['app_logo'])): ?>
                                        <br/><img src="<?=base_url('uploads/skooly/defaults/'.$settingarray['app_logo'])?>" style="max-width:80px;" alt="App Logo">
                                    <?php endif; ?>
                                    <span class="control-label"><?=form_error('app_logo'); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <!-- Favicon -->
                        <div class="col-sm-4">
                            <div class="form-group <?=form_error('favicon') ? 'has-error' : ''?>">
                                <div class="col-sm-12">
                                    <label for="favicon">
                                        <?=$this->lang->line('setting_school_favicon')?>
                                        &nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="right" title="<?=$this->lang->line('setting_school_favicon')?>"></i>
                                    </label>
                                    <input type="file" class="form-control" id="favicon" name="favicon" />
                                    <?php if(!empty($settingarray['favicon'])): ?>
                                        <br/><img src="<?=base_url('uploads/skooly/defaults/'.$settingarray['favicon'])?>" style="max-width:32px;" alt="Favicon">
                                    <?php endif; ?>
                                    <span class="control-label"><?=form_error('favicon'); ?></span>
                                </div>
                            </div>
                        </div>
                        <!-- Software Icon -->
                        <div class="col-sm-4">
                            <div class="form-group <?=form_error('softwareicon') ? 'has-error' : ''?>">
                                <div class="col-sm-12">
                                    <label for="softwareicon">
                                        <?=$this->lang->line('setting_school_softwareicon')?>
                                        &nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="right" title="<?=$this->lang->line('setting_school_softwareicon')?>"></i>
                                    </label>
                                    <input type="file" class="form-control" id="softwareicon" name="softwareicon" />
                                    <?php if(!empty($settingarray['softwareicon'])): ?>
                                        <br/><img src="<?=base_url('uploads/skooly/defaults/'.$settingarray['softwareicon'])?>" style="max-width:32px;" alt="Software Icon">
                                    <?php endif; ?>
                                    <span class="control-label"><?=form_error('softwareicon'); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                
            </fieldset>
            <fieldset class="setting-fieldset">
                <legend class="setting-legend"><?=$this->lang->line('user_time')?></legend>
                <div class="row">
                    <?php
                    $user_working_time = null;
                    if(!empty($setting->user_working_time)){

                        $user_working_time =  unserialize($setting->user_working_time);
                    }
                    ?>
                    <div class="col-sm-4">
                        <div class="form-group <?php if(form_error('user_start_time')) { echo 'has-error'; } ?>">
                            <div class="col-sm-12">
                                <label><?=$this->lang->line("start_time")?>&nbsp; <i class="fa fa-question-circle" data-toggle="tooltip" data-placement="bottom" title="Check-in time for User."></i></label>
                                <input type="time" name="user_start_time" class='form-control' value="<?= set_value('user_start_time', (isset($user_working_time['check_in']))?$user_working_time['check_in']:""); ?>">
                                <span class="control-label">
                                    <?php echo form_error('user_start_time'); ?>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group <?php if(form_error('user_end_time')) { echo 'has-error'; } ?>">
                            <div class="col-sm-12">
                                <label><?=$this->lang->line("end_time")?>&nbsp; <i class="fa fa-question-circle" data-toggle="tooltip" data-placement="bottom" title="Check-out time for User."></i></label>
                                <input type="time" name="user_end_time" class='form-control' value="<?= set_value('user_start_time', (isset($user_working_time['check_out']))? $user_working_time['check_out'] :""); ?>" >
                                <span class="control-label">
                                    <?php echo form_error('user_end_time'); ?>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </fieldset>


            <fieldset class="setting-fieldset">
                <legend class="setting-legend"><?=$this->lang->line('teacher_time')?></legend>
                <div class="row">
                    <?php

                    $teacher_working_time = null;
                    if(!empty($setting->teacher_working_time)){
                        $teacher_working_time =  unserialize($setting->teacher_working_time);
                    }
                    ?>
                    <div class="col-sm-4">
                        <div class="form-group <?php if(form_error('teacher_start_time')) { echo 'has-error'; } ?>">
                            <div class="col-sm-12">
                                <label><?=$this->lang->line("start_time")?>&nbsp; <i class="fa fa-question-circle" data-toggle="tooltip" data-placement="bottom" title="Check-in time for Teacher."></i></label>
                                <input type="time" name="teacher_start_time" class='form-control' value="<?= set_value('teacher_start_time', (isset($teacher_working_time['check_in']))? $teacher_working_time['check_in'] :""); ?>">
                                <span class="control-label">
                                    <?php echo form_error('teacher_start_time'); ?>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group <?php if(form_error('teacher_end_time')) { echo 'has-error'; } ?>">
                            <div class="col-sm-12">
                                <label><?=$this->lang->line("end_time")?>&nbsp; <i class="fa fa-question-circle" data-toggle="tooltip" data-placement="bottom" title="Check-out time for Teacher."></i></label>
                                <input type="time" name="teacher_end_time" class='form-control' value="<?= set_value('teacher_end_time', (isset($teacher_working_time['check_out']))? $teacher_working_time['check_out'] :""); ?>" >
                                <span class="control-label">
                                    <?php echo form_error('teacher_end_time'); ?>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </fieldset>

            <fieldset class="setting-fieldset">
                <legend class="setting-legend"><?=$this->lang->line('setting_auto_update')?></legend>
                <div class="row">
                    <div class="col-sm-4">
                        <div class="form-group <?php if(form_error('auto_update_notification')) { echo 'has-error'; } ?>">
                            <div class="col-sm-12">
                                <label><?=$this->lang->line("setting_auto_update_notification")?>&nbsp; <i class="fa fa-question-circle" data-toggle="tooltip" data-placement="bottom" title="Enable/Disable for auto update notification. only main system admin can see the update notification"></i>
                                </label>
                                <?php
                                    $autoupdateArray[1] = $this->lang->line('setting_enable');
                                    $autoupdateArray[0] = $this->lang->line('setting_disable');
                                    echo form_dropdown("auto_update_notification", $autoupdateArray, set_value("auto_update_notification",$setting->auto_update_notification), "id='auto_update_notification' class='form-control select2'");
                                ?>
                                <span class="control-label">
                                    <?php echo form_error('auto_update_notification'); ?>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </fieldset>

            <fieldset class="setting-fieldset">
                <legend class="setting-legend"><?=$this->lang->line('setting_captcha')?></legend>
                <div class="col-sm-4">
                    <div class="form-group <?php if(form_error('captcha_status')) { echo 'has-error'; } ?>">
                        <div class="col-sm-12">
                            <label><?=$this->lang->line("setting_captcha")?>&nbsp; <i class="fa fa-question-circle" data-toggle="tooltip" data-placement="bottom" title="Check for disable captcha in login"></i>
                            </label>
                            <?php
                                $captchaArray[0] = $this->lang->line('setting_enable');
                                $captchaArray[1] = $this->lang->line('setting_disable');
                                echo form_dropdown("captcha_status", $captchaArray, set_value("captcha_status",$setting->captcha_status), "id='captcha_status' class='form-control select2'");
                            ?>

                            <span class="control-label">
                                <?php echo form_error('captcha_status'); ?>
                            </span>
                        </div>
                    </div>
                </div>

                <div class="col-sm-4">
                    <div class="form-group <?php if(form_error('recaptcha_site_key')) { echo 'has-error'; } ?>" id="recaptcha_site_key_id">
                        <div class="col-sm-12">
                            <label for="recaptcha_site_key">
                                <?=$this->lang->line("setting_school_recaptcha_site_key")?>
                                &nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="bottom" title="Set recaptcha site key. Becareful If it's invalid then you cann't login."></i>
                            </label>
                            <input type="text" class="form-control" id="recaptcha_site_key" name="recaptcha_site_key" value="<?=set_value('recaptcha_site_key', $setting->recaptcha_site_key)?>" >
                            <span class="control-label">
                                <?php echo form_error('recaptcha_site_key'); ?>
                            </span>
                        </div>
                    </div>
                </div>

                <div class="col-sm-4">
                    <div class="form-group <?php if(form_error('recaptcha_secret_key')) { echo 'has-error'; } ?>" id="recaptcha_secret_key_id" >
                        <div class="col-sm-12">
                            <label for="recaptcha_secret_key"><?=$this->lang->line("setting_school_recaptcha_secret_key")?>&nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="bottom" title="Set recaptcha secret key. Becareful If it's invalid then you cann't login."></i>
                            </label>
                            <input type="text" class="form-control" id="recaptcha_secret_key" name="recaptcha_secret_key" value="<?=set_value('recaptcha_secret_key', $setting->recaptcha_secret_key)?>" >
                            <span class="control-label">
                                <?php echo form_error('recaptcha_secret_key'); ?>
                            </span>
                        </div>
                    </div>
                </div>
            </fieldset>

            <fieldset class="setting-fieldset">
                <legend class="setting-legend"><?=$this->lang->line('setting_attendance_notification')?></legend>
                <div class="col-sm-4">
                    <div class="form-group <?php if(form_error('attendance_notification')) { echo 'has-error'; } ?>">
                        <div class="col-sm-12">
                            <label><?=$this->lang->line("setting_attendance_notification")?>&nbsp; <i class="fa fa-question-circle" data-toggle="tooltip" data-placement="bottom" title="Select Attendance Notification"></i>
                            </label>
                            <?php
                                $array = array(
                                    "none" => $this->lang->line("setting_none"), 
                                    "email" => $this->lang->line("setting_email"), 
                                    "sms" => $this->lang->line("setting_sms")
                                );

                                echo form_dropdown("attendance_notification", $array, set_value("attendance_notification",$setting->attendance_notification), "id='attendance_notification' class='form-control select2'");
                            ?>
                            <span class="control-label">
                                <?php echo form_error('attendance_notification'); ?>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group <?php if(form_error('system_notification')) { echo 'has-error'; } ?>">
                        <div class="col-sm-12">
                            <label><?=$this->lang->line("setting_system_notification")?>&nbsp; <i class="fa fa-question-circle" data-toggle="tooltip" data-placement="bottom" title="Select Attendance Notification"></i>
                            </label>
                            <?php
                                $array = array(
                                    "" => $this->lang->line("please_select"), 
                                    "1" => $this->lang->line("yes"), 
                                    "0" => $this->lang->line("no")
                                );

                                echo form_dropdown("system_notification", $array, set_value("system_notification",$setting->system_notification), "id='system_notification' class='form-control select2'");
                            ?>
                            <span class="control-label">
                                <?php echo form_error('system_notification'); ?>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="col-sm-4">
                        <div class="form-group <?=form_error('user_notification_number') ? 'has-error' : ''?>">
                            <div class="col-sm-12">
                                <label for="user_notification_number"><?=$this->lang->line("user_notification_number")?>&nbsp;<i class="fa fa-question-circle" data-toggle="tooltip" data-placement="right" title="Set Sms balance number"></i>
                                </label>
                                <input type="text" class="form-control" id="user_notification_number" name="user_notification_number" value="<?=set_value('user_notification_number', $setting->user_notification_number)?>" >
                                <span class="control-label">
                                    <?php echo form_error('user_notification_number'); ?>
                                </span>
                            </div>
                        </div>
                </div>
                <div class="col-sm-4" id="mainSmsDiv">
                    <div class="form-group <?php if(form_error('attendance_smsgateway')) { echo 'has-error'; } ?>" id="attendance_smsgateway_div">
                        <div class="col-sm-12">
                            <label><?=$this->lang->line("setting_attendance_smsgateway")?>&nbsp; <i class="fa fa-question-circle" data-toggle="tooltip" data-placement="bottom" title="Select Sms Gateway"></i>
                            </label>
                            <?php
                                $array = array(
                                    "0" => $this->lang->line("setting_select_sms_gateway"), 
                                    "clickatell" => $this->lang->line("setting_clickatell"), 
                                    "twilio" => $this->lang->line("setting_twilio"), 
                                    "bulk" => $this->lang->line("setting_bulk"),
                                    "msg91" => $this->lang->line("setting_msg91")
                                );

                                echo form_dropdown("attendance_smsgateway", $array, set_value("attendance_smsgateway",$setting->attendance_smsgateway), "id='attendance_smsgateway' class='form-control select2'");
                            ?>
                            <span class="control-label">
                                <?php echo form_error('attendance_smsgateway'); ?>
                            </span>
                        </div>
                    </div> 
                </div>

                <div class="col-sm-4">
                    <div class="form-group <?php if(form_error('attendance_notification_template')) { echo 'has-error'; } ?>" id="attendance_notification_template_div">
                        <div class="col-sm-12">
                            <label><?=$this->lang->line("setting_attendance_notification_template")?>&nbsp; <i class="fa fa-question-circle" data-toggle="tooltip" data-placement="bottom" title="Select Attendance Notification Template"></i>
                            </label>
                            <?php
                                $attendanceNotificationArray = array(
                                    "0" => $this->lang->line("setting_select_template"), 
                                );

                                if(customCompute($attendance_notification_templates)) {
                                    foreach ($attendance_notification_templates as $attendance_notification_template) {
                                        $attendanceNotificationArray[$attendance_notification_template->mailandsmstemplateID] =  $attendance_notification_template->name;
                                    }
                                }

                                echo form_dropdown("attendance_notification_template", $attendanceNotificationArray, set_value("attendance_notification_template", $setting->attendance_notification_template), "id='attendance_notification_template' class='form-control select2'");
                            ?>
                            <span class="control-label">
                                <?php echo form_error('attendance_notification_template'); ?>
                            </span>
                        </div>
                    </div>
                </div>
            </fieldset>

            <div class="form-group">
                <div class="col-sm-8">
                    <input type="submit" class="btn btn-success btn-md" value="<?=$this->lang->line("update_setting")?>" >
                </div>
            </div>
        </div>
    </form>
</div>

<!-- <div class="box" style="margin-bottom: 40px" >
    <div class="box-header">
        <h3 class="box-title"><i class="fa fa-th-large"></i> <?=$this->lang->line('backend_theme_setting')?></h3>

    </div>
    <div class="box-body">
        <div class="row">
            <div class="col-sm-12">
                
                <ul class="list-unstyled clearfix">
                    <?php 
                        if(customCompute($themes)) {
                            foreach ($themes as $theme) {
                    ?>
                    
                    <li class="backendThemeMainWidht" style="float:left; padding: 5px;">
                        <a id="<?=$theme->themesID?>" data-toggle="tooltip" data-placement="top" title="" data-original-title="<?=$theme->themename?>"

                         data-skin="skin-green-light" style="display: block; box-shadow: 0 0 3px rgba(0,0,0,0.4); cursor: pointer;" class="clearfix full-opacity-hover backendThemeEvent">
                            <div>
                                <span class="backendThemeHeadHeight" style="display:block; width: 20%; float: left; background-color: <?=$theme->topcolor?>" >
                                    
                                </span>

                                <span class="backendThemeHeadHeight" style="display:block; width: 80%; float: left; background-color: <?=$theme->topcolor?>">
                                </span>
                            </div>

                            <div>
                                <span class="backendThemeBodyHeight" style="display:block; width: 20%; float: left; background-color: <?=$theme->leftcolor?>">
                                </span>
                                <span class="backendThemeBodyHeight" style="display:block; width: 80%; float: left; background: #f4f5f7" id="themeBodyContent-<?=strtolower(str_replace(' ', '', $theme->themename))?>">
                                <?php  ?>
                                        <?php if($setting->backend_theme == strtolower(str_replace(' ', '', $theme->themename)))  {?>
                                        <center class="backendThemeBodyMargin">
                                            <button type="button" class="btn btn-danger">
                                                <i  class="fa fa-check-circle"></i>
                                            </button>
                                        </center>
                                        <?php } ?>
                                </span>
                            </div>
                        </a>
                        <p class="text-center no-margin" style="font-size: 12px">
                            <?=$theme->themename?>
                        </p>
                    </li>


                    <?php            
                            }
                        }
                    ?>
                </ul>

            </div>
        </div>
    </div>
</div> -->

<div class="box" style="margin-bottom: 40px" >
    <div class="box-header">
        <h3 class="box-title"><i class="fa fa-th-large"></i> <?=$this->lang->line('additional_settings')?></h3>
    </div><!-- /.box-header -->
    
    <!-- form start -->
    <div class="box-body">
        <div class="row">
            <?php if ($this->session->userdata('usertype') === 'Admin' || permissionChecker('wallet')) { ?>
                <div class="col-sm-4" style="margin-bottom: 15px;">
                    <label>Generate Wallets</label>
                    <br>
                    <a href="<?= base_url('setting/generateWallets') ?>" class="btn btn-success btn-md confirm-action sms-check-button" 
                       data-title="Generate Wallets?" 
                       data-text="Are you sure you want to generate wallets for new students?" 
                       data-icon="info"
                       data-confirm-button-text="Yes, generate them!">
                       <?= $this->lang->line("generate") ?>
                    </a>
                </div>
            <?php } ?>
            
            <?php if ($this->session->userdata('usertype') === 'Admin' || permissionChecker('generate_qrcode')) { ?>
                <div class="col-sm-4" style="margin-bottom: 15px;">
                    <label>Generate Student QR Codes</label>
                    <br>
                    <a href="<?= base_url('setting/generateQrCodes') ?>" class="btn btn-success btn-md confirm-action sms-check-button"
                       data-title="Generate QR Codes?"
                       data-text="Are you sure you want to generate QR codes for new students?"
                       data-icon="info"
                       data-confirm-button-text="Yes, generate them!">
                       <?= $this->lang->line("generate_qr_code") ?>
                    </a>
                </div>
            <?php } ?>
            
            <div class="form-group col-sm-4">
                <label for="activationSwitch mr-md">OTP Login</label>
                <label class="switch">
                    <input type="checkbox" id="activationSwitch" name="otp_login" <?= $setting->otp_login == '1' ? 'checked' : '' ?>>
                    <span class="slider round"></span>
                </label>
            </div>
        </div>
        
        <hr/>
        <h4><i class="fa fa-exclamation-triangle"></i> Dangerous Settings</h4>
        <p class="text-muted">These actions are irreversible. Please be certain before you proceed.</p>
        
        <div class="row" style="margin-top: 20px;">
            <div class="col-sm-4" style="margin-bottom: 15px;">
                <label>Reset Wallets</label>
                <p><small>Sets the balance of all wallets to 0.</small></p>
                <a href="<?= base_url('setting/resetwallets') ?>" class="btn btn-danger btn-md confirm-action sms-check-button"
                   data-title="Reset All Wallets?"
                   data-text="This will reset ALL wallet balances to 0. This action cannot be undone."
                   data-icon="warning"
                   data-confirm-button-text="Yes, reset them!">
                   Reset Wallets
                </a>
            </div>
            
            <div class="col-sm-4" style="margin-bottom: 15px;">
                <label>Reset Student Balances</label>
                <p><small>Sets all student fee and wallet balances to 0.</small></p>
                <a href="<?= base_url('setting/resetstudentbalances') ?>" class="btn btn-danger btn-md confirm-action sms-check-button"
                   data-title="Reset Student Balances?"
                   data-text="This will reset ALL student fee and wallet balances to 0. This cannot be undone."
                   data-icon="warning"
                   data-confirm-button-text="Yes, reset them!">
                   Reset Student Balances
                </a>
            </div>
            
            <div class="col-sm-4" style="margin-bottom: 15px;">
                <label>Reset All Transactions</label>
                <p><small>Deletes all financial records and resets all balances.</small></p>
                <a href="<?= base_url('setting/resetalltransactions') ?>" class="btn btn-danger btn-md confirm-action sms-check-button"
                   data-title="ARE YOU ABSOLUTELY SURE?"
                   data-text="This will ERASE all transaction history and reset ALL balances. This is IRREVERSIBLE."
                   data-icon="error"
                   data-confirm-button-text="Yes, I understand, reset everything!">
                   Reset All Transactions
                </a>
            </div>
        </div>
    </div>
</div>

<?php if(form_error('recaptcha_site_key') || form_error('recaptcha_secret_key')) { ?>
<script type="text/javascript">
    $('#recaptcha_site_key_id').show(); 
    $('#recaptcha_secret_key_id').show();  
</script>
<?php } ?>

<script type="text/javascript">

    <?php if($this->data["siteinfos"]->attendance_notification == 'sms') {?>
        $("#mainSmsDiv").show();
        $("#attendance_smsgateway_div").show();
        $("#attendance_notification_template_div").show();
    <?php } elseif ($this->data["siteinfos"]->attendance_notification == 'email') { ?>
        $("#mainSmsDiv").hide();
        $("#attendance_smsgateway_div").hide();
        $("#attendance_notification_template_div").show();
    <?php  } else {  ?>
        $("#mainSmsDiv").hide();
        $("#attendance_smsgateway_div").hide();
        $("#attendance_notification_template_div").hide();
    <?php } ?>

    <?php if($attendance_notification == 'sms') { ?>
        $("#mainSmsDiv").show();
        $("#attendance_smsgateway_div").show();
        $("#attendance_notification_template_div").show();
    <?php } elseif ($attendance_notification == 'email') { ?>
        $("#mainSmsDiv").hide();
        $("#attendance_smsgateway_div").hide();
        $("#attendance_notification_template_div").show();
    <?php  } else {  ?>
        $("#mainSmsDiv").hide('slow');
        $("#attendance_smsgateway_div").hide();
        $("#attendance_notification_template_div").hide();
    <?php } ?>
    document.addEventListener('DOMContentLoaded', function () {
        const activationSwitch = document.getElementById('activationSwitch');

        activationSwitch.addEventListener('change', function () {
            const otpLoginStatus = this.checked ? 1 : 0;

            // Perform AJAX request
            $.ajax({
                type: 'POST',
                url: "<?=base_url('setting/otpStatus')?>",
                data: {"otpStatus" : otpLoginStatus},
                dataType: "html",
                success: function(response) {
                    let parsedResponse = JSON.parse(response);
                    showToastr(parsedResponse.message || 'Saved successfully', 'success');
                }
            });
        });
    });

    $(document).on('change', "#attendance_notification", function() {
        var value = $(this).val();
        if(value == 'sms') {
            $("#mainSmsDiv").show('slow');
            $("#attendance_smsgateway_div").show('slow');
            $("#attendance_notification_template_div").show('slow');
        } else if(value == 'email') {
            $("#mainSmsDiv").hide('slow');
            $("#attendance_smsgateway_div").hide('slow');
            $("#attendance_notification_template_div").show('slow');
        } else {
            $("#mainSmsDiv").hide('slow');
            $("#attendance_smsgateway_div").hide('slow');
            $("#attendance_notification_template_div").hide('slow');
        }

        if(value == 'sms' || value =='email') {
            $.ajax({
                type: 'POST',
                url: "<?=base_url('setting/getTemplate')?>",
                data: {"value" : value},
                dataType: "html",
                success: function(data) {
                   $('#attendance_notification_template').html(data);
                }
            });
        }
    });

    $(document).ready(function() {
        $('.backendThemeEvent').click(function() {
            var id = $(this).attr('id');
            if(id) {
                $.ajax({
                    type: 'POST',
                    url: "<?=base_url('setting/backendtheme')?>",
                    data: "id=" + id,
                    dataType: "html",
                    success: function(data) {
                        $('#headStyleCSSLink').attr('href', "<?=base_url('assets/inilabs/themes/')?>"+data+"/style.css");
                        $('#headInilabsCSSLink').attr('href', "<?=base_url('assets/inilabs/themes/')?>"+data+"/inilabs.css");
                        
                        $html = '<center class="backendThemeBodyMargin"><button type="button" class="btn btn-danger"><i  class="fa fa-check-circle"></i></button></center>';
                        $('.backendThemeBodyMargin').hide();
                        $('#themeBodyContent-'+data).html($html);
                        if(data) {
                            toastr["success"]("<?=$this->lang->line('menu_success');?>")
                            toastr.options = {
                                "closeButton": true,
                                "debug": false,
                                "newestOnTop": false,
                                "progressBar": false,
                                "positionClass": "toast-top-right",
                                "preventDuplicates": false,
                                "onclick": null,
                                "showDuration": "500",
                                "hideDuration": "500",
                                "timeOut": "5000",
                                "extendedTimeOut": "1000",
                                "showEasing": "swing",
                                "hideEasing": "linear",
                                "showMethod": "fadeIn",
                                "hideMethod": "fadeOut"
                            }
                        }
                    }
                });
            }
        });
    });

    

    $('#captcha_status').change(function() {
        var captcha_status = $(this).val();
        if(captcha_status == 0) {
            $('#recaptcha_site_key_id').show(300); 
            $('#recaptcha_secret_key_id').show(300);  
        } else {
            $('#recaptcha_site_key_id').hide(300); 
            $('#recaptcha_secret_key_id').hide(300); 
        }
    });

    <?php if($captcha_status == 0) { ?>
            $('#recaptcha_site_key_id').show(300); 
            $('#recaptcha_secret_key_id').show(300);
       <?php } else { ?>
            $('#recaptcha_site_key_id').hide(300); 
            $('#recaptcha_secret_key_id').hide(300); 
    <?php } ?>


    <?php if($setting->auto_invoice_generate) { ?>
        $('#automation').show();
        $('#autoinvoicediv').addClass('col-sm-6');
    <?php } else { ?>
        $('#automation').hide();
        $('#autoinvoicediv').addClass('col-sm-12');
    <?php } ?> 

    $('#auto_invoice_generate').change(function() {
        var aig = $(this).val();
        
        if(aig == 1) {
            $('#s2id_automation').show(1000);
            $("#auto_invoice_generate").fadeIn("slow", function() {
                $('#autoinvoicediv').removeClass('col-sm-12');
                $('#autoinvoicediv').addClass('col-sm-6');
            });
        } else {
            $('#s2id_automation').hide(1000);
            $("#auto_invoice_generate").fadeIn("slow", function() {
                $('#autoinvoicediv').removeClass('col-sm-6');
                $('#autoinvoicediv').addClass('col-sm-12');
            });

            
        }
    });


    $(document).on('click', '#close-preview', function(){ 
        $('.image-preview').popover('hide');
        // Hover befor close the preview
        $('.image-preview').hover(
            function () {
               $('.image-preview').popover('show');
               $('.content').css('padding-bottom', '120px');
            }, 
             function () {
               $('.image-preview').popover('hide');
               $('.content').css('padding-bottom', '20px');
            }
        );    
    });

    $(function() {
        // Create the close button
        var closebtn = $('<button/>', {
            type:"button",
            text: 'x',
            id: 'close-preview',
            style: 'font-size: initial;',
        });
        closebtn.attr("class","close pull-right");
        // Set the popover default content
        $('.image-preview').popover({
            trigger:'manual',
            html:true,
            title: "<strong>Preview</strong>"+$(closebtn)[0].outerHTML,
            content: "There's no image",
            placement:'bottom'
        });
        // Clear event
        $('.image-preview-clear').click(function(){
            $('.image-preview').attr("data-content","").popover('hide');
            $('.image-preview-filename').val("");
            $('.image-preview-clear').hide();
            $('.image-preview-input input:file').val("");
            $(".image-preview-input-title").text("<?=$this->lang->line('setting_file_browse')?>"); 
        }); 
        // Create the preview image
        $(".image-preview-input input:file").change(function (){     
            var img = $('<img/>', {
                id: 'dynamic',
                width:250,
                height:200,
                overflow:'hidden'
            });      
            var file = this.files[0];
            var reader = new FileReader();
            // Set preview image into the popover data-content
            reader.onload = function (e) {
                $(".image-preview-input-title").text("<?=$this->lang->line('setting_clear')?>");
                $(".image-preview-clear").show();
                $(".image-preview-filename").val(file.name);            
                img.attr('src', e.target.result);
                $(".image-preview").attr("data-content",$(img)[0].outerHTML).popover("show");
                $('.content').css('padding-bottom', '120px');
            }        
            reader.readAsDataURL(file);
        });  
    });

    $( ".select2" ).select2( { placeholder: "", maximumSelectionSize: 6 } );

    $('#weekends').select2();

</script>

<!-- ALERT BOX FOR ADDITIONAL SETTINGS-->
<script type="text/javascript">
$(document).ready(function() {
    $('.confirm-action').on('click', function(e) {
        // Prevent the link from navigating instantly
        e.preventDefault(); 
        
        // Get the URL and custom messages from the button's data attributes
        var url = $(this).attr('href');
        var title = $(this).data('title') || 'Are you sure?';
        var text = $(this).data('text') || 'This action cannot be undone.';
        var icon = $(this).data('icon') || 'warning';
        var confirmButtonText = $(this).data('confirm-button-text') || 'Yes, do it!';

        // Show the SweetAlert2 popup
        Swal.fire({
            title: title,
            text: text,
            icon: icon,
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: confirmButtonText,
            // This makes the alert box bigger
            customClass: {
                popup: 'swal2-lg', // You can define custom CSS for this class if needed
            },
        }).then((result) => {
            // If the user clicks the "confirm" button
            if (result.isConfirmed) {
                // Redirect to the URL
                window.location.href = url;
            }
        });
    });
});
</script>
