<?php
// THIS IS WHERE YOUR MAIN <style> BLOCK SHOULD GO (ONLY ONCE)
// For example, if this file is included within a larger HTML structure,
// ideally this <style> block would be in the <head>.
// If not, place it here, BEFORE the content that uses it.
?>
<style>
    /* ---------------------------------------------------------------------- */
    /* DEFAULT STYLES (for Screen Display)                                    */
    /* ---------------------------------------------------------------------- */
    .clear { clear: both; }
    p { font-size: 9pt; margin: 1.5pt; color: #000; font-weight: bold; }
    .id-card-holder { width: 450px; margin: 0 auto; font-family: "Nunito", sans-serif; }
    .id-card { background-color: #fff; padding: 0px; text-align: center; box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05); display: block; border-radius: 0.5rem; overflow: hidden; }
    .id { display: inline-block; float: left; font-size: 11.25pt; text-transform: uppercase; color: #fff; text-align: center; margin-left: 15pt; margin-top: 7.5pt; }
    .header { background-color: #fff; border-bottom: 1.5pt solid #6FAC45; padding: 7.5pt 0; display: flex; align-items: center; justify-content: center; }
    .header-spacer { flex-grow: 1; }
    .sc-logo { width: 50px; height: 50px; display: flex; align-items: center; justify-content: center; flex-shrink: 0; margin-right: 26.25pt; }
    .sc-logo img { max-width: 100%; max-height: 100%; object-fit: contain; }
    .head-info { flex-grow: 1; text-align: center; color: #006341; }
    .head-info h3 { font-size: 14pt; margin: 0 0 2.25pt 0; color: #000; text-transform: uppercase; font-weight: 700; }
    .contact-info { display: flex; justify-content: center; align-items: center; flex-wrap: wrap; margin-top: 3.75pt; }
    .contact-info h5 { font-size: 7.5pt; margin: 0 6pt; color: #555; font-weight: normal; display: flex; align-items: center; white-space: nowrap; }
    .contact-info h5 i { margin-right: 3.75pt; color: #333; font-size: 8.25pt; }
    .b-border { width: 100%; height: 4.5pt; display: block; background-color: #202020; margin-top: 0.75pt; }
    .card-detail { width: 100%; display: flex; padding: 7.5pt; box-sizing: border-box; margin-top: 7.5pt; margin-bottom: 15pt; align-items: flex-start; }
    .stu-photo { width: 100px; height: 140px; border-radius: 5px; box-sizing: border-box; flex-shrink: 0; display: flex; align-items: center; justify-content: center; overflow: hidden; margin-right: 11.25pt; }
    .card-photo { height: 140px; width: 100px; object-fit: cover; object-position: center; display: block; border-radius: 4px; }
    .stu-info { flex-grow: 1; padding: 0; box-sizing: border-box; text-align: left; text-transform: capitalize; }
    .session { font-size: 9.75pt; font-weight: 600; margin: 0 0 5.25pt; }
    .stu-info h3 { font-size: 11.25pt; font-weight: 700; margin: 0 0 6pt 0; color: #4a0a2cfc; }
    .stu-info p { font-size: 8.25pt; margin: 0 0 2.25pt 0; font-weight: 300; line-height: 12.75pt; }
    .stu-info p span { font-weight: 600; text-transform: uppercase; }
    footer { padding: 3.75pt 0; border-top: 0.75pt solid #6FAC45; }
    footer p { font-size: 5.25pt; margin: 0 0 1.5pt 0; }
    .center { display: flex; align-items: center; justify-content: center; text-align: center; }
    .background-image { background-size: 130px 130px; background-position: right bottom; background-repeat: no-repeat; }
    .card-detail { width: 100%; display: flex; padding: 7.5pt; box-sizing: border-box; margin-top: 7.5pt; margin-bottom: 22.5pt; }
    .column-container { display: flex; flex-direction: row; width:100%;} /* Ensure container takes full width */
    .column1 { width: 30%; padding: 0 3.75pt; }
    .column2 { width: 30%; padding: 0 3.75pt; }
    .column3 { width: 40%; padding: 0 3.75pt; }
    .qr-code-column { text-align: center; }
    .qr-code-column img { width: 135pt; height: auto; }
    .photo-column .stu-photo { width: 100%; margin: 0 auto; }
    .info-column { font-size: 11.25pt; text-align: left; color: #000; text-transform: capitalize; }
    .bold-text { font-size: 13.5pt; font-weight: 700; color: #000; text-transform: capitalize; }
    .mbc { margin-bottom: 6pt; }

    /* ---------------------------------------------------------------------- */
    /* @MEDIA PRINT STYLES (for Print Output)                                 */
    /* ---------------------------------------------------------------------- */
    @media print {
    @page {
        margin: 0.1in; /* Adjust if your printer has larger unprintable margins */
        size: auto;   /* Let the browser determine based on content */
    }

    body {
        margin: 0;
        font-family: "Nunito", sans-serif;
        color: #000;
        background-color: #fff !important;
        font-size: 8pt; /* Base font size for print */
        -webkit-print-color-adjust: exact;
        print-color-adjust: exact;
    }

    .no-print {
        display: none !important;
    }

    #printablediv {
        background-color: #fff !important;
        border: none !important;
    }
    .box-body {
        margin-bottom: 0 !important;
    }
    .print-row {
        margin-left: 0 !important;
    }

    /* Generic Bootstrap column override - place this earlier */
    .col-sm-4 {
        width: 100% !important; /* This will now be overridden by the more specific .id-card-holder if needed */
        float: none !important;
        margin: 0 !important; /* These are fine as .id-card-holder also resets them */
        padding: 0 !important;
    }
    .print-col { /* Existing class, mainly for screen margins if any, reset for print */
         margin:0 !important;
    }

    /* ID Card specific styles - place these later or ensure higher specificity */
    .id-card-holder {
        width: 3.375in !important;  /* Standard ID card width CR80 */
        height: 2.125in !important; /* Standard ID card height CR80 */
        margin: 0 !important;       /* Reset margin for print layout */
        padding: 0 !important;      /* Ensure no internal padding affects size */
        page-break-after: always !important; /* Force new page after each ID card */
        box-sizing: border-box !important;
        border: none !important; /* Use a light border for cutting guides if needed: 0.5pt solid #ccc; */
        box-shadow: none !important;
        background-color: #fff !important;
        overflow: hidden !important; /* Important to contain elements */
        position: relative;
        float: none !important;      /* Ensure it doesn't float */
        display: block !important;   /* Or flex if you want to center content vertically inside */
    }

    .id-card {
        width: 100% !important;
        height: 100% !important;
        padding: 0 !important;
        border-radius: 0 !important;
        box-shadow: none !important;
        display: flex;
        flex-direction: column;
        justify-content: flex-start;
    }

    /* ... Rest of your .id, .header, .sc-logo, etc. print styles ... */
    /* Ensure they are consistent with the reordering */
    .id { font-size: 8pt; margin-left: 10pt; margin-top: 5pt; }
    .header { padding: 2pt 0; border-bottom: 0.5pt solid #6FAC45; flex-shrink: 0; }
    .sc-logo { width: 25pt; height: 25pt; margin-right: 10pt; }
    .head-info h3 { font-size: 9pt; margin-bottom: 1.5pt; }
    .contact-info { margin-top: 1.5pt; }
    .contact-info h5 { font-size: 6pt; margin: 0 3pt; }
    .contact-info h5 i { font-size: 6.5pt; margin-right: 2pt; }
    .b-border { height: 2pt; margin-top: 0.5pt; flex-shrink: 0;}

    .card-detail {
        padding: 3pt !important;
        margin-top: 3pt !important;
        margin-bottom: 0 !important;
        display: flex !important;
        flex-direction: row !important;
        align-items: flex-start !important;
        flex-grow: 1;
        width: 100% !important;
        box-sizing: border-box !important;
    }

    .column-container {
        display: flex !important;
        flex-direction: row !important;
        width: 100% !important;
        height: 100% !important;
        align-items: stretch;
    }
    .column1, .column2, .column3 {
        padding: 0 2pt !important;
        box-sizing: border-box !important;
        display: flex;
        flex-direction: column;
        justify-content: center;
    }
    .column1 { width: 28% !important; }
    .column2 { width: 37% !important; }
    .column3 { width: 35% !important; }

    .photo-column .stu-photo {
        width: 55pt !important;
        height: 70pt !important;
        margin: 0 auto !important;
        border-radius: 0 !important;
        overflow: hidden;
    }
    .card-photo {
        width: 100% !important;
        height: 100% !important;
        object-fit: cover !important;
        object-position: center !important;
        border-radius: 0 !important;
    }

    .info-column {
        font-size: 7pt !important;
        text-align: left;
    }
    .info-column h5 {
        margin: 1pt 0 !important;
        line-height: 1.2;
    }

    .bold-text {
        font-size: 8pt !important;
        font-weight: 700 !important;
    }
    .mbc {
        margin-bottom: 3pt !important;
    }

    .qr-code-column img {
        width: 50pt !important;
        height: 50pt !important;
        margin: auto;
    }

    footer { padding: 1pt 0; border-top: 0.5pt solid #6FAC45; flex-shrink: 0; }
    footer p { font-size: 4.5pt; margin: 0; }

    .id-card { page-break-inside: avoid !important; }
}
</style>

<div class="row no-print"> <?php /* Added no-print class */ ?>
    <div class="col-sm-12" style="margin:10px 0px">
        <?php
            $pdf_preview_uri = base_url('idcardreport/pdf/'.$usertypeID.'/'.$classesID.'/'.$sectionID.'/'.$userID.'/'.$type.'/'.$background.'/'.$exclude);
            // It's better to use the system's print dialog directly via JavaScript if you're printing the current view
            // The btn_printReport function might be calling your `printDivv` function.
            // Ensure 'printablediv' is the correct ID passed to your print function.
            echo btn_printReport('idcardreport', $this->lang->line('idcardreport_print'), 'printablediv'); // This button will call printDivv('printablediv')
            echo btn_pdfPreviewReport('idcardreport',$pdf_preview_uri, $this->lang->line('idcardreport_pdf_preview'));
            echo btn_sentToMailReport('idcardreport', $this->lang->line('idcardreport_mail'));
        ?>
    </div>
</div>

<?php if($usertypeID == 3) { ?>
<div class="box">
    <div class="box-header bg-black no-print"> <?php /* Added no-print class */ ?>
        <h3 class="box-title text-white"><i class="fa fa-clipboard"></i>
            <?=$this->lang->line('idcardreport_report_for')?> -
            <?=isset($usertypes[$usertypeID]) ? $usertypes[$usertypeID]: ' ';?>
        </h3>
    </div>
    <div id="printablediv" style="background-color: #F1F2F7;border: 2px solid #ccc"> <div class="box-body" style="margin-bottom: 50px;">
            <div class="row">
                <div class="col-sm-12"> <?php /* Removed a nested .row that might cause issues */ ?>
                    <div class="row print-row" style="margin-left:10px"> <?php /* This div is for screen layout primarily */ ?>
                    <?php foreach($idcards as $idcard) {?>
                    <?php /* The <style> block that was here has been MOVED OUTSIDE the loop */ ?>
                    <div class="id-card-holder col-sm-4 print-col" style="margin:5px;"> <div class="id-card">
                            <div class="header" style="background-color: #fff;">
                                <div class="header-spacer"></div>
                                <div class="sc-logo">
                                    <img src='<?=base_url('uploads/images/'.$siteinfos->photo)?>' alt="School Logo"> <?php /* Removed fixed width here, handled by CSS */ ?>
                                </div>
                                <div class="head-info">
                                    <h3><?php echo $siteinfos->sname; ?></h3>
                                    <div class="contact-info">
                                        <h5><i class="fa fa-map-marker"></i> <span><?php echo html_escape($siteinfos->address); ?></span></h5>
                                        <h5><i class="fa fa-phone"></i> <span><?php echo html_escape($siteinfos->phone); ?></span></h5>
                                    </div>
                                </div>
                                <div class="header-spacer"></div>
                            </div>
                            <div class="clear"></div>
                            <span class="b-border"></span>

                            <div class="card-detail">
                                <div class="column-container">
                                    <div class="column1 photo-column">
                                        <div class="stu-photo">
                                            <img class="card-photo" src='<?=imagelink($idcard->srregisterNO.'.png', 'uploads/images')?>' alt="Student Photo">
                                        </div>
                                    </div>
                                    <div class="column2 info-column">
                                        <?php
                                            $nameParts = explode(' ', trim($idcard->srname));
                                            $firstName = isset($nameParts[0]) ? $nameParts[0] : '';
                                            $secondName = isset($nameParts[1]) ? $nameParts[1] : '';
                                        ?>
                                        <h5 class="bold-text"><span><?= strtoupper($firstName) ?></span></h5>
                                        <h5 class="mbc"><span><?= strtoupper($secondName) ?></span></h5>
                                        <h5>ADM</h5>
                                        <h5 class="bold-text mbc"><?=$idcard->srregisterNO?></h5>
                                        <h5>ISSUED</h5>
                                        <h5 class="bold-text"><?=date('Y')?></h5>
                                    </div>
                                    <div class="column3 qr-code-column">
                                        <?php
                                        // Ensure this path correctly generates an accessible image URL for the QR code
                                        $qrCodePath = 'uploads/students/'.$idcard->srstudentID.'/'.$idcard->srregisterNO.'.png';
                                        // Check if file exists before trying to display, or handle missing images gracefully
                                        // For example: $qrImageUrl = file_exists(FCPATH . $qrCodePath) ? base_url($qrCodePath) : base_url('path/to/default/qr.png');
                                        $qrImageUrl = base_url($qrCodePath);
                                        ?>
                                        <img src="<?php echo $qrImageUrl; ?>" alt="QR Code">
                                    </div>
                                </div>
                                <div class="clear"></div>
                            </div>
                            <?php /* Footer can be added here if needed, ensure it's styled for print too */ ?>
                            </div>
                    </div>
                    <?php }?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
// Ensure this function is globally accessible or correctly scoped if your btn_printReport calls it.
// If btn_printReport uses a different function name, adjust this function's name accordingly.
function printDiv(divName) { // Renamed to printDiv if your `btn_printReport` calls `printDiv`
    var printContents = document.getElementById(divName).innerHTML;
    var printWindow = window.open('', '_blank', 'height=750,width=1000'); // Give some dimensions

    printWindow.document.write('<html><head><title>Print ID Cards</title>');

    // Copy all <style> and <link rel="stylesheet"> tags from parent document
    var stylesheets = document.querySelectorAll('style, link[rel="stylesheet"]');
    stylesheets.forEach(function(sheet) {
        printWindow.document.write(sheet.outerHTML);
    });

    // Add a specific class to the body of the print window for print-specific overrides if needed
    printWindow.document.write('</head><body class="print-preview-body">');
    printWindow.document.write(printContents);
    printWindow.document.write('</body></html>');
    printWindow.document.close(); // Necessary for IE >= 10

    printWindow.onload = function() { // Wait for the content to load and styles to apply
        printWindow.focus(); // Required for some browsers
        printWindow.print();
        // Some browsers close the window before print dialog appears fully.
        // A slight delay, or onafterprint, can help.
        // For robustness, you might leave it to the user to close or use:
        // printWindow.onafterprint = function () { printWindow.close(); };
        // setTimeout(function () { printWindow.close(); }, 2000); // Or a longer timeout
    };
}

// If your button `btn_printReport` is actually calling a function named `printDivv`
// make sure this function is named `printDivv` or `btn_printReport` is updated.
// For example, if your button is generated like:
// <a href="javascript:printDiv('printablediv')">Print</a>
// then the function name above `printDiv` is correct.
// If it's <a href="javascript:printDivv('printablediv')">Print</a>
// then function printDivv(divName) { ... }

</script>
<?php } else { ?>
    <div class="box">
       <div class="box-header bg-gray">
           <h3 class="box-title text-navy"><i class="fa fa-clipboard"></i>
               <?=$this->lang->line('idcardreport_report_for')?> -
               <?=isset($usertypes[$usertypeID]) ? $usertypes[$usertypeID]: ' ';?>
           </h3>
       </div><!-- /.box-header -->
       <div id="printabledivv">
           <style>
               .idcardreport {
                   font-family: arial;
                   max-width: 794px;
                   max-height: 1123px;
                   margin-left: auto;
                   margin-right: auto;
                   -webkit-print-color-adjust: exact;
               }

               /*IDcard Front Part Css Code*/
               .idcardreport-frontend {
                   margin: 3px;
                   float: left;
                   border: 1px solid #000;
                   padding: 10px;
                   width: 257px;
                   text-align: center;
                   height: 290px;

                   <?php if($background==1) {
                       ?>background: url("<?=base_url('uploads/default/idcard-border.png')?>") !important;
                       background-size: 100% 100% !important;
                       <?php
                   }

                   ?>
               }

               .idcardreport-frontend h3 {
                   font-size: 20px;
                   color: #1A2229;
               }

               .idcardreport-frontend img {
                   width: 50px;
                   height: 50px;
                   border: 1px solid #ddd;
                   margin-bottom: 5px;
               }

               .idcardreport-frontend p {
                   text-align: left;
                   font-size: 12px;
                   margin-bottom: 0px;
                   color: #1A2229;
               }

               /*ID Card Back Part Css Code*/
               .idcardreport-backend {
                   margin: 3px;
                   /*float: left;*/
                   float: right;
                   border: 1px solid #1A2229;
                   padding: 10px;
                   width: 257px;
                   text-align: center;
                   height: 290px;

                   <?php if($background==1) {
                       ?>background: url("<?=base_url('uploads/default/idcard-border.png')?>") !important;
                       background-size: 100% 100% !important;
                       <?php
                   }

                   ?>
               }

               .idcardreport-backend h3 {
                   background-color: #1A2229;
                   color: #fff;
                   font-size: 13px;
                   padding: 5px 0px;
                   margin: 5px;
                   margin-top: 13px;
               }

               .idcardreport-backend h4 {
                   font-size: 11px;
                   color: #1A2229;
                   font-weight: bold;
                   padding: 5px 0px;
               }

               .idcardreport-backend p {
                   font-size: 17px;
                   color: #1A2229;
                   font-weight: 500;
                   line-height: 17px;
               }

               .idcardreport-schooladdress {
                   color: #1A2229 !important;
                   font-weight: 500;
               }

               .idcardreport-bottom {
                   text-align: center;
                   padding-top: 5px
               }

               .idcardreport-qrcode {
                   float: left;
                   width: 50%;
               }

               .idcardreport-qrcode img {
                   width: 80px;
                   height: 80px;
               }

               .idcardreport-session {
                   float: right;
                   width: 50%;
               }

               .idcardreport-session span {
                   color: #1A2229;
                   font-weight: bold;
                   margin-top: 35px;
                   overflow: hidden;
                   float: left;
               }

               
           </style>

           <div class="box-body" style="margin-bottom: 50px;">
               <div class="row">
                   <div class="col-sm-12">
                       <?php if (customCompute($idcards)) { ?>
                       <table class="idcardreport">
                           <tr>
                               <?php $j= 0; $i=0; $c = customCompute($idcards); foreach($idcards as $idcard) {
                            //TYPE 1 == Front Part
                            //TYPE 2 == Back Part
                            if($type == 1) { ?>
                               <td class="idcardreport-frontend">
                                   <h3><?=$siteinfos->sname?></h3>
                                   <img src="<?=imagelink($idcard->photo)?>" alt="">
                                   <div class="profile-view-dis">
                                       <?php if($usertypeID == 1) { ?>
                                       <div class="profile-view-tab">
                                           <p><span><b><?=$this->lang->line('idcardreport_name')?></b></span>:
                                               <?=$idcard->name?></p>
                                       </div>
                                       <div class="profile-view-tab">
                                           <p><span><b><?=$this->lang->line('idcardreport_dob')?></b> </span>:
                                               <?=date('d M Y',strtotime($idcard->dob))?></p>
                                       </div>
                                       <div class="profile-view-tab">
                                           <p><span><b><?=$this->lang->line('idcardreport_jod')?></b> </span>:
                                               <?=date('d M Y',strtotime($idcard->jod))?></p>
                                       </div>
                                       <div class="profile-view-tab">
                                           <p><span><b><?=$this->lang->line('idcardreport_phone')?></b> </span>:
                                               <?=$idcard->phone?> </p>
                                       </div>
                                       <div class="profile-view-tab">
                                           <p><span><b><?=$this->lang->line('idcardreport_email')?></b> </span>:
                                               <?=$idcard->email?></p>
                                       </div>
                                       <?php } elseif($usertypeID == 2) { ?>
                                       <div class="profile-view-tab">
                                           <p><span><b><?=$this->lang->line('idcardreport_name')?></b> </span>:
                                               <?=$idcard->name?></p>
                                       </div>
                                       <div class="profile-view-tab">
                                           <p><span><b><?=$this->lang->line('idcardreport_designation')?></b> </span>:
                                               <?=$idcard->designation?></p>
                                       </div>
                                       <div class="profile-view-tab">
                                           <p><span><b><?=$this->lang->line('idcardreport_jod')?></b> </span>:
                                               <?=date('d M Y',strtotime($idcard->jod))?></p>
                                       </div>
                                       <div class="profile-view-tab">
                                           <p><span><b><?=$this->lang->line('idcardreport_phone')?></b> </span>:
                                               <?=$idcard->phone?></p>
                                       </div>
                                       <div class="profile-view-tab">
                                           <p><span><b><?=$this->lang->line('idcardreport_email')?></b> </span>:
                                               <?=$idcard->email?></p>
                                       </div>
                                       <?php } elseif($usertypeID == 3) { ?>
                                       <div class="profile-view-tab">
                                           <p><span><b><?=$this->lang->line('idcardreport_name')?></b> </span>:
                                               <?=$idcard->srname?></p>
                                       </div>
                                       <div class="profile-view-tab">
                                           <p><span><b><?=$this->lang->line('idcardreport_registerNO')?></b> </span>:
                                               <?=$idcard->srregisterNO?></p>
                                       </div>
                                       <div class="profile-view-tab">
                                           <p><span><b><?=$this->lang->line('idcardreport_class')?></b> </span>:
                                               <?=isset($classes[$idcard->srclassesID]) ? $classes[$idcard->srclassesID] : ''?>
                                           </p>
                                       </div>
                                       <div class="profile-view-tab">
                                           <p><span><b><?=$this->lang->line('idcardreport_section')?></b> </span>:
                                               <?=isset($sections[$idcard->srsectionID]) ? $sections[$idcard->srsectionID] : ''?>
                                           </p>
                                       </div>
                                       <div class="profile-view-tab">
                                           <p><span><b><?=$this->lang->line('idcardreport_roll')?></b> </span>:
                                               <?=$idcard->srroll?></p>
                                       </div>
                                       <div class="profile-view-tab">
                                           <p><span><b><?=$this->lang->line('idcardreport_blood_group')?></b> </span>:
                                               <?=$idcard->bloodgroup?></p>
                                       </div>
                                       <?php } else { ?>
                                       <div class="profile-view-tab">
                                           <p><span><b><?=$this->lang->line('idcardreport_name')?></b> </span>:
                                               <?=$idcard->name?></p>
                                       </div>
                                       <div class="profile-view-tab">
                                           <p><span><b><?=$this->lang->line('idcardreport_dob')?></b> </span>:
                                               <?=date('d M Y',strtotime($idcard->dob))?></p>
                                       </div>
                                       <div class="profile-view-tab">
                                           <p><span><b><?=$this->lang->line('idcardreport_jod')?></b> </span>:
                                               <?=date('d M Y',strtotime($idcard->jod))?></p>
                                       </div>
                                       <div class="profile-view-tab">
                                           <p><span><b><?=$this->lang->line('idcardreport_phone')?></b> </span>:
                                               <?=$idcard->phone?> </p>
                                       </div>
                                       <div class="profile-view-tab">
                                           <p><span><b><?=$this->lang->line('idcardreport_email')?></b> </span>:
                                               <?=$idcard->email?></p>
                                       </div>
                                       <?php } ?>
                                   </div>
                               </td>
                               <?php 
                                $i++; 
                                if($i==3) {
                                    $j++;
                                    $k = $c/3;
                                    $k = ceil($k);
                                    if($k == $j) {
                                        echo "";
                                    } else {
                                        echo "</tr><tr>";
                                    }
                                    $i=0;
                                }
                            } else { $i++;?>
                               <?php 
                                    if($usertypeID == 1) {
                                        $filename = $idcard->usertypeID.'-'.$idcard->systemadminID;
                                        $text = $this->lang->line('idcardreport_type')." : ".'1'.',';
                                        $text.= $this->lang->line('idcardreport_id')." : ".$idcard->systemadminID;
                                    } elseif($usertypeID == 2) {
                                        $filename = $idcard->usertypeID.'-'.$idcard->teacherID;
                                        $text = $this->lang->line('idcardreport_type')." : ".'2'.',';
                                        $text.= $this->lang->line('idcardreport_id')." : ".$idcard->teacherID;
                                    } elseif($usertypeID == 3) {
                                        $filename = $idcard->usertypeID.'-'.$idcard->studentID;
                                        $text = $this->lang->line('idcardreport_type')." : ".'3'.',';
                                        $text.= $this->lang->line('idcardreport_id')." : ".$idcard->srstudentID;
                                    } elseif($usertypeID == 4) {
                                        $filename = $idcard->usertypeID.'-'.$idcard->parentsID;
                                        $text = "invalid";
                                    } else {
                                        $filename = $idcard->usertypeID.'-'.$idcard->userID;
                                        $text = $this->lang->line('idcardreport_type')." : ".$idcard->usertypeID.',';
                                        $text.= $this->lang->line('idcardreport_id')." : ".$idcard->userID;
                                    }

                                    $filepath = FCPATH.'uploads/idQRcode/'.$filename.'.png';
                                    if(!file_exists($filepath)) {
                                        generate_qrcode($text,$filename);
                                    }
                                ?>
                               <td class="idcardreport-backend">
                                   <h3><?=$this->lang->line('idcardreport_valid_up')?>
                                       <?=date('F Y',strtotime($schoolyear->endingdate))?></h3>
                                   <h4><?=$this->lang->line('idcardreport_please_return')?> : </h4>
                                   <p><?=$siteinfos->sname?></p>
                                   <div class="idcardreport-schooladdress">
                                       <?=$siteinfos->address?>
                                   </div>
                                   <div class="idcardreport-bottom">
                                       <div class="idcardreport-qrcode">
                                           <img src="<?=base_url('uploads/idQRcode/'.$filename.'.png')?>" alt="">
                                       </div>
                                       <div class="idcardreport-session">
                                           <span><?=$this->lang->line('idcardreport_session')?> :
                                               <?=$schoolyear->schoolyear?></span>
                                       </div>
                                   </div>
                               </td>
                               <?php } } ?>
                           </tr>
                       </table>
                       <?php } else { ?>
                       <div class="callout callout-danger">
                           <p><b class="text-info"><?=$this->lang->line('idcardreport_data_not_found')?></b></p>
                       </div>
                       <?php } ?>
                   </div>
               </div><!-- row -->
           </div><!-- Body -->
       </div>
   </div>
<?php } ?> 
<!-- email modal starts here -->
<form class="form-horizontal" role="form" action="<?=base_url('idcardreport/send_pdf_to_mail');?>" method="post">
    <div class="modal fade" id="mail">
      <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only"><?=$this->lang->line('idcardreport_close')?></span></button>
                <h4 class="modal-title"><?=$this->lang->line('idcardreport_mail')?></h4>
            </div>
            <div class="modal-body">

                <?php
                    if(form_error('to'))
                        echo "<div class='form-group has-error' >";
                    else
                        echo "<div class='form-group' >";
                ?>
                    <label for="to" class="col-sm-2 control-label">
                        <?=$this->lang->line("idcardreport_to")?> <span class="text-red">*</span>
                    </label>
                    <div class="col-sm-6">
                        <input type="email" class="form-control" id="to" name="to" value="<?=set_value('to')?>" >
                    </div>
                    <span class="col-sm-4 control-label" id="to_error">
                    </span>
                </div>

                <?php
                    if(form_error('subject'))
                        echo "<div class='form-group has-error' >";
                    else
                        echo "<div class='form-group' >";
                ?>
                    <label for="subject" class="col-sm-2 control-label">
                        <?=$this->lang->line("idcardreport_subject")?> <span class="text-red">*</span>
                    </label>
                    <div class="col-sm-6">
                        <input type="text" class="form-control" id="subject" name="subject" value="<?=set_value('subject')?>" >
                    </div>
                    <span class="col-sm-4 control-label" id="subject_error">
                    </span>

                </div>

                <?php
                    if(form_error('message'))
                        echo "<div class='form-group has-error' >";
                    else
                        echo "<div class='form-group' >";
                ?>
                    <label for="message" class="col-sm-2 control-label">
                        <?=$this->lang->line("idcardreport_message")?>
                    </label>
                    <div class="col-sm-6">
                        <textarea class="form-control" id="message" style="resize: vertical;" name="message" value="<?=set_value('message')?>" ></textarea>
                    </div>
                </div>


            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" style="margin-bottom:0px;" data-dismiss="modal"><?=$this->lang->line('close')?></button>
                <input type="button" id="send_pdf" class="btn btn-success" value="<?=$this->lang->line("idcardreport_send")?>" />
            </div>
        </div>
      </div>
    </div>
</form>
<!-- email end here -->

<script type="text/javascript">
    
    function check_email(email) {
        var status = false;
        var emailRegEx = /^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,4}$/i;
        if (email.search(emailRegEx) == -1) {
            $("#to_error").html('');
            $("#to_error").html("<?=$this->lang->line('idcardreport_mail_valid')?>").css("text-align", "left").css("color", 'red');
        } else {
            status = true;
        }
        return status;
    }


    $('#send_pdf').click(function() {
        var field = {
            'to'         : $('#to').val(), 
            'subject'    : $('#subject').val(), 
            'message'    : $('#message').val(),
            'usertypeID' : '<?=$usertypeID?>',
            'classesID'  : '<?=$classesID?>',
            'sectionID'  : '<?=$sectionID?>',
            'userID'     : '<?=$userID?>',
            'type'       : '<?=$type?>',
            'background' : '<?=$background?>',
        };

        var to = $('#to').val();
        var subject = $('#subject').val();
        var error = 0;

        $("#to_error").html("");
        $("#subject_error").html("");

        if(to == "" || to == null) {
            error++;
            $("#to_error").html("<?=$this->lang->line('idcardreport_mail_to')?>").css("text-align", "left").css("color", 'red');
        } else {
            if(check_email(to) == false) {
                error++
            }
        }

        if(subject == "" || subject == null) {
            error++;
            $("#subject_error").html("<?=$this->lang->line('idcardreport_mail_subject')?>").css("text-align", "left").css("color", 'red');
        } else {
            $("#subject_error").html("");
        }

        if(error == 0) {
            $('#send_pdf').attr('disabled','disabled');
            $.ajax({
                type: 'POST',
                url: "<?=base_url('idcardreport/send_pdf_to_mail')?>",
                data: field,
                dataType: "html",
                success: function(data) {
                    var response = JSON.parse(data);
                    if (response.status == false) {
                        $('#send_pdf').removeAttr('disabled');
                        if( response.to) {
                            $("#to_error").html("<?=$this->lang->line('idcardreport_mail_to')?>").css("text-align", "left").css("color", 'red');
                        } 
                        if( response.subject) {
                            $("#subject_error").html("<?=$this->lang->line('idcardreport_mail_subject')?>").css("text-align", "left").css("color", 'red');
                        }
                        if(response.message) {
                            toastr["error"](response.message)
                            toastr.options = {
                              "closeButton": true,
                              "debug": false,
                              "newestOnTop": false,
                              "progressBar": false,
                              "positionClass": "toast-top-right",
                              "preventDuplicates": false,
                              "onclick": null,
                              "showDuration": "500",
                              "hideDuration": "500",
                              "timeOut": "5000",
                              "extendedTimeOut": "1000",
                              "showEasing": "swing",
                              "hideEasing": "linear",
                              "showMethod": "fadeIn",
                              "hideMethod": "fadeOut"
                            }
                        }
                    } else {
                        location.reload();
                    }
                }
            });
        }
    });
</script>