<style>
.clear { clear: both; }
p { font-size: 9pt; margin: 1.5pt; color: #000; font-weight: bold; }
.id-card-holder { width: 450px; margin: 0 auto; font-family: "Nunito", sans-serif; }
.id-card { background-color: #fff; padding: 0px; text-align: center; box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05); display: block; border-radius: 0.5rem; overflow: hidden; }
.id { display: inline-block; float: left; font-size: 11.25pt; text-transform: uppercase; color: #fff; text-align: center; margin-left: 15pt; margin-top: 7.5pt; }
.header { background-color: #fff; border-bottom: 1.5pt solid #6FAC45; padding: 7.5pt 0; display: flex; align-items: center; justify-content: center; }
.header-spacer { flex-grow: 1; }
.sc-logo { width: 50px; height: 50px; display: flex; align-items: center; justify-content: center; flex-shrink: 0; margin-right: 26.25pt; }
.sc-logo img { max-width: 100%; max-height: 100%; object-fit: contain; }
.head-info { flex-grow: 1; text-align: center; color: #006341; }
.head-info h3 { font-size: 14pt; margin: 0 0 2.25pt 0; color: #000; text-transform: uppercase; font-weight: 700; }
.contact-info { display: flex; justify-content: center; align-items: center; flex-wrap: wrap; margin-top: 3.75pt; }
.contact-info h5 { font-size: 7.5pt; margin: 0 6pt; color: #555; font-weight: normal; display: flex; align-items: center; white-space: nowrap; }
.contact-info h5 i { margin-right: 3.75pt; color: #333; font-size: 8.25pt; }
.b-border { width: 100%; height: 4.5pt; display: block; background-color: #202020; margin-top: 0.75pt; }
.card-detail { width: 100%; display: flex; padding: 7.5pt; box-sizing: border-box; margin-top: 7.5pt; margin-bottom: 22.5pt; align-items: flex-start; }
.stu-photo { width: 100px; height: 140px; border-radius: 5px; box-sizing: border-box; flex-shrink: 0; display: flex; align-items: center; justify-content: center; overflow: hidden; margin-right: 11.25pt; }
.card-photo { height: 140px; width: 100px; object-fit: cover; object-position: center; display: block; border-radius: 4px; }
.stu-info { flex-grow: 1; padding: 0; box-sizing: border-box; text-align: left; text-transform: capitalize; }
.session { font-size: 9.75pt; font-weight: 600; margin: 0 0 5.25pt; }
.stu-info h3 { font-size: 11.25pt; font-weight: 700; margin: 0 0 6pt 0; color: #4a0a2cfc; }
.stu-info p { font-size: 8.25pt; margin: 0 0 2.25pt 0; font-weight: 300; line-height: 12.75pt; }
.stu-info p span { font-weight: 600; text-transform: uppercase; }
footer { padding: 3.75pt 0; border-top: 0.75pt solid #6FAC45; }
footer p { font-size: 5.25pt; margin: 0 0 1.5pt 0; }
.center { display: flex; align-items: center; justify-content: center; text-align: center; }
.background-image { background-size: 130px 130px; background-position: right bottom; background-repeat: no-repeat; }
.column-container { display: flex; flex-direction: row; width:100%;}
.column1 { width: 30%; padding: 0 3.75pt; }
.column2 { width: 30%; padding: 0 3.75pt; }
.column3 { width: 40%; padding: 0 3.75pt; }
.qr-code-column { text-align: center; }
.qr-code-column img { width: 135pt; height: auto; }
.photo-column .stu-photo { width: 100%; margin: 0 auto; }
.info-column { font-size: 11.25pt; text-align: left; color: #000; text-transform: capitalize; }
.bold-text { font-size: 13.5pt; font-weight: 700; color: #000; text-transform: capitalize; }
.mbc { margin-bottom: 6pt; }

@media print {
@page {
    margin: 0.1in;
    size: auto;
}
body {
    margin: 0;
    font-family: "Nunito", sans-serif;
    color: #000;
    background-color: #fff !important;
    font-size: 8pt;
    -webkit-print-color-adjust: exact;
    print-color-adjust: exact;
}
.no-print { display: none !important; }
#printablediv { background-color: #fff !important; border: none !important; }
.box-body { margin-bottom: 0 !important; }
.print-row { margin-left: 0 !important; }
.col-sm-4 { width: 100% !important; float: none !important; margin: 0 !important; padding: 0 !important; }
.print-col { margin:0 !important; }
.id-card-holder {
    width: 3.375in !important;
    height: 2.125in !important;
    margin: 0 !important;
    padding: 0 !important;
    page-break-after: always !important;
    box-sizing: border-box !important;
    border: none !important;
    box-shadow: none !important;
    background-color: #fff !important;
    overflow: hidden !important;
    position: relative;
    float: none !important;
    display: block !important;
}
.id-card {
    width: 100% !important;
    height: 100% !important;
    padding: 0 !important;
    border-radius: 0 !important;
    box-shadow: none !important;
    display: flex;
    flex-direction: column;
    justify-content: flex-start;
}
.id { font-size: 8pt; margin-left: 10pt; margin-top: 5pt; }
.header { padding: 2pt 0; border-bottom: 0.5pt solid #6FAC45; flex-shrink: 0; }
.sc-logo { width: 25pt; height: 25pt; margin-right: 10pt; }
.head-info h3 { font-size: 9pt; margin-bottom: 1.5pt; }
.contact-info { margin-top: 1.5pt; }
.contact-info h5 { font-size: 6pt; margin: 0 3pt; }
.contact-info h5 i { font-size: 6.5pt; margin-right: 2pt; }
.b-border { height: 2pt; margin-top: 0.5pt; flex-shrink: 0;}
.card-detail {
    padding: 3pt !important;
    margin-top: 3pt !important;
    margin-bottom: 0 !important;
    display: flex !important;
    flex-direction: row !important;
    align-items: flex-start !important;
    flex-grow: 1;
    width: 100% !important;
    box-sizing: border-box !important;
}
.column-container {
    display: flex !important;
    flex-direction: row !important;
    width: 100% !important;
    height: 100% !important;
    align-items: stretch;
}
.column1, .column2, .column3 {
    padding: 0 2pt !important;
    box-sizing: border-box !important;
    display: flex;
    flex-direction: column;
    justify-content: center;
}
.column1 { width: 28% !important; }
.column2 { width: 37% !important; }
.column3 { width: 35% !important; }
.photo-column .stu-photo {
    width: 55pt !important;
    height: 70pt !important;
    margin: 0 auto !important;
    border-radius: 0 !important;
    overflow: hidden;
}
.card-photo {
    width: 100% !important;
    height: 100% !important;
    object-fit: cover !important;
    object-position: center !important;
    border-radius: 0 !important;
}
.info-column {
    font-size: 7pt !important;
    text-align: left;
}
.info-column h5 {
    margin: 1pt 0 !important;
    line-height: 1.2;
}
.bold-text {
    font-size: 8pt !important;
    font-weight: 700 !important;
}
.mbc {
    margin-bottom: 3pt !important;
}
.qr-code-column img {
    width: 50pt !important;
    height: 50pt !important;
    margin: auto;
}
footer { padding: 1pt 0; border-top: 0.5pt solid #6FAC45; flex-shrink: 0; }
footer p { font-size: 4.5pt; margin: 0; }
.id-card { page-break-inside: avoid !important; }
}
</style>

<div class="row print-row" style="margin-left:10px">
<?php if (!empty($idcards)) { foreach($idcards as $idcard) { ?>
    <div class="id-card-holder col-sm-4 print-col" style="margin:5px;">
        <div class="id-card">
            <div class="header" style="background-color: #fff;">
                <div class="header-spacer"></div>
                <div class="sc-logo">
                    <img src='<?=base_url('uploads/images/'.$siteinfos->photo)?>' alt="School Logo">
                </div>
                <div class="head-info">
                    <h3><?php echo $siteinfos->sname; ?></h3>
                    <div class="contact-info">
                        <h5><i class="fa fa-map-marker"></i> <span><?php echo html_escape($siteinfos->address); ?></span></h5>
                        <h5><i class="fa fa-phone"></i> <span><?php echo html_escape($siteinfos->phone); ?></span></h5>
                    </div>
                </div>
                <div class="header-spacer"></div>
            </div>
            <div class="clear"></div>
            <span class="b-border"></span>
            <div class="card-detail">
                <div class="column-container">
                    <div class="column1 photo-column">
                        <div class="stu-photo">
                            <img class="card-photo" src='<?=imagelink($idcard->srregisterNO.".png", "uploads/images")?>' alt="Student Photo">
                        </div>
                    </div>
                    <div class="column2 info-column">
                        <?php
                            $nameParts = explode(' ', trim($idcard->srname));
                            $firstName = isset($nameParts[0]) ? $nameParts[0] : '';
                            $secondName = isset($nameParts[1]) ? $nameParts[1] : '';
                        ?>
                        <h5 class="bold-text"><span><?= strtoupper($firstName) ?></span></h5>
                        <h5 class="mbc"><span><?= strtoupper($secondName) ?></span></h5>
                        <h5>ADM</h5>
                        <h5 class="bold-text mbc"><?=$idcard->srregisterNO?></h5>
                        <h5>ISSUED</h5>
                        <h5 class="bold-text"><?=date('Y')?></h5>
                    </div>
                    <div class="column3 qr-code-column">
                        <?php
                        $qrCodePath = 'uploads/students/'.$idcard->srstudentID.'/'.$idcard->srregisterNO.'.png';
                        $qrImageUrl = base_url($qrCodePath);
                        ?>
                        <img src="<?php echo $qrImageUrl; ?>" alt="QR Code">
                    </div>
                </div>
                <div class="clear"></div>
            </div>
        </div>
    </div>
<?php } } else { ?>
    <div class="col-sm-12">
        <div class="callout callout-danger">
            <p><b class="text-info"><?= isset($this->lang) ? $this->lang->line('idcardreport_data_not_found') : "No data found" ?></b></p>
        </div>
    </div>
<?php } ?>
</div>