<?php
// Place this file in your view directory and use it for your ID card print/PDF export page.
// Variables needed: $idcards (array), $siteinfos (object), etc.
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>ID Cards Print/PDF</title>
    <style>
        /* ----------- Screen Styles ----------- */
        body {
            background: #f1f2f7;
            font-family: "Nunito", sans-serif;
            margin: 0;
            padding: 0;
        }
        .clear { clear: both; }
        .id-card-holder {
            width: 450px;
            margin: 0 auto 20px auto;
            font-family: "Nunito", sans-serif;
        }
        .id-card {
            background-color: #fff;
            padding: 0px;
            text-align: center;
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
            display: block;
            border-radius: 0.5rem;
            overflow: hidden;
        }
        .header { background-color: #fff; border-bottom: 1.5pt solid #6FAC45; padding: 7.5pt 0; display: flex; align-items: center; justify-content: center; }
        .header-spacer { flex-grow: 1; }
        .sc-logo { width: 50px; height: 50px; display: flex; align-items: center; justify-content: center; flex-shrink: 0; margin-right: 26.25pt; }
        .sc-logo img { max-width: 100%; max-height: 100%; object-fit: contain; }
        .head-info { flex-grow: 1; text-align: center; color: #006341; }
        .head-info h3 { font-size: 14pt; margin: 0 0 2.25pt 0; color: #000; text-transform: uppercase; font-weight: 700; }
        .contact-info { display: flex; justify-content: center; align-items: center; flex-wrap: wrap; margin-top: 3.75pt; }
        .contact-info h5 { font-size: 7.5pt; margin: 0 6pt; color: #555; font-weight: normal; display: flex; align-items: center; white-space: nowrap; }
        .contact-info h5 i { margin-right: 3.75pt; color: #333; font-size: 8.25pt; }
        .b-border { width: 100%; height: 4.5pt; display: block; background-color: #202020; margin-top: 0.75pt; }
        .card-detail { width: 100%; display: flex; padding: 7.5pt; box-sizing: border-box; margin-top: 7.5pt; margin-bottom: 15pt; align-items: flex-start; }
        .column-container { display: flex; flex-direction: row; width:100%; }
        .column1 { width: 30%; padding: 0 3.75pt; }
        .column2 { width: 30%; padding: 0 3.75pt; }
        .column3 { width: 40%; padding: 0 3.75pt; }
        .qr-code-column { text-align: center; }
        .qr-code-column img { width: 135pt; height: auto; }
        .photo-column .stu-photo { width: 100%; margin: 0 auto; }
        .stu-photo { width: 100px; height: 140px; border-radius: 5px; box-sizing: border-box; flex-shrink: 0; display: flex; align-items: center; justify-content: center; overflow: hidden; margin-right: 11.25pt; }
        .card-photo { height: 140px; width: 100px; object-fit: cover; object-position: center; display: block; border-radius: 4px; }
        .info-column { font-size: 11.25pt; text-align: left; color: #000; text-transform: capitalize; }
        .bold-text { font-size: 13.5pt; font-weight: 700; color: #000; text-transform: capitalize; }
        .mbc { margin-bottom: 6pt; }
        .no-print { display: block; }
        /* ---------- Print Styles ----------- */
        @media print {
            @page {
                size: 3.375in 2.125in;
                margin: 0;
            }
            body {
                background: #fff !important;
                margin: 0;
                font-size: 8pt;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            .no-print { display: none !important; }
            .id-card-holder {
                width: 3.375in !important;
                height: 2.125in !important;
                margin: 0 !important;
                padding: 0 !important;
                page-break-after: always !important;
                box-sizing: border-box !important;
                border: none !important;
                box-shadow: none !important;
                background-color: #fff !important;
                overflow: hidden !important;
                position: relative;
                float: none !important;
                display: block !important;
            }
            .id-card {
                width: 100% !important;
                height: 100% !important;
                padding: 0 !important;
                border-radius: 0 !important;
                box-shadow: none !important;
                display: flex;
                flex-direction: column;
                justify-content: flex-start;
            }
            .header { padding: 2pt 0; border-bottom: 0.5pt solid #6FAC45; flex-shrink: 0; }
            .sc-logo { width: 25pt; height: 25pt; margin-right: 10pt; }
            .head-info h3 { font-size: 9pt; margin-bottom: 1.5pt; }
            .contact-info { margin-top: 1.5pt; }
            .contact-info h5 { font-size: 6pt; margin: 0 3pt; }
            .contact-info h5 i { font-size: 6.5pt; margin-right: 2pt; }
            .b-border { height: 2pt; margin-top: 0.5pt; flex-shrink: 0;}
            .card-detail {
                padding: 3pt !important;
                margin-top: 3pt !important;
                margin-bottom: 0 !important;
                display: flex !important;
                flex-direction: row !important;
                align-items: flex-start !important;
                flex-grow: 1;
                width: 100% !important;
                box-sizing: border-box !important;
            }
            .column-container {
                display: flex !important;
                flex-direction: row !important;
                width: 100% !important;
                height: 100% !important;
                align-items: stretch;
            }
            .column1, .column2, .column3 {
                padding: 0 2pt !important;
                box-sizing: border-box !important;
                display: flex;
                flex-direction: column;
                justify-content: center;
            }
            .column1 { width: 28% !important; }
            .column2 { width: 37% !important; }
            .column3 { width: 35% !important; }
            .photo-column .stu-photo {
                width: 55pt !important;
                height: 70pt !important;
                margin: 0 auto !important;
                border-radius: 0 !important;
                overflow: hidden;
            }
            .card-photo {
                width: 100% !important;
                height: 100% !important;
                object-fit: cover !important;
                object-position: center !important;
                border-radius: 0 !important;
            }
            .info-column {
                font-size: 7pt !important;
                text-align: left;
            }
            .info-column h5 {
                margin: 1pt 0 !important;
                line-height: 1.2;
            }
            .bold-text {
                font-size: 8pt !important;
                font-weight: 700 !important;
            }
            .mbc {
                margin-bottom: 3pt !important;
            }
            .qr-code-column img {
                width: 135pt !important;
                height: auto !important;
                margin: auto;
            }
            
            .b-border {
                width: 100%;
                height: 4.5pt;
                display: block;
                background-color: #202020;
                margin-top: 0.75pt;
              }
        }
    </style>
</head>
<body>
    <div class="no-print" style="margin:20px 0; text-align:center;">
        <button onclick="printDiv('printablediv')" style="padding:10px 20px; font-size:16px;">Print / Save as PDF</button>
        <p style="color: #666; font-size:12px; margin-top:8px;">Tip: In the print dialog, set Paper Size to <b>Custom</b> (3.375in × 2.125in), Margins to <b>None</b>, and "Background graphics" ON for best results.</p>
    </div>
    <div id="printablediv">
        <?php foreach($idcards as $idcard) { ?>
        <div class="id-card-holder">
            <div class="id-card">
                <div class="header">
                    <div class="header-spacer"></div>
                    <div class="sc-logo">
                        <img src="<?=base_url('uploads/images/'.$siteinfos->photo)?>" alt="School Logo">
                    </div>
                    <div class="head-info">
                        <h3><?=htmlspecialchars($siteinfos->sname)?></h3>
                        <div class="contact-info">
                            <h5><i class="fa fa-map-marker"></i> <span><?=htmlspecialchars($siteinfos->address)?></span></h5>
                            <h5><i class="fa fa-phone"></i> <span><?=htmlspecialchars($siteinfos->phone)?></span></h5>
                        </div>
                    </div>
                    <div class="header-spacer"></div>
                </div>
                <div class="clear"></div>
                <span class="b-border"></span>
                <div class="card-detail">
                    <div class="column-container">
                        <div class="column1 photo-column">
                            <div class="stu-photo">
                                <img class="card-photo"
                                     src="<?=imagelink($idcard->srregisterNO.'.png', 'uploads/images')?>"
                                     alt="Student Photo">
                            </div>
                        </div>
                        <div class="column2 info-column">
                            <?php
                                $nameParts = explode(' ', trim($idcard->srname));
                                $firstName = isset($nameParts[0]) ? $nameParts[0] : '';
                                $secondName = isset($nameParts[1]) ? $nameParts[1] : '';
                            ?>
                            <h5 class="bold-text"><span><?=strtoupper($firstName)?></span></h5>
                            <h5 class="mbc"><span><?=strtoupper($secondName)?></span></h5>
                            <h5>ADM</h5>
                            <h5 class="bold-text mbc"><?=htmlspecialchars($idcard->srregisterNO)?></h5>
                            <h5>ISSUED</h5>
                            <h5 class="bold-text"><?=date('Y')?></h5>
                        </div>
                        <div class="column3 qr-code-column">
                            <?php
                                $qrCodePath = 'uploads/students/'.$idcard->srstudentID.'/'.$idcard->srregisterNO.'.png';
                                $qrImageUrl = base_url($qrCodePath);
                            ?>
                            <img src="<?=$qrImageUrl?>" alt="QR Code">
                        </div>
                    </div>
                    <div class="clear"></div>
                </div>
            </div>
        </div>
        <?php } ?>
    </div>
    <script type="text/javascript">
    function printDiv(divName) {
        var printContents = document.getElementById(divName).innerHTML;
        var printWindow = window.open('', '_blank', 'height=750,width=1000');
        printWindow.document.write('<html><head><title>Print ID Cards</title>');
        // Copy all style/link tags from parent
        var stylesheets = document.querySelectorAll('style, link[rel="stylesheet"]');
        stylesheets.forEach(function(sheet) {
            printWindow.document.write(sheet.outerHTML);
        });
        printWindow.document.write('</head><body>');
        printWindow.document.write(printContents);
        printWindow.document.write('</body></html>');
        printWindow.document.close();
        printWindow.onload = function() {
            printWindow.focus();
            printWindow.print();
        };
    }
    </script>
</body>
</html>