<?php
// Place this file in your view directory and use it for your ID card print/PDF export page.
// Variables needed: $idcards (array), $siteinfos (object), etc.
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>SKOOLY ID CARD</title>
    <style>
        /* ----------- Screen Styles (Reduced by ~25%) ----------- */
        body {
            background: #f1f2f7;
            font-family: "Nunito", sans-serif;
            margin: 0;
            padding: 0;
            font-size: 7.5pt; /* Reduced from approx 10pt */
        }
        .clear { clear: both; }
        .id-card-holder {
            width: 338px; /* was 450px */
            margin: 0 auto 15px auto;
            font-family: "Nunito", sans-serif;
        }
        .id-card {
            background-color: #fff;
            padding: 0px;
            text-align: center;
            box-shadow: 0 7.5px 11px -2.2px rgba(0, 0, 0, 0.1), 0 2.8px 4.2px -1.8px rgba(0, 0, 0, 0.05);
            display: block;
            border-radius: 0.375rem;
            overflow: hidden;
        }
        .header {
            background-color: #fff;
            border-bottom: 3pt solid #202020;
            padding: 5.6pt 0;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .header-spacer { flex-grow: 1; }
        .sc-logo { width: 37.5px; height: 37.5px; display: flex; align-items: center; justify-content: center; flex-shrink: 0; margin-right: 19.6pt; }
        .sc-logo img { max-width: 100%; max-height: 100%; object-fit: contain; }
        .head-info { flex-grow: 1; text-align: center; color: #006341; }
        .head-info h3 { font-size: 10.5pt; margin: 0 0 1.7pt 0; color: #000; text-transform: uppercase; font-weight: 700; }
        .contact-info { display: flex; justify-content: center; align-items: center; flex-wrap: wrap; margin-top: 2.8pt; }
        .contact-info h5 { font-size: 5.6pt; margin: 0 4.5pt; color: #555; font-weight: normal; display: flex; align-items: center; white-space: nowrap; }
        .contact-info h5 i { margin-right: 2.8pt; color: #333; font-size: 5.8pt; }
/*        .b-border { width: 100%; height: 3.3pt; display: block; background-color: #202020; margin-top: 0.5pt; } */
        .card-detail { width: 100%; display: flex; padding: 5.6pt; box-sizing: border-box; margin-top: 5.6pt; margin-bottom: 11.2pt; align-items: flex-start; }
        .column-container { display: flex; flex-direction: row; width:100%; }
        .column1 { width: 30%; padding: 0 2.8pt; }
        .column2 { width: 30%; padding: 0 2.8pt; }
        .column3 { width: 40%; padding: 0 2.8pt; }
        .qr-code-column { text-align: center; }
        .qr-code-column img { width: 101pt; height: auto; }
        .photo-column .stu-photo { width: 100%; margin: 0 auto; }
        .stu-photo { width: 75px; height: 105px; border-radius: 3.75px; box-sizing: border-box; flex-shrink: 0; display: flex; align-items: center; justify-content: center; overflow: hidden; margin-right: 8.4pt; }
        .card-photo { height: 105px; width: 75px; object-fit: cover; object-position: center; display: block; border-radius: 3px; }
        .info-column { font-size: 8.4pt; text-align: left; color: #000; text-transform: capitalize; }
        .bold-text { font-size: 10pt; font-weight: 700; color: #000; text-transform: capitalize; }
        .mbc { margin-bottom: 4.5pt; }
        .no-print { display: block; }

        /* ---------- Minimal Print Styles ----------- */
        @media print {
            @page {
                size: 3.375in 2.125in;
                margin: 0;
            }
            .id-card-holder {
                width: 3.375in !important;
                height: 2.125in !important;
                margin: 0 !important;
                padding: 0 !important;
                page-break-after: always !important;
                box-sizing: border-box !important;
                border: none !important;
                box-shadow: none !important;
                background-color: #fff !important;
                overflow: hidden !important;
                position: relative;
                float: none !important;
                display: block !important;
            }
            .no-print { display: none !important; }
            
            .info-column h5:not(.bold-text) {
                font-size: 10pt !important;
                font-weight: 400 !important;
            }
         }
    </style>
</head>
<body>
    <div class="no-print" style="margin:15px 0; text-align:center;">
        <button onclick="printDiv('printablediv')" style="padding:7px 15px; font-size:12px;">Print / Save as PDF</button>
        <p style="color: #666; font-size:9px; margin-top:6px;">Tip: In the print dialog, set Paper Size to <b>Custom</b> (3.375in × 2.125in), Margins to <b>None</b>, and "Background graphics" ON for best results.</p>
    </div>
    <div id="printablediv">
        <?php foreach($idcards as $idcard) { ?>
        <div class="id-card-holder">
            <div class="id-card">
                <div class="header">
                    <div class="header-spacer"></div>
                    <div class="sc-logo">
                        <img src="<?=base_url('uploads/images/'.$siteinfos->photo)?>" alt="School Logo">
                    </div>
                    <div class="head-info">
                        <h3><?=htmlspecialchars($siteinfos->sname)?></h3>
                        <div class="contact-info">
                            <h5><i class="fa fa-map-marker"></i> <span><?=htmlspecialchars($siteinfos->address)?></span></h5>
                            <h5><i class="fa fa-phone"></i> <span><?=htmlspecialchars($siteinfos->phone)?></span></h5>
                        </div>
                    </div>
                    <div class="header-spacer"></div>
                </div>
                <div class="clear"></div>
                <span class="b-border"></span>
                <div class="card-detail">
                    <div class="column-container">
                        <div class="column1 photo-column">
                            <div class="stu-photo">
                                <img class="card-photo"
                                     src="<?=imagelink($idcard->srregisterNO.'.png', 'uploads/images')?>"
                                     alt="Student Photo">
                            </div>
                        </div>
                        <div class="column2 info-column">
                            <?php
                                $nameParts = explode(' ', trim($idcard->srname));
                                $firstName = isset($nameParts[0]) ? $nameParts[0] : '';
                                $secondName = isset($nameParts[1]) ? $nameParts[1] : '';
                            ?>
                            <!-- Second name as large/bold, first name as normal, as per your request -->
                            <h5 class="bold-text mbc"><?=strtoupper($secondName)?></h5>
                            <h5><?=strtoupper($firstName)?></h5>
                            
                            <h5>ADM</h5>
                            <h5 class="bold-text mbc"><?=htmlspecialchars($idcard->srregisterNO)?></h5>
                            <h5>ISSUED</h5>
                            <h5 class="bold-text"><?=date('Y')?></h5>
                        </div>
                        <div class="column3 qr-code-column">
                            <?php
                                $qrCodePath = 'uploads/students/'.$idcard->srstudentID.'/'.$idcard->srregisterNO.'.png';
                                $qrImageUrl = base_url($qrCodePath);
                            ?>
                            <img src="<?=$qrImageUrl?>" alt="QR Code">
                        </div>
                    </div>
                    <div class="clear"></div>
                </div>
            </div>
        </div>
        <?php } ?>
    </div>
    <script type="text/javascript">
    function printDiv(divName) {
        var printContents = document.getElementById(divName).innerHTML;
        var printWindow = window.open('', '_blank', 'height=750,width=1000');
        printWindow.document.write('<html><head><title>Print ID Cards</title>');
        // Copy all style/link tags from parent
        var stylesheets = document.querySelectorAll('style, link[rel="stylesheet"]');
        stylesheets.forEach(function(sheet) {
            printWindow.document.write(sheet.outerHTML);
        });
        printWindow.document.write('</head><body>');
        printWindow.document.write(printContents);
        printWindow.document.write('</body></html>');
        printWindow.document.close();
        printWindow.onload = function() {
            printWindow.focus();
            printWindow.print();
        };
    }
    </script>
</body>
</html>