<div class="box">
    <div class="box-header">
        <h3 class="box-title"><i class="fa icon-attendance"></i> <?= $this->lang->line('panel_title') ?></h3>

        <ol class="breadcrumb">
            <li><a href="<?= base_url("dashboard/index") ?>"><i class="fa fa-laptop"></i> <?= $this->lang->line('menu_dashboard') ?></a></li>
            <li class="active"> <?= $this->lang->line('attendancereport_report_for') ?> <?= $this->lang->line('menu_student') ?> <?= $this->lang->line('attendancereport_attendance') ?></li>
        </ol>
    </div>

    <div class="box-body">
        <div class="row">
            <div class="col-sm-12">
                <form method="GET" id="filter_attendance">
                    <div class="form-group col-sm-3" id="classesDiv">
                        <label><?= $this->lang->line("attendancereport_class") ?></label>
                        <?php
                        $array = array("" => $this->lang->line("attendancereport_please_select"));
                        if (customCompute($classes)) {
                            foreach ($classes as $classa) {
                                $array[$classa->classesID] = $classa->classes;
                            }
                        }
                        echo form_dropdown("classesID", $array,($this->input->get('classesID')? $this->input->get('classesID') : ""), "id='classesID' class='form-control select2'");
                        ?>
                    </div>

                    <div class="form-group col-sm-3" id="sectionDiv">
                        <label><?= $this->lang->line("attendancereport_section") ?></label>
                        <select id="sectionID" name="sectionID" class="form-control select2">
                            <option value=""><?php echo $this->lang->line("attendancereport_please_select"); ?></option>
                        </select>
                    </div>

                    <div class="form-group col-sm-3" id="dateDiv">
                        <label><?= $this->lang->line("attendancereport_start_date") ?><span class="text-red"> * </span></label>
                        <input class="form-control" name="start_date" id="start_date" value="<?= ($this->input->get('start_date')? $this->input->get('start_date') : '') ?>" type="text">
                    </div>

                    <div class="form-group col-sm-3" id="dateDiv">
                        <label><?= $this->lang->line("attendancereport_end_date") ?><span class="text-red"> * </span></label>
                        <input class="form-control" name="end_date" id="end_date" value="<?= ($this->input->get('end_date')? $this->input->get('end_date') : '') ?>" type="text">
                    </div>

                    <div class="form-group col-sm-12">
                        <button id="get_attendancereport" class="btn btn-success pull-left" style="margin-top:23px;"> <?= $this->lang->line("attendancereport_submit") ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

</div>


<div class="box">
    <div class="box-header bg-gray">
        <h3 class="box-title text-navy"><i class="fa fa-clipboard"></i> <?= $this->lang->line('attendancereport_report_for') ?> <?= $this->lang->line('menu_student') ?> <?= $this->lang->line('attendancereport_attendance') ?> </h3>
    </div>
    <div id="printablediv">
        <div class="box-body">
            <div class="row">
                <div class="col-sm-12">
                    <div id="hide-table">
                        <table id="attendance_report" class="table table-striped table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th>Roll no#</th>
                                    <th>Date</th>
                                    <th>Student Name</th>
                                    <th>Classes</th>
                                    <th>Time In</th>
                                    <th>Time Out</th>
                                    <th>Hours Spent</th>
                                    <th>Status<br>Arrival/Departure</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(customCompute($attendence_report)): ?>
                                    <?php foreach($attendence_report as $key => $attendence): ?>
                                        <?php 
                                            $time_spent = null;
                                            if(!empty($attendence->clock_out)){
                                                $time1 = new DateTime($attendence->clock_out); 
                                                $time2 = new DateTime($attendence->clock_in);
                                                $timediff = $time1->diff($time2);
                                                $time_spent = $timediff->h.'h:'.$timediff->i.'m';
                                            } 

                                            $arrival = null; 
                                            $start_time = null;
                                            if(!empty($attendence->clock_in)){
                                                $start_time = strtotime($attendence->start_time);
                                                $check_in   = strtotime(date('H:i',strtotime($attendence->clock_in)));
                                                $diff = $start_time - $check_in;
                                                $arrival =  ($diff < 0)? 'Late!' : (($diff == 0)? "On time":"Early");
                                            }

                                            $departure = null;
                                            $end_time = null;
                                            if(!empty($attendence->clock_out)){
                                                $end_time  = strtotime($attendence->end_time);
                                                $check_out = strtotime(date('H:i',strtotime($attendence->clock_out)));
                                                $diff = $check_out - $start_time;
                                                $departure =  ($diff > 0)? 'Late!' : (($diff == 0)? "On time":"Early");
                                            }
                                        ?>
                                        <tr>
                                            <td><?= $attendence->roll; ?></td>
                                            <td><?= $attendence->check_date; ?></td>
                                            <td><?= $attendence->name; ?></td>
                                            <td><?= $attendence->classes; ?></td>
                                            <td><?= $attendence->clock_in; ?></td>
                                            <td><?= ($attendence->clock_out)? $attendence->clock_out : '-'; ?></td>
                                            <td><?= (isset($time_spent))? $time_spent : "-" ?></td>
                                            <!-- <td><?php //((array) $attendence)['a'.abs(date('d',strtotime($attendence->check_date)))]; ?></td> -->
                                            <td><?php echo $arrival."/".$departure; ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<style>
    .error {
        color: red;
    }
</style>

<script>


    var classes_id = $('#classesID').val();
    var section_id = <?= ($this->input->get('sectionID')? $this->input->get('sectionID') : 0) ?>;
    if(classes_id){
        $('#load_attendance_report').html('');

        if(classes_id == 0) {
            $('#sectionID').html('<option value="">'+"<?=$this->lang->line("attendancereport_please_select")?>"+'</option>');
            $('#sectionID').val('');

            $('#subjectID').html('<option value="">'+"<?=$this->lang->line("attendancereport_please_select")?>"+'</option>');
            $('#subjectID').val('');
            
            $('#date').val('');
        } else {
            $.ajax({
                type: 'POST',
                url: "<?=base_url('attendancereport/getSection_data')?>",
                data: {"id" : classes_id},
                dataType: "json",
                success: function(data) {
                    // console.log(section_id);
                    data.forEach(function(v,i){
                        // console.log(v.sectionID);
                        $('#sectionID').append('<option value="'+v.sectionID+'" '+((v.sectionID == section_id) ? 'selected' : '')+' >'+v.section+'</option>');
                    });
                }
            });
        }

    }
    


    $(document).on('change', '#classesID', function() {
        $('#load_attendance_report').html('');
        var id = $(this).val();
        if(id == 0) {
            $('#sectionID').html('<option value="">'+"<?=$this->lang->line("attendancereport_please_select")?>"+'</option>');
            $('#sectionID').val('');

            $('#subjectID').html('<option value="">'+"<?=$this->lang->line("attendancereport_please_select")?>"+'</option>');
            $('#subjectID').val('');
            
            $('#date').val('');
        } else {
            $.ajax({
                type: 'POST',
                url: "<?=base_url('attendancereport/getSection')?>",
                data: {"id" : id},
                dataType: "html",
                success: function(data) {
                    $('#sectionID').html(data);
                }
            });

            $.ajax({
                type: 'POST',
                url: "<?=base_url('attendancereport/getSubject')?>",
                data: {"classID" : id},
                dataType: "html",
                success: function(data) {
                    $('#subjectID').html(data);
                }
            });
        }
    });

    // $(document).bind('click', function() {
    $('#start_date').datepicker({
        autoclose: true,
        format: 'yyyy-mm-dd',
        endDate:'<?=date('Y-m-d')?>',
        daysOfWeekDisabled: "<?=$siteinfos->weekends?>",
        datesDisabled: ["<?=$get_all_holidays;?>"], 
    }); 

    // });

    $('#end_date').datepicker({
        autoclose: true,
        format: 'yyyy-mm-dd',
        endDate:'<?=date('Y-m-d')?>',
        daysOfWeekDisabled: "<?=$siteinfos->weekends?>",
        datesDisabled: ["<?=$get_all_holidays;?>"], 
    }); 

    $("#filter_attendance").validate({
        rules:{
            // classesID : {
            //     required : true
            // },
            // sectionID: {
            //     required : true
            // },
            start_date : {
                required : true
            },
            end_date : {
                required : true
            }
        },
        messages : {
            // classesID : {
            //     required : "Please Select Class"
            // },
            // sectionID: {
            //     required : "Please Select Section"
            // },
            start_date : {
                required : "Please Enter Start Date"
            },
            end_date : {
                required : "Please Enter End Date"
            }
        },
        submitHandler: function(form) {
            form.submit();
        }
    });
</script>