<div class="box" style="height: 600px; overflow: hidden;">
    <div class="box-header">
        <h3 class="box-title"><i class="fa icon-template"></i> <?=$this->lang->line('panel_title')?></h3>

        <ol class="breadcrumb" style="margin-bottom: 10px;">
            <li><a href="<?=base_url("dashboard/index")?>"><i class="fa fa-laptop"></i> <?=$this->lang->line('menu_dashboard')?></a></li>
            <li class="active"><?=$this->lang->line('panel_title')?></li>
        </ol>
    </div><!-- /.box-header -->
<style>
    /* Styling for list group items */
.skooly-title {
    transition: background-color 0.3s, color 0.3s;
}

.skooly-title:hover {
    background-color: #348fe2 !important;
    color: #fff !important;
}

.skooly-title.active {
    background-color: #007bff !important;
    color: #fff !important;
}

[data-theme="dark"] .skooly-title {
    color: #f8f9fa;
}

[data-theme="dark"] .skooly-title:hover {
    background-color: #348fe2 !important;
    color: #fff !important;
}

[data-theme="dark"] .skooly-title.active {
    background-color: #007bff !important;
    color: #fff !important;
}

</style>
    <div class="box-body" style="display: flex; height: calc(100% - 50px);">
        <!-- Sidebar -->
        <div class="col-sm-3 border-right">
            <div class="list-group" style="margin: 0; padding: 0;">
                <?php foreach ($templates as $template): ?>
                    <a href="#" 
                    class="list-group-item list-group-item-action skooly-title" 
                    data-id="<?= $template->mailandsmstemplateID ?>" 
                    data-usertypeid="<?= $template->usertypeID ?>"
                    data-status="<?= $template->status ?>"
                    data-template_name="<?= $template->name ?>"
                    data-template="<?= htmlspecialchars($template->template?? '') ?>">
                        <?= $template->name ?>
                    </a>
                <?php endforeach; ?>
            </div>
        </div>

        <div class="col-sm-9" style="padding: 15px;">
            <form id="templateForm">
                 <input type="hidden" name="template_name" id="template_name">
                 <input type="hidden" name="template_id" id="template_id">
                <div class="row">
                    <div class="form-group col-sm-6">
                        <label for="activationSwitch">Notification Status</label><br>
                        <label class="switch">
                            <input type="checkbox" id="activationSwitch" name="status">
                            <span class="slider round"></span>
                        </label>
                    </div>

                    <div class="form-group col-sm-6">
                        <label for="userSelector">Select User</label>
                        <select id="userSelector" class="form-control" name="userType">
                            <option value="">Select User Type</option>
                            <?php foreach ($usertypes as $usertype): ?>
                                <option value="<?= $usertype->usertypeID ?>">
                                    <?= $usertype->usertype ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div> 

                <!-- Tags Section -->
                <div class="form-group">
                    <label for="tagsSection">Tags</label>
                    <div class="border p-2" id="tagsSection" style="min-height: 80px;">
                        <?php
                        if (customCompute($usertypes)) {
                            foreach ($usertypes as $key => $usertype) {
                                if ($usertype->usertypeID == 2) {
                                    echo '<div class="smstagdiv" id="tags_' . $usertype->usertypeID . '" style="display: none;">';
                                    echo $teachers;
                                    echo '</div>';
                                } elseif ($usertype->usertypeID == 3) {
                                    echo '<div class="smstagdiv" id="tags_' . $usertype->usertypeID . '" style="display: none;">';
                                    echo $students;
                                    echo '</div>';
                                } elseif ($usertype->usertypeID == 4) {
                                    echo '<div class="smstagdiv" id="tags_' . $usertype->usertypeID . '" style="display: none;">';
                                    echo $parents;
                                    echo '</div>';
                                } else {
                                    echo '<div class="smstagdiv" id="tags_' . $usertype->usertypeID . '" style="display: none;">';
                                    echo $users;
                                    echo '</div>';
                                }
                            }
                        }
                        ?>
                    </div>
                </div>

                <!-- SMS Message -->
                <div class="form-group">
                    <label for="sms_message">SMS Message</label>
                    <textarea id="sms_message" name="sms_message" class="form-control" rows="4"></textarea>
                </div>

                <!-- Update Button -->
                <div class="form-group">
                    <button type="submit" class="btn btn-primary">Update Template</button>
                </div>
            </form>
        </div>
    </div><!-- /.box-body -->
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const userSelector = document.getElementById('userSelector');
        const tagsSection = document.getElementById('tagsSection');
        const smsMessage = document.getElementById('sms_message');
        const templateId = document.getElementById('template_id');
        const templateName = document.getElementById('template_name');
        const activationSwitch = document.getElementById('activationSwitch');
        const templateLinks = document.querySelectorAll('.list-group-item');

        function updateTemplateFields(templateLink) {
            const userTypeId = templateLink.getAttribute('data-usertypeid');
            userSelector.value = userTypeId;

            activationSwitch.checked = templateLink.getAttribute('data-status') === '1';

            document.querySelectorAll('.smstagdiv').forEach(tagDiv => {
                tagDiv.style.display = 'none';
            });

            templateId.value = templateLink.getAttribute('data-id') || '';
            templateName.value = templateLink.getAttribute('data-template_name') || '';

            const selectedTagDiv = document.getElementById(`tags_${userTypeId}`);
            if (selectedTagDiv) selectedTagDiv.style.display = 'block';

            smsMessage.value = templateLink.getAttribute('data-template') || '';
        }

        if (templateLinks.length > 0) {
            templateLinks[0].classList.add('active');
            updateTemplateFields(templateLinks[0]);
        }

        templateLinks.forEach(item => {
            item.addEventListener('click', function (e) {
                e.preventDefault();

                templateLinks.forEach(item => item.classList.remove('active'));

                this.classList.add('active');

                updateTemplateFields(this);
            });
        });

        userSelector.addEventListener('change', function () {
            const userId = this.value;
            document.querySelectorAll('.smstagdiv').forEach(tagDiv => {
                tagDiv.style.display = 'none';
            });

            const selectedTagDiv = document.getElementById(`tags_${userId}`);
            if (selectedTagDiv) selectedTagDiv.style.display = 'block';
        });

        $('.smstagdiv > .sms_alltag').click(function() {
            var value = $(this).val(); console.log(value);
            insertAtCaret("sms_message", value, 'id');
        });
    });

    function insertAtCaret(areaClass, text, type) {
        if(type == 'id') {
            var txtarea = document.getElementById(areaClass);
        } else {
            var txtarea = document.querySelector('.'+areaClass);
        }

        if (!txtarea) { return; }

        var scrollPos = txtarea.scrollTop;
        var strPos = 0;
        var br = ((txtarea.selectionStart || txtarea.selectionStart == '0') ?
            "ff" : (document.selection ? "ie" : false ) );
        if (br == "ie") {
            txtarea.focus();
            var range = document.selection.createRange();
            range.moveStart ('character', -txtarea.value.length);
            strPos = range.text.length;
        } else if (br == "ff") {
            strPos = txtarea.selectionStart;
        }

        var front = (txtarea.value).substring(0, strPos);
        var back = (txtarea.value).substring(strPos, txtarea.value.length);
        txtarea.value = front + text + back;
        strPos = strPos + text.length;
        if (br == "ie") {
            txtarea.focus();
            var ieRange = document.selection.createRange();
            ieRange.moveStart ('character', -txtarea.value.length);
            ieRange.moveStart ('character', strPos);
            ieRange.moveEnd ('character', 0);
            ieRange.select();
        } else if (br == "ff") {
            txtarea.selectionStart = strPos;
            txtarea.selectionEnd = strPos;
            txtarea.focus();
        }

        txtarea.scrollTop = scrollPos;
    }
    $('#templateForm').on('submit', function (e) {
        e.preventDefault();

        const formData = $(this).serialize();
        console.log(formData);
        $.ajax({
            url: "<?= base_url('mailandsmstemplate/save_template'); ?>",
            type: 'POST',
            data: formData,
            success: function (response) {
                let parsedResponse = JSON.parse(response);
                showToastr(parsedResponse.message || 'Template saved successfully', 'success');
            },
            error: function () {
                showToastr('An error occurred while saving the template.', 'error');
            }
        });
    });
</script>