<style>
/* Container for the cog button */
.cog-container {
    position: fixed; /* Ensures the button stays in place */
    top: 50%;
    right: 0;
    transform: translateY(-50%);
    z-index: 999; /* Places the button above other elements */
}

/* Cog button styles */
.cog-btn {
    background: #007bff; /* Blue background */
    border: none;
    border-radius: 20px 0 0 20px; /* Rounded on the left */
    padding: 10px 15px;
    cursor: pointer;
    font-size: 20px;
    color: white; /* White icon color */
    display: flex;
    align-items: center;
    justify-content: center;
    transition: background 0.3s ease; /* Smooth background transition */
    margin-right: 0; /* Ensures button aligns with the right edge */
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.2); /* Subtle shadow for effect */
}

.cog-btn:hover {
    background: #0056b3; /* Darker blue on hover */
}

/* Icon inside the button */
.cog-btn i {
    font-size: 28px; /* Larger icon size */
    transition: transform 0.3s ease; /* Smooth spinning effect */
}

.cog-btn:hover i {
    transform: rotate(360deg); /* Spins the icon on hover */
}

/* Side Panel Modal */
.side-panel {
    position: fixed; /* Ensures the panel is fixed on the screen */
    top: 0;
    right: -400px;
    width: 400px;
    height: 100%;
    background: #f9f9f9;
    box-shadow: -2px 0 5px rgba(0, 0, 0, 0.2);
    transition: right 0.3s ease;
    z-index: 1000; /* Places the panel above the button */
}

.side-panel.open {
    right: 0;
}

.side-panel-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 20px;
    background: #007bff;
    color: white;
}

.side-panel-body {
    padding: 20px;
}

.close-btn {
    background: none;
    border: none;
    color: white;
    font-size: 24px;
    cursor: pointer;
}

/* Switch Styles */
.switch {
    position: relative;
    display: inline-block;
    width: 40px;
    height: 20px;
}

.switch input {
    opacity: 0;
    width: 0;
    height: 0;
}

.slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #ccc;
    transition: 0.4s;
    border-radius: 20px;
}

.slider:before {
    position: absolute;
    content: "";
    height: 14px;
    width: 14px;
    left: 3px;
    bottom: 3px;
    background-color: white;
    transition: 0.4s;
    border-radius: 50%;
}

input:checked + .slider {
    background-color: #007bff;
}

input:checked + .slider:before {
    transform: translateX(20px);
}

[data-theme="dark"] .side-panel {
    color: #cfd4e6 !important;
    background-color: #292B30 !important;
}
[data-theme="dark"] .side-panel-header {
    color: #ffffff !important;
    background-color: #1A1C1E !important;
}
</style>
<div class="cog-container">
    <button class="cog-btn" onclick="toggleSidePanel()">
        <i class="fa fa-cog"></i>
    </button>
</div>

<div class="side-panel" id="sidePanel">
    <div class="side-panel-header">
        <h3>SMS Settings</h3>
        <button class="close-btn" onclick="toggleSidePanel()">&times;</button>
    </div>
    <div class="side-panel-body">
        <form method="post" id="smsSettingsForm">
            <div class="form-group">
                <label for="creditValue">Value for 1 Credit</label>
                <input type="text" id="creditValue" class="form-control" name="sms_credit_value" 
                    placeholder="Enter credit value" value="<?= set_value('sms_credit_value', $settings['sms_credit_value']?? '') ?>">
            </div>
            <div class="form-group">
                <label for="creditValue">Allowed URL</label>
                <input type="text" id="creditValue" class="form-control" name="allowed_url" 
                    placeholder="example.com" value="<?= set_value('allowed_url', $settings['allowed_url']?? '') ?>">
            </div>
            <div class="form-group">
                <label>Automatic Recharge</label>
                <label class="switch">
                    <input type="checkbox" id="autoRecharge" name="auto_recharge" 
                        <?= isset($settings['auto_recharge'])? ($settings['auto_recharge'] == 1 ? 'checked' : ''): '' ?>>
                    <span class="slider round"></span>
                </label>
            </div>
            <div class="form-group">
                <label>Notify Admin on Purchase</label>
                <label class="switch">
                    <input type="checkbox" id="notifyAdmin" name="notify_admin" 
                        <?= isset($settings['notify_admin'])? ($settings['notify_admin'] == 1 ? 'checked' : '') : '' ?>>
                    <span class="slider round"></span>
                </label>
            </div>
            <div class="form-group">
                <label>Send Client Notification on Purchase</label>
                <label class="switch">
                    <input type="checkbox" id="clientNotification" name="notify_client" 
                        <?= isset($settings['notify_client'])? ($settings['notify_client'] == 1 ? 'checked' : ''): '' ?>>
                    <span class="slider round"></span>
                </label>
            </div>
            <div class="form-group">
                <label for="creditValue">SMS Threshold</label>
                <input type="text" id="sms_threshold" class="form-control" name="sms_threshold" 
                    placeholder="Enter SMS threshold" value="<?= set_value('sms_threshold', $settings['sms_threshold']?? '') ?>">
            </div>
            <button type="button" class="btn btn-primary" onclick="submitSettingsForm()">Save Settings</button>
        </form>

    </div>
</div>


<script>
    function toggleSidePanel() {
        const panel = document.getElementById('sidePanel');
        if (panel.classList.contains('open')) {
            panel.classList.remove('open');
        } else {
            panel.classList.add('open');
        }
    }

    function submitSettingsForm() {
        const form = $('#smsSettingsForm');
        const formData = form.serialize();
        const panel = document.getElementById('sidePanel');

        $.ajax({
            url: "<?=base_url('smspanel/updateSettings')?>",
            type: 'POST',
            data: formData,
            success: function(response) {
                showToastr(response.message || 'Settings updated successfully!', 'success');
                panel.classList.remove("open");
            },
            error: function() {
                showToastr('Failed to update settings.', 'error');
            }
        });
    }
</script>