<div class="box">
    <div class="box-header">
        <h3 class="box-title"><i class="fa iniicon-productpurchase"></i> <?=$this->lang->line('log_panel_title')?></h3>


        <ol class="breadcrumb">
            <li><a href="<?=base_url("dashboard/index")?>"><i class="fa fa-laptop"></i> <?=$this->lang->line('menu_dashboard')?></a></li>
            <li class="active"><?=$this->lang->line('log_panel_title')?></li>
        </ol>
    </div><!-- /.box-header -->
    <div class="box-body">
        <div class="row">
            <div class="col-sm-12">
                <form method="GET" id="filter_attendance">                   
                
                    <div class="form-group col-sm-3" id="dateDiv">
                        <label><?= $this->lang->line("lunch_start_date") ?><span class="text-red"> * </span></label>
                        <input class="form-control" name="start_date" id="start_date" value="<?= ($this->input->get('start_date')? $this->input->get('start_date') : '') ?>" type="text">
                    </div>

                    <div class="form-group col-sm-3" id="dateDiv">
                        <label><?= $this->lang->line("lunch_end_date") ?><span class="text-red"> * </span></label>
                        <input class="form-control" name="end_date" id="end_date" value="<?= ($this->input->get('end_date')? $this->input->get('end_date') : '') ?>" type="text">
                    </div>

                    <div class="form-group col-sm-3">
                        <button id="get_attendancereport" class="btn btn-success pull-left" style="margin-top:23px;"> <?= $this->lang->line("lunch_submit") ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="row"> 
    <div class="col-sm-8">
        <div class="box"> 
            <div id="column-chart"></div>
        </div>
    </div>
    <div class="col-sm-4">
        <div class="box"> 
            <div id="mealLog"></div>
        </div>
    </div>
</div>
<div class="box">  
    <!-- form start -->
    <div class="box-body">
        <div class="row">
            <div class="col-sm-12">
                <div id="hide-table">
                    <table id="example1" class="table table-striped table-bordered table-hover dataTable no-footer">
                        <thead>
                            <tr>
                                <th><?=$this->lang->line('slno')?></th>
                                <th><?=$this->lang->line('lunch_referenceno')?></th>
                                <th><?=$this->lang->line('lunch_student')?></th>
                                <th><?=$this->lang->line('lunch_type')?></th>
                                <th><?=$this->lang->line('lunch_amount')?></th>
                                <th><?=$this->lang->line('lunch_time')?></th>
                                <th><?=$this->lang->line('lunch_date')?></th>                              
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(customCompute($lunchLogs)) {$i = 1; foreach($lunchLogs['lunchlogs'] as $lunchLog) { ?>
                                <tr>
                                    <td data-title="<?=$this->lang->line('slno')?>">
                                        <?php echo $i; ?>
                                    </td>

                                    <td data-title="<?=$this->lang->line('lunch_referenceno')?>">
                                        <?php echo $lunchLog->referenceno; ?>
                                    </td>
                                    <td data-title="<?= $this->lang->line('lunch_student') ?>">
                                        <a href="<?= base_url('wallet/view/' . $lunchLog->studentID) ?>" style="color:blue">
                                            <?php echo $lunchLog->name; ?>
                                        </a>
                                    </td>
                                    <td data-title="<?=$this->lang->line('lunch_type')?>">
                                        <?php echo $lunchLog->type; ?>
                                    </td>
                                    <td data-title="<?=$this->lang->line('lunch_amount')?>">
                                        <?php echo $lunchLog->amount; ?>
                                    </td>
                                    <td data-title="<?=$this->lang->line('lunch_time')?>">
                                        <?= date('H:i:s', strtotime($lunchLog->time)); ?>
                                    </td>
                                    <td data-title="<?=$this->lang->line('lunch_date')?>">
                                        <?= date('d M Y', strtotime($lunchLog->date)); ?>
                                    </td>
                                    
                                </tr>
                            <?php $i++; }} ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(function() {
        LoadGraph();
        function LoadGraph()
        {  
        // Convert PHP arrays to JavaScript arrays
        var breakData = <?php echo json_encode($breakData); ?>;
        var lunchData = <?php echo json_encode($lunchData); ?>;

        // Prepare data for Highcharts
        var categories = Object.keys(breakData).map(function (day) {
            return new Date(day).toLocaleDateString('en-US', { weekday: 'short', month: 'short', day: 'numeric' });
        });

        var breakSeries = Object.values(breakData);
        var lunchSeries = Object.values(lunchData);

        // Create the column chart using Highcharts
        Highcharts.chart('column-chart', {
            chart: {
                type: 'column'
            },
            title: {
                text: 'This Week Meals Income'
            },
            xAxis: {
                categories: categories,
                title: {
                    text: 'Date',
                    enabled: false
                }
            },
            yAxis: {
                title: {
                    text: 'Amount',
                    enabled: false
                }
            },
            series: [{
                name: 'Break',
                data: breakSeries,
                color: '#09A3A3'
            }, {
                name: 'Lunch',
                data: lunchSeries,
                color: '#FF8A65'
            }],
        });
    }
});
</script>



<script>
$(function() {
  LoadMealDonut();

  function LoadMealDonut() {
    $('#mealLog').highcharts({
      chart: {
        type: 'pie',
        options3d: {
          enabled: true,
          alpha: 45
        }
      },
      title: {
        text: 'Meals Income For <?=getSchoolYear()?>',
        align: 'center'
      },
      subtitle: {
        text: 'Total Amount: <?= number_format($lunchLogsPie[0]["y"]+$lunchLogsPie[1]["y"]); ?>',
        style: {
          fontWeight: 'bold',
          fontSize: '16px'
        }
      },
      accessibility: {
        announceNewData: {
          enabled: true
        },
        point: {
          valueSuffix: 'KES'
        }
      },
      tooltip: {
        formatter: function() {
          return this.point.name + ': ' + Highcharts.numberFormat(this.point.y, 0, '.', ',');
        }
      },
      plotOptions: {
        pie: {
          innerSize: 100,
          depth: 45,
          dataLabels: {
            enabled: false,
            formatter: function() {
              return this.point.name + ': ' + Highcharts.numberFormat(this.point.y, 0, '.', ',');
            }
          },
          showInLegend: true
        }
      },
      series: [{
        name: 'Lunch Expenses',
        colorByPoint: true,
        data: <?php echo json_encode($lunchLogsPie); ?>
      }]
    });
  }
});
</script>


<script type="text/javascript">
        function clearDateField() {
            document.getElementById("start_date").value = "";
            document.getElementById("end_date").value = "";
        }
    // $(document).bind('click', function() {
        $('#start_date').datepicker({
            autoclose: true,
            format: 'yyyy-mm-dd',
            endDate:'<?=date('Y-m-d')?>',
            daysOfWeekDisabled: "<?=$siteinfos->weekends?>",
            datesDisabled: ["<?=$get_all_holidays;?>"], 
        }); 

    // });

    $('#end_date').datepicker({
        autoclose: true,
        format: 'yyyy-mm-dd',
        endDate:'<?=date('Y-m-d')?>',
        daysOfWeekDisabled: "<?=$siteinfos->weekends?>",
        datesDisabled: ["<?=$get_all_holidays;?>"], 
    });     
</script>

