<div class="box">
    <div class="box-header">
        <h3 class="box-title"><i class="fa fa-camera"></i> <?=$this->lang->line('panel_title')?></h3>

        <ol class="breadcrumb">
            <li><a href="<?=base_url("dashboard/index")?>"><i class="fa fa-laptop"></i> <?=$this->lang->line('menu_dashboard')?></a></li>
            <li class="active"><?=$this->lang->line('menu_student')?></li>
        </ol>
    </div>
    <div class="box-body">
        <div class="row qrcode-scan">
			<div class="col-sm-4">
                <div class="form-group box mt-md">
                    <span class="title"><?=$this->lang->line('scan_qr_code')?></span>
                    <div class="justify-content-md-center" id="reader" width="300px" height="300px"></div>
                    <span class="text-center" id='qr_status'><?=$this->lang->line('scanning')?></span>
                    <div class="radio-custom radio-success radio-inline mt-md">
                        <input type="radio" value="in_time" checked name="in_out_time" id="in_time">
                        <label for="in_time"><?=$this->lang->line('clock_in')?></label>
                    </div>
                    <div class="radio-custom radio-success radio-inline mt-md">
                        <input type="radio" value="out_time" name="in_out_time" id="out_time">
                        <label for="out_time"><?=$this->lang->line('clock_out')?></label>
                    </div>
                    <div class="mt-md">
                        <button id="flipCameraFront" class="btn btn-primary">Front Cam</button>
                        <button id="flipCameraBack" class="btn btn-primary">Back Cam</button>
                    </div>
                </div>
            </div>
			<div class="col-sm-4">
				<div class="box mt-md" style="height:485px; text-align: left;">
				    <span class="title"><?=$this->lang->line('custom_entry')?></span>
					<div class="box-body">
						<form method="post" id="admForm">
							<div class="form-group">
								<div class="radio-custom radio-success radio-inline mt-md">
									<input type="radio" value="in_time" checked name="clock_in_out1" id="clock_in1">
									<label for="clock_in1"><?=$this->lang->line('clock_in')?></label>
								</div>
								<div class="radio-custom radio-success radio-inline mt-md">
									<input type="radio" value="out_time" name="clock_in_out1" id="clock_out1">
									<label for="clock_out1"><?=$this->lang->line('clock_out')?></label>
								</div>
							</div>
							<!-- <div class="row"> -->
								<div class="form-group">
									<label for="admissionNumber">Admission Number:</label>
									<input type="text" class="form-control" id="admissionNumber" name="admissionNumber" autocomplete="off">
								</div>
								<div class="form-group">
									<label for="admissionNumber">User Type</label>
									<select class="form-control" id="userType" name="userType">
										<option value="S">Student</option>
										<option value="T">Teacher</option>
										<option value="U">Others</option>
									</select>
								</div>
							<!-- </div> -->
							<div class="form-group">
								<button type="submit" class="btn btn-primary">Submit</button>
							</div>
						</form>
                    </div> 
					<div class="box-body" style="bottom:0;border: 1px solid #4b4b4b;">
						<p> Use this custom entry section if the student doesn't have an ID card.</p>
					</div>
                </div>                
            </div>
            <div class="col-sm-4">
                <div class="box mt-md" style="height:485px">
				<span class="title"><?=$this->lang->line('scanned_details')?></span>
					<!-- <h3 class="box-title"><?= $this->lang->line('scanned_details') ?></h3> -->
                    <div class="box-layout" id="attendence_res" style="display: none; margin-top:10px">
                    </div>
                </div>
            </div>
			
        </div>
    </div>
</div>

<audio id="successAudio">
    <source src="<?php echo base_url('assets/inilabs/themes/skooly/vendor/qrcode/success.mp3') ?>" type="audio/ogg">
</audio>
<script src="<?php echo base_url('assets/inilabs/themes/skooly/vendor/qrcode/qrcode.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/inilabs/themes/skooly/js/qrcode_attendance.js'); ?>"></script>
<script type="text/javascript">
    var statusMatched = "<?=$this->lang->line('matched')?>";
    var statusScanning = "<?=$this->lang->line('scanning')?>";
    $("#qr_status").css("background", "green");
    
    var x = document.getElementById("successAudio");
    var lastResult, modalOpen = 0;
    const html5QrCode = new Html5Qrcode("reader");
    const qrCodeSuccessCallback = (decodedText, decodedResult) => {
        if (decodedText !== lastResult && modalOpen == 0) {
            var inOutTime = $('input[name="in_out_time"]:checked').val();
            x.play();
            lastResult = decodedText;
            submitQR(inOutTime, true);    
            html5QrCode.clear();
        }
    };

    const formatsToSupport = [
        Html5QrcodeSupportedFormats.QR_CODE,
    ];

    var config = { fps: 50, qrbox: 200};
    if($(window).width()  <= '400'){
        config = { fps: 50, qrbox: 150};
    }
    if($(window).width()  <= '370'){
        config = { fps: 50, qrbox: 120};
    }

    function startCamera(cameraFacingMode) {
        html5QrCode.start({ facingMode: cameraFacingMode }, config, qrCodeSuccessCallback).catch((err) => {
            $("#qr_status").css("background", "red");
            $("#reader").addClass("camera-preview").html(cameraFacingMode + " camera not found.");
            $("#qr_status").html(err);
            alert(cameraFacingMode + ' camera not found.');
            console.log(err);
        });
    }

    // Start with the back camera
    startCamera("environment");

    // Event listeners for the camera flip buttons
    document.getElementById("flipCameraFront").addEventListener("click", function() {
        html5QrCode.stop().then(ignore => {
            startCamera("user");
        }).catch(err => {
            console.log("Failed to stop QR code scanner.");
        });
    });

    document.getElementById("flipCameraBack").addEventListener("click", function() {
        html5QrCode.stop().then(ignore => {
            startCamera("environment");
        }).catch(err => {
            console.log("Failed to stop QR code scanner.");
        });
    });

    function submitQR(inOutTime, qr) {
        $.ajax({
            type: 'post',
            url: "<?= base_url('qrcode_attendance/submit_qr'); ?>",
            data: {
                'qr_token' : lastResult,
                'in_out_time': inOutTime
            },
            dataType: 'json',
            beforeSend: function () {
                if(qr){
                    $("#qr_status").css("background", "blue");
                    $("#qr_status").html('Processing..');
                }                
            },
            success: function (response) {
                if(qr){
                    $("#qr_status").css("background", "green");
                }
                
                if(response.status=='error'){
                    $('#attendence_res').html("<table class='table table-responsive'>"+
                    "<tr><th class='danger text-center' colspan='2'><span><strong>"+response.message+"</strong><span></th></tr>"+
                    "</table>")
                    $('#attendence_res').show();
                } else {
                    var feeBalanceRow = "";
                    if (response.user_type == 'Student') {
                        feeBalanceRow = "<tr><td><strong><h5>Fee Balance:</h5></strong></td><td><h5>"+ ((response.fee_balance) ? response.fee_balance : '-')+"</h5></td></tr>";
                    }

                    $('#attendence_res').html(
                        "<table class='table table-responsive'>"+
                            "<tr><td colspan='2'>"+response.photo+"</td></tr>"+
                            "<tr><td colspan='2'><h4>"+response.name+"</h4></td></tr>"+
                            "<tr><td colspan='2'><h6>"+response.user_type+"</h6></td></tr>"+
                            feeBalanceRow +
                            "<tr><td><strong><h5>Clock-in:</h5></strong></td><td><h5>"+ ((response.clock_in) ? response.clock_in : '-')+"</h5></td></tr>"+
                            "<tr><td><strong><h5>Clock-out:</h5></strong></td><td><h5>"+ ((response.clock_out) ? response.clock_out : '-')+"</h5></td></tr>"+
                        "</table>"
                    );
      
                    $('#attendence_res').show();
                }
                if(qr){
                    $("#qr_status").html(statusScanning);
                }
            },
            complete: function (data) {
                $('#attendence_res').show();
                $('#admissionNumber').val('');

                if(qr){
                    $("#qr_status").css("background", "green");
                    $("#qr_status").html(statusMatched);
                }
            },
            error: function () {
                $('#attendence_res').show();
                $('#admissionNumber').val('');
                if(qr){
                    $("#qr_status").css("background", "red");
                    $("#qr_status").html('An error Occurred');
                }
            }
        });
    }

    $('.modal-dismiss').on('click', function() {
        end_loader()
    });

    $('input[name="in_out_time"]').on('change', function() {
        end_loader()
    });

    $(document).ready(function() {
          $('#admForm').submit(function(event) {
            event.preventDefault();
        
            var inOutTime = $('input[name="clock_in_out1"]:checked').val();
            var userType = $('#userType').val();
            lastResult = userType+'-'+$('#admissionNumber').val(); console.log(lastResult);
            
            submitQR(inOutTime, false);
          });
    });
</script>