<?php echo doctype("html5"); ?>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <title>SKOOLY LOGIN</title>
    <link rel="SHORTCUT ICON" href="<?=base_url("uploads/images/$siteinfos->photo")?>" />
    <link href="<?php echo base_url('assets/bootstrap/bootstrap.min.css'); ?>" rel="stylesheet" type="text/css">
    <link href="<?php echo base_url('assets/fonts/font-awesome.css'); ?>" rel="stylesheet" type="text/css">
    <link href="<?php echo base_url($backendThemePath.'/style.css'); ?>" rel="stylesheet" type="text/css">
    <link href="<?php echo base_url($backendThemePath.'/inilabs.css'); ?>" rel="stylesheet" type="text/css">
    <link href="<?php echo base_url('assets/inilabs/responsive.css'); ?>" rel="stylesheet" type="text/css">
    <link rel="stylesheet" href="<?=base_url('assets/fonts/fontstyle.css')?>">
    <link rel="stylesheet" href="<?=base_url('assets/skooly/css/skooly_login.css')?>?v=4">

    <style>
        .toastr {
            display: flex;
            align-items: center;
            padding: 10px 20px;
            margin-bottom: 10px;
            border-radius: 5px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            font-family: 'Manrope', sans-serif;
            font-size: 14px;
            color: #fff;
            animation: fade-in 0.5s, fade-out 0.5s 2.5s;
        }
        .toastr.success { background-color: #28a745; }
        .toastr.error { background-color: #dc3545; }
        .toastr.info { background-color: #17a2b8; }
        .bg-success { background-color: #28a745; }
        .bg-danger { background-color: #dc3545; }
        @keyframes fade-in { from { opacity: 0; transform: translateY(-20px); }
        to { opacity: 1; transform: translateY(0); } }
        @keyframes fade-out { from { opacity: 1; transform: translateY(0); }
        to { opacity: 0; transform: translateY(-20px); } }
    </style>
</head>
<body class="login-page">
    <div class="glassmorphism-background"></div>
    <div class="skooly-login-flex">
        <div class="skooly-login-right">
            <img src="<?= base_url('uploads/skooly/defaults/' . $siteinfos->app_logo) ?>" alt="Logo" class="skooly-login-logo" />
            <?php $this->load->view($subview); ?>
            <div class="skooly-login-slogan"><?= htmlspecialchars($siteinfos->slogan) ?></div>
        </div>
    </div>
    <div id="toastr-container" style="position: fixed; top: 20px; right: 20px; z-index: 9999;"></div>

    <?php if(config_item('demo')) { ?>
        <div class="skooly-demo-nav">
            <nav class="navbar navbar-default">
                <div class="container-fluid">
                    <div class="navbar-header">
                        <a class="navbar-brand" href="#">
                         &nbsp; &nbsp; &nbsp; For Quick Demo Login Click Below...
                        </a>
                    </div>
                </div>
            </nav>
        </div>
        <div class="skooly-demo-btns">
            <center>
                <div class="btn-group" role="group" aria-label="...">
                    <button class="btn btn-sm btn-primary" id="admin">Admin</button>
                    <button class="btn btn-sm btn-info" id="teacher">Teacher</button>
                    <button class="btn btn-sm btn-warning" id="student">Student</button>
                    <button class="btn btn-sm btn-success" id="parent">Parent</button>
                    <button class="btn btn-sm btn-danger" id="accountant">Accountant</button>
                    <button class="btn btn-sm btn-default" id="librarian">Librarian</button>
                    <button class="btn btn-sm btn-primary" id="recep">Receptionist</button>
                </div>
            </center>
        </div>
    <?php } ?>

    <script type="text/javascript" src="<?php echo base_url('assets/inilabs/jquery.js'); ?>"></script>
    <script type="text/javascript" src="<?php echo base_url('assets/bootstrap/bootstrap.min.js'); ?>"></script>
    <?php if(config_item('demo')) { ?>
        <script type="text/javascript">
            $('#admin').click(function () {
                $("input[name=username]").val('admin');
                $("input[name=password]").val('123456');
            });
            $('#teacher').click(function () {
                $("input[name=username]").val('teacher1');
                $("input[name=password]").val('123456');
            });
            $('#student').click(function () {
                $("input[name=username]").val('student1');
                $("input[name=password]").val('123456');
            });
            $('#parent').click(function () {
                $("input[name=username]").val('parent1');
                $("input[name=password]").val('123456');
            });
            $('#accountant').click(function () {
                $("input[name=username]").val('accountant');
                $("input[name=password]").val('123456');
            });
            $('#librarian').click(function () {
                $("input[name=username]").val('librarian');
                $("input[name=password]").val('123456');
            });
            $('#recep').click(function () {
                $("input[name=username]").val('receptionist');
                $("input[name=password]").val('123456');
            });
        </script>
    <?php } ?>
    <script>
        function showToastr(message, type = 'success') {
            const toastr = document.createElement('div');
            toastr.classList.add('toastr', type);
            toastr.innerText = message;
            const container = document.getElementById('toastr-container');
            container.appendChild(toastr);
            setTimeout(() => { toastr.remove(); }, 3000);
        }
    </script>
    <?php if ($this->session->flashdata('success')): ?>
        <script type="text/javascript">
            showToastr("<?=$this->session->flashdata('success');?>", 'success');
        </script>
    <?php $this->session->unset_userdata('success'); endif ?>
    <?php if ($this->session->flashdata('error')): ?>
        <script type="text/javascript">
            showToastr("<?=$this->session->flashdata('error');?>", 'error');
        </script>
    <?php $this->session->unset_userdata('error'); endif ?>
</body>
</html>