<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Uattendance_m extends MY_Model {
	protected $_table_name = 'uattendance';
	protected $_primary_key = 'uattendanceID';
	protected $_primary_filter = 'intval';
	protected $_order_by = "monthyear asc";

	function __construct() {
		parent::__construct();
	}

	public function get_uattendance($array=NULL, $signal=FALSE) {
		$query = parent::get($array, $signal);
		return $query;
	}

	public function get_order_by_uattendance($array=NULL) {
		$query = parent::get_order_by($array);
		return $query;
	}

	public function insert_uattendance($array) {
		$error = parent::insert($array);
		return $error;
	}

	public function insert_batch_uattendance($array) {
		$id = parent::insert_batch($array);
		return $id;
	}

	public function update_uattendance($data, $id = NULL) {
		parent::update($data, $id);
		return $id;
	}

	public function update_batch_uattendance($data, $id = NULL) {
        parent::update_batch($data, $id);
        return TRUE;
    }

	public function delete_uattendance($id){
		parent::delete($id);
	}


	public function verify_attendence($where)
	{
		// return $where;
		$attendence = $this->db->select('*')
				->from('clock_in_out')
				->join('uattendance', 'uattendance.uattendanceID = clock_in_out.attendanceID')
				->join('user','user.userID = clock_in_out.userID')
				// ->from('user')
				// ->join('uattendance', 'uattendance.userID = user.userID', 'LEFT')
				// ->join('clock_in_out','clock_in_out.attendanceID = uattendance.uattendanceID','LEFT')
				->where($where)
				->get()->row();
		return $attendence;

	}


	public function get_today_attendence($userID)
	{
		return $this->db->select('*')
			->from('uattendance')
			->where('userID',$userID)
			->where('monthyear',date('m-Y'))
			->get()->row();
	}

	public function get_attendance_report($where){
	
		return $this->db->select('user.userID as ID,name,clock_in_out.*,uattendance.*')
			->from('clock_in_out')
			->join('uattendance', 'uattendance.uattendanceID = clock_in_out.attendanceID')
			->join('user','user.userID = clock_in_out.userID')
			->where('clock_in_out.usertypeID<>',1)
			->where('clock_in_out.usertypeID<>',2)
			->where('clock_in_out.usertypeID<>',3)
			->where('clock_in_out.usertypeID<>',4)
			->where($where)
			->order_by('last_modified','desc')
			->get()->result();
	}
}