<?php

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Sattendance_m extends MY_Model {

	protected $_table_name = 'attendance';
	protected $_primary_key = 'attendanceID';
	protected $_primary_filter = 'intval';
	protected $_order_by = "monthyear asc";

	function __construct() {
		parent::__construct();
	}

	public function get_attendance($array=NULL, $signal=FALSE) {
		$query = parent::get($array, $signal);
		return $query;
	}

	public function get_order_by_attendance($array=NULL) {
		$query = parent::get_order_by($array);
		return $query;
	}

	public function insert_attendance($array) {
		$error = parent::insert($array);
		return $error;
	}

	public function insert_batch_attendance($array) {
		$id = parent::insert_batch($array);
		return $id;
	}

	public function update_attendance($data, $id = NULL) {
		parent::update($data, $id);
		return $id;
	}

	public function update_batch_attendance($data, $id = NULL) {
        parent::update_batch($data, $id);
        return TRUE;
    }

	public function delete_attendance($id){
		parent::delete($id);
	}

	public function verify_attendence($where)
	{
		// return $where;
		$attendence = $this->db->select('*')
				->from('clock_in_out')
				->join('attendance', 'attendance.attendanceID = clock_in_out.attendanceID')
				->join('student','student.studentID = clock_in_out.userID')
				->where($where)
				->get()->row();
		return $attendence;

	}

	public function get_student($roll)
	{
		return $this->db->select('*')
			->from('student')
			->where('registerNO',$roll)
			->get()->row();
	}


	public function get_today_attendence($studentID)
	{
		return $this->db->select('*')
			->from('attendance')
			->where('studentID',$studentID)
			->where('monthyear',date('m-Y'))
			->get()->row();
	}

	public function get_absent_students($currentTime, $currentDate) {

		if ($currentTime > '08:00') {
            $this->db->select('*');
            $this->db->from("student");
            $this->db->join('studentrelation', 'student.studentID = studentrelation.srstudentID');
            $this->db->join('studentextend', 'studentextend.studentID = student.studentID', 'LEFT');
            $this->db->join('clock_in_out', 'student.studentID = clock_in_out.userID AND clock_in_out.usertypeID = 3 AND clock_in_out.check_date = "'.$currentDate.'"', 'left');
            $this->db->where('(clock_in_out.clock_in IS NULL OR clock_in_out.clock_in > "08:00")');
        
            $absentStudents = $this->db->get()->result();
        
            return $absentStudents;
        }


		return null;
	}

	public function get_last_seven_days_attendance($studentID)
	{
		$startDate = date('Y-m-d', strtotime('-7 days'));
		$endDate = date('Y-m-d');

		return $this->db->select('*')
			->from('attendance')
			->where('studentID', $studentID)
			->where('date >=', $startDate)
			->where('date <=', $endDate)
			->get()->result();
	}



	public function get_attendance_report($where){

		return $this->db->select('roll,name,clock_in_out.*,attendance.*,classes,start_time,end_time')
			->from('clock_in_out')
			->join('attendance', 'attendance.attendanceID = clock_in_out.attendanceID')
			->join('student','student.studentID = clock_in_out.userID')
			->join('classes','classes.classesID = student.classesID')
			->where($where)
			->order_by('last_modified','DESC')
			->get()->result();
	}


}