<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Clock_in_out_m extends MY_Model {


    protected $_table_name = 'clock_in_out';
	protected $_primary_key = 'id';
    protected $_primary_filter = 'intval';
    protected $_order_by = "check_date desc";

    function __construct() {
		parent::__construct();
	}

    public function get_attendance_time($array=NULL, $signal=FALSE) {
		$query = parent::get($array, $signal);
		return $query;
	}
    
    public function get_clock_in($where){

		$clock_in = $this->db->select('*')
		->from($this->_table_name)
		->where($where)
		->get()->row();

		return $clock_in;
	}

    public function insert_clock_attend($data){

		$this->db->insert($this->_table_name,$data);
        $insert_id = $this->db->insert_id();

        return  $insert_id;
    }

    public function update_clock_attend($data,$id){
		return $this->db->set($data)
			->where('id',$id)
			->update($this->_table_name);
	}

	public function getData($schoolyearID){
		$this->db->select('clock_in_out.clock_in, clock_in_out.clock_out, clock_in_out.userID, clock_in_out.last_modified, studentrelation.srclasses,studentrelation.srclassesID, studentrelation.srsection, studentrelation.srsectionID,studentrelation.srname, studentrelation.srregisterNO,studentrelation.srstudentID');
		$this->db->from('clock_in_out');		
		$this->db->join('studentrelation', 'studentrelation.srstudentID = clock_in_out.userID');
		$this->db->where('srschoolyearID', $schoolyearID);
// 		$this->db->join('attendance', 'attendance.studentID = clock_in_out.userID');
// 		if ( customCompute($array) ) {
// 			$this->db->where($array);
// 		}
		$this->db->order_by('clock_in_out.last_modified', 'DESC');
		$this->db->limit(10);
		$query = $this->db->get();
		$result = $query->result();

		return $result;

	}

	public function getDatastudent($schoolyearID, $studentID){
		$this->db->select('clock_in_out.clock_in, clock_in_out.clock_out, clock_in_out.userID, clock_in_out.last_modified, studentrelation.srclasses,studentrelation.srclassesID, studentrelation.srsection, studentrelation.srsectionID,studentrelation.srname, studentrelation.srregisterNO,studentrelation.srstudentID');
		$this->db->from('clock_in_out');		
		$this->db->join('studentrelation', 'studentrelation.srstudentID = clock_in_out.userID');
		$this->db->where('srschoolyearID', $schoolyearID);
		$this->db->where('studentrelation.srstudentID', $studentID);
		$this->db->order_by('clock_in_out.last_modified', 'DESC');
// 		$this->db->limit(7);
		$query = $this->db->get();
		$result = $query->result();

		return $result;

	}

	public function get_clock_in_out_data() {

		try{
			$this->db->select('(CASE WHEN user.usertypeID = 3 THEN student.name ELSE user.name END) AS name, 
                   CASE user.usertypeID 
                        WHEN 1 THEN "Admin" 
                        WHEN 2 THEN "Teacher" 
                        WHEN 3 THEN "Student" 
                        WHEN 4 THEN "Parent" 
                        WHEN 5 THEN "Accountant" 
                        WHEN 6 THEN "Librarian" 
                        WHEN 7 THEN "Receptionist" 
                        WHEN 9 THEN "Head" 
                        WHEN 10 THEN "Support" 
                   END AS usertype, 
                   clock_in_out.clockin AS time, 
                   clock_in_out.check_date AS date');

		$this->db->join('user', 'user.userID = clock_in_out.userID', 'left');
		$this->db->join('student', 'student.studentID = clock_in_out.userID', 'left');
		$this->db->where('user.usertypeID !=', 3);
		$query = $this->db->get('clock_in_out');
		if ($query === false) {
			$error = $this->db->error();
			echo $error['message'];
            // $error = $this->db->error();
            // log_message('error', 'SQL error: '.$error['message']);
            // throw new Exception('Unable to fetch clock in/out data. Please try again later.');
        }
        return $query->result();
    } catch (Exception $e) {
        log_message('error', $e->getMessage());
        return array('error' => $e->getMessage());
    }
	}

}