<?php
                //SweetAlert Confirmation helper//
defined('BASEPATH') OR exit('No direct script access allowed');

if (!function_exists('swal_confirm')) {
    /**
     * Generate SweetAlert confirmation attributes for any element
     */
    function swal_confirm($url, $title = 'Are you sure?', $text = 'This action cannot be undone.', $type = 'warning', $confirmText = 'Yes, proceed!', $replacements = []) {
        
        // Replace variables in text
        foreach ($replacements as $key => $value) {
            $text = str_replace('{' . $key . '}', $value, $text);
        }
        
        $attributes = [
            'href' => $url,
            'data-title' => htmlspecialchars($title, ENT_QUOTES),
            'data-text' => htmlspecialchars($text, ENT_QUOTES),
            'data-icon' => $type,
            'data-confirm-button-text' => htmlspecialchars($confirmText, ENT_QUOTES)
        ];
        
        // Add replacement data attributes
        foreach ($replacements as $key => $value) {
            $attributes['data-' . $key] = htmlspecialchars($value, ENT_QUOTES);
        }
        
        $attrString = '';
        foreach ($attributes as $key => $value) {
            $attrString .= " $key=\"$value\"";
        }
        
        return $attrString . ' class="confirm-action sms-check-button"';
    }
}

if (!function_exists('swal_danger')) {
    function swal_danger($url, $title = 'Are you sure?', $text = 'This action is dangerous and cannot be undone.', $replacements = []) {
        return swal_confirm($url, $title, $text, 'error', 'Yes, I understand!', $replacements);
    }
}

if (!function_exists('swal_info')) {
    function swal_info($url, $title = 'Please confirm', $text = 'Please confirm you want to proceed.', $replacements = []) {
        return swal_confirm($url, $title, $text, 'info', 'Confirm', $replacements);
    }
}

if (!function_exists('swal_success')) {
    function swal_success($url, $title = 'Success!', $text = 'Operation completed successfully.', $replacements = []) {
        return swal_confirm($url, $title, $text, 'success', 'Continue', $replacements);
    }
}