
        
<?php
defined('BASEPATH') OR exit('No direct script access allowed');

if (!function_exists('swal_confirm_link')) {
    function swal_confirm_link($url, $title = 'Are you sure?', $text = 'This action cannot be undone.', $type = 'warning', $confirmText = 'Yes, proceed!', $replacements = []) {
        
        foreach ($replacements as $key => $value) {
            $text = str_replace('{' . $key . '}', $value, $text);
        }
        
        $attributes = [
            'href' => $url,
            'data-title' => htmlspecialchars($title, ENT_QUOTES),
            'data-text' => htmlspecialchars($text, ENT_QUOTES),
            'data-icon' => $type,
            'data-confirm-button-text' => htmlspecialchars($confirmText, ENT_QUOTES)
        ];
        
        foreach ($replacements as $key => $value) {
            $attributes['data-' . $key] = htmlspecialchars($value, ENT_QUOTES);
        }
        
        $attrString = '';
        foreach ($attributes as $key => $value) {
            $attrString .= " $key=\"$value\"";
        }
        
        return $attrString . ' class="swal-confirm sms-check"';
    }
}

if (!function_exists('swal_confirm_button')) {
    function swal_confirm_button($formId, $title = 'Are you sure?', $text = 'This action cannot be undone.', $type = 'warning', $confirmText = 'Yes, proceed!', $replacements = []) {
        
        foreach ($replacements as $key => $value) {
            $text = str_replace('{' . $key . '}', $value, $text);
        }
        
        $attributes = [
            'data-form-id' => $formId,
            'data-title' => htmlspecialchars($title, ENT_QUOTES),
            'data-text' => htmlspecialchars($text, ENT_QUOTES),
            'data-icon' => $type,
            'data-confirm-button-text' => htmlspecialchars($confirmText, ENT_QUOTES),
            'type' => 'button'
        ];
        
        foreach ($replacements as $key => $value) {
            $attributes['data-' . $key] = htmlspecialchars($value, ENT_QUQUOTES);
        }
        
        $attrString = '';
        foreach ($attributes as $key => $value) {
            $attrString .= " $key=\"$value\"";
        }
        
        return $attrString . ' class="swal-confirm sms-check"';
    }
}

// Shortcut functions
if (!function_exists('swal_danger_link')) {
    function swal_danger_link($url, $title = 'Are you sure?', $text = 'This action is dangerous.', $replacements = []) {
        return swal_confirm_link($url, $title, $text, 'error', 'Yes, I understand!', $replacements);
    }
}

if (!function_exists('swal_danger_button')) {
    function swal_danger_button($formId, $title = 'Are you sure?', $text = 'This action is dangerous.', $replacements = []) {
        return swal_confirm_button($formId, $title, $text, 'error', 'Yes, I understand!', $replacements);
    }
}