<?php
                //SweetAlert flashdata helper//
defined('BASEPATH') OR exit('No direct script access allowed');

if (!function_exists('show_sweetalert')) {
    function show_sweetalert() {
        $CI =& get_instance();
        
        $alerts = [];
        $types = ['success', 'error', 'warning', 'info'];
        
        foreach ($types as $type) {
            if ($CI->session->flashdata($type)) {
                $message = $CI->session->flashdata($type);
                $alerts[] = [
                    'type' => $type,
                    'message' => $message
                ];
                $CI->session->unset_userdata($type);
            }
        }
        
        if (!empty($alerts)) {
            echo "<script>
            document.addEventListener('DOMContentLoaded', function() {";
            
            foreach ($alerts as $alert) {
                $title = ucfirst($alert['type']);
                $icon = $alert['type'];
                
                if ($alert['type'] == 'error') $title = 'Error!';
                if ($alert['type'] == 'success') $title = 'Success!';
                
                // Properly escape the message for JavaScript
                $message = addslashes($alert['message']);
                
                echo "
                Swal.fire({
                    title: '{$title}',
                    text: '{$message}',
                    icon: '{$icon}',
                    confirmButtonText: 'OK',
                    confirmButtonColor: '#3085d6',
                    allowOutsideClick: false
                });";
            }
            
            echo "});
            </script>";
        }
    }
}

if (!function_exists('flashdata_success')) {
    function flashdata_success($message, $replacements = []) {
        $CI =& get_instance();
        foreach ($replacements as $key => $value) {
            $message = str_replace('{' . $key . '}', $value, $message);
        }
        $CI->session->set_flashdata('success', $message);
    }
}

if (!function_exists('flashdata_error')) {
    function flashdata_error($message, $replacements = []) {
        $CI =& get_instance();
        foreach ($replacements as $key => $value) {
            $message = str_replace('{' . $key . '}', $value, $message);
        }
        $CI->session->set_flashdata('error', $message);
    }
}

if (!function_exists('flashdata_warning')) {
    function flashdata_warning($message, $replacements = []) {
        $CI =& get_instance();
        foreach ($replacements as $key => $value) {
            $message = str_replace('{' . $key . '}', $value, $message);
        }
        $CI->session->set_flashdata('warning', $message);
    }
}

if (!function_exists('flashdata_info')) {
    function flashdata_info($message, $replacements = []) {
        $CI =& get_instance();
        foreach ($replacements as $key => $value) {
            $message = str_replace('{' . $key . '}', $value, $message);
        }
        $CI->session->set_flashdata('info', $message);
    }
}