<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Vendorpurchasereport extends Admin_Controller {
/*
| -----------------------------------------------------
| PRODUCT NAME: 	INILABS SCHOOL MANAGEMENT SYSTEM
| -----------------------------------------------------
| AUTHOR:			INILABS TEAM
| -----------------------------------------------------
| EMAIL:			info@inilabs.net
| -----------------------------------------------------
| COPYRIGHT:		RESERVED BY INILABS IT
| -----------------------------------------------------
| WEBSITE:			http://inilabs.net
| -----------------------------------------------------
*/
    function __construct() {
        parent::__construct();
        $this->load->model("productpurchase_m");
        $this->load->model("productcategory_m");
        $this->load->model("product_m");
        $this->load->model("productsupplier_m");
        $this->load->model("productwarehouse_m");
        $this->load->model("productpurchaseitem_m");
        $this->load->model("productpurchasepaid_m");
        $language = $this->session->userdata('lang');
        $this->lang->load('vendorpurchase', $language);
    }

    public function index() {
        $this->data['headerassets'] = array(
            'css' => array(
                'assets/datepicker/datepicker.css',
            ),
            'js' => array(
                'assets/datepicker/datepicker.js',
            )
        );
        $schoolyearID = $this->session->userdata('defaultschoolyearID');
        $filter = array(
            'create_date>='         =>  date('Y-m-d 00:00:00'),
            'create_date<='         =>  date('Y-m-d 23:59:59'),
            'schoolyearID' => $schoolyearID);
    
        if($_GET){
            $filter = array(
                'create_date>='         =>  $this->input->get('start_date'),
                'create_date<='         =>  $this->input->get('end_date'),
                'schoolyearID' => $schoolyearID
            );
        }
        $this->data['productpurchases'] = $this->productpurchase_m->get_order_by_productpurchase($filter);

        $this->data['get_all_holidays'] = $this->getHolidaysSession();
        
        $this->data['productsuppliers'] = pluck($this->productsupplier_m->get_productsupplier(), 'productsuppliercompanyname', 'productsupplierID');
        
        $this->data['grandtotalandpaid'] = $this->grandtotalandpaid($this->data['productpurchases'], $schoolyearID);
    
        $grouped = array_reduce($this->data['productpurchases'], function ($carry, $item) {
            if (!array_key_exists($item->productsupplierID, $carry)) {
                $carry[$item->productsupplierID] = [
                    'productsupplierID' => $item->productsupplierID,
                    'grandtotal' => 0,
                    'amountpaid' => 0,
                    'balance' => 0,
                ];
            }
            $carry[$item->productsupplierID]['grandtotal'] += isset($this->data['grandtotalandpaid']['grandtotal'][$item->productpurchaseID])? $this->data['grandtotalandpaid']['grandtotal'][$item->productpurchaseID]: 0;
            $carry[$item->productsupplierID]['amountpaid'] += isset($this->data['grandtotalandpaid']['totalpaid'][$item->productpurchaseID])? $this->data['grandtotalandpaid']['totalpaid'][$item->productpurchaseID]: 0;
            if(isset($this->data['grandtotalandpaid']['grandtotal'][$item->productpurchaseID]) && isset($this->data['grandtotalandpaid']['totalpaid'][$item->productpurchaseID])) {
                $balance = ($this->data['grandtotalandpaid']['grandtotal'][$item->productpurchaseID] - $this->data['grandtotalandpaid']['totalpaid'][$item->productpurchaseID]);
                $carry[$item->productsupplierID]['balance'] += $balance;
            } elseif(isset($this->data['grandtotalandpaid']['grandtotal'][$item->productpurchaseID])) {
                $balance = $this->data['grandtotalandpaid']['grandtotal'][$item->productpurchaseID];
                $carry[$item->productsupplierID]['balance'] += $balance;
            } elseif(isset($this->data['grandtotalandpaid']['totalpaid'][$item->productpurchaseID])) {
                $balance = (0-$this->data['grandtotalandpaid']['totalpaid'][$item->productpurchaseID]);
                $carry[$item->productsupplierID]['balance'] += $balance;
            }
            return $carry;
        }, []);
        $this->data['grouped_purchases'] = array_values($grouped);
        $this->data["subview"] = "new_reports/vendorPurchaseReport";
        $this->load->view('_layout_main', $this->data);
    }
    


    private function grandtotalandpaid($productpurchases, $schoolyearID) {
        $retArray = [];
        
        $productpurchaseitems = pluck_multi_array($this->productpurchaseitem_m->get_order_by_productpurchaseitem(array('schoolyearID' => $schoolyearID)), 'obj', 'productpurchaseID');

        $productpurchasepaids = pluck_multi_array($this->productpurchasepaid_m->get_order_by_productpurchasepaid(array('schoolyearID' => $schoolyearID)), 'obj', 'productpurchaseID');

        if(customCompute($productpurchases)) {
            foreach ($productpurchases as $productpurchase) {
                if(isset($productpurchaseitems[$productpurchase->productpurchaseID])) {
                    if(customCompute($productpurchaseitems[$productpurchase->productpurchaseID])) {
                        foreach ($productpurchaseitems[$productpurchase->productpurchaseID] as $productpurchaseitem) {
                            if(isset($retArray['grandtotal'][$productpurchaseitem->productpurchaseID])) {
                                $retArray['grandtotal'][$productpurchaseitem->productpurchaseID] = (($retArray['grandtotal'][$productpurchaseitem->productpurchaseID]) + ($productpurchaseitem->productpurchaseunitprice*$productpurchaseitem->productpurchasequantity));
                            } else {
                                $retArray['grandtotal'][$productpurchaseitem->productpurchaseID] = ($productpurchaseitem->productpurchaseunitprice*$productpurchaseitem->productpurchasequantity);
                            }
                        }
                    }
                }

                if(isset($productpurchasepaids[$productpurchase->productpurchaseID])) {
                    if(customCompute($productpurchasepaids[$productpurchase->productpurchaseID])) {
                        foreach ($productpurchasepaids[$productpurchase->productpurchaseID] as $productpurchasepaid) {
                            if(isset($retArray['totalpaid'][$productpurchasepaid->productpurchaseID])) {
                                $retArray['totalpaid'][$productpurchasepaid->productpurchaseID] = (($retArray['totalpaid'][$productpurchasepaid->productpurchaseID]) + ($productpurchasepaid->productpurchasepaidamount));
                            } else {
                                $retArray['totalpaid'][$productpurchasepaid->productpurchaseID] = ($productpurchasepaid->productpurchasepaidamount);
                            }
                        }
                    }
                }
            }
        }
        return $retArray;
    }    
    
}