<?php if ( ! defined('BASEPATH')) exit('No direct script allowed');

class Student_attendance_report extends Admin_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model("subject_m");
        $this->load->model('section_m');
        $this->load->model("classes_m");
        $this->load->model("studentrelation_m");
        $this->load->model("sattendance_m");
        $this->load->model("subjectattendance_m");
        $this->load->model("leaveapplication_m");
        $language = $this->session->userdata('lang');
        $this->lang->load('attendancereport', $language);
    }

    public function index()
    {
        $this->data['classes'] = $this->classes_m->general_get_classes();
        $this->data['get_all_holidays'] = $this->getHolidaysSession();

        $this->data['headerassets'] = array(
            'css' => array(
                'assets/datepicker/datepicker.css',
                'assets/select2/css/select2.css',
                'assets/select2/css/select2-bootstrap.css'
            ),
            'js' => array(
                'assets/datepicker/datepicker.js',
                'assets/select2/select2.js',
                'assets/jquery-validate/jquery.validate.min.js'
            )
        );

        $filter = array();

        // Prepare summary filters
        $summaryFilters = [
            'date' => date('Y-m-d'), // default is today
            'srclassesID' => null,   // CHANGED KEY
            'srsectionID' => null,   // CHANGED KEY
            'schoolyearID' => $this->session->userdata('defaultschoolyearID')
        ];

        if($_GET){
            if($this->input->get('start_date')) {
                $filter['check_date>='] = $this->input->get('start_date');
                $summaryFilters['date'] = $this->input->get('start_date');
            }
            if($this->input->get('end_date')) {
                $filter['check_date<='] = $this->input->get('end_date');
            }
            if($this->input->get('sectionID')) {
                $filter['student.sectionID'] = $this->input->get('sectionID');
                $summaryFilters['srsectionID'] = $this->input->get('sectionID'); // CHANGED KEY
            }
            if($this->input->get('classesID')) {
                $filter['student.classesID'] = $this->input->get('classesID');
                $summaryFilters['srclassesID'] = $this->input->get('classesID'); // CHANGED KEY
            }
        } else {
            $filter['clock_in_out.check_date'] = date('Y-m-d');
        }

        // Attendance report table data
        $this->data['attendence_report'] = $this->sattendance_m->get_attendance_report($filter);

        // Summary cards data
        $summary = $this->sattendance_m->get_attendance_summary($summaryFilters);
        $this->data = array_merge($this->data, $summary);

        $this->data["subview"] = "report/attendance/StudentAttendanceReport";
        $this->load->view('_layout_main', $this->data);
    }
}