<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Smstemplate extends Admin_Controller {
/*
| -----------------------------------------------------
| PRODUCT NAME: 	INILABS SCHOOL MANAGEMENT SYSTEM
| -----------------------------------------------------
| AUTHOR:			INILABS TEAM
| -----------------------------------------------------
| EMAIL:			info@inilabs.net
| -----------------------------------------------------
| COPYRIGHT:		RESERVED BY INILABS IT
| -----------------------------------------------------
| WEBSITE:			http://inilabs.net
| -----------------------------------------------------
*/
	function __construct() {
		parent::__construct();
		$this->load->model('usertype_m');
		$this->load->model("mailandsmstemplate_m");
		$this->load->model("mailandsmstemplatetag_m");
		$language = $this->session->userdata('lang');
		$this->lang->load('mailandsmstemplate', $language);
	}

	public function index() {
		$usertypes = $this->usertype_m->get_usertype();
		$this->data['usertypes'] = $usertypes;
		$this->all_tag($usertypes);
		$this->data['templates'] = $this->mailandsmstemplate_m->get_order_by_mailandsmstemplate_with_usertypeID();
		$this->data["subview"] = "mailandsmstemplate/add";
		$this->load->view('_layout_main', $this->data);
	}

	protected function rules_email() {
		$rules = array(
				array(
					'field' => 'type',
					'label' => '',
					'rules' => 'trim|required|xss_clean|max_length[10]'
				),
				array(
					'field' => 'email_name',
					'label' => $this->lang->line("mailandsmstemplate_name"),
					'rules' => 'trim|required|xss_clean|max_length[128]'
				),
				array(
					'field' => 'email_user',
					'label' => $this->lang->line("mailandsmstemplate_user"),
					'rules' => 'trim|required|xss_clean|max_length[15]|callback_email_user_check'
				),
				array(
					'field' => 'email_template',
					'label' => $this->lang->line("mailandsmstemplate_template"),
					'rules' => 'trim|required|xss_clean|max_length[20000]'
				)
			);
		return $rules;
	}

	protected function rules_sms() {
		$rules = array(
				array(
					'field' => 'type',
					'label' => '',
					'rules' => 'trim|required|xss_clean|max_length[10]'
				),
				array(
					'field' => 'sms_name',
					'label' => $this->lang->line("mailandsmstemplate_name"),
					'rules' => 'trim|required|xss_clean|max_length[128]'
				),
				array(
					'field' => 'sms_user',
					'label' => $this->lang->line("mailandsmstemplate_user"),
					'rules' => 'trim|required|xss_clean|max_length[15]|callback_sms_user_check'
				),
				array(
					'field' => 'sms_template',
					'label' => $this->lang->line("mailandsmstemplate_template"),
					'rules' => 'trim|required|xss_clean|max_length[1500]'
				)
			);
		return $rules;
	}

	public function save_template(){
		try{
			$id = $this->input->post('template_id');
			$array = array(
				'name' => $this->input->post('template_name'),
				'usertypeID' => $this->input->post('userType'),
				'template' => $this->input->post('sms_message'),
				'status' => $this->input->post('status') == 'on' ? 1: 0
			);

			$this->mailandsmstemplate_m->update_mailandsmstemplate($array, $id);
			echo json_encode(array(
                "status" => 'success',
                "message" => 'Template saved successfully',
            ));
		} catch(\Exception $e){
            echo json_encode(array(
                "status" => 'error',
                "message" => $e->getMessage(),
            ));
        }
		
	}


	function email_user_check() {
		if($this->input->post('email_user') == 'select') {
			$this->form_validation->set_message("email_user_check", "The %s field is required");
	     	return FALSE;
		}
		return TRUE;
	}

	function sms_user_check() {
		if($this->input->post('sms_user') == 'select') {
			$this->form_validation->set_message("sms_user_check", "The %s field is required");
	     	return FALSE;
		}
		return TRUE;
	}

	public function view() {
		$id = htmlentities(escapeString($this->uri->segment(3)));
		if((int)$id) {
			$this->data['mailandsmstemplate'] = $this->mailandsmstemplate_m->get_mailandsmstemplate($id);
			if($this->data['mailandsmstemplate']) {
				$this->data["subview"] = "mailandsmstemplate/view";
				$this->load->view('_layout_main', $this->data);
			} else {
				$this->data["subview"] = "error";
				$this->load->view('_layout_main', $this->data);
			}
		} else {
			$this->data["subview"] = "error";
			$this->load->view('_layout_main', $this->data);
		}
	}

	public function delete() {
		$id = htmlentities(escapeString($this->uri->segment(3)));
		if((int)$id) {
			$this->data['mailandsmstemplate'] = $this->mailandsmstemplate_m->get_mailandsmstemplate($id);
			if($this->data['mailandsmstemplate']) {
				$this->mailandsmstemplate_m->delete_mailandsmstemplate($id);
				$this->session->set_flashdata('success', $this->lang->line('menu_success'));
				redirect(base_url("mailandsmstemplate/index"));
			} else {
				redirect(base_url("mailandsmstemplate/index"));
			}
		} else {
			redirect(base_url("mailandsmstemplate/index"));
		}
	}

	public function all_tag($usertypes) {
		if(is_array($usertypes)) {
 			foreach ($usertypes as $key => $usertype) {
				if($usertype->usertypeID == 2) {
					$teachertags = $this->mailandsmstemplatetag_m->get_order_by_mailandsmstemplatetag(array('usertypeID' => $usertype->usertypeID));

					$flag = '';
					if(customCompute($teachertags)) {
						foreach ($teachertags as $teachertagkey => $teachertag) {
							$flag .= '<input class="btn bg-black btn-xs email_alltag sms_alltag" type="button" value="'.$teachertag->tagname.'"> ';
						}
					}

					$this->data['teachers'] = $flag;
				} elseif($usertype->usertypeID == 3) {
					$studenttags = $this->mailandsmstemplatetag_m->get_order_by_mailandsmstemplatetag(array('usertypeID' => $usertype->usertypeID));
					$flag = '';
					if(customCompute($studenttags)) {
						foreach ($studenttags as $studenttagkey => $studenttag) {
							$flag .= '<input class="btn bg-black btn-xs email_alltag sms_alltag" type="button" value="'.$studenttag->tagname.'"> ';
						}
					}

					$this->data['students'] = $flag;
				} elseif($usertype->usertypeID == 4) {
					$parentstags = $this->mailandsmstemplatetag_m->get_order_by_mailandsmstemplatetag(array('usertypeID' => $usertype->usertypeID));

					$flag = '';
					if(customCompute($parentstags)) {
						foreach ($parentstags as $parentstagkey => $parentstag) {
							$flag .= '<input class="btn bg-black btn-xs email_alltag sms_alltag" type="button" value="'.$parentstag->tagname.'"> ';
						}
					}

					$this->data['parents'] = $flag;
				} else {
					$usertags = $this->mailandsmstemplatetag_m->get_order_by_mailandsmstemplatetag(array('usertypeID' => 1));

					$flag = '';
					if(customCompute($usertags)) {
						foreach ($usertags as $usertagkey => $usertag) {
							$flag .= '<input class="btn bg-black btn-xs email_alltag sms_alltag" type="button" value="'.$usertag->tagname.'"> ';
						}
					}

					$this->data['users'] = $flag;
				}
			}
		}
	}
}
