<?php

class Lunch extends Admin_Controller
{
    function __construct()
    {
        parent::__construct();

        $this->load->model("student_m");
        $this->load->model("parents_m");
        $this->load->model("sattendance_m");
        $this->load->model("tattendance_m");
        $this->load->model('uattendance_m');
        $this->load->model("teacher_m");
        $this->load->model("classes_m");
        $this->load->model("user_m");
        $this->load->model("grade_m");
        $this->load->model("usertype_m");
        $this->load->model("maininvoice_m");
        $this->load->model("setting_m");
        $this->load->model('studentrelation_m');
        $this->load->model('leaveapplication_m');

        $this->load->model('frontend_setting_m');
        $this->load->helper('frontenddata');
        $this->load->model('lunch_m');
        $this->load->model('invoice_m');
        $this->load->model('wallet_m');
        $this->load->library('sms/skooly_init');

        $language = $this->session->userdata('lang');
        $this->lang->load('lunch', $language);
    }


    public function index()
    {
        // $newFileName = FCPATH."assets";
        // print_r($newFileName);
        // $myfile = fopen($newFileName."/newfile.txt", "a");
        // $txt = "Message Sent\n";
        // print_r(fwrite($myfile, $txt));
        // fclose($myfile);
        // die();
        $this->data['headerassets'] = array(
            'css' => array(
                'assets/select2/css/select2.css',
                'assets/select2/css/select2-bootstrap.css',
                'assets/datepicker/datepicker.css'
            ),
            'js' => array(
                'assets/select2/select2.js',
                'assets/datepicker/datepicker.js',
            )
        );
        // print_r($this->session->userdata('usertypeID'));
        // die();
        $this->data['footerassets'] = array(
            'js' => array(
                'assets/html5-qrcode/html5-qrcode.min.js'
            )
        );

        $this->data['date'] = date("d-m-Y");
        $this->data['holidays'] =  $this->getHolidaysSession();
        $this->data['getWeekendDays'] =  $this->getWeekendDaysSession();



        $this->data["subview"] = "lunch/index";
        $this->load->view('_layout_main', $this->data);
    }
    
    public function verify_attendance($qr_token)
    {

        $data = array();
        $user = array();
        $where = array();
        $qr_data = explode("-",$qr_token);

        if(count($qr_data) < 2){
            echo 0;
            exit;
        }

        if ($qr_data[0] == 'S') {
            $user = $this->student_m->get_select_student('*',array(
                'qr_token' => $qr_token
            ))[0];

            if(!empty($user)){
                $where = array(
                    'student.studentID' => $user->studentID,
                    'clock_in_out.usertypeID' => 3,
                    'check_date'=>date('Y-m-d')
                );
                $user->ID = $user->studentID;
            }

            $data = $this->sattendance_m->verify_attendence($where);

        } elseif ($qr_data[0] == "T") {
            $user = $this->teacher_m->get_select_teacher('*',array(
                'qr_token' => $qr_token
            ))[0];

            if(!empty($user)){
                $where = array(
                    'teacher.teacherID' => $user->teacherID,
                    'clock_in_out.usertypeID' => $user->usertypeID,
                    'check_date'=>date('Y-m-d')
                );

                $user->ID = $user->teacherID;
            }

            $data = $this->tattendance_m->verify_attendence($where);

        } else {
            $user = $this->user_m->get_select_user('*',array(
                'qr_token' => $qr_token
            ))[0];

            if(!empty($user)){
                $where = array(
                    'user.userID' => $user->userID,
                    'clock_in_out.usertypeID' => $user->usertypeID,
                    'check_date'=>date('Y-m-d')
                );
                $user->ID = $user->userID;
            }
            $data = $this->uattendance_m->verify_attendence($where);
        }


        $data = (array)$data;

        if(!empty($user)){
            $user_type = $this->usertype_m->get_usertype($user->usertypeID);
            if (!empty($data)) {
                return json_encode(array(
                    "ID" => $user->ID,
                    "usertypeID" => $user->usertypeID,
                    "photo" => profileviewimage($user->photo),
                    "name" => $user->name,
                    "user_type" =>$user_type->usertype,
                    "clock_in" => $data['clock_in'],
                    "clock_out" => $data['clock_out'],
                ));
            } else {
                return json_encode(array(
                    "ID" => $user->ID,
                    "usertypeID" => $user->usertypeID,
                    "photo" => profileviewimage($user->photo),
                    "name" => $user->name,
                    "user_type" =>$user_type->usertype,
                ));
            }
        } else {
            echo 0;
        }
        exit;
    }

    public function lunch_break(){
        $qr_token = $this->input->post('qr_token');
        $custom_amount = $this->input->post('custom_amount');

        if($this->input->post('lunch_break') == 'break'){            
            $this->take_break($qr_token, $custom_amount);
        }elseif($this->input->post('lunch_break') == 'lunch'){
            $this->take_lunch($qr_token, $custom_amount);
        }
    }

    public function take_lunch($qr_token, $custom_amount)
    {  
        if(allowTransaction()){
            if($qr_token != null){
                $response = json_decode($this->verify_attendance($qr_token), true);
                $usertype = $response['usertypeID'];
                $user_ID = $response['ID'];
                $day = abs(date('d'));
    
                $lunch_setting = $this->frontend_setting_m->get_frontend_setting();
                $schoolyearID = $this->session->userdata('defaultschoolyearID');
                
                $type = 'lunch';
    
                if($custom_amount != null){
                    $lunchAmount = floatval($custom_amount);
                }else{
                    $lunchAmount = $lunch_setting->lunch;
                }
    
                $invoice = $this->invoice_m->get_single_invoice(array('studentID'=> $user_ID, 'feetype'=> 'LUNCH', 'isLiveInvoice'=> 1));
                
                if($invoice){
                    $paidstatus = ($invoice->paidstatus == 2 || $invoice->paidstatus == 1) ? 1 : 0;
    
                    $updated_amount = (float) $invoice->amount + (float) $lunchAmount;
                    $update_data = array('amount' => $updated_amount, 'paidstatus' => $paidstatus);
                    $this->invoice_m->update_invoice($update_data, $invoice->invoiceID);
                    $this->maininvoice_m->update_maininvoice(array('maininvoicestatus' => $paidstatus), $invoice->maininvoiceID);
                    // foreach ($invoices as $invoice) {
                    //     if ($invoice->isLiveInvoice == 1) {
                    //         $updated_amount = $invoice->amount + $lunchAmount;
                    
                    //         $update_data = array('amount' => $updated_amount);
                    //         $this->invoice_m->update_invoice($update_data, $invoice->invoiceID);
                    //         break;
                    //     }
                    // }
                }else{
                    // $this->processData($user_ID, $lunchAmount, $type, $schoolyearID);  
                }  
                
                $student = $this->studentrelation_m->get_single_student(array('srstudentID' => $user_ID), TRUE);         
                
                //check student exist
                if (!empty($student)) {
                    $user_type = $this->usertype_m->get_usertype($student->usertypeID);
                    $ref = getTrx();                
    
                    $lunchData = array(
                        'amount'        => $lunchAmount,
                        'studentID'     => $user_ID,
                        'type'          => 'lunch',
                        'referenceno'   => $ref,
                        'time'          => date('H:i:s'),
                        'date'          => date("Y-m-d H:i:s"),
                        'schoolyearID' => $schoolyearID
                    );
                    $this->lunch_m->insert_lunch($lunchData);
                    $this->initializeInvoiceCharge($student->srstudentID, $lunchAmount);
                        
                    update_fee_balance([$student->srstudentID], $schoolyearID);
    
                    SmsService::scanMealLunch($student, 3, $this->data, $lunchAmount); 
    
                    echo json_encode(array(
                        "photo" => profileviewimage($student->photo),
                        'name' => $student->name, 
                        "user_type" =>$user_type->usertype, 
                        'adm' => $student->registerNO,                          
                        'lunch_break' => 'Lunch',
                        'ref' => $ref,
                        'time' => date('H:i:s')
                    ));
                    exit;
                } else {
    
                    echo json_encode(array(
                        'status' => 'error', 
                        'message' => 'Student does not exist in the current teacher class, please enter correct roll no ',
                    ));
                    exit;
                }
            }        
        } else {
    
            echo json_encode(array(
                'status' => 'error', 
                'message' => 'Your SMS balance is low. Kindly recharge.',
            ));
            exit;
        }         
    }

    public function take_break($qr_token, $custom_amount)
    {   
        if(allowTransaction()){
            if($qr_token != null){
                $response = json_decode($this->verify_attendance($qr_token), true);
                $usertype = $response['usertypeID'];
                $user_ID = $response['ID'];
                $day = abs(date('d'));
    
                // $usertype = 3;
                $student = $this->studentrelation_m->get_single_student(array('srstudentID' => $user_ID), TRUE);
                
                $lunch_setting = $this->frontend_setting_m->get_frontend_setting();
                $schoolyearID = $this->session->userdata('defaultschoolyearID');
                
                $type = 'break';
    
                if($custom_amount != null){
                    $lunchAmount = floatval($custom_amount);
                }else{
                    $lunchAmount = $lunch_setting->break;
                } 
                
                $invoice = $this->invoice_m->get_single_invoice(array('studentID'=> $user_ID, 'feetype'=> 'LUNCH', 'isLiveInvoice'=> 1));
             
                if($invoice){
                    $paidstatus = ($invoice->paidstatus == 2 || $invoice->paidstatus == 1) ? 1 : 0;
    
                    $updated_amount = (float) $invoice->amount + (float) $lunchAmount;
                    $update_data = array('amount' => $updated_amount, 'paidstatus' => $paidstatus);
                    $this->invoice_m->update_invoice($update_data, $invoice->invoiceID);
                    $this->maininvoice_m->update_maininvoice(array('maininvoicestatus' => $paidstatus), $invoice->maininvoiceID);
                }else{
                    // $this->processData($user_ID, $lunchAmount, $type, $schoolyearID);  
                }         
             
                if (!empty($student)) {
                    $user_type = $this->usertype_m->get_usertype($student->usertypeID);                
                    $ref = getTrx(); 
                    $lunchData = array(
                        'amount'        => $lunchAmount,
                        'studentID'     => $user_ID,
                        'type'          => $type,
                        'referenceno'   => $ref,
                        'time'          => date('H:i:s'),
                        'date'          => date("Y-m-d H:i:s"),
                        'schoolyearID' => $schoolyearID
                    );
                    $this->lunch_m->insert_lunch($lunchData);
                    $this->initializeInvoiceCharge($student->srstudentID, $lunchAmount);
                    update_fee_balance([$student->srstudentID], $schoolyearID);
    
                    SmsService::scanMealBreak($student, 3, $this->data, $lunchAmount);
                    
                    echo json_encode(array(
                        "photo" => profileviewimage($student->photo),
                        'name' => $student->name, 
                        "user_type" =>$user_type->usertype, 
                        'adm' => $student->registerNO,                          
                        'lunch_break' => 'Break',
                        'ref' => $ref,
                        'time' => date('H:i:s')
                    ));
                    exit;
                } else {
    
                    echo json_encode(array(
                        'status' => 'error', 
                        'message' => 'Student does not exist in the current teacher class, please enter correct roll no ',
                    ));
                    exit;
                }
            }         
        }else {
    
            echo json_encode(array(
                'status' => 'error', 
                'message' => 'Your SMS balance is low. Kindly recharge.',
            ));
            exit;
        }
                       
    }  

    public function initializeInvoiceCharge($studentID, $lunchAmount){
        $student = $this->studentrelation_m->get_single_student(array('srstudentID' => $studentID), TRUE);
        $walletData = $this->wallet_m->getWallet(['studentID' => $studentID]);
        $currentWalletBalance = $walletData->balance ?? 0;
        if($currentWalletBalance > $lunchAmount){
            processStudentPayment($student->srstudentID, $lunchAmount, 'Wallet');
        }
        
    }
    
    public function processDataa($lunchData, $user_ID, $lunchAmount, $type, $schoolyearID){
 
        $this->db->trans_start();

        $this->db->select('*');
        $this->db->from('wallets');
        $this->db->where('studentID', $user_ID);
        $this->db->order_by('modify_date', 'DESC');
        $this->db->limit(1);
        $query = $this->db->get();
        $row = $query->row();

        if ($row && (time() - strtotime($row->modify_date) < 60)) {
            
        } else {         

            $this->db->insert('lunchlogs', $lunchData);

            $walletData = array(
                'balance' => round(floatval($row->balance) - floatval($lunchAmount)),
                'modify_date' => date("Y-m-d H:i:s")
            );

            $this->wallet_m->update_wallet( $walletData, $row->id);

                $transactionData = array(
                    'studentID' => (int) $user_ID,
                    'amount' => $lunchAmount,
                    'post_balance' => round(floatval($row->balance) - floatval($lunchAmount)),
                    'trx_type' => 'debit',
                    'walletID' => (int) $row->id,
                    'referenceNO' => getTrx(),
                    'details' => "KES $lunchAmount used for $type",
                    'create_date' => date("Y-m-d H:i:s")

                );
            $this->db->insert('wallet_transactions', $transactionData);
        }

        $this->db->trans_complete();
        update_fee_balance([$user_ID],$schoolyearID);
    }
    public function processData($user_ID, $lunchAmount, $type){
        
        
        $this->db->select('*');
        $this->db->from('wallets');
        $this->db->where('studentID', $user_ID);
        $this->db->order_by('modify_date', 'DESC');
        $this->db->limit(1);
        $query = $this->db->get();
        $row = $query->row();

        if($row){
            $walletData = array(
                'balance' => round(floatval($row->balance) - floatval($lunchAmount)),
                'modify_date' => date("Y-m-d H:i:s")
            );
    
            $this->wallet_m->update_wallet( $walletData, $row->id);
    
            $transactionData = array(
                'studentID' => (int) $user_ID,
                'amount' => $lunchAmount,
                'post_balance' => round(floatval($row->balance) - floatval($lunchAmount)),
                'trx_type' => 'debit',
                'walletID' => (int) $row->id,
                'referenceNO' => getTrx(),
                'details' => "KES $lunchAmount used for $type",
                'create_date' => date("Y-m-d H:i:s")
    
            ); 
    
            $this->db->insert('wallet_transactions', $transactionData); 
        }
               
    } 
}