<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Itempurchasereport extends Admin_Controller {
/*
| -----------------------------------------------------
| PRODUCT NAME: 	INILABS SCHOOL MANAGEMENT SYSTEM
| -----------------------------------------------------
| AUTHOR:			INILABS TEAM
| -----------------------------------------------------
| EMAIL:			info@inilabs.net
| -----------------------------------------------------
| COPYRIGHT:		RESERVED BY INILABS IT
| -----------------------------------------------------
| WEBSITE:			http://inilabs.net
| -----------------------------------------------------
*/
    function __construct() {
        parent::__construct();
        $this->load->model("productpurchase_m");
        $this->load->model("productcategory_m");
        $this->load->model("product_m");
        $this->load->model("productsupplier_m");
        $this->load->model("productwarehouse_m");
        $this->load->model("productpurchaseitem_m");
        $this->load->model("productpurchasepaid_m");
        $language = $this->session->userdata('lang');
        $this->lang->load('itempurchase', $language);
    }

    public function index() {
     
        $this->data['headerassets'] = array(
            'css' => array(
                'assets/datepicker/datepicker.css',
            ),
            'js' => array(
                'assets/datepicker/datepicker.js',
            )
        );
        // $schoolyearID = $this->session->userdata('defaultschoolyearID');
        $filter = array();
        if ($_GET) {
            if($this->input->get('start_date') || $this->input->get('end_date')){
                $filter['create_date>='] = $this->input->get('start_date') . ' ' . '00:00:00';
                $filter['create_date<='] = $this->input->get('end_date') . ' ' . '23:59:59';
            }
        }   

        $this->data['item_purchases'] = $this->productpurchase_m->get_data($filter);
        $this->data['get_all_holidays'] = $this->getHolidaysSession();
        $products = $this->product_m->get_products();
        $this->data['products'] = array();
        foreach($products as $product) {
            $this->data['products'][$product->productID] = array(
                'productname' => $product->productname,
                'productsellingprice' => $product->productbuyingprice
            );
        }

        $this->data["subview"] = "new_reports/itemPurchaseReport";       
        $this->load->view('_layout_main', $this->data);
    }
    
    
}