<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Idcardreport extends Admin_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('usertype_m');
        $this->load->model('classes_m');
        $this->load->model('section_m');
        $this->load->model('user_m');
        $this->load->model('systemadmin_m');
        $this->load->model('studentrelation_m');
        $this->load->model('teacher_m');
        $this->load->model('schoolyear_m');
        $this->load->model('site_m');
        $language = $this->session->userdata('lang');
        $this->lang->load('idcardreport', $language);
    }

    public function index() {
        // Load school/site info for use in views
        $this->data['siteinfos'] = $this->site_m->get_site();

        $this->data['headerassets'] = array(
            'css' => array(
                'assets/select2/css/select2.css',
                'assets/select2/css/select2-bootstrap.css'
            ),
            'js' => array(
                'assets/select2/select2.js'
            )
        );
        $this->data['usertypes'] = $this->usertype_m->get_usertype();
        $this->data['classes'] = $this->classes_m->general_get_classes();
        $this->data["subview"] = "report/idcard/IdcardReportView";
        $this->load->view('_layout_main', $this->data);
    }

    public function getIdcardReport() {
        $retArray['status'] = FALSE;
        $retArray['render'] = '';
        if($_POST) {
            // Load school/site info for use in views
            $this->data['siteinfos'] = $this->site_m->get_site();

            $usertypeID = $this->input->post('usertypeID');
            $classesID  = $this->input->post('classesID');
            $sectionID  = $this->input->post('sectionID');
            $userID     = $this->input->post('userID');

            $this->data['usertypeID'] = $usertypeID;
            $this->data['classesID'] = $classesID;
            $this->data['sectionID'] = $sectionID;
            $this->data['userID'] = $userID;

            // Example: get students for demonstration
            $this->data['idcards'] = $this->studentrelation_m->general_get_order_by_student([
                'srschoolyearID' => $this->session->userdata('defaultschoolyearID')
            ]);

            $retArray['status'] = TRUE;
            $retArray['render'] = $this->load->view('report/idcard/IdcardReport', $this->data, TRUE);
        } else {
            $retArray['render'] = '<div class="alert alert-danger">No data submitted.</div>';
        }
        echo json_encode($retArray);
    }
}