<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Mailandsms extends Admin_Controller
{
	/*
| -----------------------------------------------------
| PRODUCT NAME: 	INILABS SCHOOL MANAGEMENT SYSTEM
| -----------------------------------------------------
| AUTHOR:			INILABS TEAM
| -----------------------------------------------------
| EMAIL:			info@inilabs.net
| -----------------------------------------------------
| COPYRIGHT:		RESERVED BY INILABS IT
| -----------------------------------------------------
| WEBSITE:			http://inilabs.net
| -----------------------------------------------------
*/
	function __construct()
	{
		parent::__construct();
		$this->load->model('usertype_m');
		$this->load->model('systemadmin_m');
		$this->load->model('teacher_m');
		$this->load->model('student_m');
		$this->load->model('parents_m');
		$this->load->model('user_m');
		$this->load->model('classes_m');
		$this->load->model('section_m');
		$this->load->model("mark_m");
		$this->load->model("grade_m");
		$this->load->model("exam_m");
		$this->load->model('mailandsms_m');
		$this->load->model('mailandsmstemplate_m');
		$this->load->model('mailandsmstemplatetag_m');
		$this->load->model('studentgroup_m');
		$this->load->model('studentrelation_m');
		$this->load->model('emailsetting_m');
		$this->load->model('subject_m');
		$this->load->library("email");
		$this->load->model('payment_m');
		$this->load->library("inilabs", $this->data);
		$this->load->library('sms/skooly_init');

		$language = $this->session->userdata('lang');
		$this->lang->load('mailandsms', $language);
	}

	protected function rules_mail()
	{
		$rules = array(
			array(
				'field' => 'email_usertypeID',
				'label' => $this->lang->line("mailandsms_usertype"),
				'rules' => 'trim|required|xss_clean|max_length[15]|callback_check_email_usertypeID'
			),
			array(
				'field' => 'email_schoolyear',
				'label' => $this->lang->line("mailandsms_schoolyear"),
				'rules' => 'trim|xss_clean'
			),
			array(
				'field' => 'email_class',
				'label' => $this->lang->line("mailandsms_class"),
				'rules' => 'trim|xss_clean'
			),
			array(
				'field' => 'email_users',
				'label' => $this->lang->line("mailandsms_users"),
				'rules' => 'trim|xss_clean'
			),
			array(
				'field' => 'email_template',
				'label' => $this->lang->line("mailandsms_template"),
				'rules' => 'trim|xss_clean'
			),
			array(
				'field' => 'email_subject',
				'label' => $this->lang->line("mailandsms_subject"),
				'rules' => 'trim|required|xss_clean|max_length[255]'
			),
			array(
				'field' => 'email_message',
				'label' => $this->lang->line("mailandsms_message"),
				'rules' => 'trim|required|xss_clean|max_length[20000]'
			),
		);
		return $rules;
	}

	protected function rules_sms()
	{
		$rules = array(
			array(
				'field' => 'sms_usertypeID',
				'label' => $this->lang->line("mailandsms_usertype"),
				'rules' => 'trim|required|xss_clean|max_length[15]|callback_check_sms_usertypeID'
			),
			array(
				'field' => 'sms_schoolyear',
				'label' => $this->lang->line("mailandsms_schoolyear"),
				'rules' => 'trim|xss_clean'
			),
			array(
				'field' => 'sms_class',
				'label' => $this->lang->line("mailandsms_select_class"),
				'rules' => 'trim|xss_clean'
			),
			array(
				'field' => 'sms_users',
				'label' => $this->lang->line("mailandsms_users"),
				'rules' => 'trim|xss_clean'
			),
			array(
				'field' => 'sms_template',
				'label' => $this->lang->line("mailandsms_template"),
				'rules' => 'trim|xss_clean'
			),
			// array(
			// 	'field' => 'sms_getway',
			// 	'label' => $this->lang->line("mailandsms_getway"),
			// 	'rules' => 'trim|required|xss_clean|max_length[15]|callback_check_getway'
			// ),
			array(
				'field' => 'sms_message',
				'label' => $this->lang->line("mailandsms_message"),
				'rules' => 'trim|required|xss_clean|max_length[20000]'
			),
		);
		return $rules;
	}

	protected function rules_otheremail()
	{
		$rules = array(
			array(
				'field' => 'otheremail_name',
				'label' => $this->lang->line("mailandsms_name"),
				'rules' => 'trim|required|xss_clean'
			),
			array(
				'field' => 'otheremail_email',
				'label' => $this->lang->line("mailandsms_email"),
				'rules' => 'trim|required|xss_clean|valid_email'
			),
			array(
				'field' => 'otheremail_subject',
				'label' => $this->lang->line("mailandsms_subject"),
				'rules' => 'trim|required|xss_clean|max_length[255]'
			),
			array(
				'field' => 'otheremail_message',
				'label' => $this->lang->line("mailandsms_message"),
				'rules' => 'trim|required|xss_clean|max_length[20000]'
			)
		);
		return $rules;
	}

	protected function rules_othersms()
	{
		$rules = array(
			array(
				'field' => 'othersms_name',
				'label' => $this->lang->line("mailandsms_name"),
				'rules' => 'trim|required|xss_clean'
			),
			array(
				'field' => 'othersms_phone',
				'label' => $this->lang->line("mailandsms_phone"),
				'rules' => 'trim|required|xss_clean'
			),
			// array(
			// 	'field' => 'sms_getway',
			// 	'label' => $this->lang->line("mailandsms_getway"),
			// 	'rules' => 'trim|required|xss_clean|callback_unique_data|max_length[15]|callback_check_getway'
			// ),
			array(
				'field' => 'othersms_message',
				'label' => $this->lang->line("mailandsms_message"),
				'rules' => 'trim|required|xss_clean|max_length[20000]'
			),
		);
		return $rules;
	}

	public function index()
	{
		$this->data['mailandsmss'] = $this->mailandsms_m->get_mailandsms_with_usertypeID();
		$this->data["subview"] = "mailandsms/index";
		$this->load->view('_layout_main', $this->data);
	}

	public function add()
    {
        $this->data['headerassets'] = array(
            'css' => array(
                'assets/select2/css/select2.css',
                'assets/select2/css/select2-bootstrap.css',
                'assets/editor/jquery-te-1.4.0.css'
            ),
            'js' => array(
                'assets/select2/select2.js',
                'assets/editor/jquery-te-1.4.0.min.js'
            )
        );
        $this->data['usertypes'] = $this->usertype_m->get_usertype();
        $this->data['schoolyears'] = $this->schoolyear_m->get_schoolyear();
        $this->data['allClasses'] = $this->classes_m->general_get_classes();
        $this->data['sections'] = [];
        $classesID = $this->input->post("classesID");
        if ($classesID > 0) {
            $this->data['sections'] = $this->section_m->get_order_by_section(array("classesID" => $classesID));
        } else {
            $this->data['sections'] = [];
        }
    
        // Email post handling unchanged...
    
        $sms_usertypeID = 3;
        if ($sms_usertypeID && $sms_usertypeID != 'select') {
            $this->data['sms_usertypeID'] = $sms_usertypeID;
        } else {
            $this->data['sms_usertypeID'] = 'select';
        }
    
        if ($_POST) {
            $this->data['submittype'] = $this->input->post('type');
            if ($this->input->post('type') == "sms") {
                $rules = $this->rules_sms();
                $this->form_validation->set_rules($rules);
                if ($this->form_validation->run() == FALSE) {
                    $this->data['smsUserID'] = $this->input->post('sms_users');
                    $this->data['smsTemplateID'] = $this->input->post('sms_template');
                    $this->data['allStudents'] = $this->studentrelation_m->get_order_by_student(array('srschoolyearID' => $this->input->post('sms_schoolyear'), 'srclassesID' => $this->input->post('sms_class')));
                    $this->data['emailUserID'] = 0;
                    $this->data['emailTemplateID'] = 0;
                    $this->data["email"] = 0;
                    $this->data["sms"] = 1;
                    $this->data["otheremail"] = 0;
                    $this->data["othersms"] = 0;
                    $this->data["subview"] = "mailandsms/add";
                    $this->load->view('_layout_main', $this->data);
                } else {
                    $usertypeID = $this->input->post('sms_usertypeID');
                    $schoolyearID = $this->input->post('sms_schoolyear');
                    $message = $this->input->post('sms_message');
    
                    // Admins
                    if ($usertypeID == 1) {
                        $systemadminID = $this->input->post('sms_users');
                        if ($systemadminID == 'select') {
                            $multisystemadmins = $this->systemadmin_m->get_systemadmin();
                            if (customCompute($multisystemadmins)) {
                                foreach ($multisystemadmins as $admin) {
                                    sendSms(
                                        $admin->phone,
                                        SmsUtils::userConfigSMS($this->data, $message, $admin, 1),
                                        $admin->name,
                                        1,
                                        $admin->systemadminID,
                                        'mailandsms',
                                        'manual_send'
                                    );
                                }
                                redirect(base_url('mailandsms/index'));
                            } else {
                                $this->session->set_flashdata('error', $this->lang->line('mailandsms_notfound_error'));
                                redirect(base_url('mailandsms/add'));
                            }
                        } else {
                            $admin = $this->systemadmin_m->get_systemadmin($systemadminID);
                            if (customCompute($admin)) {
                                sendSms(
                                    $admin->phone,
                                    SmsUtils::userConfigSMS($this->data, $message, $admin, 1),
                                    $admin->name,
                                    1,
                                    $admin->systemadminID,
                                    'mailandsms',
                                    'manual_send'
                                );
                                redirect(base_url('mailandsms/index'));
                            } else {
                                $this->session->set_flashdata('error', $this->lang->line('mailandsms_notfound_error'));
                                redirect(base_url('mailandsms/add'));
                            }
                        }
                    }
                    // Teachers
                    elseif ($usertypeID == 2) {
                        $teacherID = $this->input->post('sms_users');
                        if ($teacherID == 'select') {
                            $multiteachers = $this->teacher_m->general_get_teacher();
                            if (customCompute($multiteachers)) {
                                foreach ($multiteachers as $teacher) {
                                    sendSms(
                                        $teacher->phone,
                                        SmsUtils::userConfigSMS($this->data, $message, $teacher, 2),
                                        $teacher->name,
                                        2,
                                        $teacher->teacherID,
                                        'mailandsms',
                                        'manual_send'
                                    );
                                }
                                redirect(base_url('mailandsms/index'));
                            } else {
                                $this->session->set_flashdata('error', $this->lang->line('mailandsms_notfound_error'));
                                redirect(base_url('mailandsms/add'));
                            }
                        } else {
                            $teacher = $this->teacher_m->general_get_teacher($teacherID);
                            if (customCompute($teacher)) {
                                sendSms(
                                    $teacher->phone,
                                    SmsUtils::userConfigSMS($this->data, $message, $teacher, 2),
                                    $teacher->name,
                                    2,
                                    $teacher->teacherID,
                                    'mailandsms',
                                    'manual_send'
                                );
                                redirect(base_url('mailandsms/index'));
                            } else {
                                $this->session->set_flashdata('error', $this->lang->line('mailandsms_notfound_error'));
                                redirect(base_url('mailandsms/add'));
                            }
                        }
                    }
                    // Students
                    elseif ($usertypeID == 3) {
                        $studentID = $this->input->post('sms_users');
                        $class = $this->input->post('sms_class');
                        $schoolyear = $this->input->post('sms_schoolyear');
                        if ($studentID == 'select') {
                            if ($class == 'select') {
                                if ($schoolyear == 'select') {
                                    $multiSchoolYearStudents = $this->studentrelation_m->general_get_student(TRUE);
                                    if (customCompute($multiSchoolYearStudents)) {
                                        foreach ($multiSchoolYearStudents as $student) {
                                            sendSms(
                                                $student->phone,
                                                SmsUtils::userConfigSMS($this->data, $message, $student, 3, 'celcom', $student->srschoolyearID),
                                                $student->name,
                                                3,
                                                $student->studentID,
                                                'mailandsms',
                                                'manual_send'
                                            );
                                        }
                                        redirect(base_url('mailandsms/index'));
                                    } else {
                                        $this->session->set_flashdata('error', $this->lang->line('mailandsms_notfound_error'));
                                        redirect(base_url('mailandsms/add'));
                                    }
                                } else {
                                    $singleSchoolYearStudents = $this->studentrelation_m->general_get_order_by_student(array('srschoolyearID' => $schoolyear), TRUE);
                                    if (customCompute($singleSchoolYearStudents)) {
                                        foreach ($singleSchoolYearStudents as $student) {
                                            sendSms(
                                                $student->phone,
                                                SmsUtils::userConfigSMS($this->data, $message, $student, 3, 'celcom', $schoolyear),
                                                $student->name,
                                                3,
                                                $student->studentID,
                                                'mailandsms',
                                                'manual_send'
                                            );
                                        }
                                        redirect(base_url('mailandsms/index'));
                                    } else {
                                        $this->session->set_flashdata('error', $this->lang->line('mailandsms_notfound_error'));
                                        redirect(base_url('mailandsms/add'));
                                    }
                                }
                            } else {
                                $singleSection = $this->input->post('sms_section');
                                if ((int)$singleSection) {
                                    $students = $this->studentrelation_m->general_get_order_by_student(array('srclassesID' => $class, 'srsectionID' => $singleSection, 'srschoolyearID' => $schoolyearID), TRUE);
                                } else {
                                    $students = $this->studentrelation_m->general_get_order_by_student(array('srclassesID' => $class, 'srschoolyearID' => $schoolyearID), TRUE);
                                }
                                if (customCompute($students)) {
                                    foreach ($students as $student) {
                                        sendSms(
                                            $student->phone,
                                            SmsUtils::userConfigSMS($this->data, $message, $student, 3, 'celcom', $schoolyearID),
                                            $student->name,
                                            3,
                                            $student->studentID,
                                            'mailandsms',
                                            'manual_send'
                                        );
                                    }
                                    redirect(base_url('mailandsms/index'));
                                } else {
                                    $this->session->set_flashdata('error', $this->lang->line('mailandsms_notfound_error'));
                                    redirect(base_url('mailandsms/add'));
                                }
                            }
                        } else {
                            $student = $this->studentrelation_m->general_get_single_student(array('srstudentID' => $studentID, 'srschoolyearID' => $schoolyearID), TRUE);
                            if (customCompute($student)) {
                                sendSms(
                                    $student->phone,
                                    SmsUtils::userConfigSMS($this->data, $message, $student, 3, 'celcom', $schoolyearID),
                                    $student->name,
                                    3,
                                    $student->studentID,
                                    'mailandsms',
                                    'manual_send'
                                );
                                redirect(base_url('mailandsms/index'));
                            } else {
                                $this->session->set_flashdata('error', $this->lang->line('mailandsms_notfound_error'));
                                redirect(base_url('mailandsms/add'));
                            }
                        }
                    }
                    // Parents
                    elseif ($usertypeID == 4) {
                        $parentsID = $this->input->post('sms_users');
                        if ($parentsID == 'select') {
                            $multiparents = $this->parents_m->get_parents();
                            if (customCompute($multiparents)) {
                                foreach ($multiparents as $parent) {
                                    sendSms(
                                        $parent->phone,
                                        SmsUtils::userConfigSMS($this->data, $message, $parent, 4),
                                        $parent->name,
                                        4,
                                        $parent->parentsID,
                                        'mailandsms',
                                        'manual_send'
                                    );
                                }
                                redirect(base_url('mailandsms/index'));
                            } else {
                                $this->session->set_flashdata('error', $this->lang->line('mailandsms_notfound_error'));
                                redirect(base_url('mailandsms/add'));
                            }
                        } else {
                            $parent = $this->parents_m->get_parents($parentsID);
                            if (customCompute($parent)) {
                                sendSms(
                                    $parent->phone,
                                    SmsUtils::userConfigSMS($this->data, $message, $parent, 4),
                                    $parent->name,
                                    4,
                                    $parent->parentsID,
                                    'mailandsms',
                                    'manual_send'
                                );
                                redirect(base_url('mailandsms/index'));
                            } else {
                                $this->session->set_flashdata('error', $this->lang->line('mailandsms_notfound_error'));
                                redirect(base_url('mailandsms/add'));
                            }
                        }
                    }
                    // Users
                    else {
                        $userID = $this->input->post('sms_users');
                        if ($userID == 'select') {
                            $multiusers = $this->user_m->get_order_by_user(array('usertypeID' => $usertypeID));
                            if (customCompute($multiusers)) {
                                foreach ($multiusers as $user) {
                                    sendSms(
                                        $user->phone,
                                        SmsUtils::userConfigSMS($this->data, $message, $user, $usertypeID),
                                        $user->name,
                                        $usertypeID,
                                        $user->userID,
                                        'mailandsms',
                                        'manual_send'
                                    );
                                }
                                redirect(base_url('mailandsms/index'));
                            } else {
                                $this->session->set_flashdata('error', $this->lang->line('mailandsms_notfound_error'));
                                redirect(base_url('mailandsms/add'));
                            }
                        } else {
                            $user = $this->user_m->get_user($userID);
                            if (customCompute($user)) {
                                sendSms(
                                    $user->phone,
                                    SmsUtils::userConfigSMS($this->data, $message, $user, $usertypeID),
                                    $user->name,
                                    $usertypeID,
                                    $user->userID,
                                    'mailandsms',
                                    'manual_send'
                                );
                                redirect(base_url('mailandsms/index'));
                            } else {
                                $this->session->set_flashdata('error', $this->lang->line('mailandsms_notfound_error'));
                                redirect(base_url('mailandsms/add'));
                            }
                        }
                    }
                }
            } elseif ($this->input->post('type') == "othersms") {
                $rules = $this->rules_othersms();
                $this->form_validation->set_rules($rules);
                if ($this->form_validation->run() == FALSE) {
                    $this->data['emailUserID'] = 0;
                    $this->data['emailTemplateID'] = 0;
                    $this->data['allStudents'] = [];
                    $this->data['smsUserID'] = 0;
                    $this->data['smsTemplateID'] = 0;
                    $this->data["email"] = 0;
                    $this->data["sms"] = 0;
                    $this->data["otheremail"] = 0;
                    $this->data["othersms"] = 1;
                    $this->data["subview"] = "mailandsms/add";
                    $this->load->view('_layout_main', $this->data);
                } else {
                    sendSms(
                        $this->input->post('othersms_phone'),
                        $this->input->post('othersms_message'),
                        $this->input->post('othersms_name'),
                        0,
                        null,
                        'mailandsms',
                        'othersms'
                    );
                    redirect(base_url('mailandsms/index'));
                }
            } else {
                redirect('mailandsms/add');
            }
        } else {
            $this->data['emailUserID'] = 0;
            $this->data['emailTemplateID'] = 0;
            $this->data['smsUserID'] = 0;
            $this->data['smsTemplateID'] = 0;
            $this->data["email"] = 1;
            $this->data["sms"] = 0;
            $this->data["otheremail"] = 0;
            $this->data["othersms"] = 0;
            $this->data['submittype'] = 'none';
            $this->data['allStudents'] = array();
            $this->data["subview"] = "mailandsms/add";
            $this->load->view('_layout_main', $this->data);
        }
    }

	private function userConfigEmail($message, $user, $usertypeID, $schoolyearID = 1)
	{
		if ($user && $usertypeID) {
			$userTags = $this->mailandsmstemplatetag_m->get_order_by_mailandsmstemplatetag(array('usertypeID' => $usertypeID));

			if ($usertypeID == 2) {
				$userTags = $this->mailandsmstemplatetag_m->get_order_by_mailandsmstemplatetag(array('usertypeID' => 2));
			} elseif ($usertypeID == 3) {
				$userTags = $this->mailandsmstemplatetag_m->get_order_by_mailandsmstemplatetag(array('usertypeID' => 3));
			} elseif ($usertypeID == 4) {
				$userTags = $this->mailandsmstemplatetag_m->get_order_by_mailandsmstemplatetag(array('usertypeID' => 4));
			} else {
				$userTags = $this->mailandsmstemplatetag_m->get_order_by_mailandsmstemplatetag(array('usertypeID' => 1));
			}

			$message = $this->tagConvertor($userTags, $user, $message, 'email', $schoolyearID);

			if ($user->email) {
				$subject = $this->input->post('email_subject');
				$email = $user->email;

				$emailsetting = $this->emailsetting_m->get_emailsetting();
				$this->email->set_mailtype("html");
				if (customCompute($emailsetting)) {
					if ($emailsetting->email_engine == 'smtp') {
						$config = array(
							'protocol'  => 'smtp',
							'smtp_host' => $emailsetting->smtp_server,
							'smtp_port' => $emailsetting->smtp_port,
							'smtp_user' => $emailsetting->smtp_username,
							'smtp_pass' => $emailsetting->smtp_password,
							'mailtype'  => 'html',
							'charset'   => 'utf-8'
						);
						$this->email->initialize($config);
						$this->email->set_newline("\r\n");
					}

					$this->email->to($email);
					$this->email->from($this->data['siteinfos']->email, $this->data['siteinfos']->sname);
					$this->email->subject($subject);
					$this->email->message($message);
					if ($this->email->send()) {
						$this->session->set_flashdata('success', $this->lang->line('mail_success'));
					} else {
						$this->session->set_flashdata('error', $this->lang->line('mail_error'));
					}
				}
			}
		}
	}

	
	
	public function alltemplate()
	{
		if ($this->input->post('usertypeID') == 'select') {
			echo '<option value="select">' . $this->lang->line('mailandsms_select_template') . '</option>';
		} else {
			$usertypeID = $this->input->post('usertypeID');
			$type = $this->input->post('type');

			$templates = $this->mailandsmstemplate_m->get_order_by_mailandsmstemplate(array('usertypeID' => $usertypeID, 'type' => $type));
			echo '<option value="select">' . $this->lang->line('mailandsms_select_template') . '</option>';
			if (customCompute($templates)) {
				foreach ($templates as $key => $template) {
					echo '<option value="' . $template->mailandsmstemplateID . '">' . $template->name  . '</option>';
				}
			}
		}
	}

	public function allusers()
	{
		if ($this->input->post('usertypeID') == 'select') {
			echo '<option value="select">' . $this->lang->line('mailandsms_all_users') . '</option>';
		} else {
			$usertypeID = $this->input->post('usertypeID');
			$userID = $this->input->post('userID');

			if ($usertypeID == 1) {
				$systemadmins = $this->systemadmin_m->get_systemadmin();
				if (customCompute($systemadmins)) {
					echo "<option value='select'>" . $this->lang->line('mailandsms_all_users') . "</option>";
					foreach ($systemadmins as $key => $systemadmin) {
						echo "<option value='" . $systemadmin->systemadminID . "'>" . $systemadmin->name . '</option>';
					}
				} else {
					echo '<option value="select">' . $this->lang->line('mailandsms_all_users') . '</option>';
				}
			} elseif ($usertypeID == 2) {
				$teachers = $this->teacher_m->general_get_teacher();
				if (customCompute($teachers)) {
					echo "<option value='select'>" . $this->lang->line('mailandsms_all_users') . "</option>";
					foreach ($teachers as $key => $teacher) {
						echo "<option value='" . $teacher->teacherID . "'>" . $teacher->name . '</option>';
					}
				} else {
					echo '<option value="select">' . $this->lang->line('mailandsms_all_users') . '</option>';
				}
			} elseif ($usertypeID == 3) {
				$classes = $this->classes_m->general_get_classes();
				if (customCompute($classes)) {
					echo "<option value='select'>" . $this->lang->line('mailandsms_all_class') . "</option>";
					foreach ($classes as $key => $classm) {
						echo "<option value='" . $classm->classesID . "'>" . $classm->classes . '</option>';
					}
				} else {
					echo '<option value="select">' . $this->lang->line('mailandsms_all_class') . '</option>';
				}
			} elseif ($usertypeID == 4) {
				$parents = $this->parents_m->get_parents();
				if (customCompute($parents)) {
					echo "<option value='select'>" . $this->lang->line('mailandsms_all_users') . "</option>";
					foreach ($parents as $key => $parent) {
						echo "<option value='" . $parent->parentsID . "'>" . $parent->name . '</option>';
					}
				} else {
					echo '<option value="select">' . $this->lang->line('mailandsms_all_users') . '</option>';
				}
			} else {
				$users = $this->user_m->get_order_by_user(array('usertypeID' => $usertypeID));
				if (customCompute($users)) {
					echo "<option value='select'>" . $this->lang->line('mailandsms_all_users') . "</option>";
					foreach ($users as $key => $user) {
						echo "<option value='" . $user->userID . "'>" . $user->name . '</option>';
					}
				} else {
					echo '<option value="select">' . $this->lang->line('mailandsms_all_users') . '</option>';
				}
			}
		}
	}

	public function allstudent()
	{
		$schoolyearID = $this->input->post('schoolyear');
		$classesID = $this->input->post('classes');
		$sectionID = $this->input->post('section');
		if ((int)$schoolyearID && (int)$classesID) {
			if ((int)$sectionID) {
				$students = $this->studentrelation_m->get_order_by_student(array('srschoolyearID' => $schoolyearID, 'srsectionID' => $sectionID, 'srclassesID' => $classesID));
			} else {
				$students = $this->studentrelation_m->get_order_by_student(array('srschoolyearID' => $schoolyearID, 'srclassesID' => $classesID));
			}
			if (customCompute($students)) {
				echo '<option value="select">' . $this->lang->line('mailandsms_all_users') . '</option>';
				foreach ($students as $key => $student) {
					echo '<option value="' . $student->srstudentID . '">' . $student->srname . '</option>';
				}
			} else {
				echo '<option value="select">' . $this->lang->line('mailandsms_all_users') . '</option>';
			}
		} else {
			echo '<option value="select">' . $this->lang->line('mailandsms_all_users') . '</option>';
		}
	}

	public function allsection()
	{
		$classesID = $this->input->post('classes');
		if ((int)$classesID) {
			$allsection = $this->section_m->general_get_order_by_section(array('classesID' => $classesID));
			echo "<option value='select'>", $this->lang->line("mailandsms_all_section"), "</option>";
			foreach ($allsection as $value) {
				echo "<option value=\"$value->sectionID\">", $value->section, "</option>";
			}
		}
	}

	public function check_email_usertypeID()
	{
		if ($this->input->post('email_usertypeID') == 'select') {
			$this->form_validation->set_message("check_email_usertypeID", "The %s field is required");
			return FALSE;
		} else {
			return TRUE;
		}
	}

	public function alltemplatedesign()
	{
		if ((int)$this->input->post('templateID')) {
			$templateID = $this->input->post('templateID');
			$templates = $this->mailandsmstemplate_m->get_mailandsmstemplate($templateID);
			if (customCompute($templates)) {
				echo $templates->template;
			}
		} else {
			echo '';
		}
	}

	public function check_sms_usertypeID()
	{
		if ($this->input->post('sms_usertypeID') == 'select') {
			$this->form_validation->set_message("check_sms_usertypeID", "The %s field is required");
			return FALSE;
		} else {
			return TRUE;
		}
	}

	public function check_getway()
	{
		if ($this->input->post('sms_getway') == 'select') {
			$this->form_validation->set_message("check_getway", "The %s field is required");
			return FALSE;
		} else {

			return TRUE;
		}
	}

	private function allgetway_send_message($getway, $to, $message)
	{
		$result = [];
		if ($to) {
			if (Skooly::send($to, $message, '') == TRUE) {
				$result['check'] = TRUE;
				return $result;
			} else {
				$result['check'] = FALSE;
				$result['message'] = "Check your celcom account";
				return $result;
			}
		}
	}

	public function view()
	{
		$id = htmlentities(escapeString($this->uri->segment(3)));
		if ((int)$id) {
			$this->data['mailandsms'] = $this->mailandsms_m->get_mailandsms($id);
			if ($this->data['mailandsms']) {
				$this->data["subview"] = "mailandsms/view";
				$this->load->view('_layout_main', $this->data);
			} else {
				$this->data["subview"] = "error";
				$this->load->view('_layout_main', $this->data);
			}
		} else {
			$this->data["subview"] = "error";
			$this->load->view('_layout_main', $this->data);
		}
	}

	public function unique_data($data)
	{
		if ($data != "") {
			if ($data == "select") {
				$this->form_validation->set_message('unique_data', 'The %s field is required.');
				return FALSE;
			}
		}
		return TRUE;
	}
}