<?php if ( !defined('BASEPATH') ) {
    exit('No direct script access allowed');
}

    class Dashboard extends Admin_Controller
    {
        /*
        | -----------------------------------------------------
        | PRODUCT NAME: 	INILABS SCHOOL MANAGEMENT SYSTEM
        | -----------------------------------------------------
        | AUTHOR:			INILABS TEAM
        | -----------------------------------------------------
        | EMAIL:			info@inilabs.net
        | -----------------------------------------------------
        | COPYRIGHT:		RESERVED BY INILABS IT
        | -----------------------------------------------------
        | WEBSITE:			http://inilabs.net
        | -----------------------------------------------------
        */
        protected $_versionCheckingUrl = 'http://demo.inilabs.net/autoupdate/update/index';

        function __construct()
        {
            parent::__construct();
            $this->load->model('systemadmin_m');
            $this->load->model("dashboard_m");
            $this->load->model("automation_shudulu_m");
            $this->load->model("automation_rec_m");
            $this->load->model("setting_m");
            $this->load->model("notice_m");
            $this->load->model("user_m");
            $this->load->model("student_m");
            $this->load->model("classes_m");
            $this->load->model("teacher_m");
            $this->load->model("parents_m");
            $this->load->model("sattendance_m");
            $this->load->model("subjectattendance_m");
            $this->load->model("subject_m");
            $this->load->model("feetypes_m");
            $this->load->model("invoice_m");
            $this->load->model("expense_m");
            $this->load->model("payment_m");
            $this->load->model("lmember_m");
            $this->load->model("book_m");
            $this->load->model("issue_m");
            $this->load->model('hmember_m');
            $this->load->model('tmember_m');
            $this->load->model('event_m');
            $this->load->model('holiday_m');
            $this->load->model('visitorinfo_m');
            $this->load->model('income_m');
            $this->load->model('make_payment_m');
            $this->load->model('maininvoice_m');
            $this->load->model('studentrelation_m');
            $this->load->model('reports_m');
            $this->load->model('wallettransactions_m');
            $this->load->model('clock_in_out_m');
            $this->load->model('wallet_m');
            $this->load->model('wallettransactions_m');
            $this->load->model("section_m");
            $this->load->model('studentgroup_m');
            $this->load->model('routine_m');
            $this->load->model('exam_m');
            $this->load->model('grade_m');
            $this->load->model('mark_m');
            $this->load->model('markpercentage_m');
            $this->load->model('markrelation_m');
            $this->load->model('marksetting_m');
            $this->load->model('weaverandfine_m');
            $this->load->model('document_m');
            $this->load->model('leaveapplication_m');
            $this->load->model('lunch_m');
            $this->load->model('reminders_m');
            $language = $this->session->userdata('lang');
            $this->lang->load('dashboard', $language);
            $this->load->model('smssettings_m');

            $this->_automation();
        }

        private function _automation()
        {
            /* Automation Start */
            if ( $this->data['siteinfos']->auto_invoice_generate == 1 ) {

                $array        = [];
                $autoRecArray = [];
                $cnt          = 0;
                $date         = date('Y-m-d');
                $day          = date('d');
                $month        = date('m');
                $year         = date('Y');
                $setting      = $this->setting_m->get_setting();
                if ( $day >= $setting->automation ) {
                    $libraryFeetype = $this->feetypes_m->get_single_feetypes([ 'feetypes' => $this->lang->line('dashboard_libraryfee') ]);
                    if ( !customCompute($libraryFeetype) ) {
                        $this->feetypes_m->insert_feetypes([
                            'feetypes' => $this->lang->line('dashboard_libraryfee'),
                            'note'     => "Don't delete it!"
                        ]);
                    }
                    $libraryFeetype = $this->feetypes_m->get_single_feetypes([ 'feetypes' => $this->lang->line('dashboard_libraryfee') ]);

                    $transportFeetype = $this->feetypes_m->get_single_feetypes([ 'feetypes' => $this->lang->line('dashboard_transportfee') ]);
                    if ( !customCompute($transportFeetype) ) {
                        $this->feetypes_m->insert_feetypes([
                            'feetypes' => $this->lang->line('dashboard_transportfee'),
                            'note'     => "Don't delete it!"
                        ]);
                    }
                    $transportFeetype = $this->feetypes_m->get_single_feetypes([ 'feetypes' => $this->lang->line('dashboard_transportfee') ]);

                    $hostelFeetype = $this->feetypes_m->get_single_feetypes([ 'feetypes' => $this->lang->line('dashboard_hostelfee') ]);
                    if ( !customCompute($hostelFeetype) ) {
                        $this->feetypes_m->insert_feetypes([
                            'feetypes' => $this->lang->line('dashboard_hostelfee'),
                            'note'     => "Don't delete it!"
                        ]);
                    }
                    $hostelFeetype = $this->feetypes_m->get_single_feetypes([ 'feetypes' => $this->lang->line('dashboard_hostelfee') ]);

                    $automation_shudulus = $this->automation_shudulu_m->get_automation_shudulu();

                    if ( customCompute($automation_shudulus) ) {
                        foreach ( $automation_shudulus as $automation_shudulu ) {
                            if ( $automation_shudulu->month == $month && $automation_shudulu->year == $year ) {
                                $cnt = 1;
                            }
                        }

                        if ( $cnt === 0 ) {
                            $automationStudents = $this->student_m->general_get_order_by_student([
                                'schoolyearID' => $this->data['siteinfos']->school_year,
                                'classesID !=' => $this->data['siteinfos']->ex_class
                            ]);
                            $automationLMember  = pluck($this->lmember_m->get_lmember(), 'lbalance', 'studentID');
                            $automationTMember  = pluck($this->tmember_m->get_tmember(), 'tbalance', 'studentID');
                            $automationHMember  = pluck($this->hmember_m->get_hmember(), 'hbalance', 'studentID');
                            $allRecord          = $this->_getAllRec($this->automation_rec_m->get_automation_rec());
                            $superAdmin         = $this->systemadmin_m->get_systemadmin(1);

                            $mainInvoiceArray = [];
                            if ( customCompute($automationStudents) ) {
                                foreach ( $automationStudents as $aTstudentkey => $aTstudent ) {
                                    if ( customCompute($automationLMember) ) {
                                        if ( isset($automationLMember[ $aTstudent->studentID ]) ) {
                                            if ( $automationLMember[ $aTstudent->studentID ] > 0 ) {
                                                if ( !isset($allRecord[5427279][ $aTstudent->studentID ][ $month ][ $year ]) ) {

                                                    $mainInvoiceArray[] = [
                                                        'maininvoiceschoolyearID' => $this->data['siteinfos']->school_year,
                                                        'maininvoiceclassesID'    => $aTstudent->classesID,
                                                        'maininvoicestudentID'    => $aTstudent->studentID,
                                                        'maininvoicestatus'       => 0,
                                                        'maininvoiceuserID'       => 1,
                                                        'maininvoiceusertypeID'   => 1,
                                                        'maininvoiceuname'        => null,
                                                        'maininvoicedate'         => date("Y-m-d"),
                                                        'maininvoicecreate_date'  => date('Y-m-d'),
                                                        'maininvoiceday'          => date('d'),
                                                        'maininvoicemonth'        => date('m'),
                                                        'maininvoiceyear'         => date('Y'),
                                                        'maininvoicedeleted_at'   => 1
                                                    ];

                                                    $array[] = [
                                                        'schoolyearID' => $this->data['siteinfos']->school_year,
                                                        'classesID'    => $aTstudent->classesID,
                                                        'studentID'    => $aTstudent->studentID,
                                                        'feetypeID'    => customCompute($libraryFeetype) ? $libraryFeetype->feetypesID : 0,
                                                        'feetype'      => customCompute($libraryFeetype) ? $libraryFeetype->feetypes : null,
                                                        'amount'       => (int) $automationLMember[ $aTstudent->studentID ],
                                                        'discount'     => 0,
                                                        'paidstatus'   => 0,
                                                        'userID'       => 1,
                                                        'usertypeID'   => 1,
                                                        'uname'        => $superAdmin->name,
                                                        'date'         => date("Y-m-d"),
                                                        'create_date'  => date('Y-m-d'),
                                                        'day'          => date('d'),
                                                        'month'        => date('m'),
                                                        'year'         => date('Y'),
                                                        'deleted_at'   => 1
                                                    ];

                                                    $autoRecArray[] = [
                                                        'studentID' => $aTstudent->studentID,
                                                        'date'      => $date,
                                                        'day'       => $day,
                                                        'month'     => $month,
                                                        'year'      => $year,
                                                        'nofmodule' => 5427279
                                                    ];
                                                }
                                            }
                                        }
                                    }

                                    if ( customCompute($automationTMember) ) {
                                        if ( isset($automationTMember[ $aTstudent->studentID ]) ) {
                                            if ( $automationTMember[ $aTstudent->studentID ] > 0 ) {
                                                if ( !isset($allRecord[872677678][ $aTstudent->studentID ][ $month ][ $year ]) ) {

                                                    $mainInvoiceArray[] = [
                                                        'maininvoiceschoolyearID' => $this->data['siteinfos']->school_year,
                                                        'maininvoiceclassesID'    => $aTstudent->classesID,
                                                        'maininvoicestudentID'    => $aTstudent->studentID,
                                                        'maininvoicestatus'       => 0,
                                                        'maininvoiceuserID'       => 1,
                                                        'maininvoiceusertypeID'   => 1,
                                                        'maininvoiceuname'        => null,
                                                        'maininvoicedate'         => date("Y-m-d"),
                                                        'maininvoicecreate_date'  => date('Y-m-d'),
                                                        'maininvoiceday'          => date('d'),
                                                        'maininvoicemonth'        => date('m'),
                                                        'maininvoiceyear'         => date('Y'),
                                                        'maininvoicedeleted_at'   => 1
                                                    ];

                                                    $array[] = [
                                                        'schoolyearID' => $this->data['siteinfos']->school_year,
                                                        'classesID'    => $aTstudent->classesID,
                                                        'studentID'    => $aTstudent->studentID,
                                                        'feetypeID'    => customCompute($transportFeetype) ? $transportFeetype->feetypesID : 0,
                                                        'feetype'      => customCompute($transportFeetype) ? $transportFeetype->feetypes : 0,
                                                        'amount'       => (int) $automationTMember[ $aTstudent->studentID ],
                                                        'discount'     => 0,
                                                        'paidstatus'   => 0,
                                                        'userID'       => 1,
                                                        'usertypeID'   => 1,
                                                        'uname'        => $superAdmin->name,
                                                        'date'         => date("Y-m-d"),
                                                        'create_date'  => date('Y-m-d'),
                                                        'day'          => date('d'),
                                                        'month'        => date('m'),
                                                        'year'         => date('Y'),
                                                        'deleted_at'   => 1
                                                    ];

                                                    $autoRecArray[] = [
                                                        'studentID' => $aTstudent->studentID,
                                                        'date'      => $date,
                                                        'day'       => $day,
                                                        'month'     => $month,
                                                        'year'      => $year,
                                                        'nofmodule' => 872677678
                                                    ];
                                                }
                                            }
                                        }
                                    }

                                    if ( customCompute($automationHMember) ) {
                                        if ( isset($automationHMember[ $aTstudent->studentID ]) ) {
                                            if ( $automationHMember[ $aTstudent->studentID ] > 0 ) {
                                                if ( !isset($allRecord[467835][ $aTstudent->studentID ][ $month ][ $year ]) ) {

                                                    $mainInvoiceArray[] = [
                                                        'maininvoiceschoolyearID' => $this->data['siteinfos']->school_year,
                                                        'maininvoiceclassesID'    => $aTstudent->classesID,
                                                        'maininvoicestudentID'    => $aTstudent->studentID,
                                                        'maininvoicestatus'       => 0,
                                                        'maininvoiceuserID'       => 1,
                                                        'maininvoiceusertypeID'   => 1,
                                                        'maininvoiceuname'        => null,
                                                        'maininvoicedate'         => date("Y-m-d"),
                                                        'maininvoicecreate_date'  => date('Y-m-d'),
                                                        'maininvoiceday'          => date('d'),
                                                        'maininvoicemonth'        => date('m'),
                                                        'maininvoiceyear'         => date('Y'),
                                                        'maininvoicedeleted_at'   => 1
                                                    ];

                                                    $array[] = [
                                                        'schoolyearID' => $this->data['siteinfos']->school_year,
                                                        'classesID'    => $aTstudent->classesID,
                                                        'studentID'    => $aTstudent->studentID,
                                                        'feetypeID'    => customCompute($hostelFeetype) ? $hostelFeetype->feetypesID : null,
                                                        'feetype'      => customCompute($hostelFeetype) ? $hostelFeetype->feetypes : null,
                                                        'feetype'      => $this->lang->line('dashboard_hostelfee'),
                                                        'amount'       => (int) $automationHMember[ $aTstudent->studentID ],
                                                        'discount'     => 0,
                                                        'paidstatus'   => 0,
                                                        'userID'       => 1,
                                                        'usertypeID'   => 1,
                                                        'uname'        => $superAdmin->name,
                                                        'date'         => date("Y-m-d"),
                                                        'create_date'  => date('Y-m-d'),
                                                        'day'          => date('d'),
                                                        'month'        => date('m'),
                                                        'year'         => date('Y'),
                                                        'deleted_at'   => 1
                                                    ];

                                                    $autoRecArray[] = [
                                                        'studentID' => $aTstudent->studentID,
                                                        'date'      => $date,
                                                        'day'       => $day,
                                                        'month'     => $month,
                                                        'year'      => $year,
                                                        'nofmodule' => 467835
                                                    ];
                                                }
                                            }
                                        }
                                    }
                                }
                            }

                            if ( customCompute($mainInvoiceArray) ) {
                                $count   = customCompute($mainInvoiceArray);
                                $firstID = $this->maininvoice_m->insert_batch_maininvoice($mainInvoiceArray);
                                $lastID  = $firstID + ( $count - 1 );

                                if ( $lastID >= $firstID ) {
                                    $j = 0;
                                    for ( $i = $firstID; $i <= $lastID; $i++ ) {
                                        $array[ $j ]['maininvoiceID'] = $i;
                                        $j++;
                                    }
                                }

                                if ( customCompute($array) ) {
                                    $this->invoice_m->insert_batch_invoice($array);
                                }

                                if ( customCompute($autoRecArray) ) {
                                    $this->automation_rec_m->insert_batch_automation_rec($autoRecArray);
                                }

                                $this->automation_shudulu_m->insert_automation_shudulu([
                                    'date'  => $date,
                                    'day'   => $day,
                                    'month' => $month,
                                    'year'  => $year
                                ]);
                            }
                        }
                    } else {
                        $this->automation_shudulu_m->insert_automation_shudulu([
                            'date'  => $date,
                            'day'   => $day,
                            'month' => $month,
                            'year'  => $year
                        ]);
                    }
                }
            }
            /* Automation Close */
        }

        private function _getAllRec( $arrays )
        {
            $returnArray = [];
            if ( customCompute($arrays) ) {
                foreach ( $arrays as $key => $array ) {
                    $returnArray[ $array->nofmodule ][ $array->studentID ][ $array->month ][ $array->year ] = 'Yes';
                }
            }
            return $returnArray;
        }

        public function studentWithBalances(){
            $schoolyearID = $this->session->userdata('defaultschoolyearID');
            $students = $this->studentrelation_m->general_get_order_by_student(array('srschoolyearID' => $schoolyearID), true);
            
            $recipients = [];
            foreach ($students as $student) {
                if ($student->fee_balance > 1) {
                    $recipients[] = $student;
                }
            }

            return $recipients;
        }
     

        public function sendFeeNotices()
        {
            try {
                $schoolyearID = $this->session->userdata('defaultschoolyearID');
                $students = $this->studentrelation_m->general_get_order_by_student(['srschoolyearID' => $schoolyearID], true);
        
                $smsSentCount = 0;
                foreach ($students as $student) {
                    if ($student->fee_balance > 1) {
                        // This function now sends the SMS and logs it.
                        SmsService::studentWithBalanceCard($student, 3, $this->data);
                        $smsSentCount++;
                    }
                }
        
                // Check if any SMS were sent to provide a more accurate message.
                if ($smsSentCount > 0) {
                    echo json_encode([
                        'success' => true,
                        'message' => 'Fee balance notices sent successfully to ' . $smsSentCount . ' recipients!'
                    ]);
                } else {
                    echo json_encode([
                        'success' => true,
                        'message' => 'No students with outstanding balances found.'
                    ]);
                }
        
            } catch (\Exception $e) {
                echo json_encode([
                    'success' => false, // It's better to set success to false on error
                    'message' => $e->getMessage()
                ]);
            }
        }

        public function get_ajax(){

            echo json_encode($this->index(true));
        }

        public function index($ajax=false){
            $get_celcoms = $this->smssettings_m->get_order_by_celcom();
            $celcomBalanceKey = array_search("celcom_balance", array_column($get_celcoms, "field_names"));
            $this->data['celcomBalance'] = $get_celcoms[$celcomBalanceKey]->field_values; 

            $schoolyearID = $this->session->userdata('defaultschoolyearID');

            $this->data['headerassets'] = [
            'css' => [
                'assets/fullcalendar/lib/cupertino/jquery-ui.min.css',
                'assets/fullcalendar/fullcalendar.css',
            ],
            'js'  => [
                'assets/fullcalendar/lib/jquery-ui.min.js',
                'assets/fullcalendar/lib/moment.min.js',
                'assets/fullcalendar/fullcalendar.min.js'
            ]
        ];  $salesData = $this->reports_m->getSalesData($schoolyearID);
            $this->data['total_sales'] = $salesData['total_sales']?? [];
            $this->data['sales_months'] = $salesData['months']?? [];
            $this->data['total_fines'] = $this->reports_m->getFinesData($schoolyearID);
            $this->data['total_fees'] = $this->reports_m->getTotalFeesAndFinesData($schoolyearID);
            
            $this->data['total_income'] =  $this->reports_m->getTotalIncomeDatas($schoolyearID);
            $this->data['total_purchases'] =  $this->reports_m->getPurchasesData($schoolyearID);
            $this->data['total_salary'] =  $this->reports_m->getSalaryData($schoolyearID);
            $this->data['total_expense'] =  $this->reports_m->getTotalExpenseData($schoolyearID);
            $this->data['fess_by_class'] =  $this->reports_m->get_total_fees_by_class($schoolyearID); 
            $this->data['fess_by_class_due'] =  $this->reports_m->get_total_fees_by_class_due($schoolyearID);
            $this->data['fess_donut'] =  $this->reports_m->fess_donut($schoolyearID);
            $this->data['cards'] =  $this->reports_m->cards();
            $this->data['admissions'] =  $this->reports_m->get_latest_admissions($schoolyearID);
            $this->data['balances'] = $this->studentWithBalances(); // $this->reports_m->get_highest_balance($schoolyearID);
            $this->data['reminders'] =  $this->reminders_m->get_reminder();
            
            $filter = array(
                'schoolyearID' =>  $this->session->userdata('defaultschoolyearID')
            );
            $this->data["wallet_logs"] = $this->wallettransactions_m->getDatas($filter);
            $this->data['clock_in_out'] = $this->clock_in_out_m->getData($schoolyearID);
            $this->data['salaries'] = $this->reports_m->getSalariesData($schoolyearID);
            $this->data['mpesa_logs'] = $this->reports_m->getMpesaData($schoolyearID);
            
            // dd($this->data['salaries']);
            
            $this->_tails();
            $this->_attendanceGraph();
           $res =  $this->_incomeExpenseGraph();
           
            $this->_visitorGraph();
            $this->_profile();

            if($this->session->userdata('usertypeID') == 3 ){
                $loginuserID = $this->session->userdata('loginuserID');
                $getLoginStudent = $this->studentrelation_m->get_single_student([
                    'srstudentID'    => $loginuserID,
                    'srschoolyearID' => $schoolyearID
                ]);
                // $this->data['attendance'] = $this->sattendance_m->get_this_week_attendance($loginuserID);
        
                
                $this->studentDashboard($loginuserID, $getLoginStudent->srclassesID);
                $filter = array(
                    'schoolyearID' =>  $this->session->userdata('defaultschoolyearID'),
                    // 'studentID'    => $loginuserID,
                );
                $this->data["wallet_logs_student"] = $this->wallettransactions_m->getDatastudent($filter, $loginuserID);
                $this->data["mpesa_logs"] = $this->wallettransactions_m->getMpesaData($loginuserID);
                
                $this->data['lunch_logs'] = $this->lunch_m->getDatastudent($loginuserID);
                $this->data['clock_in_out_student'] = $this->clock_in_out_m->getDatastudent($schoolyearID, $loginuserID);
                $this->data['sms_logs'] = $this->reports_m->getSMSData($getLoginStudent->name);
                
                $this->data['fess_donut_student'] =  $this->reports_m->fess_donut_student($schoolyearID, $loginuserID);      
            }

            if ( ( config_item('demo') === false ) && ( $this->data['siteinfos']->auto_update_notification == 1 ) && ( $this->session->userdata('usertypeID') == 1 ) && ( $this->session->userdata('loginuserID') == 1 ) ) {
                if ( $this->session->userdata('updatestatus') === null ) {
                    $this->data['versionChecking'] = $this->_checkUpdate();
                } else {
                    $this->data['versionChecking'] = 'none';
                }
            } else {
                $this->data['versionChecking'] = 'none';
            }
            if($ajax){
                return $this->data;
            }else{
                if($this->session->userdata('usertypeID') == (1 || 5)){
                    $this->data["subview"] = "dashboard/index-new";
                    $this->load->view('_layout_main', $this->data);
                    // $this->load->view('new_layout', $this->data);
                }else{
                    $this->data["subview"] = "dashboard/index";
                 //   $this->load->view('_layout_main', $this->data);
                }

            }
            
            // $this->data["subview"] = "dashboard/index-new";
            // $this->load->view('_layout_main', $this->data);
            
            
        }
        
        public function get_sms_balance() {
        try {
            // This probably updates the SMS balance cache
            Skooly::getBalance();

            // Fetch balance from db
            $get_celcoms = $this->smssettings_m->get_order_by_celcom();
            $celcomBalanceKey = array_search("celcom_balance", array_column($get_celcoms, "field_names"));
            $balanceValue = (float)$get_celcoms[$celcomBalanceKey]->field_values - 1;
            $balance = number_format($balanceValue, 2);

            // Only send SMS if specifically requested (e.g. via card click)
            if ($this->input->get('action') === 'sendsms') {
                // $this->data should be set up in your controller as needed
                SmsService::smsCreditBalanceCard($balance, $this->data);
            }

            echo json_encode([
                'success' => true,
                'balance' => $balance
            ]);
        } catch (Exception $e) {
            echo json_encode([
                'success' => false,
                'message' => $e->getMessage()
            ]);
        }
    }

        private function studentDashboard($id, $url){
          
            $schoolyearID = $this->session->userdata('defaultschoolyearID');
            $studentInfo = $this->studentrelation_m->get_single_student(array('srstudentID' => $id, 'srclassesID' => $url, 'srschoolyearID' => $schoolyearID), TRUE);

                $this->pluckInfo();
                $this->basicInfo($studentInfo);
                $this->parentInfo($studentInfo);
                $this->routineInfo($studentInfo);
                $this->attendanceInfo($studentInfo);
                $this->markInfo($studentInfo);
                $this->invoiceInfo($studentInfo);
                $this->paymentInfo($studentInfo);
                $this->documentInfo($studentInfo);

                if(customCompute($studentInfo)) {
                    $this->data['set']     = $url;
                    $this->data['leaveapplications'] = $this->leave_applications_date_list_by_user_and_schoolyear($id,$schoolyearID,$studentInfo->usertypeID);
                    // $this->data["subview"] = "student/getView";
                    // $this->load->view('_layout_main', $this->data);
                } else {
                    $this->data["subview"] = "error";
                    $this->load->view('_layout_main', $this->data);
                }
        }

        private function pluckInfo() {
            $this->data['subjects'] = pluck($this->subject_m->general_get_subject(), 'subject', 'subjectID');
            $this->data['teachers'] = pluck($this->teacher_m->get_teacher(), 'name', 'teacherID');
            $this->data['feetypes'] = pluck($this->feetypes_m->get_feetypes(), 'feetypes', 'feetypesID');
        }
        private function leave_applications_date_list_by_user_and_schoolyear($userID, $schoolyearID, $usertypeID) {
            $leaveapplications = $this->leaveapplication_m->get_order_by_leaveapplication(array('create_userID'=>$userID,'create_usertypeID'=>$usertypeID,'schoolyearID'=>$schoolyearID,'status'=>1));
            
            $retArray = [];
            if(customCompute($leaveapplications)) {
                $oneday    = 60*60*24;
                foreach($leaveapplications as $leaveapplication) {
                    for($i=strtotime($leaveapplication->from_date); $i<= strtotime($leaveapplication->to_date); $i= $i+$oneday) {
                        $retArray[] = date('d-m-Y', $i);
                    }
                }
            }
            return $retArray;
        }

        private function getMark($studentID, $classesID) {
            if((int)$studentID && (int)$classesID) {
                $schoolyearID = $this->session->userdata('defaultschoolyearID');
                $student      = $this->studentrelation_m->get_single_student(array('srstudentID' => $studentID, 'srclassesID' => $classesID, 'srschoolyearID' => $schoolyearID));
                $classes      = $this->classes_m->get_single_classes(array('classesID' => $classesID));
    
                if(customCompute($student) && customCompute($classes)) {
                    $queryArray = [
                        'classesID'    => $student->srclassesID,
                        'sectionID'    => $student->srsectionID,
                        'studentID'    => $student->srstudentID, 
                        'schoolyearID' => $schoolyearID, 
                    ];
    
                    $exams             = pluck($this->exam_m->get_exam(), 'exam', 'examID');
                    $grades            = $this->grade_m->get_grade();
                    $marks             = $this->mark_m->student_all_mark_array($queryArray);
                    $markpercentages   = $this->markpercentage_m->get_markpercentage();
    
                    $subjects          = $this->subject_m->general_get_order_by_subject(array('classesID' => $classesID));
                    $subjectArr        = [];
                    $optionalsubjectArr= [];
                    if(customCompute($subjects)) {
                        foreach ($subjects as $subject) {
                            if($subject->type == 0) {
                                $optionalsubjectArr[$subject->subjectID] = $subject->subjectID;
                            }
                            $subjectArr[$subject->subjectID] = $subject;
                        }
                    }
    
                    $retMark = [];
                    if(customCompute($marks)) {
                        foreach ($marks as $mark) {
                            $retMark[$mark->examID][$mark->subjectID][$mark->markpercentageID] = $mark->mark;
                        }
                    }
    
                    $allStudentMarks = $this->mark_m->student_all_mark_array(array('classesID' => $classesID, 'schoolyearID' => $schoolyearID));
                    $highestMarks    = [];
                    foreach ($allStudentMarks as $value) {
                        if(!isset($highestMarks[$value->examID][$value->subjectID][$value->markpercentageID])) {
                            $highestMarks[$value->examID][$value->subjectID][$value->markpercentageID] = -1;
                        }
                        $highestMarks[$value->examID][$value->subjectID][$value->markpercentageID] = max($value->mark, $highestMarks[$value->examID][$value->subjectID][$value->markpercentageID]);
                    }
                    $marksettings  = $this->marksetting_m->get_marksetting_markpercentages();
    
                    $this->data['settingmarktypeID'] = $this->data['siteinfos']->marktypeID;
                    $this->data['subjects']          = $subjectArr;
                    $this->data['exams']             = $exams;
                    $this->data['grades']            = $grades;
                    $this->data['markpercentages']   = pluck($markpercentages, 'obj', 'markpercentageID');
                    $this->data['optionalsubjectArr']= $optionalsubjectArr;
                    $this->data['marks']             = $retMark;
                    $this->data['highestmarks']      = $highestMarks;
                    $this->data['marksettings']      = isset($marksettings[$classesID]) ? $marksettings[$classesID] : [];
                } else {
                    $this->data['settingmarktypeID'] = 0;
                    $this->data['subjects']          = [];
                    $this->data['exams']             = [];
                    $this->data['grades']            = [];
                    $this->data['markpercentages']   = [];
                    $this->data['optionalsubjectArr']= [];
                    $this->data['marks']             = [];
                    $this->data['highestmarks']      = [];
                    $this->data['marksettings']      = [];
                }
            } else {
                $this->data['settingmarktypeID'] = 0;
                $this->data['subjects']          = [];
                $this->data['exams']             = [];
                $this->data['grades']            = [];
                $this->data['markpercentages']   = [];
                $this->data['optionalsubjectArr']= [];
                $this->data['marks']             = [];
                $this->data['highestmarks']      = [];
                $this->data['marksettings']      = [];
            }
        }
    
        private function basicInfo($studentInfo) {
            if(customCompute($studentInfo)) {
                $this->data['profile'] = $studentInfo;
                $this->data['profile']->fee_balance = $this->payment_m->balance($studentInfo->srstudentID);
                $this->data['profile']->wallet_balance = $this->wallet_m->getBalance(array('studentID' => $studentInfo->srstudentID));
                $this->data["last_transaction"] = $this->wallettransactions_m->getLastTrx($studentInfo->srstudentID);
                
                $this->data['total_invoices'] = $this->wallettransactions_m->totalInvoices($studentInfo->srstudentID);
                $this->data['usertype'] = $this->usertype_m->get_single_usertype(array('usertypeID' => 3));
                $this->data['class'] = $this->classes_m->get_single_classes(array('classesID' => $studentInfo->srclassesID));
                $this->data['section'] = $this->section_m->general_get_single_section(array('sectionID' => $studentInfo->srsectionID));
                $this->data['group'] = $this->studentgroup_m->get_single_studentgroup(array('studentgroupID' => $studentInfo->srstudentgroupID));
                $this->data['optionalsubject'] = $this->subject_m->general_get_single_subject(array('subjectID' => $studentInfo->sroptionalsubjectID));
            } else {
                $this->data['profile'] = [];
            }
        }
        private function allPaymentByInvoice($payments) {
            $retPaymentArr = [];
            if($payments) {
                foreach ($payments as $payment) {
                    if(isset($retPaymentArr[$payment->invoiceID])) {
                        $retPaymentArr[$payment->invoiceID] += $payment->paymentamount;
                    } else {
                        $retPaymentArr[$payment->invoiceID] = $payment->paymentamount;                  
                    }
                }
            }
            return $retPaymentArr;
        }
        private function allWeaverAndFineByInvoice($weaverandfines) {
            $retWeaverAndFineArr = [];
            if($weaverandfines) {
                foreach ($weaverandfines as $weaverandfine) {
                    if(isset($retWeaverAndFineArr[$weaverandfine->invoiceID]['weaver'])) {
                        $retWeaverAndFineArr[$weaverandfine->invoiceID]['weaver'] += $weaverandfine->weaver;
                    } else {
                        $retWeaverAndFineArr[$weaverandfine->invoiceID]['weaver'] = $weaverandfine->weaver;                 
                    }
    
                    if(isset($retWeaverAndFineArr[$weaverandfine->invoiceID]['fine'])) {
                        $retWeaverAndFineArr[$weaverandfine->invoiceID]['fine'] += $weaverandfine->fine;
                    } else {
                        $retWeaverAndFineArr[$weaverandfine->invoiceID]['fine'] = $weaverandfine->fine;                 
                    }
                }
            }
            return $retWeaverAndFineArr;
        }
    
        private function parentInfo($studentInfo) {
            if(customCompute($studentInfo)) {
                $this->data['parents'] = $this->parents_m->get_single_parents(array('parentsID' => $studentInfo->parentID));
            } else {
                $this->data['parents'] = [];
            }
        }
    
        private function routineInfo($studentInfo) {
            $settingWeekends = [];
            if($this->data['siteinfos']->weekends != '') {
                $settingWeekends = explode(',', $this->data['siteinfos']->weekends);
            }
            $this->data['routineweekends'] = $settingWeekends;
    
            $this->data['routines'] = [];
            if(customCompute($studentInfo)) {
                $schoolyearID           = $this->session->userdata('defaultschoolyearID');
                $this->data['routines'] = pluck_multi_array($this->routine_m->get_order_by_routine(array('classesID'=>$studentInfo->srclassesID, 'sectionID'=>$studentInfo->srsectionID, 'schoolyearID'=> $schoolyearID)), 'obj', 'day');
            }
        }
    
        private function attendanceInfo($studentInfo) {
            $this->data['holidays'] =  $this->getHolidaysSession();
            $this->data['getWeekendDays'] =  $this->getWeekendDaysSession();
            if(customCompute($studentInfo)) {
                $this->data['setting'] = $this->setting_m->get_setting();
                if($this->data['setting']->attendance == "subject") {
                    $this->data["attendancesubjects"] = $this->subject_m->general_get_order_by_subject(array("classesID" => $studentInfo->srclassesID));
                }
    
                if($this->data['setting']->attendance == "subject") {
                    $attendances = $this->subjectattendance_m->get_order_by_sub_attendance(array("studentID" => $studentInfo->srstudentID, "classesID" => $studentInfo->srclassesID));
                    $this->data['attendances_subjectwisess'] = pluck_multi_array_key($attendances, 'obj', 'subjectID', 'monthyear');
                } else {
                    $attendances = $this->sattendance_m->get_order_by_attendance(array("studentID" => $studentInfo->srstudentID, "classesID" => $studentInfo->srclassesID));
                    $this->data['attendancesArray'] = pluck($attendances,'obj','monthyear');
                }
            } else {
                $this->data['setting'] = [];
                $this->data['attendancesubjects'] = [];
                $this->data['attendances_subjectwisess'] = [];
                $this->data['attendancesArray'] = [];
            }
        }
    
        private function markInfo($studentInfo) {
            if(customCompute($studentInfo)) {
                $this->getMark($studentInfo->srstudentID, $studentInfo->srclassesID);
            } else {
                $this->data['set']              = [];
                $this->data["exams"]            = [];
                $this->data["grades"]           = [];
                $this->data['markpercentages']  = [];
                $this->data['validExam']        = [];
                $this->data['separatedMarks']   = [];
                $this->data["highestMarks"]     = [];
                $this->data["section"]          = [];
            }
        }
    
        private function invoiceInfo($studentInfo) {
            $schoolyearID = $this->session->userdata('defaultschoolyearID');
            if(customCompute($studentInfo)) {
                $this->data['invoices'] = $this->invoice_m->get_order_by_invoice(array('schoolyearID' => $schoolyearID, 'studentID' => $studentInfo->srstudentID,'deleted_at' => 1));
    
                $payments = $this->payment_m->get_order_by_payment(array('schoolyearID' => $schoolyearID, 'studentID' => $studentInfo->srstudentID));
                $weaverandfines = $this->weaverandfine_m->get_order_by_weaverandfine(array('schoolyearID' => $schoolyearID, 'studentID' => $studentInfo->srstudentID));
    
                $this->data['allpaymentbyinvoice'] = $this->allPaymentByInvoice($payments);
                $this->data['allweaverandpaymentbyinvoice'] = $this->allWeaverAndFineByInvoice($weaverandfines);
            } else {
                $this->data['invoices'] = [];
                $this->data['allpaymentbyinvoice'] = [];
                $this->data['allweaverandpaymentbyinvoice'] = [];
            }
        }
    
        private function paymentInfo($studentInfo) {
            $schoolyearID = $this->session->userdata('defaultschoolyearID');
            if(customCompute($studentInfo)) {
                $this->data['payments'] = $this->payment_m->get_payment_with_studentrelation_by_studentID_and_schoolyearID($studentInfo->srstudentID, $schoolyearID);
            } else {
                $this->data['payments'] = [];
            }
        }        
    
        private function documentInfo($studentInfo) {
            if(customCompute($studentInfo)) {
                $this->data['documents'] = $this->document_m->get_order_by_document(array('usertypeID' => 3, 'userID' => $studentInfo->srstudentID));
            } else {
                $this->data['documents'] = [];
            }
        }
    
    

        private function _tails()
        {
            $schoolyearID = $this->session->userdata('defaultschoolyearID');
            $loginuserID  = $this->session->userdata('loginuserID');

            $students    = $this->studentrelation_m->get_order_by_student([ 'srschoolyearID' => $schoolyearID, 'active'=> 1 ]);
            $classes     = pluck($this->classes_m->get_classes(), 'obj', 'classesID');
            $teachers    = $this->teacher_m->get_teacher();
            $parents     = $this->parents_m->get_parents();
            $books       = $this->book_m->get_book();
            $feetypes    = $this->feetypes_m->get_feetypes();
            $lmembers    = $this->lmember_m->get_lmember();
            $events      = $this->event_m->get_order_by_event([ 'schoolyearID' => $schoolyearID ]);
            $holidays    = $this->holiday_m->get_order_by_holiday([ 'schoolyearID' => $schoolyearID ]);
            $visitors    = $this->visitorinfo_m->get_order_by_visitorinfo([ 'schoolyearID' => $schoolyearID ]);
            $invoicex    = $this->invoice_m->get_pending_invoices();
     
            $allmenu     = pluck($this->menu_m->get_order_by_menu(), 'icon', 'link');
            $allmenulang = pluck($this->menu_m->get_order_by_menu(), 'menuName', 'link');
// dd($allmenu);
            if ( $this->session->userdata('usertypeID') == 3 ) {
                $getLoginStudent = $this->studentrelation_m->get_single_student([
                    'srstudentID'    => $loginuserID,
                    'srschoolyearID' => $schoolyearID
                ]);
                if ( customCompute($getLoginStudent) ) {
                    $subjects = $this->subject_m->get_order_by_subject([ 'classesID' => $getLoginStudent->srclassesID ]);
                    $invoices = $this->maininvoice_m->get_order_by_maininvoice([
                        'maininvoicestudentID'    => $getLoginStudent->srstudentID,
                        'maininvoiceschoolyearID' => $schoolyearID,
                        'maininvoicedeleted_at'   => 1
                    ]);
                    $lmember  = $this->lmember_m->get_single_lmember([ 'studentID' => $getLoginStudent->srstudentID ]);
                    if ( customCompute($lmember) ) {
                        $issues = $this->issue_m->get_order_by_issue([ "lID" => $lmember->lID, 'return_date' => null ]);
                    } else {
                        $issues = [];
                    }
                } else {
                    $invoices = [];
                    $subjects = [];
                    $issues   = [];
                }
            } else {
                $invoices = $this->maininvoice_m->get_order_by_maininvoice([
                    'maininvoiceschoolyearID' => $schoolyearID,
                    'maininvoicedeleted_at'   => 1
                ]);
                $subjects = $this->subject_m->get_subject();
                $issues   = $this->issue_m->get_order_by_issue([ 'return_date' => null ]);
            }

            $this->data['dashboardWidget']['students']    = customCompute($students);
            $this->data['dashboardWidget']['classes']     = customCompute($classes);
            $this->data['dashboardWidget']['teachers']    = customCompute($teachers);
            $this->data['dashboardWidget']['parents']     = customCompute($parents);
            $this->data['dashboardWidget']['subjects']    = customCompute($subjects);
            $this->data['dashboardWidget']['books']       = customCompute($books);
            $this->data['dashboardWidget']['feetypes']    = customCompute($feetypes);
            $this->data['dashboardWidget']['lmembers']    = customCompute($lmembers);
            $this->data['dashboardWidget']['events']      = customCompute($events);
            $this->data['dashboardWidget']['issues']      = customCompute($issues);
            $this->data['dashboardWidget']['holidays']    = customCompute($holidays);
            $this->data['dashboardWidget']['invoices']    = customCompute($invoices);
            $this->data['dashboardWidget']['visitors']    = customCompute($visitors);
            $this->data['dashboardWidget']['invoicex']    = customCompute($invoicex);
            $this->data['dashboardWidget']['allmenu']     = $allmenu;
            $this->data['dashboardWidget']['allmenulang'] = $allmenulang;

            $this->data['notices']  = $this->notice_m->getData([ 'notice.schoolyearID' => $schoolyearID ]);
            $this->data['holidays'] = $holidays;
            $this->data['events']   = $events;
            $this->data['classes']  = $classes;
        }

        private function _attendanceGraph()
        {
            $schoolyearID                   = $this->session->userdata('defaultschoolyearID');
            $attendanceSystem               = $this->data['siteinfos']->attendance;
            $this->data['attendanceSystem'] = $attendanceSystem;

            if ( $attendanceSystem != 'subject' ) {
                $attendances = $this->sattendance_m->get_order_by_attendance([
                    'schoolyearID' => $schoolyearID,
                    'monthyear'    => date('m-Y')
                ]);

                $classWiseAttendance = [];
                foreach ( $attendances as $attendance ) {
                    for ( $i = 1; $i <= 31; $i++ ) {
                        if ( $i > date('d') ) {
                            break;
                        }
                        $date = 'a' . $i;

                        if ( !isset($classWiseAttendance[ $attendance->classesID ][ $i ]['P']) ) {
                            $classWiseAttendance[ $attendance->classesID ][ $i ]['P'] = 0;
                        }

                        if ( !isset($classWiseAttendance[ $attendance->classesID ][ $i ]['A']) ) {
                            $classWiseAttendance[ $attendance->classesID ][ $i ]['A'] = 0;
                        }

                        if ( $attendance->$date == 'P' || $attendance->$date == 'L' || $attendance->$date == 'LE' ) {
                            $classWiseAttendance[ $attendance->classesID ][ $i ]['P']++;
                        } else {
                            $classWiseAttendance[ $attendance->classesID ][ $i ]['A']++;
                        }
                    }
                }

                $todaysAttendance = [];
                foreach ( $classWiseAttendance as $key => $value ) {
                    $todaysAttendance[ $key ] = $value[ (int) date('d') ];
                }
                
                $totalPresentStudents = 0;

                foreach ($todaysAttendance as $attendance) {
                    if (isset($attendance['P'])) {
                        $totalPresentStudents += $attendance['P'];
                    }
                }
                $this->data['classWiseAttendance'] = $classWiseAttendance;
                $this->data['todaysAttendance']    = $todaysAttendance; 
                $this->data['todaysCardAttendance']    = $totalPresentStudents;
            } else {
                $subjectWiseAttendance = [];
                $attendances           = $this->subjectattendance_m->get_order_by_sub_attendance([
                    'schoolyearID' => $schoolyearID,
                    'monthyear'    => date('m-Y')
                ]);

                foreach ( $attendances as $attendance ) {
                    for ( $i = 1; $i <= 31; $i++ ) {
                        if ( $i > date('d') ) {
                            break;
                        }
                        $date = 'a' . $i;

                        if ( !isset($subjectWiseAttendance[ $attendance->classesID ][ $attendance->subjectID ][ $i ]['P']) ) {
                            $subjectWiseAttendance[ $attendance->classesID ][ $attendance->subjectID ][ $i ]['P'] = 0;
                        }

                        if ( !isset($subjectWiseAttendance[ $attendance->classesID ][ $attendance->subjectID ][ $i ]['A']) ) {
                            $subjectWiseAttendance[ $attendance->classesID ][ $attendance->subjectID ][ $i ]['A'] = 0;
                        }

                        if ( $attendance->$date == 'P' || $attendance->$date == 'L' || $attendance->$date == 'LE' ) {
                            $subjectWiseAttendance[ $attendance->classesID ][ $attendance->subjectID ][ $i ]['P']++;
                        } else {
                            $subjectWiseAttendance[ $attendance->classesID ][ $attendance->subjectID ][ $i ]['A']++;
                        }
                    }
                }

                $todaysSubjectWiseAttendance = [];
                foreach ( $subjectWiseAttendance as $class => $subject ) {
                    foreach ( $subject as $key => $value ) {
                        if ( !isset($todaysSubjectWiseAttendance[ $class ]) ) {
                            $todaysSubjectWiseAttendance[ $class ]['P'] = 0;
                            $todaysSubjectWiseAttendance[ $class ]['A'] = 0;
                        }
                        $todaysSubjectWiseAttendance[ $class ]['P'] += $value[ (int) date('d') ]['P'];
                        $todaysSubjectWiseAttendance[ $class ]['A'] += $value[ (int) date('d') ]['A'];
                    }
                }

                $this->data['subjectWiseAttendance']       = $subjectWiseAttendance;
                $this->data['todaysSubjectWiseAttendance'] = $todaysSubjectWiseAttendance;
            }
        }
        
                 
        
        
        private function _incomeExpenseGraph()
        {
            $months = [
                1 => 'Jan',
                'Feb',
                'Mar',
                'Apr',
                'May',
                'Jun',
                'Jul',
                'Aug',
                'Sep',
                'Oct',
                'Nov',
                'Dec',
            ];

            $monthArray   = [];
            $schoolyearID = $this->session->userdata('defaultschoolyearID');
            $schoolyear   = $this->schoolyear_m->get_obj_schoolyear($schoolyearID);
            if ( customCompute($schoolyear) ) {
                $monthStart = abs($schoolyear->startingmonth);
                if ( $schoolyear->startingyear == $schoolyear->endingyear ) {
                    $monthLimit = ( ( $schoolyear->endingmonth - $schoolyear->startingmonth ) + 1 );
                } else {
                    $monthLimit = ( $schoolyear->startingmonth + $schoolyear->endingmonth + 1 );
                }

                $n = $monthStart;
                for ( $k = 1; $k <= $monthLimit; $k++ ) {
                    $monthArray[ $n ] = $months[ $n ];
                    $n++;
                    if ( $n > 12 ) {
                        $n = 1;
                    }
                }
                $months = $monthArray;
            }

            $incomes  = $this->income_m->get_order_by_income([ 'schoolyearID' => $schoolyearID ]);
            $payments = $this->payment_m->get_order_by_payment([
                'schoolyearID'  => $schoolyearID,
                'paymentamount' => null
            ]);

            $expenses     = $this->expense_m->get_order_by_expense([ 'schoolyearID' => $schoolyearID ]);
            $makepayments = $this->make_payment_m->get_order_by_make_payment([ 'schoolyearID' => $schoolyearID ]);

            $incomeMonthAndDay = [];
            $incomeMonthTotal  = [];
            if ( customCompute($incomes) ) {
                foreach ( $incomes as $incomeKey => $income ) {
                    if ( !isset($incomeMonthAndDay[ (int) $income->incomemonth ][ $income->incomeday ]) ) {
                        $incomeMonthAndDay[ (int) $income->incomemonth ][ (string) $income->incomeday ] = 0;
                    }

                    $incomeMonthAndDay[ (int) $income->incomemonth ][ (string) $income->incomeday ] += $income->amount;
                    if ( !isset($incomeMonthTotal[ (int) $income->incomemonth ]) ) {
                        $incomeMonthTotal[ (int) $income->incomemonth ] = 0;
                    }
                    $incomeMonthTotal[ (int) $income->incomemonth ] += $income->amount;
                }
            }
            
            //Get School fess data for allmonths
            $schoolfees = $this->db->query("
                SELECT
                    DATE_FORMAT(payment.paymentdate, '%c') AS month,
                    SUM(payment.paymentamount) + COALESCE(SUM(weaverandfine.fine), 0) AS total_fees
                FROM
                    payment
                LEFT JOIN
                    weaverandfine ON payment.paymentID = weaverandfine.paymentID
                WHERE
                    payment.schoolyearID = $schoolyearID
                GROUP BY
                    month
            ");
            
            $feesData = [];
            if ($schoolfees->num_rows() > 0) {
                foreach ($schoolfees->result() as $fee) {                    
                    $feesData[(int) $fee->month] = (int) $fee->total_fees;
                }
            }
            
            // Get lunch data for all months
            // $lunchlogs = $this->db->query("
            //     SELECT
            //         DATE_FORMAT(`date`, '%c') AS month,
            //         SUM(amount) AS total_lunch_sold
            //     FROM
            //         lunchlogs l
            //     WHERE
            //         l.schoolyearID = $schoolyearID
            //     GROUP BY
            //         month
            // ");
            
            
            // $lunchData = [];
            // if ($lunchlogs->num_rows() > 0) {
            //     foreach ($lunchlogs->result() as $lunch) {                    
            //         $lunchData[(int) $lunch->month] = (int) $lunch->total_lunch_sold;
            //     }
            // }
            $saleslogs = $this->db->query("
                SELECT
                        DATE_FORMAT(`create_date`, '%c') AS month,
                        SUM(pi.productsaleunitprice * pi.productsalequantity) AS total_sales
                    FROM
                        productsale p
                    LEFT JOIN
                        productsaleitem pi ON pi.productsaleID = p.productsaleID
                    WHERE
                        p.schoolyearID = $schoolyearID AND p.productsalestatus = 3
                    GROUP BY
                        month
        
            ");
            $salesData = [];
            if ($saleslogs->num_rows() > 0) {
                foreach ($saleslogs ->result() as $sales) {                    
                    $salesData[(int) $sales->month] = (int) $sales->total_sales;
                }
            }
           
            // Add Sales data to income data
            foreach ($salesData as $key => $value) {
                if (!isset($incomeMonthTotal[$key])) {
                    $incomeMonthTotal[$key] = $value;
                } else {
                    $incomeMonthTotal[$key] += $value;
                }
            }

            // // Add lunch data to income data
            // foreach ($lunchData as $key => $value) {
            //     if (!isset($incomeMonthTotal[$key])) {
            //         $incomeMonthTotal[$key] = $value;
            //     } else {
            //         $incomeMonthTotal[$key] += $value;
            //     }
            // }
            
            
            // Add fees data to income data
            foreach ($feesData as $key => $value) {
                
                if (!isset($incomeMonthTotal[$key])) {                    
                    $incomeMonthTotal[$key] = $value;
                } else {
                    $incomeMonthTotal[$key] += $value;
                }
            }
            
            if ( customCompute($payments) ) {
                foreach ( $payments as $paymentKey => $payment ) { 
                    if ( !isset($incomeMonthAndDay[ (int) $payment->paymentmonth ][ $payment->paymentday ]) ) {
                        $incomeMonthAndDay[ (int) $payment->paymentmonth ][ (string) $payment->paymentday ] = 0;
                    }
            
                    $incomeMonthAndDay[ (int) $payment->paymentmonth ][ (string) $payment->paymentday ] += $payment->paymentamount;
                    if ( !isset($incomeMonthTotal[ (int) $payment->paymentmonth ]) ) {
                        $incomeMonthTotal[ (int) $payment->paymentmonth ] = 0;
                    }
                    $incomeMonthTotal[ (int) $payment->paymentmonth ] += $payment->paymentamount;                 
                }
            }
            $expenseMonthAndDay = [];
            $expenseMonthTotal  = [];
            if ( customCompute($expenses) ) {
                foreach ( $expenses as $expenseKey => $expense ) {
                    if ( !isset($expenseMonthAndDay[ (int) $expense->expensemonth ][ $expense->expenseday ]) ) {
                        $expenseMonthAndDay[ (int) $expense->expensemonth ][ (string) $expense->expenseday ] = 0;
                    }

                    $expenseMonthAndDay[ (int) $expense->expensemonth ][ (string) $expense->expenseday ] += $expense->amount;
                    if ( !isset($expenseMonthTotal[ (int) $expense->expensemonth ]) ) {
                        $expenseMonthTotal[ (int) $expense->expensemonth ] = 0;
                    }
                    $expenseMonthTotal[ (int) $expense->expensemonth ] += $expense->amount;
                }
            }
            
            if ( customCompute($makepayments) ) {
                foreach ( $makepayments as $makepaymentKey => $makepayment ) {
                    $makepaymentDay   = date('d', strtotime($makepayment->create_date));
                    $makepaymentMonth = date('m', strtotime($makepayment->create_date));
                    if ( !isset($expenseMonthAndDay[ (int) $makepaymentMonth ][ $makepaymentDay ]) ) {
                        $expenseMonthAndDay[ (int) $makepaymentMonth ][ (string) $makepaymentDay ] = 0;
                    }

                    $expenseMonthAndDay[ (int) $makepaymentMonth ][ (string) $makepaymentDay ] += $makepayment->payment_amount;
                    if ( !isset($expenseMonthTotal[ (int) $makepaymentMonth ]) ) {
                        $expenseMonthTotal[ (int) $makepaymentMonth ] = 0;
                    }
                    $expenseMonthTotal[ (int) $makepaymentMonth ] += $makepayment->payment_amount;
                }
            }
            
            $waivers = $this->db->query("
                SELECT
                    DATE_FORMAT(payment.paymentdate, '%c') AS month,
                    SUM(weaverandfine.weaver) AS total_waivers
                FROM
                    payment
                LEFT JOIN
                    weaverandfine ON payment.paymentID = weaverandfine.paymentID
                WHERE
                    payment.schoolyearID = $schoolyearID
                GROUP BY
                    DATE_FORMAT(payment.paymentdate, '%c')
            ");
            
            $waiverData = [];
            if ($waivers->num_rows() > 0) {
                foreach ($waivers->result() as $waiver) {                    
                    $waiverData[(int) $waiver->month] = (int) $waiver->total_waivers;
                }
            }
            
            // foreach ($waiverData as $key => $value) {
            //     if (!isset($expenseMonthTotal[$key])) {
            //         $expenseMonthTotal[$key] = $value;
            //     } else {
            //         $expenseMonthTotal[$key] += $value;
            //     }
            // }
            
            $productpurchaselogs = $this->db->query("
                SELECT
                        DATE_FORMAT(`productpurchasepaiddate`, '%c') AS month,
                        SUM(p.productpurchasepaidamount) AS total_purchase
                    FROM
                        productpurchasepaid p
                    WHERE
                        p.schoolyearID = $schoolyearID 
                    GROUP BY
                        month
        
            ");
            
            $productpurchaseData = [];
            if ($productpurchaselogs->num_rows() > 0) {
                foreach ($productpurchaselogs->result() as $productpurchase) {                    
                    $productpurchaseData[(int) $productpurchase->month] = (int) $productpurchase->total_purchase;
                }
            }
            
            foreach ($productpurchaseData as $key => $value) {
                if (!isset($expenseMonthTotal[$key])) {
                    $expenseMonthTotal[$key] = $value;
                } else {
                    $expenseMonthTotal[$key] += $value;
                }
            }
            ksort($expenseMonthTotal);

            foreach($months as $key => $mon){
                if(!isset($expenseMonthTotal[$key])){
                    $expenseMonthTotal[$key] = 0;
                }

                if(!isset($incomeMonthTotal[$key])){
                    $incomeMonthTotal[$key] = 0;
                }

                if(!isset($incomeMonthAndDay[$key])){
                    $incomeMonthAndDay[$key] = 0;
                }

                if(!isset($expenseMonthAndDay[$key])){
                    $expenseMonthAndDay[$key] = 0;
                }
            }            
           
            $this->data['months']             = $months;
            $this->data['incomeMonthAndDay']  = $incomeMonthAndDay;
            $this->data['incomeMonthTotal']   = $incomeMonthTotal;
            $this->data['expenseMonthAndDay'] = $expenseMonthAndDay;
            $this->data['expenseMonthTotal']  = $expenseMonthTotal;
        }

        private function _visitorGraph()
        {
            $showChartVisitor  = [];
            $currentDate       = strtotime(date('Y-m-d H:i:s'));
            $previousSevenDate = strtotime(date('Y-m-d 00:00:00', strtotime('-7 days')));
            $visitors          = $this->loginlog_m->get_order_by_loginlog([
                'login <= ' => $currentDate,
                'login >= ' => $previousSevenDate
            ]);
            foreach ( $visitors as $visitor ) {
                $date = date('j M', $visitor->login);
                if ( !isset($showChartVisitor[ $date ]) ) {
                    $showChartVisitor[ $date ] = 0;
                }
                $showChartVisitor[ $date ]++;
            }

            $this->data['showChartVisitor'] = $showChartVisitor;
        }

        private function _profile()
        {
            $userTypeID             = $this->session->userdata('usertypeID');
            $loginUserID            = $this->session->userdata('loginuserID');
            $this->data['usertype'] = $this->session->userdata('usertype');

            if ( $userTypeID == 1 ) {
                $this->data['user'] = $this->systemadmin_m->get_single_systemadmin([ 'systemadminID' => $loginUserID ]);
            } elseif ( $userTypeID == 2 ) {
                $this->data['user'] = $this->teacher_m->get_single_teacher([ 'teacherID' => $loginUserID ]);
            } elseif ( $userTypeID == 3 ) {
                $this->data['user'] = $this->studentrelation_m->general_get_single_student([ 'studentID' => $loginUserID ]);
            } elseif ( $userTypeID == 4 ) {
                $this->data['user'] = $this->parents_m->get_single_parents([ 'parentsID' => $loginUserID ]);
            } else {
                $this->data['user'] = $this->user_m->get_single_user([ 'userID' => $loginUserID ]);
            }
        }

        private function _checkUpdate()
        {
            $version = 'none';
            if ( $this->session->userdata('usertypeID') == 1 && $this->session->userdata('loginuserID') == 1 ) {
                if ( customCompute($postDatas = @$this->_postData()) ) {
                    $versionChecking = $this->_versionChecking($postDatas);
                    if ( $versionChecking->status ) {
                        $version = $versionChecking->version;
                    }
                }
            }

            return $version;
        }

        private function _postData()
        {
            $postDatas = [];
            $this->load->model('update_m');
            $updates = $this->update_m->get_max_update();
            if ( customCompute($updates) ) {
                $postDatas = [
                    'username'       => customCompute($this->data['siteinfos']) ? $this->data['siteinfos']->purchase_username : '',
                    'purchasekey'    => customCompute($this->data['siteinfos']) ? $this->data['siteinfos']->purchase_code : '',
                    'domainname'     => base_url(),
                    'email'          => customCompute($this->data['siteinfos']) ? $this->data['siteinfos']->email : '',
                    'currentversion' => $updates->version,
                    'projectname'    => 'school',
                ];
            }

            return $postDatas;
        }

        private function _versionChecking( $postDatas )
        {
            $result = [
                'status'  => false,
                'message' => 'Error',
                'version' => 'none'
            ];

            $postDataStrings = json_encode($postDatas);
            $ch              = curl_init($this->_versionCheckingUrl);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postDataStrings);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER,
                [
                    'Content-Type: application/json',
                    'Content-Length: ' . strlen($postDataStrings)
                ]
            );

            $serverResult = curl_exec($ch);
            curl_close($ch);
            if(customCompute($serverResult)) {
                $result = json_decode($serverResult, true);
            }
            return (object) $result;
        }

        public function update()
        {
            if ( $this->session->userdata('usertypeID') == 1 && $this->session->userdata('loginuserID') == 1 ) {
                $this->session->set_userdata('updatestatus', true);
                redirect(base_url('update/autoupdate'));
            }
            redirect(base_url('dashboard/index'));
        }

        public function remind()
        {
            if ( $this->session->userdata('usertypeID') == 1 && $this->session->userdata('loginuserID') == 1 ) {
                $this->session->set_userdata('updatestatus', false);
            }
            redirect(base_url('dashboard/index'));
        }

        public function getDayWiseAttendance()
        {
            $showChartData = [];
            if ( $this->input->post('dayWiseAttendance') ) {
                $dayWiseAttendance = json_decode($this->input->post('dayWiseAttendance'), true);
                $type              = $this->input->post('type');
                foreach ( $dayWiseAttendance as $key => $value ) {
                    $showChartData[ $key ] = $value[ $type ];
                }
            }
            echo json_encode($showChartData);
        }

        public function dayWiseExpenseOrIncome()
        {
            $type          = $this->input->post('type');
            $monthID       = $this->input->post('monthID');
            $schoolyearID  = $this->session->userdata('defaultschoolyearID');
            $showChartData = [];
            if ( $type && $monthID ) {
                $year = date('Y');

                $yearArray  = [];
                $schoolyear = $this->schoolyear_m->get_obj_schoolyear($schoolyearID);
                if ( customCompute($schoolyear) ) {
                    $monthStart = abs($schoolyear->startingmonth);
                    if ( $schoolyear->startingyear == $schoolyear->endingyear ) {
                        $monthLimit = ( ( $schoolyear->endingmonth - $schoolyear->startingmonth ) + 1 );
                    } else {
                        $monthLimit = ( $schoolyear->startingmonth + $schoolyear->endingmonth + 1 );
                    }

                    $n             = $monthStart;
                    $endYearStatus = false;
                    for ( $k = 1; $k <= $monthLimit; $k++ ) {
                        if ( $endYearStatus == false ) {
                            $yearArray[ $n ] = $schoolyear->startingyear;
                        }

                        if ( $endYearStatus ) {
                            $yearArray[ $n ] = $schoolyear->endingyear;
                        }

                        $n++;
                        if ( $n > 12 ) {
                            $n             = 1;
                            $endYearStatus = true;
                        }
                    }
                    $year = ( isset($yearArray[ abs($monthID) ]) ? $yearArray[ abs($monthID) ] : date('Y') );
                }

                $days        = date('t', mktime(0, 0, 0, $monthID, 1, $year));
                $dayWiseData = json_decode($this->input->post('dayWiseData'), true);
                for ( $i = 1; $i <= $days; $i++ ) {
                    if ( !isset($dayWiseData[ lzero($i) ]) ) {
                        $showChartData[ $i ] = 0;
                    } else {
                        $showChartData[ $i ] = isset($dayWiseData[ lzero($i) ]) ? $dayWiseData[ lzero($i) ] : 0;
                    }
                }
            } else {
                for ( $i = 1; $i <= 31; $i++ ) {
                    $showChartData[ $i ] = 0;
                }
            }

            echo json_encode($showChartData);
        }

        public function getSubjectWiseAttendance()
        {
            $subjectWiseAttendance = json_decode($this->input->post('subjectWiseAttendance'), true);
            $classID               = $this->input->post('classID');
            $data['subjects']      = pluck($this->subject_m->get_order_by_subject([ 'classesID' => $classID ]), 'obj',
                'subjectID');
            $present               = [];
            $absent                = [];
            foreach ( $subjectWiseAttendance as $subjectID => $days ) {
                foreach ( $days as $key => $attendance ) {
                    if ( !isset($present[ $subjectID ]) ) {
                        $present[ $subjectID ] = 0;
                    }

                    if ( !isset($absent[ $subjectID ]) ) {
                        $absent[ $subjectID ] = 0;
                    }

                    $present[ $subjectID ] += $attendance['P'];
                    $absent[ $subjectID ]  += $attendance['A'];
                }
            }

            $data['present']               = $present;
            $data['absent']                = $absent;
            $data['subjectWiseAttendance'] = $subjectWiseAttendance;
            echo json_encode($data);
        }
    }