<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Cron extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model("sattendance_m");
        $this->load->model('systemadmin_m');
        $this->load->model("cron_m");
        $this->load->library('sms/skooly_init');
    }
    
    public function run() {
        $now = date('Y-m-d H:i:s');
        $dayOfWeek = date('N');
        
        if(get_setting('cron_service') == 1){
            $crons = $this->cron_m->getScheduledCrons($now, $dayOfWeek);
            
            foreach ($crons as $cron) {
                $message = "";
                try {
                    if (method_exists($this, $cron->code)) {
                        $this->{$cron->code}();
                        $message = "Cron executed successfully.";
                    } else {
                        $message = "Cron function '{$cron->code}' not found.";
                    }
                } catch (Exception $e) {
                    $message = "Error executing cron: " . $e->getMessage();
                }
    
                $nextRun = date('Y-m-d', strtotime("+1 day")) . " " . $cron->specific_time;
                if ($cron->ideal_time === 'DAILY' && $dayOfWeek >= 6) {
                    $nextRun = date('Y-m-d', strtotime('next Monday')) . " " . $cron->specific_time;
                }
    
                $this->cron_m->updateCron($cron->id, [
                    'last_run' => $now,
                    'next_run' => $nextRun,
                    'message'  => $message
                ]);
            }
        }
        
    }
/*
    public function send_absent_reminder() {
        $currentTime = date('H:i');
        $currentDate = date('Y-m-d');

        $absentStudents = $this->sattendance_m->get_absent_students($currentTime, $currentDate);
        
        $StudentArray = [];

        if ($absentStudents) {
            foreach ($absentStudents as $absentStudent) {
                $StudentArray[] = [
                    'name'=> $absentStudent->name,
                    'phone' => $absentStudent->phone,
                    'message' => SmsService::notClockedInEmergencyAlert($absentStudent, 3)['message']
                ];               
            }

            Skooly::sendBulk($StudentArray);
        }
    }
*/
   public function send_absent_reminder() {
        $currentDate = date('Y-m-d');
        // Optionally: $clockInTime = '08:00';
        $absentStudents = $this->sattendance_m->get_absent_students($currentDate); // no time check
    
        $sentCount = 0;
        if ($absentStudents) {
            foreach ($absentStudents as $absentStudent) {
                $studentObj = (object) [
                    'studentID' => $absentStudent->studentID,
                    'name' => $absentStudent->name,
                    'phone' => $absentStudent->phone,
                    'usertypeID' => 3
                ];
                $result = SmsService::notClockedInEmergencyAlert($studentObj, 3, [
                    'student_name' => $absentStudent->name,
                    'absent_date' => $currentDate,
                ]);
                if ($result) $sentCount++;
            }
        }
    
        echo json_encode([
            'success' => true,
            'message' => $sentCount > 0
                ? "Absent SMS reminders sent to {$sentCount} students."
                : "No absent students or no reminders sent."
        ]);
    }
}
