<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Categorysalereport extends Admin_Controller {
/*
| -----------------------------------------------------
| PRODUCT NAME: 	INILABS SCHOOL MANAGEMENT SYSTEM
| -----------------------------------------------------
| AUTHOR:			INILABS TEAM
| -----------------------------------------------------
| EMAIL:			info@inilabs.net
| -----------------------------------------------------
| COPYRIGHT:		RESERVED BY INILABS IT
| -----------------------------------------------------
| WEBSITE:			http://inilabs.net
| -----------------------------------------------------
*/
    function __construct() {
        parent::__construct();
        $this->load->model("productsale_m");
        $this->load->model("productcategory_m");
        $this->load->model("product_m");
        $this->load->model("category_m");
        $this->load->model("productsupplier_m");
        $this->load->model("productwarehouse_m");
        $this->load->model("productpurchaseitem_m");
        $this->load->model("productpurchasepaid_m");
        $language = $this->session->userdata('lang');
        $this->lang->load('categorysale', $language);
    }

    public function index() {
     
        $this->data['headerassets'] = array(
            'css' => array(
                'assets/datepicker/datepicker.css',
            ),
            'js' => array(
                'assets/datepicker/datepicker.js',
            )
        );

        $filter = array();
        if ($_GET) {
            if($this->input->get('start_date') || $this->input->get('end_date')){
                $filter['productsale.create_date>='] = $this->input->get('start_date') . ' ' . '00:00:00';
                $filter['productsale.create_date<='] = $this->input->get('end_date') . ' ' . '23:59:59';
            }
        } 

        $products = $this->product_m->get_products_category_sale($filter);
        $categories = $this->productcategory_m->get_productcategory();
        $categories_array = array();
        foreach($categories as $category) {
            $categories_array[$category->productcategoryID] = $category->productcategoryname;
        }
        $this->data['get_all_holidays'] = $this->getHolidaysSession();
        $this->data['products'] = $products;
        $this->data['categories'] = $categories_array;
        $this->data["subview"] = "new_reports/categorySaleReport";       
        $this->load->view('_layout_main', $this->data);
    }
    
    
}