<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Automation extends Admin_Controller {
    function __construct() {
		parent::__construct();
        $this->load->model("sattendance_m");
        $this->load->model('setting_m');
        $this->load->model("cron_m");
        $this->load->library('sms/skooly_init');
        $language = $this->session->userdata('lang');
        $this->lang->load('cron', $language);        
    }
    
    public function index() {
        $this->data['headerassets'] = array(
            'css' => array(
                'assets/datepicker/datepicker.css',
            ),
            'js' => array(
                'assets/datepicker/datepicker.js',
            )
        );    

        $this->data['crons'] = $this->cron_m->getData();
        $this->data["subview"] = "crons/index";
        $this->load->view('_layout_main', $this->data);
    }
    
    public function update_cron_service(){
        
        $cron_service = $this->input->post("cron_service");

            if (isset($cron_service)) {
                $settings = [
                'cron_service' => $this->input->post('cron_service') ? 1 : 0,
            ];
        
            $this->setting_m->insertorupdate($settings);
    
            echo json_encode(["success" => true]);
            return;
        }
    
        echo json_encode(["success" => false, "message" => "Invalid request"]);
        
    }
    
}