<?php


class Attendance extends Admin_Controller
{
    function __construct()
    {
        parent::__construct();

        $this->load->model("student_m");
        $this->load->model("parents_m");
        $this->load->model("sattendance_m");
        $this->load->model("tattendance_m");
        $this->load->model('uattendance_m');
        $this->load->model("teacher_m");
        $this->load->model("classes_m");
        $this->load->model("user_m");
        $this->load->model("usertype_m");
        $this->load->model("section_m");
        $this->load->model("setting_m");
        $this->load->model('studentgroup_m');
        $this->load->model('subject_m');
        $this->load->model('schoolyear_m');
        $this->load->model('mailandsmstemplate_m');
        $this->load->model('mailandsmstemplatetag_m');
        $this->load->model('markpercentage_m');
        $this->load->model('mark_m');
        $this->load->model('grade_m');
        $this->load->model('exam_m');
        $this->load->model('studentrelation_m');
        $this->load->model('leaveapplication_m');
        $this->load->model('payment_m');

        $this->load->model('clock_in_out_m');
        
        $this->load->library("email");
        $this->load->library('clickatell');
        $this->load->library('twilio');
        $this->load->library('bulk');
        $this->load->library('msg91');
        $this->load->library('sms/skooly_init');

        // $this->data['setting'] = $this->setting_m->get_setting();

        // if($this->data['setting']->attendance == "subject") {
        //  $this->load->model("subjectattendance_m");
        // }

        $language = $this->session->userdata('lang');
        // $this->lang->load('sattendance', $language);
        // $this->lang->load('tattendance', $language);
        $this->lang->load('uattendance', $language);
    }


    public function index()
    {
        $this->data['headerassets'] = array(
            'css' => array(
                'assets/select2/css/select2.css',
                'assets/select2/css/select2-bootstrap.css',
                'assets/datepicker/datepicker.css'
            ),
            'js' => array(
                'assets/select2/select2.js',
                'assets/datepicker/datepicker.js'
            )
        );

        $this->data['date'] = date("d-m-Y");
        $this->data['holidays'] =  $this->getHolidaysSession();
        $this->data['getWeekendDays'] =  $this->getWeekendDaysSession();



        $this->data["subview"] = "attendance/index";
        $this->load->view('_layout_main', $this->data);
    }



    public function verify_attendence()
    {
        $data = array();
        $user = array();
        $where = array();
        $usertype = $this->input->post('usertype');
        $roll_ID = $this->input->post('roll_no');
        if ($usertype == 3) {

            //Students are searched by registration number
            // $user = $this->sattendance_m->get_student_by_reg_no($roll_ID);

            $user = $this->sattendance_m->get_student($roll_ID);

            if(!empty($user)){
                $where = array(
                    'clock_in_out.userID' => $user->studentID,
                    'clock_in_out.usertypeID' => $usertype,
                    'check_date'=>date('Y-m-d')
                );
            }
            
            $data = $this->sattendance_m->verify_attendence($where);

        } elseif ($usertype == 2) {
            $user = $this->teacher_m->get_teacher($roll_ID,true);
            if(!empty($user)){
                $where = array(
                    'teacher.teacherID' => $roll_ID,
                    'clock_in_out.usertypeID' => $user->usertypeID,
                    'check_date'=> date('Y-m-d')
                );
            }
            $data = $this->tattendance_m->verify_attendence($where);

        } else {
            $user = $this->user_m->get_user($roll_ID,true);
            if(!empty($user)){
                $where = array(
                    'user.userID' => $roll_ID,
                    'clock_in_out.usertypeID' => $user->usertypeID,
                    'check_date'=>date('Y-m-d')
                );
            }
            
            $data = $this->uattendance_m->verify_attendence($where);
        }

        $data = (array)$data;
        $fee = null;
        if ($usertype == 3) {
            $fee = $this->payment_m->balance($user->studentID);
        }
        if(!empty($user)){
            $user_type = $this->usertype_m->get_usertype($user->usertypeID);
            if (!empty($data)) {
                echo json_encode(array(
                    "photo" => profileviewimage($user->photo),
                    "name" => $user->name,
                    "user_type" =>$user_type->usertype,
                    "clock_in" => $data['clock_in'],                    
                    "clock_out" => $data['clock_out'],
                    "fee_balance" => $fee? $fee : null,
                ));
            } else {
                echo json_encode(array(
                    "photo" => profileviewimage($user->photo),
                    "name" => $user->name,
                    "user_type" =>$user_type->usertype,
                ));
            }
        } else {
            echo 0;
        }
        exit;
    }

    public function clock_in()
    {
        $usertype = $this->input->post('usertype');
        $roll_ID = $this->input->post('roll_no');
        $day = abs(date('d'));

        //check users type
        if ($usertype == 3) {


            $student = $this->sattendance_m->get_student($roll_ID);
            
            //check student exist
            if (!empty($student)) {
                $parent = $this->parents_m->get_parents($student->parentID);
                $user_type = $this->usertype_m->get_usertype($student->usertypeID);
                $attendence = $this->sattendance_m->get_today_attendence($student->studentID);

                //check attendence record is created
                if (!empty($attendence)) {

                   $clock_in =  $this->clock_in_out_m->get_clock_in(array(
                       'attendanceID' => $attendence->attendanceID,
                       'userID' => $student->studentID,
                       'check_date' => date('Y-m-d'),
                       'usertypeID' => $usertype
                   ));


                    if(!empty($clock_in)){

                        $this->clock_in_out_m->update_clock_attend(array(
                            'clock_in' =>  date('H:i:s')
                        ), $clock_in->id);

                        $updateArray = array(
                            'a' . abs($day)     => 'P'
                        );
                        $this->sattendance_m->update_attendance($updateArray, $attendence->attendanceID);

                        if(!empty($student->phone)){
                            $message = "Dear Guardian, your child ".$student->name." ADM ".$student->registerNO." has checked in at school at ".date('H:i:s')." on ".date('d/m/Y')." . Thanks";
                            sendSms($student->phone,$message, $student->name);
                        }

                        $check_time = $this->clock_in_out_m->get_attendance_time($clock_in->id);
                        $fee_balance = $this->payment_m->balance($student->studentID);
                        echo json_encode(array(
                            "photo" => profileviewimage($student->photo),
                            'name' => $student->name, 
                            "user_type" =>$user_type->usertype,
                            'clock_in' => $check_time->clock_in,
                            'clock_out' => $check_time->clock_out,
                            'fee_balance' => $fee_balance,
                        ));
                        exit;
                    } else {

                        $data = array(
                            'attendanceID' => $attendence->attendanceID,
                            'userID' => $student->studentID,
                            'usertypeID' => $student->usertypeID,
                            'check_date' => date('y-m-d'),
                            'clock_in' => date('H:i:s')
                        );
                        $clock_out = $this->clock_in_out_m->insert_clock_attend($data);

                        $updateArray = array(
                            'a' . abs($day)     => 'P'
                        );
                        $this->sattendance_m->update_attendance($updateArray, $attendence->attendanceID);

                        SmsService::clockIn($student, 3, $this->data);
                        $fee_balance = $this->payment_m->balance($student->studentID);
                        echo json_encode(array(
                            "photo" => profileviewimage($student->photo),
                            'name' => $student->name, 
                            "user_type" =>$user_type->usertype,
                            'clock_in'=>$data['clock_in'],
                            'clock_out'=>null,
                            'fee_balance' => $fee_balance,
                        ));
                        exit;
                    }
                    
                } else {

            

                    $schoolyearID = $this->session->userdata('defaultschoolyearID');
                    $userID = $this->session->userdata('loginuserID');
                    $usertype = $this->session->userdata('usertype');

                    $studentArray = array(
                        "studentID" => $student->studentID,
                        'schoolyearID' => $schoolyearID,
                        "classesID" => $student->classesID,
                        'sectionID' => $student->sectionID,
                        "userID" => $userID,
                        "usertype" => $usertype,
                        "monthyear" => date('m-Y'),
                        'a'.abs($day) => 'P'

                    );

                    $attendence_id = $this->sattendance_m->insert_attendance($studentArray);

                    $data = array(
                        'attendanceID' => $attendence_id,
                        'userID' => $student->studentID,
                        'usertypeID' => $student->usertypeID,
                        'check_date' => date('y-m-d'),
                        'clock_in' => date('H:i:s')
                    );
                    $clock_out = $this->clock_in_out_m->insert_clock_attend($data);
                    $studentInfo = $this->studentrelation_m->get_single_student(array('srstudentID' => $student->studentID), TRUE);
                    SmsService::clockIn($studentInfo, 3, $this->data);
                     $fee_balance = $this->payment_m->balance($student->studentID);
                    echo json_encode(array(
                        "photo" => profileviewimage($student->photo),
                        'name' => $student->name, 
                        "user_type" =>$user_type->usertype,
                        'clock_in'=>date('H:i:s'),
                        'clock_out' => null,
                        'fee_balance' => $fee_balance,
                    ));
                    exit;
                }
            } else {

                echo json_encode(array(
                    'status' => 'error', 
                    'message' => 'Student does not exist, please enter correct roll no',
                ));
                exit;
            }
        } elseif ($usertype == 2) {
            $teacher  = $this->teacher_m->get_teacher($roll_ID, true);
            

            $insertArray = array();
            if (!empty($teacher)) {
                $user_type = $this->usertype_m->get_usertype($teacher->usertypeID);
                $attendence = $this->tattendance_m->get_today_attendence($teacher->teacherID);

                if (!empty($attendence)) {


                    $clock_in =  $this->clock_in_out_m->get_clock_in(array(
                        'attendanceID' => $attendence->tattendanceID,
                        'userID' => $teacher->teacherID,
                        'check_date' => date('Y-m-d'),
                        'usertypeID' => $usertype
                    ));

                    if(!empty($clock_in)){

                        $this->clock_in_out_m->update_clock_attend(array(
                            'clock_in' =>  date('H:i:s')
                        ), $clock_in->id);

                        $updateArray = array(
                            'a' . abs($day)     => 'P'
                        );
                        $this->tattendance_m->update_tattendance($updateArray, $attendence->tattendanceID);


                        $check_time = $this->clock_in_out_m->get_attendance_time($clock_in->id);
                        echo json_encode(array(
                            "photo" => profileviewimage($teacher->photo),
                            'name' => $teacher->name,
                            "user_type" =>$user_type->usertype,
                            'clock_in' => $check_time->clock_in,
                            'clock_out' => $check_time->clock_out
                        ));
                        exit;
                    } else {

                        $data = array(
                            'attendanceID' => $attendence->tattendanceID,
                            'userID' => $teacher->teacherID,
                            'usertypeID' => $teacher->usertypeID,
                            'check_date' => date('y-m-d'),
                            'clock_in' => date('H:i:s')
                        );
                        $clock_out = $this->clock_in_out_m->insert_clock_attend($data);

                        $updateArray = array(
                            'a' . abs($day)     => 'P'
                        );
                        $this->tattendance_m->update_tattendance($updateArray, $attendence->tattendanceID);

                        echo json_encode(array(
                            "photo" => profileviewimage($teacher->photo),
                            'name' => $teacher->name,
                            "user_type" =>$user_type->usertype,
                            'clock_in'=>$data['clock_in'],
                            'clock_out'=>null
                        ));
                        exit;
                    }

                } else {


                    $schoolyearID = $this->session->userdata('defaultschoolyearID');
                    $insertArray = array(
                        'schoolyearID' => $schoolyearID,
                        "teacherID" => $teacher->teacherID,
                        "usertypeID" => $teacher->usertypeID,
                        "monthyear" => date('m-Y'),
                        'a' . abs($day)     => 'P'
                    );
                    $attendence_id = $this->tattendance_m->insert_tattendance($insertArray);

                    $data = array(
                        'attendanceID' => $attendence_id,
                        'userID' => $teacher->teacherID,
                        'usertypeID' => $teacher->usertypeID,
                        'check_date' => date('y-m-d'),
                        'clock_in' => date('H:i:s')
                    );
                    $clock_out = $this->clock_in_out_m->insert_clock_attend($data);

                    echo json_encode(array(
                        "photo" => profileviewimage($teacher->photo),
                        'name' => $teacher->name,
                        "user_type" =>$user_type->usertype,
                        'clock_in'=>date('H:i:s'),
                        'clock_out' => null
                    ));
                    exit;
                }
            } else {
                echo json_encode(array(
                    'status' => 'error', 
                    'message' => 'Teacher does not exist, please enter correct ID'
                ));
                exit;
            }
        } else {

            $user = $this->user_m->get_user($roll_ID, true);
            

            if (!empty($user)) {
                $user_type = $this->usertype_m->get_usertype($user->usertypeID);
                $attendence = $this->uattendance_m->get_today_attendence($user->userID);

                if (!empty($attendence)) {

                    $clock_in =  $this->clock_in_out_m->get_clock_in(array(
                        'attendanceID' => $attendence->uattendanceID,
                        'userID' => $user->userID,
                        'check_date' => date('Y-m-d'),
                        'usertypeID' => $user->usertypeID
                    ));

                    if(!empty($clock_in)){

                        $this->clock_in_out_m->update_clock_attend(array(
                            'clock_in' =>  date('H:i:s')
                        ), $clock_in->id);

                        $updateArray = array(
                            'a' . abs($day)     => 'P'
                        );
                        $this->uattendance_m->update_uattendance($updateArray, $attendence->uattendanceID);


                        $check_time = $this->clock_in_out_m->get_attendance_time($clock_in->id);
                        echo json_encode(array(
                            "photo" => profileviewimage($user->photo),
                            "name" => $user->name,
                            "user_type" =>$user_type->usertype,
                            'clock_in' => $check_time->clock_in,
                            'clock_out' => $check_time->clock_out
                        ));
                        exit;
                    } else {

                        $data = array(
                            'attendanceID' => $attendence->uattendanceID,
                            'userID' => $user->userID,
                            'usertypeID' => $user->usertypeID,
                            'check_date' => date('y-m-d'),
                            'clock_in' => date('H:i:s')
                        );
                        $clock_out = $this->clock_in_out_m->insert_clock_attend($data);

                        $updateArray = array(
                            'a' . abs($day)     => 'P'
                        );
                        $this->uattendance_m->update_uattendance($updateArray, $attendence->uattendanceID);


                        echo json_encode(array(
                            "photo" => profileviewimage($user->photo),
                            "name" => $user->name,
                            "user_type" =>$user_type->usertype,
                            'clock_in'=>$data['clock_in'],
                            'clock_out'=>null
                        ));
                        exit;
                    }

                } else {

                    $schoolyearID = $this->session->userdata('defaultschoolyearID');

                    $userArray = array(
                        'schoolyearID'  => $schoolyearID,
                        "userID"        => $user->userID,
                        "usertypeID"    => $user->usertypeID,
                        "monthyear"     => date('m-Y'),
                        'a' . abs($day) => 'P'
                    );

                    $attendence_id = $this->uattendance_m->insert_uattendance($userArray);

                    $data = array(
                        'attendanceID' => $attendence_id,
                        'userID' => $user->userID,
                        'usertypeID' => $user->usertypeID,
                        'check_date' => date('y-m-d'),
                        'clock_in' => date('H:i:s')
                    );
                    $clock_out = $this->clock_in_out_m->insert_clock_attend($data);
                    
                    echo json_encode(array(
                        "photo" => profileviewimage($user->photo),
                        "name" => $user->name,
                        "user_type" =>$user_type->usertype,
                        'clock_in'=>date('H:i:s'),
                        'clock_out' => null
                    ));
                    exit;
                }
            } else {
                echo json_encode(array(
                    'status' => 'error', 
                    'message' => 'User does not exist, please enter correct ID'
                ));
                exit;
            }
        }
    }


    public function clock_out()
    {
        $usertype = $this->input->post('usertype');
        $roll_ID = $this->input->post('roll_no');
        $day = abs(date('d'));

        if ($usertype == 3) {

            //Students are searched by registration number
            // $student = $this->sattendance_m->get_student_by_reg_no($roll_ID);
            $student = $this->sattendance_m->get_student($roll_ID);


            if (!empty($student)) {
                $parent = $this->parents_m->get_parents($student->parentID);
                $user_type = $this->usertype_m->get_usertype($student->usertypeID);
                $attendence = $this->sattendance_m->get_today_attendence($student->studentID);


                if (!empty($attendence)) {

                    $clock_out =  $this->clock_in_out_m->get_clock_in(array(
                        'attendanceID' => $attendence->attendanceID,
                        'userID' => $student->studentID,
                        'check_date' => date('Y-m-d'),
                        'usertypeID' => $usertype
                    ));

                    if(!empty($clock_out)){

                        $this->clock_in_out_m->update_clock_attend(array(
                            'clock_out' =>  date('H:i:s')
                        ), $clock_out->id);

                        $studentInfo = $this->studentrelation_m->get_single_student(array('srstudentID' => $student->studentID), TRUE);
                        SmsService::clockOut($studentInfo, 3, $this->data);

                        $check_time = $this->clock_in_out_m->get_attendance_time($clock_out->id);
                        echo json_encode(array(
                            "photo" => profileviewimage($student->photo),
                            'name' => $student->name, 
                            "user_type" =>$user_type->usertype,
                            'clock_in' => $check_time->clock_in,
                            'clock_out' => $check_time->clock_out,
                            'fee_balance' => $this->payment_m->balance($student->studentID)
                        ));
                        exit;

                    } else {
                        //Create clock out record
                        $data = array(
                            'attendanceID' => $attendence->attendanceID,
                            'userID' => $student->studentID,
                            'usertypeID' => $student->usertypeID,
                            'check_date' => date('y-m-d'),
                            'clock_out' => date('H:i:s')
                        );

                        $clock_out = $this->clock_in_out_m->insert_clock_attend($data);
                        $studentInfo = $this->studentrelation_m->get_single_student(array('srstudentID' => $student->studentID), TRUE);
                        SmsService::clockOut($studentInfo, 3, $this->data);

                        echo json_encode(array(
                            "photo" => profileviewimage($student->photo),
                            'name' => $student->name,
                            "user_type" =>$user_type->usertype,
                            'clock_in'=>null,
                            'clock_out' => date('H:i:s'),
                            'fee_balance' => $this->payment_m->balance($student->studentID)
                        ));
                        exit;
                    }

                } else {

                    $schoolyearID = $this->session->userdata('defaultschoolyearID');
                    $userID = $this->session->userdata('loginuserID');
                    $usertype = $this->session->userdata('usertype');

                    $studentArray = array(
                        "studentID" => $student->studentID,
                        'schoolyearID' => $schoolyearID,
                        "classesID" => $student->classesID,
                        'sectionID' => $student->sectionID,
                        "userID" => $userID,
                        "usertype" => $usertype,
                        "monthyear" => date('m-Y'),
                        'a'.abs($day) => 'P'

                    );

                    $attendence_id = $this->sattendance_m->insert_attendance($studentArray);

                    $data = array(
                        'attendanceID' => $attendence_id,
                        'userID' => $student->studentID,
                        'usertypeID' => $student->usertypeID,
                        'check_date' => date('y-m-d'),
                        'clock_out' => date('H:i:s')
                    );

                    $clock_out = $this->clock_in_out_m->insert_clock_attend($data);
                    $studentInfo = $this->studentrelation_m->get_single_student(array('srstudentID' => $student->studentID), TRUE);
                    SmsService::clockOut($studentInfo, 3, $this->data);

                    echo json_encode(array(
                        "photo" => profileviewimage($student->photo),
                        'name' => $student->name,
                        "user_type" =>$user_type->usertype,
                        'clock_in'=>null,
                        'clock_out' => date('H:i:s'),
                        'fee_balance' => $this->payment_m->balance($student->studentID)
                    ));
                    exit;
                }
            } else {
                echo json_encode(array(
                    'status' => 'error',
                    'message' => 'Student does not exist, please enter correct roll no'));
                exit;
            }
        } elseif ($usertype == 2) {
            $teacher  = $this->teacher_m->get_teacher($roll_ID, true);
            
            if (!empty($teacher)) {
                $user_type = $this->usertype_m->get_usertype($teacher->usertypeID);
                $attendence = $this->tattendance_m->get_today_attendence($teacher->teacherID);

                if (!empty($attendence)) {


                    $clock_out =  $this->clock_in_out_m->get_clock_in(array(
                        'attendanceID' => $attendence->tattendanceID,
                        'userID' => $teacher->teacherID,
                        'check_date' => date('Y-m-d'),
                        'usertypeID' => $usertype
                    ));

                    if(!empty($clock_out)){

                        $this->clock_in_out_m->update_clock_attend(array(
                            'clock_out' =>  date('H:i:s')
                        ), $clock_out->id);

                        $check_time = $this->clock_in_out_m->get_attendance_time($clock_out->id);
                        echo json_encode(array(
                            "photo" => profileviewimage($teacher->photo),
                            'name' => $teacher->name,
                            "user_type" =>$user_type->usertype,
                            'clock_in' => $check_time->clock_in,
                            'clock_out' => $check_time->clock_out
                        ));
                        exit;

                    } else {
                        echo json_encode(array(
                            'status' => 'error',
                            'message' => 'Have not Checked-in yet',
                            "photo" => profileviewimage($teacher->photo),
                            "name" => $teacher->name,
                            "user_type" =>$user_type->usertype,
                        ));
                        exit;
                    }

                } else {
                    echo json_encode(array(
                        'status' => 'error',
                        'message' => 'Have not Checked-in yet',
                        "photo" => profileviewimage($teacher->photo),
                        "name" => $teacher->name,
                        "user_type" =>$user_type->usertype,
                    ));
                    exit;
                }
            } else {
                echo json_encode(array(
                    'status' => 'error',
                    'message' => 'Teacher does not exist, please enter correct ID'
                ));
                exit;
            }
        } else {

            $user = $this->user_m->get_user($roll_ID, true);
            

            if (!empty($user)) {
                $user_type = $this->usertype_m->get_usertype($user->usertypeID);
                $attendence = $this->uattendance_m->get_today_attendence($user->userID);

                if (!empty($attendence)) {

                    $clock_out =  $this->clock_in_out_m->get_clock_in(array(
                        'attendanceID' => $attendence->uattendanceID,
                        'userID' => $user->userID,
                        'check_date' => date('Y-m-d'),
                        'usertypeID' => $user->usertypeID
                    ));


                    if(!empty($clock_out)){

                        $this->clock_in_out_m->update_clock_attend(array(
                            'clock_out' =>  date('H:i:s')
                        ), $clock_out->id);

                        $check_time = $this->clock_in_out_m->get_attendance_time($clock_out->id);
                        echo json_encode(array(
                            "photo" => profileviewimage($user->photo),
                            "name" => $user->name,
                            "user_type" =>$user_type->usertype,
                            'clock_in' => $check_time->clock_in,
                            'clock_out' => $check_time->clock_out
                        ));
                        exit;

                    } else {
                        echo json_encode(array(
                            'status' => 'error',
                            'message' => 'Have not Checked-in yet',
                            "photo" => profileviewimage($user->photo),
                            "name" => $user->name,
                            "user_type" =>$user_type->usertype,
                        ));
                        exit;
                    }
                } else {
                    echo json_encode(array(
                        'status' => 'error',
                        'message' => 'Have not Checked-in yet',
                        "photo" => profileviewimage($user->photo),
                        "name" => $user->name,
                        "user_type" =>$user_type->usertype,
                        ));
                    exit;
                }
            } else {
                echo json_encode(array(
                    'status' => 'error',
                    'message' => 'User does not exist, please enter correct ID'
                ));
                exit;
            }
        }
    }

}
