<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Accountledgerreport extends Admin_Controller
{
	/*
| -----------------------------------------------------
| PRODUCT NAME: 	INILABS SCHOOL MANAGEMENT SYSTEM
| -----------------------------------------------------
| AUTHOR:			INILABS TEAM
| -----------------------------------------------------
| EMAIL:			info@inilabs.net
| -----------------------------------------------------
| COPYRIGHT:		RESERVED BY INILABS IT
| -----------------------------------------------------
| WEBSITE:			http://inilabs.net
| -----------------------------------------------------
*/
	public function __construct()
	{
		parent::__construct();
		$this->load->model('income_m');
		$this->load->model('expense_m');
		$this->load->model('make_payment_m');
		$this->load->model('payment_m');
		$this->load->model('schoolyear_m');
		$this->load->model("productpurchase_m");
		$this->load->model("productsale_m");
		$this->load->model("productsaleitem_m");
		$this->load->model("productpurchaseitem_m");
        $this->load->model("productpurchasepaid_m");
		$this->load->model("productsalepaid_m");
		$language = $this->session->userdata('lang');
		$this->lang->load('accountledgerreport', $language);
	}

	protected function rules()
	{
		$rules = array(
			array(
				'field' => 'schoolyearID',
				'label' => $this->lang->line("accountledgerreport_academicyear"),
				'rules' => 'trim|required|xss_clean'
			),
			array(
				'field' => 'fromdate',
				'label' => $this->lang->line("accountledgerreport_fromdate"),
				'rules' => 'trim|xss_clean|callback_date_valid|callback_unique_date'
			),
			array(
				'field' => 'todate',
				'label' => $this->lang->line("accountledgerreport_todate"),
				'rules' => 'trim|xss_clean|callback_date_valid|callback_unique_date'
			),
		);
		return $rules;
	}

	protected function send_pdf_to_mail_rules()
	{
		$rules = array(
			array(
				'field' => 'schoolyearID',
				'label' => $this->lang->line("accountledgerreport_academicyear"),
				'rules' => 'trim|required|xss_clean'
			),
			array(
				'field' => 'fromdate',
				'label' => $this->lang->line("accountledgerreport_fromdate"),
				'rules' => 'trim|xss_clean|callback_date_valid|callback_unique_date'
			),
			array(
				'field' => 'todate',
				'label' => $this->lang->line("accountledgerreport_todate"),
				'rules' => 'trim|xss_clean|callback_date_valid|callback_unique_date'
			),
			array(
				'field' => 'to',
				'label' => $this->lang->line("accountledgerreport_to"),
				'rules' => 'trim|required|xss_clean|valid_email'
			),
			array(
				'field' => 'subject',
				'label' => $this->lang->line("accountledgerreport_subject"),
				'rules' => 'trim|required|xss_clean'
			),
			array(
				'field' => 'message',
				'label' => $this->lang->line("accountledgerreport_message"),
				'rules' => 'trim|xss_clean'
			),
		);
		return $rules;
	}

	public function index()
	{
		$this->data['headerassets'] = array(
			'css' => array(
				'assets/datepicker/datepicker.css',
				'assets/select2/css/select2.css',
				'assets/select2/css/select2-bootstrap.css'
			),
			'js' => array(
				'assets/datepicker/datepicker.js',
				'assets/select2/select2.js'
			)
		);

		$this->data['schoolyears'] = $this->schoolyear_m->get_order_by_schoolyear();
		$this->data["subview"] = "report/accountledger/AccountledgerReportView";
		$this->load->view('_layout_main', $this->data);
	}

	public function queryArray($array)
	{
		$retArray = [];
		if (!empty($array['fromdate']) && !empty($array['todate'])) {
			$retArray['fromdate']    = date('Y-m-d', strtotime($array['fromdate']));
			$retArray['todate']      = date('Y-m-d', strtotime($array['todate']));
		}

		if (!empty($array['schoolyearID'])) {
			$retArray['schoolyearID'] = $array['schoolyearID'];
		}
		$schoolyear = $this->schoolyear_m->get_single_schoolyear(array('schoolyearID' => $array['schoolyearID']));
		$this->data['schoolyearName'] = customCompute($schoolyear) ? $schoolyear->schoolyear : $this->lang->line('accountledgerreport_all_accademic_year');
		return $retArray;
	}

	public function queryArrayy($array)
	{
		$retArray = [];
		if (!empty($array['fromdate']) && !empty($array['todate'])) {
			$retArray['productsaledate>=']    = date('Y-m-d', strtotime($array['fromdate']));
			$retArray['productsaledate<=']      = date('Y-m-d', strtotime($array['todate']));
		}

		if (!empty($array['schoolyearID'])) {
			$retArray['schoolyearID'] = (int) $array['schoolyearID'];
		}
		$schoolyear = $this->schoolyear_m->get_single_schoolyear(array('schoolyearID' => $array['schoolyearID']));
		$this->data['schoolyearName'] = customCompute($schoolyear) ? $schoolyear->schoolyear : $this->lang->line('accountledgerreport_all_accademic_year');
		return $retArray;
	}

	public function queryArrayp($array)
	{
		$retArray = [];
		if (!empty($array['fromdate']) && !empty($array['todate'])) {
			$retArray['productpurchasedate>=']    = date('Y-m-d', strtotime($array['fromdate']));
			$retArray['productpurchasedate<=']      = date('Y-m-d', strtotime($array['todate']));
		}

		if (!empty($array['schoolyearID'])) {
			$retArray['schoolyearID'] = $array['schoolyearID'];
		}
		$schoolyear = $this->schoolyear_m->get_single_schoolyear(array('schoolyearID' => $array['schoolyearID']));
		$this->data['schoolyearName'] = customCompute($schoolyear) ? $schoolyear->schoolyear : $this->lang->line('accountledgerreport_all_accademic_year');
		return $retArray;
	}

	public function getaccountledgerreport()
	{
		$retArray['status'] = FALSE;
		$retArray['render'] = '';
		if (permissionChecker('accountledgerreport')) {
			if ($_POST) {
				$rules = $this->rules();
				$this->form_validation->set_rules($rules);
				if ($this->form_validation->run() == FALSE) {
					$retArray = $this->form_validation->error_array();
					$retArray['status'] = FALSE;
					echo json_encode($retArray);
					exit;
				} else {

					$array = $this->queryArray($_POST);

					$arrayy = $this->queryArrayy($_POST);

					$arrayp = $this->queryArrayp($_POST);

					$totalincome        = $this->income_m->get_income_order_by_with_date_schoolyear($array);
					$totalexpense       = $this->expense_m->get_expense_order_with_date_schoolyear($array);
					$totalsalarypayment = $this->make_payment_m->get_payment_salary_with_date_schoolyear($array);

					$payments = $this->payment_m->get_payment_with_fine_schoolyear($array);
					$totalcollection = 0;
					$totalfine    = 0;
					if (customCompute($payments)) {
						foreach ($payments as $payment) {
							if ($payment->paymentamount != null) {
								$totalcollection += $payment->paymentamount;
							}
							if ($payment->fine != null) {
								$totalfine += $payment->fine;
							}
						}
					}

					$this->data['totalincome']   = $totalincome;
					$this->data['totalexpense']  = $totalexpense->amount;
					$this->data['totalsalarypayment']  = $totalsalarypayment->payment_amount;
					$this->data['totalcollection']  = $totalcollection;
					$this->data['totalfine']     = $totalfine;

					$this->data['totalSales'] = $this->getTotalSale($arrayy);
					$this->data['totalPurchases'] = $this->getTotalPurchase($arrayp);

					$this->data['fromdate'] = $this->input->post('fromdate');
					$this->data['todate']   = $this->input->post('todate');
					$this->data['schoolyearID']   = $this->input->post('schoolyearID');


					$retArray['render'] = $this->load->view('report/accountledger/AccountledgerReport', $this->data, true);
					$retArray['status'] = TRUE;
					echo json_encode($retArray);
					exit;
				}
			} else {
				echo json_encode($retArray);
				exit;
			}
		} else {
			echo json_encode($retArray);
			exit;
		}
	}

	public function getTotalSale($array)
	{

		$this->data['productsales'] = $this->productsale_m->filter_items($array);
		$this->data['grandtotalandpaidsale'] = $this->grandtotalandpaidsale($this->data['productsales'], $array['schoolyearID']);

		$totalGrand = 0;
		$totalPaid = 0;
		$totalBalance = 0;
		foreach ($this->data['productsales'] as $productsale) {
			$grandTotal = isset($this->data['grandtotalandpaidsale']['grandtotal'][$productsale->productsaleID]) ? $this->data['grandtotalandpaidsale']['grandtotal'][$productsale->productsaleID] : 0;
			$totalGrand += $grandTotal;
			$totalPaid += isset($this->data['grandtotalandpaidsale']['totalpaid'][$productsale->productsaleID]) ? $this->data['grandtotalandpaidsale']['totalpaid'][$productsale->productsaleID] : 0;
			$balance = $grandTotal - (isset($this->data['grandtotalandpaidsale']['totalpaid'][$productsale->productsaleID]) ? $this->data['grandtotalandpaidsale']['totalpaid'][$productsale->productsaleID] : 0);
			$totalBalance += $balance;
		}
		return $totalPaid;
	}

	public function getTotalPurchase($array)
	{	
		$this->data['productpurchases'] = $this->productpurchase_m->get_order_by_productpurchase($array);
		$this->data['grandtotalandpaid'] = $this->grandtotalandpaid($this->data['productpurchases'], $array['schoolyearID']);

		$totalGrand = 0;
		$totalPaid = 0;
		$totalBalance = 0;
		foreach ($this->data['productpurchases'] as $productpurchase) {
			$grandTotal = isset($this->data['grandtotalandpaid']['grandtotal'][$productpurchase->productpurchaseID]) ? $this->data['grandtotalandpaid']['grandtotal'][$productpurchase->productpurchaseID] : 0;
			$totalGrand += $grandTotal;
			$totalPaid += isset($this->data['grandtotalandpaid']['totalpaid'][$productpurchase->productpurchaseID]) ? $this->data['grandtotalandpaid']['totalpaid'][$productpurchase->productpurchaseID] : 0;
			$balance = $grandTotal - (isset($this->data['grandtotalandpaid']['totalpaid'][$productpurchase->productpurchaseID]) ? $this->data['grandtotalandpaid']['totalpaid'][$productpurchase->productpurchaseID] : 0);
			$totalBalance += $balance;
		}

		return $totalPaid;
	}

	private function grandtotalandpaid($productpurchases, $schoolyearID)
	{	
		$retArray = [];

		$productpurchaseitems = pluck_multi_array($this->productpurchaseitem_m->get_order_by_productpurchaseitem(array('schoolyearID' => $schoolyearID)), 'obj', 'productpurchaseID');

		$productpurchasepaids = pluck_multi_array($this->productpurchasepaid_m->get_order_by_productpurchasepaid(array('schoolyearID' => $schoolyearID)), 'obj', 'productpurchaseID');

		if (customCompute($productpurchases)) {
			foreach ($productpurchases as $productpurchase) {
				if (isset($productpurchaseitems[$productpurchase->productpurchaseID])) {
					if (customCompute($productpurchaseitems[$productpurchase->productpurchaseID])) {
						foreach ($productpurchaseitems[$productpurchase->productpurchaseID] as $productpurchaseitem) {
							if (isset($retArray['grandtotal'][$productpurchaseitem->productpurchaseID])) {
								$retArray['grandtotal'][$productpurchaseitem->productpurchaseID] = (($retArray['grandtotal'][$productpurchaseitem->productpurchaseID]) + ($productpurchaseitem->productpurchaseunitprice * $productpurchaseitem->productpurchasequantity));
							} else {
								$retArray['grandtotal'][$productpurchaseitem->productpurchaseID] = ($productpurchaseitem->productpurchaseunitprice * $productpurchaseitem->productpurchasequantity);
							}
						}
					}
				}

				if (isset($productpurchasepaids[$productpurchase->productpurchaseID])) {
					if (customCompute($productpurchasepaids[$productpurchase->productpurchaseID])) {
						foreach ($productpurchasepaids[$productpurchase->productpurchaseID] as $productpurchasepaid) {
							if (isset($retArray['totalpaid'][$productpurchasepaid->productpurchaseID])) {
								$retArray['totalpaid'][$productpurchasepaid->productpurchaseID] = (($retArray['totalpaid'][$productpurchasepaid->productpurchaseID]) + ($productpurchasepaid->productpurchasepaidamount));
							} else {
								$retArray['totalpaid'][$productpurchasepaid->productpurchaseID] = ($productpurchasepaid->productpurchasepaidamount);
							}
						}
					}
				}
			}
		}
		return $retArray;
	}

	private function grandtotalandpaidsale($productsales, $schoolyearID)
	{
		$retArray = [];

		$productsaleKey = [];
		if (customCompute($productsales)) {
			foreach ($productsales as $productsale) {
				$productsaleKey[] = $productsale->productsaleID;
			}
		}

		if (customCompute($productsaleKey)) {
			$productsaleitems = pluck_multi_array($this->productsaleitem_m->get_order_by_productsaleitem(array('schoolyearID' => $schoolyearID)), 'obj', 'productsaleID');

			$productsalepaids = pluck_multi_array($this->productsalepaid_m->get_where_in_productsalepaid($productsaleKey, 'productsaleID'), 'obj', 'productsaleID');

			if (customCompute($productsales)) {
				foreach ($productsales as $productsale) {
					if (isset($productsaleitems[$productsale->productsaleID])) {
						if (customCompute($productsaleitems[$productsale->productsaleID])) {
							foreach ($productsaleitems[$productsale->productsaleID] as $productpurchaseitem) {
								if (isset($retArray['grandtotal'][$productpurchaseitem->productsaleID])) {
									$retArray['grandtotal'][$productpurchaseitem->productsaleID] = (($retArray['grandtotal'][$productpurchaseitem->productsaleID]) + ($productpurchaseitem->productsaleunitprice * $productpurchaseitem->productsalequantity));
								} else {
									$retArray['grandtotal'][$productpurchaseitem->productsaleID] = ($productpurchaseitem->productsaleunitprice * $productpurchaseitem->productsalequantity);
								}
							}
						}
					}

					if (isset($productsalepaids[$productsale->productsaleID])) {
						if (customCompute($productsalepaids[$productsale->productsaleID])) {
							foreach ($productsalepaids[$productsale->productsaleID] as $productsalepaid) {
								if (isset($retArray['totalpaid'][$productsalepaid->productsaleID])) {
									$retArray['totalpaid'][$productsalepaid->productsaleID] = (($retArray['totalpaid'][$productsalepaid->productsaleID]) + ($productsalepaid->productsalepaidamount));
								} else {
									$retArray['totalpaid'][$productsalepaid->productsaleID] = ($productsalepaid->productsalepaidamount);
								}
							}
						}
					}
				}
			}
		}

		return $retArray;
	}

	public function pdf()
	{
		if (permissionChecker('accountledgerreport')) {
			$schoolyearID = htmlentities(escapeString($this->uri->segment(3)));
			$fromdate = htmlentities(escapeString($this->uri->segment(4)));
			$todate  = htmlentities(escapeString($this->uri->segment(5)));
			if (((int)$schoolyearID || ($schoolyearID == 0)) && ((int)$fromdate || ($fromdate == null)) && ((int)$todate || $todate == null)) {
				$postArray = [];
				if ((int)$fromdate && (int) $todate) {
					$postArray['fromdate'] = date('d-m-Y', $fromdate);
					$postArray['todate'] = date('d-m-Y', $todate);
				}
				$postArray['schoolyearID'] = $schoolyearID;

				$array = $this->queryArray($postArray);

				$totalincome        = $this->income_m->get_income_order_by_with_date_schoolyear($array);
				$totalexpense       = $this->expense_m->get_expense_order_with_date_schoolyear($array);
				$totalsalarypayment = $this->make_payment_m->get_payment_salary_with_date_schoolyear($array);

				$payments = $this->payment_m->get_payment_with_fine_schoolyear($array);
				$totalcollection = 0;
				$totalfine    = 0;
				if (customCompute($payments)) {
					foreach ($payments as $payment) {
						if ($payment->paymentamount != null) {
							$totalcollection += $payment->paymentamount;
						}
						if ($payment->fine != null) {
							$totalfine += $payment->fine;
						}
					}
				}

				$this->data['totalincome']   = $totalincome->amount;
				$this->data['totalexpense']  = $totalexpense->amount;
				$this->data['totalsalarypayment']  = $totalsalarypayment->payment_amount;
				$this->data['totalcollection']  = $totalcollection;
				$this->data['totalfine']     = $totalfine;

				$this->data['fromdate'] = $fromdate;
				$this->data['todate']   = $todate;

				$this->reportPDF('accountledgerreport.css', $this->data, 'report/accountledger/AccountledgerReportPDF');
			} else {
				$this->data["subview"] = "error";
				$this->load->view('_layout_main', $this->data);
			}
		} else {
			$this->data["subview"] = "errorpermission";
			$this->load->view('_layout_main', $this->data);
		}
	}

	public function send_pdf_to_mail()
	{
		$retArray['status'] = FALSE;
		$retArray['message'] = '';

		if (permissionChecker('accountledgerreport')) {
			if ($_POST) {
				$to      = $this->input->post('to');
				$subject = $this->input->post('subject');
				$message = $this->input->post('message');

				$rules = $this->send_pdf_to_mail_rules();
				$this->form_validation->set_rules($rules);
				if ($this->form_validation->run() == FALSE) {
					$retArray = $this->form_validation->error_array();
					$retArray['status'] = FALSE;
					echo json_encode($retArray);
					exit;
				} else {
					$array = $this->queryArray($_POST);

					$totalincome        = $this->income_m->get_income_order_by_with_date_schoolyear($array);
					$totalexpense       = $this->expense_m->get_expense_order_with_date_schoolyear($array);
					$totalsalarypayment = $this->make_payment_m->get_payment_salary_with_date_schoolyear($array);

					$payments = $this->payment_m->get_payment_with_fine_schoolyear($array);
					$totalcollection = 0;
					$totalfine    = 0;
					if (customCompute($payments)) {
						foreach ($payments as $payment) {
							if ($payment->paymentamount != null) {
								$totalcollection += $payment->paymentamount;
							}
							if ($payment->fine != null) {
								$totalfine += $payment->fine;
							}
						}
					}

					$this->data['totalincome']   = $totalincome->amount;
					$this->data['totalexpense']  = $totalexpense->amount;
					$this->data['totalsalarypayment']  = $totalsalarypayment->payment_amount;
					$this->data['totalcollection']  = $totalcollection;
					$this->data['totalfine']     = $totalfine;

					$this->data['fromdate'] = $this->input->post('fromdate');
					$this->data['todate']   = $this->input->post('todate');
					$this->data['schoolyearID']   = $this->input->post('schoolyearID');
					$this->reportSendToMail('accountledgerreport.css', $this->data, 'report/accountledger/AccountledgerReportPDF', $to, $subject, $message);
					$retArray['status'] = TRUE;
					echo json_encode($retArray);
					exit;
				}
			} else {
				$retArray['message'] = $this->lang->line('accountledgerreport_permissionmethod');
				echo json_encode($retArray);
				exit;
			}
		} else {
			$retArray['message'] = $this->lang->line('accountledgerreport_permission');
			echo json_encode($retArray);
			exit;
		}
	}

	public function date_valid($date)
	{
		if ($date) {
			if (strlen($date) < 10) {
				$this->form_validation->set_message("date_valid", "The %s is not valid dd-mm-yyyy");
				return FALSE;
			} else {
				$arr = explode("-", $date);
				$dd = $arr[0];
				$mm = $arr[1];
				$yyyy = $arr[2];
				if (checkdate($mm, $dd, $yyyy)) {
					return TRUE;
				} else {
					$this->form_validation->set_message("date_valid", "The %s is not valid dd-mm-yyyy");
					return FALSE;
				}
			}
		}
		return TRUE;
	}

	public function unique_date()
	{
		$fromdate = $this->input->post('fromdate');
		$todate   = $this->input->post('todate');

		$startingdate = $this->data['schoolyearsessionobj']->startingdate;
		$endingdate = $this->data['schoolyearsessionobj']->endingdate;
		if ($fromdate != '' && $todate != '') {
			if (strtotime($fromdate) > strtotime($todate)) {
				$this->form_validation->set_message("unique_date", "The from date can not be upper than todate .");
				return FALSE;
			}
			return TRUE;
		} elseif ($fromdate == '' && $todate != '') {
			$this->form_validation->set_message("unique_date", "The to date are invalid .");
			return FALSE;
		} elseif ($fromdate != '' && $todate == '') {
			$this->form_validation->set_message("unique_date", "The to date are invalid .");
			return FALSE;
		}
		return TRUE;
	}
}
